/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Arrays;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.oper.OperandArray;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;

public abstract class SimpleExpression
extends Expression
implements Callable {
    private OperandArray a;

    protected void setOperanda(OperandArray operandArray) {
        this.a = operandArray;
    }

    protected OperandArray getOperanda() {
        return this.a;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.a.operands();
    }

    public void setArguments(Expression[] objectArray) {
        if (this.getOperanda() != null && this.getOperanda().getNumberOfOperands() > 0) {
            throw new IllegalArgumentException("Cannot replace existing argument array");
        }
        Expression[] expressionArray = Arrays.copyOf(objectArray, objectArray.length);
        objectArray = new OperandRole[objectArray.length];
        Arrays.fill(objectArray, OperandRole.NAVIGATE);
        this.setOperanda(new OperandArray((Expression)this, expressionArray, (OperandRole[])objectArray));
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        try {
            SimpleExpression simpleExpression = (SimpleExpression)this.getClass().newInstance();
            Expression[] expressionArray = new Expression[this.a.getNumberOfOperands()];
            int n2 = 0;
            for (Operand operand : ((Expression)this).operands()) {
                expressionArray[n2++] = operand.getChildExpression().copy(rebindingMap);
            }
            OperandArray operandArray = new OperandArray((Expression)simpleExpression, expressionArray, this.a.getRoles());
            simpleExpression.setOperanda(operandArray);
            return simpleExpression;
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new UnsupportedOperationException(this.getClass().getName() + ".copy()");
        }
    }

    protected SimpleExpression copyOperandsFrom(SimpleExpression simpleExpression) {
        Expression[] expressionArray = new Expression[simpleExpression.a.getNumberOfOperands()];
        int n2 = 0;
        for (Operand operand : ((Expression)simpleExpression).operands()) {
            expressionArray[n2++] = operand.getChildExpression().copy(new RebindingMap());
        }
        OperandArray operandArray = new OperandArray((Expression)this, expressionArray, simpleExpression.a.getRoles());
        this.setOperanda(operandArray);
        return this;
    }

    @Override
    public ItemType getItemType() {
        return Type.ITEM_TYPE;
    }

    @Override
    public int computeCardinality() {
        if ((this.getImplementationMethod() & 1) == 0) {
            return 49152;
        }
        return 24576;
    }

    public final Item evaluateItem(XPathContext xPathContext) {
        return this.call(xPathContext, this.a(xPathContext)).head();
    }

    @Override
    public final SequenceIterator<?> iterate(XPathContext xPathContext) {
        return this.call(xPathContext, this.a(xPathContext)).iterate();
    }

    @Override
    public final void process(XPathContext xPathContext) {
        SequenceIterator<?> sequenceIterator = this.call(xPathContext, this.a(xPathContext)).iterate();
        sequenceIterator.forEachOrFail(item -> xPathContext.getReceiver().append(item, this.getLocation(), 524288));
    }

    private Sequence<?>[] a(XPathContext xPathContext) {
        Sequence<?>[] sequenceArray = SequenceTool.makeSequenceArray(this.getOperanda().getNumberOfOperands());
        int n2 = 0;
        for (Operand operand : ((Expression)this).operands()) {
            sequenceArray[n2++] = SequenceTool.toLazySequence(operand.getChildExpression().iterate(xPathContext));
        }
        return sequenceArray;
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        throw new XPathException("In general, stylesheets using extension instructions cannot be exported");
    }

    public String getExpressionType() {
        return this.getClass().getName();
    }
}

