/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;

public final class SimpleStepExpression
extends SlashExpression {
    private static OperandRole a = new OperandRole(6, OperandUsage.TRANSMISSION, SequenceType.ANY_SEQUENCE);

    public SimpleStepExpression(Expression expression, Expression expression2) {
        super(expression, expression2);
        if (!(expression2 instanceof AxisExpression)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected final OperandRole getOperandRole(int n2) {
        if (n2 == 0) {
            return OperandRole.FOCUS_CONTROLLING_SELECT;
        }
        return a;
    }

    @Override
    public final Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo object2) {
        this.getLhs().typeCheck((ExpressionVisitor)object, (ContextItemStaticInfo)object2);
        object2 = this.getStart().getItemType();
        if (object2 == ErrorType.getInstance()) {
            return Literal.makeEmptySequence();
        }
        object2 = ((ExpressionVisitor)object).getConfiguration().makeContextItemStaticInfo((ItemType)object2, false);
        ((ContextItemStaticInfo)object2).setContextSettingExpression(this.getStart());
        this.getRhs().typeCheck((ExpressionVisitor)object, (ContextItemStaticInfo)object2);
        if (!(this.getStep() instanceof AxisExpression)) {
            if (Literal.isEmptySequence(this.getStep())) {
                return this.getStep();
            }
            object = new SlashExpression(this.getStart(), this.getStep());
            ExpressionTool.copyLocationInfo(this, (Expression)object);
            return object;
        }
        if (this.getStart() instanceof ContextItemExpression && AxisInfo.isForwards[((AxisExpression)this.getStep()).getAxis()]) {
            return this.getStep();
        }
        return this;
    }

    @Override
    public final Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        return this;
    }

    @Override
    public final SimpleStepExpression copy(RebindingMap object) {
        object = new SimpleStepExpression(this.getStart().copy((RebindingMap)object), this.getStep().copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public final int getImplementationMethod() {
        return 2;
    }

    @Override
    public final SequenceIterator<?> iterate(XPathContext object) {
        try {
            object = (NodeInfo)this.getStart().evaluateItem((XPathContext)object);
        }
        catch (XPathException xPathException) {
            if ("XPDY0002".equals(xPathException.getErrorCodeLocalPart()) && !xPathException.hasBeenReported()) {
                throw new XPathException("The context item for axis step " + ((Expression)this).toShortString() + " is absent", "XPDY0002", this.getLocation());
            }
            throw xPathException;
        }
        if (object == null) {
            return EmptyIterator.getInstance();
        }
        return ((AxisExpression)this.getStep()).iterate((NodeInfo)object);
    }

    @Override
    public final String getExpressionName() {
        return "simpleStep";
    }
}

