/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.value.Cardinality;

public abstract class SingleItemFilter
extends UnaryExpression {
    public SingleItemFilter(Expression expression) {
        super(expression);
    }

    @Override
    protected OperandRole getOperandRole() {
        return OperandRole.SAME_FOCUS_ACTION;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.getOperand().optimize(expressionVisitor, contextItemStaticInfo);
        Expression expression = this.getBaseExpression();
        if (!Cardinality.allowsMany(expression.getCardinality())) {
            return expression;
        }
        return super.optimize(expressionVisitor, contextItemStaticInfo);
    }

    @Override
    public int computeCardinality() {
        return 24576;
    }
}

