/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

public final class SingletonAtomizer
extends UnaryExpression {
    private boolean a;
    private RoleDiagnostic b;

    public SingletonAtomizer(Expression expression, RoleDiagnostic roleDiagnostic, boolean bl2) {
        super(expression);
        this.a = bl2;
        this.b = roleDiagnostic;
    }

    @Override
    protected final OperandRole getOperandRole() {
        return OperandRole.SINGLE_ATOMIC;
    }

    public final boolean isAllowEmpty() {
        return this.a;
    }

    @Override
    public final Expression simplify() {
        Expression expression = this.getBaseExpression().simplify();
        if (expression instanceof Literal && ((Literal)expression).getValue() instanceof AtomicValue) {
            return expression;
        }
        this.setBaseExpression(expression);
        return this;
    }

    @Override
    public final Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo object2) {
        this.getOperand().typeCheck((ExpressionVisitor)object, (ContextItemStaticInfo)object2);
        object2 = this.getBaseExpression();
        ExpressionTool.resetStaticProperties(this);
        if (Literal.isEmptySequence((Expression)object2)) {
            if (!this.a) {
                this.typeError("An empty sequence is not allowed as the " + this.b.getMessage(), this.b.getErrorCode(), null);
            }
            return object2;
        }
        ItemType itemType = ((Expression)object2).getItemType();
        if (itemType.isPlainType()) {
            return object2;
        }
        if (!itemType.isAtomizable(((ExpressionVisitor)object).getConfiguration().getTypeHierarchy())) {
            object = itemType instanceof MapType ? new XPathException("Cannot atomize a map (" + ((Expression)this).toShortString() + ")", "FOTY0013") : (itemType instanceof FunctionItemType ? new XPathException("Cannot atomize a function item", "FOTY0013") : new XPathException("Cannot atomize an element that is defined in the schema to have element-only content", "FOTY0012"));
            ((XPathException)object).setIsTypeError(true);
            ((XPathException)object).setLocation(this.getLocation());
            ((XPathException)object).setFailingExpression(this.getParentExpression());
            throw object;
        }
        return this;
    }

    @Override
    public final Expression optimize(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        if ((object = super.optimize((ExpressionVisitor)object, contextItemStaticInfo)) == this) {
            SingletonAtomizer singletonAtomizer = this;
            singletonAtomizer.setBaseExpression(singletonAtomizer.getBaseExpression().unordered(true, false));
            if (this.getBaseExpression().getItemType().isPlainType() && !Cardinality.allowsMany(this.getBaseExpression().getCardinality())) {
                return this.getBaseExpression();
            }
            return this;
        }
        return object;
    }

    @Override
    public final int computeSpecialProperties() {
        int n2 = super.computeSpecialProperties();
        return n2 | 0x800000;
    }

    @Override
    public final Expression copy(RebindingMap object) {
        object = new SingletonAtomizer(this.getBaseExpression().copy((RebindingMap)object), this.b, this.a);
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public final int getImplementationMethod() {
        return 1;
    }

    @Override
    public final String getStreamerName() {
        return "SingletonAtomizer";
    }

    public final RoleDiagnostic getRole() {
        return this.b;
    }

    @Override
    public final PathMap.PathMapNodeSet addToPathMap(PathMap object, PathMap.PathMapNodeSet object2) {
        ItemType itemType;
        object = this.getBaseExpression().addToPathMap((PathMap)object, (PathMap.PathMapNodeSet)object2);
        if (object != null && (((TypeHierarchy)(object2 = this.getConfiguration().getTypeHierarchy())).relationship(NodeKindTest.ELEMENT, itemType = this.getBaseExpression().getItemType()) != 4 || ((TypeHierarchy)object2).relationship(NodeKindTest.DOCUMENT, itemType) != 4)) {
            ((PathMap.PathMapNodeSet)object).setAtomized();
        }
        return null;
    }

    public final AtomicValue evaluateItem(XPathContext xPathContext) {
        Object object;
        int n2 = 0;
        AtomicValue atomicValue = null;
        SequenceIterator<?> sequenceIterator = this.getBaseExpression().iterate(xPathContext);
        while ((object = sequenceIterator.next()) != null) {
            if ((n2 += (object = object.atomize()).getLength()) > 1) {
                this.typeError("A sequence of more than one item is not allowed as the " + this.b.getMessage() + CardinalityChecker.depictSequenceStart(this.getBaseExpression().iterate(xPathContext), 3), this.b.getErrorCode(), xPathContext);
            }
            if (n2 != 1) continue;
            atomicValue = object.head();
        }
        if (n2 == 0 && !this.a) {
            this.typeError("An empty sequence is not allowed as the " + this.b.getMessage(), this.b.getErrorCode(), null);
        }
        return atomicValue;
    }

    @Override
    public final ItemType getItemType() {
        boolean bl2;
        block10: {
            bl2 = true;
            try {
                bl2 = this.getPackageData().isSchemaAware();
            }
            catch (NullPointerException nullPointerException) {
                if (this.getConfiguration().isLicensedFeature(1)) break block10;
                bl2 = false;
            }
        }
        ItemType itemType = this.getBaseExpression().getItemType();
        if (itemType.isPlainType()) {
            return itemType;
        }
        if (itemType instanceof NodeTest) {
            UType uType = itemType.getUType();
            if (!bl2) {
                if (Atomizer.STRING_KINDS.subsumes(uType)) {
                    return BuiltInAtomicType.STRING;
                }
                if (Atomizer.UNTYPED_IF_UNTYPED_KINDS.subsumes(uType)) {
                    return BuiltInAtomicType.UNTYPED_ATOMIC;
                }
            } else if (Atomizer.UNTYPED_KINDS.subsumes(uType)) {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
            return itemType.getAtomizedItemType();
        }
        if (itemType instanceof JavaExternalObjectType) {
            return itemType.getAtomizedItemType();
        }
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    @Override
    public final int computeCardinality() {
        if (this.a) {
            return 24576;
        }
        return 16384;
    }

    @Override
    public final String getExpressionName() {
        return "atomizeSingleton";
    }

    @Override
    public final void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("atomSing", this);
        if (this.a) {
            expressionPresenter.emitAttribute("card", "?");
        }
        expressionPresenter.emitAttribute("diag", this.getRole().save());
        this.getBaseExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public final String toShortString() {
        return this.getBaseExpression().toShortString();
    }
}

