/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SimpleStepExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.CopyOf;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.functions.Doc;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.KeyFn;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AncestorQualifiedPattern;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.GeneralNodePattern;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternMaker;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public class SlashExpression
extends BinaryExpression
implements ContextSwitchingExpression {
    private boolean a;

    public SlashExpression(Expression expression, Expression expression2) {
        super(expression, 2, expression2);
    }

    @Override
    protected OperandRole getOperandRole(int n2) {
        if (n2 == 0) {
            return OperandRole.FOCUS_CONTROLLING_SELECT;
        }
        return OperandRole.FOCUS_CONTROLLED_ACTION;
    }

    public Expression getStart() {
        return this.getLhsExpression();
    }

    public void setStart(Expression expression) {
        this.setLhsExpression(expression);
    }

    public Expression getStep() {
        return this.getRhsExpression();
    }

    public void setStep(Expression expression) {
        this.setRhsExpression(expression);
    }

    @Override
    public String getExpressionName() {
        return "pathExpression";
    }

    @Override
    public Expression getSelectExpression() {
        return this.getStart();
    }

    @Override
    public Expression getActionExpression() {
        return this.getStep();
    }

    @Override
    public final ItemType getItemType() {
        return this.getStep().getItemType();
    }

    @Override
    public UType getStaticUType(UType uType) {
        return this.getStep().getStaticUType(this.getStart().getStaticUType(uType));
    }

    @Override
    public IntegerValue[] getIntegerBounds() {
        return this.getStep().getIntegerBounds();
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.getLhs().typeCheck(expressionVisitor, contextItemStaticInfo);
        if (Literal.isEmptySequence(this.getStart())) {
            return this.getStart();
        }
        Configuration configuration = expressionVisitor.getConfiguration();
        Object object = configuration.getTypeChecker(false);
        Object object2 = new RoleDiagnostic(1, "/", 0);
        ((RoleDiagnostic)object2).setErrorCode("XPTY0019");
        this.setStart(((TypeChecker)object).staticTypeCheck(this.getStart(), SequenceType.NODE_SEQUENCE, (RoleDiagnostic)object2, expressionVisitor));
        object = this.getStart().getItemType();
        if (object == ErrorType.getInstance()) {
            return Literal.makeEmptySequence();
        }
        object2 = configuration.makeContextItemStaticInfo((ItemType)object, false);
        ((ContextItemStaticInfo)object2).setContextSettingExpression(this.getStart());
        this.getRhs().typeCheck(expressionVisitor, (ContextItemStaticInfo)object2);
        object2 = this.simplifyDescendantPath(expressionVisitor.getStaticContext());
        if (object2 != null) {
            return ((Expression)object2).typeCheck(expressionVisitor, contextItemStaticInfo);
        }
        if (this.getStart() instanceof ContextItemExpression && this.getStep().hasSpecialProperty(131072)) {
            return this.getStep();
        }
        if (this.getStep() instanceof ContextItemExpression && this.getStart().hasSpecialProperty(131072)) {
            return this.getStart();
        }
        if (this.getStep() instanceof AxisExpression && ((AxisExpression)this.getStep()).getAxis() == 12 && configuration.getTypeHierarchy().isSubType((ItemType)object, this.getStep().getItemType())) {
            return this.getStart();
        }
        return this;
    }

    public SlashExpression simplifyDescendantPath(StaticContext object) {
        Object object2;
        Expression expression = this.getStep();
        while (expression instanceof FilterExpression) {
            if (((FilterExpression)expression).isPositional(object.getConfiguration().getTypeHierarchy())) {
                return null;
            }
            expression = ((FilterExpression)expression).getSelectExpression();
        }
        if (!(expression instanceof AxisExpression)) {
            return null;
        }
        object = this.getStart();
        if (object instanceof AxisExpression) {
            if (((AxisExpression)(object = (AxisExpression)object)).getAxis() != 5) {
                return null;
            }
            object2 = new ContextItemExpression();
            ExpressionTool.copyLocationInfo(this, (Expression)object2);
            object = ExpressionTool.makePathExpression((Expression)object2, ((Expression)object).copy(new RebindingMap()));
            ExpressionTool.copyLocationInfo(this, (Expression)object);
        }
        if (!(object instanceof SlashExpression)) {
            return null;
        }
        if (!(((SlashExpression)(object = (SlashExpression)object)).getStep() instanceof AxisExpression)) {
            return null;
        }
        object2 = (AxisExpression)((SlashExpression)object).getStep();
        if (((AxisExpression)object2).getAxis() != 5) {
            return null;
        }
        if ((object2 = ((AxisExpression)object2).getNodeTest()) != null && !(object2 instanceof AnyNodeTest)) {
            return null;
        }
        byte by = ((AxisExpression)expression).getAxis();
        if (by == 3 || by == 4 || by == 5) {
            by = by == 5 ? (byte)5 : 4;
            Expression expression2 = new AxisExpression(by, ((AxisExpression)expression).getNodeTest());
            ExpressionTool.copyLocationInfo(this, expression2);
            expression = this.getStep();
            Stack<Expression> stack = new Stack<Expression>();
            while (expression instanceof FilterExpression) {
                stack.add(((FilterExpression)expression).getFilter());
                expression = ((FilterExpression)expression).getSelectExpression();
            }
            while (!stack.isEmpty()) {
                expression2 = new FilterExpression(expression2, (Expression)stack.pop());
                ExpressionTool.copyLocationInfo(this.getStep(), expression2);
            }
            if (!((object = ExpressionTool.makePathExpression(((SlashExpression)object).getStart(), expression2)) instanceof SlashExpression)) {
                return null;
            }
            ExpressionTool.copyLocationInfo(this, (Expression)object);
            return (SlashExpression)object;
        }
        if (by == 2) {
            Expression expression3 = new AxisExpression(5, NodeKindTest.ELEMENT);
            ExpressionTool.copyLocationInfo(this, expression3);
            expression3 = ExpressionTool.makePathExpression(((SlashExpression)object).getStart(), expression3);
            Expression expression4 = ExpressionTool.makePathExpression(expression3, this.getStep());
            if (!(expression4 instanceof SlashExpression)) {
                return null;
            }
            ExpressionTool.copyLocationInfo(this, expression4);
            return (SlashExpression)expression4;
        }
        return null;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        Object object = expressionVisitor.getConfiguration();
        object = ((Configuration)object).getTypeHierarchy();
        Optimizer optimizer = expressionVisitor.obtainOptimizer();
        this.getLhs().optimize(expressionVisitor, contextItemStaticInfo);
        if (Literal.isEmptySequence(this.getStart())) {
            return Literal.makeEmptySequence();
        }
        Object object2 = expressionVisitor.getConfiguration().makeContextItemStaticInfo(this.getStart().getItemType(), false);
        ((ContextItemStaticInfo)object2).setContextSettingExpression(this.getStart());
        this.getRhs().optimize(expressionVisitor, (ContextItemStaticInfo)object2);
        if (Literal.isEmptySequence(this.getStep())) {
            return Literal.makeEmptySequence();
        }
        if (this.getStart() instanceof RootExpression && ((TypeHierarchy)object).isSubType(contextItemStaticInfo.getItemType(), NodeKindTest.DOCUMENT)) {
            return this.getStep();
        }
        object2 = this.simplifyDescendantPath(expressionVisitor.getStaticContext());
        if (object2 != null) {
            return ((Expression)object2).optimize(expressionVisitor, contextItemStaticInfo);
        }
        object2 = this.getFirstStep();
        if (!((Expression)object2).isCallOn(Doc.class) && !((Expression)object2).isCallOn(DocumentFn.class) && (object2 = this.getLastStep()) instanceof FilterExpression && !((FilterExpression)object2).isPositional((TypeHierarchy)object)) {
            object = this.getLeadingSteps();
            object = ExpressionTool.makePathExpression((Expression)object, ((FilterExpression)object2).getSelectExpression());
            object = new FilterExpression((Expression)object, ((FilterExpression)object2).getFilter());
            ExpressionTool.copyLocationInfo(this, (Expression)object);
            return ((Expression)object).optimize(expressionVisitor, contextItemStaticInfo);
        }
        if (!expressionVisitor.isOptimizeForStreaming() && (object2 = optimizer.convertPathExpressionToKey(this, expressionVisitor)) != null) {
            return ((Expression)object2).typeCheck(expressionVisitor, contextItemStaticInfo).optimize(expressionVisitor, contextItemStaticInfo);
        }
        object2 = this.tryToMakeSorted(expressionVisitor, contextItemStaticInfo);
        if (object2 != null) {
            return object2;
        }
        if (this.getStep() instanceof AxisExpression) {
            if (!Cardinality.allowsMany(this.getStart().getCardinality())) {
                object2 = new SimpleStepExpression(this.getStart(), this.getStep());
                ExpressionTool.copyLocationInfo(this, (Expression)object2);
                ((Expression)object2).setParentExpression(this.getParentExpression());
                return object2;
            }
            this.a = true;
        }
        if (this.getStart() instanceof RootExpression && this.getStep().isCallOn(KeyFn.class) && ((FunctionCall)(object2 = (SystemFunctionCall)this.getStep())).getArity() == 3 && ((FunctionCall)object2).getArg(2) instanceof ContextItemExpression) {
            ((FunctionCall)object2).setArg(2, new RootExpression());
            ((Expression)object2).setParentExpression(this.getParentExpression());
            ExpressionTool.resetStaticProperties((Expression)object2);
            return object2;
        }
        object2 = this.promoteFocusIndependentSubexpressions(expressionVisitor, contextItemStaticInfo);
        if (object2 != this) {
            return object2;
        }
        if (expressionVisitor.isOptimizeForStreaming() && (object = ExpressionTool.unfilteredExpression(this.getStep(), true)) instanceof CopyOf && ((CopyOf)object).getSelect() instanceof ContextItemExpression) {
            ((CopyOf)object).setSelect(this.getStart());
            ((Expression)object).resetLocalStaticProperties();
            this.getStep().resetLocalStaticProperties();
            return this.getStep();
        }
        return this;
    }

    public SlashExpression tryToMakeAbsolute() {
        Object object;
        Expression expression = this.getFirstStep();
        if (expression.getItemType().getPrimitiveType() == 9) {
            return this;
        }
        if (expression instanceof AxisExpression && (object = ((AxisExpression)expression).getContextItemType()) != null && object.getPrimitiveType() == 9) {
            expression = new RootExpression();
            ExpressionTool.copyLocationInfo(this, expression);
            object = ExpressionTool.makePathExpression(expression, ((Expression)this).copy(new RebindingMap()));
            if (!(object instanceof SlashExpression)) {
                return null;
            }
            ExpressionTool.copyLocationInfo(this, (Expression)object);
            return (SlashExpression)object;
        }
        if (expression instanceof DocumentSorter && ((DocumentSorter)expression).getBaseExpression() instanceof SlashExpression && (expression = ((SlashExpression)(object = (SlashExpression)((DocumentSorter)expression).getBaseExpression())).tryToMakeAbsolute()) != null) {
            if (expression == object) {
                return this;
            }
            object = this.getRemainingSteps();
            expression = new DocumentSorter(expression);
            return new SlashExpression(expression, (Expression)object);
        }
        return null;
    }

    @Override
    public double getCost() {
        int n2 = Cardinality.allowsMany(this.getLhsExpression().getCardinality()) ? 5 : 1;
        double d2 = this.getLhsExpression().getCost() + 1.0;
        double d3 = this.getRhsExpression().getCost();
        double d4 = d2 + (double)n2 * d3;
        return Math.max(d4, 1.0E9);
    }

    public Expression tryToMakeSorted(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        Object object2 = ((ExpressionVisitor)object).getConfiguration();
        object2 = ((Configuration)object2).getTypeHierarchy();
        object = ((ExpressionVisitor)object).obtainOptimizer();
        Expression expression = ExpressionTool.unfilteredExpression(this.getStart(), false);
        if (!(expression instanceof AxisExpression) || ((AxisExpression)expression).getAxis() != 4) {
            return null;
        }
        expression = ExpressionTool.unfilteredExpression(this.getStep(), false);
        if (!(expression instanceof AxisExpression) || ((AxisExpression)expression).getAxis() != 3) {
            return null;
        }
        expression = this.getStart().copy(new RebindingMap());
        Expression expression2 = (AxisExpression)ExpressionTool.unfilteredExpression(expression, false);
        expression2.setAxis((byte)9);
        expression2 = this.getStep().copy(new RebindingMap());
        AxisExpression axisExpression = (AxisExpression)ExpressionTool.unfilteredExpression(expression2, false);
        axisExpression.setAxis((byte)4);
        expression = new FilterExpression(expression2, expression);
        if (!((TypeHierarchy)object2).isSubType(contextItemStaticInfo.getItemType(), NodeKindTest.DOCUMENT)) {
            expression = new SlashExpression(new AxisExpression(3, NodeKindTest.ELEMENT), expression);
            ExpressionTool.copyLocationInfo(this, expression);
            ((Optimizer)object).trace("Rewrote descendant::X/child::Y as child::*/descendant::Y[parent::X]", expression);
        } else {
            ExpressionTool.copyLocationInfo(this, expression);
            ((Optimizer)object).trace("Rewrote descendant::X/child::Y as descendant::Y[parent::X]", expression);
        }
        return expression;
    }

    protected Expression promoteFocusIndependentSubexpressions(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        return this;
    }

    @Override
    public Expression unordered(boolean bl2, boolean bl3) {
        SlashExpression slashExpression = this;
        slashExpression.setStart(slashExpression.getStart().unordered(bl2, bl3));
        SlashExpression slashExpression2 = this;
        slashExpression2.setStep(slashExpression2.getStep().unordered(bl2, bl3));
        return this;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        pathMapNodeSet = this.getStart().addToPathMap(pathMap, pathMapNodeSet);
        return this.getStep().addToPathMap(pathMap, pathMapNodeSet);
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = ExpressionTool.makePathExpression(this.getStart().copy((RebindingMap)object), this.getStep().copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int computeSpecialProperties() {
        block18: {
            block17: {
                block16: {
                    var1_1 = this.getStart().getSpecialProperties();
                    var2_2 = this.getStep().getSpecialProperties();
                    if ((var2_2 & 0x400000) != 0) {
                        return 0x8A0000;
                    }
                    var3_3 = 0;
                    if (!Cardinality.allowsMany(this.getStart().getCardinality())) {
                        var1_1 |= 0x10A0000;
                    }
                    if (!Cardinality.allowsMany(this.getStep().getCardinality())) {
                        var2_2 |= 0x10A0000;
                    }
                    if ((var1_1 & var2_2 & 65536) != 0) {
                        var3_3 = 65536;
                    }
                    if ((var1_1 & 0x1000000) != 0 && (var2_2 & 65536) != 0) {
                        var3_3 |= 0x1000000;
                    }
                    if ((var1_1 & var2_2 & 524288) != 0) {
                        var3_3 |= 524288;
                    }
                    if ((var1_1 & var2_2 & 0x100000) != 0) {
                        var3_3 |= 0x100000;
                    }
                    var6_4 = var2_2;
                    var5_5 = var1_1;
                    var4_6 = this;
                    if ((var6_4 & 131072) == 0) ** GOTO lbl-1000
                    if (!Cardinality.allowsMany(var4_6.getStart().getCardinality())) break block16;
                    if ((var5_5 & 131072) != 0) break block17;
                    ** GOTO lbl-1000
                }
                v0 = true;
                break block18;
            }
            if ((var6_4 & 0x200000) != 0) {
                v0 = true;
            } else if ((var6_4 & 0x400000) != 0) {
                v0 = true;
            } else if ((var5_5 & 524288) != 0 && (var6_4 & 0x100000) != 0) {
                v0 = true;
            } else lbl-1000:
            // 3 sources

            {
                v0 = false;
            }
        }
        if (v0) {
            var3_3 |= 131072;
        }
        v1 = !Cardinality.allowsMany((var4_6 = this).getStart().getCardinality()) && var4_6.getStep() instanceof AxisExpression ? !AxisInfo.isForwards[((AxisExpression)var4_6.getStep()).getAxis()] : Cardinality.allowsMany(var4_6.getStep().getCardinality()) == false && var4_6.getStart() instanceof AxisExpression != false && AxisInfo.isForwards[((AxisExpression)var4_6.getStart()).getAxis()] == false;
        if (v1) {
            var3_3 |= 262144;
        }
        if ((var1_1 & var2_2 & 0x800000) != 0) {
            var3_3 |= 0x800000;
        }
        return var3_3;
    }

    @Override
    public int computeCardinality() {
        int n2 = this.getStart().getCardinality();
        int n3 = this.getStep().getCardinality();
        return Cardinality.multiply(n2, n3);
    }

    @Override
    public Pattern toPattern(Configuration configuration) {
        AxisExpression axisExpression;
        SlashExpression slashExpression;
        Expression expression;
        Expression expression2 = this.getLeadingSteps();
        Expression expression3 = this.getLastStep();
        if (expression2 instanceof ItemChecker && ((UnaryExpression)(expression = (ItemChecker)expression2)).getBaseExpression() instanceof ContextItemExpression) {
            return expression3.toPattern(configuration);
        }
        expression = expression3.toPattern(configuration);
        if (expression instanceof NodeTestPattern) {
            if (expression.getItemType() instanceof ErrorType) {
                return expression;
            }
        } else if (expression instanceof GeneralNodePattern) {
            return new GeneralNodePattern(this, (NodeTest)expression.getItemType());
        }
        byte by = 0;
        Pattern pattern = null;
        if (expression2 instanceof SlashExpression && (slashExpression = (SlashExpression)expression2).getActionExpression() instanceof AxisExpression && (axisExpression = (AxisExpression)slashExpression.getActionExpression()).getAxis() == 5 && (axisExpression.getNodeTest() == null || axisExpression.getNodeTest() instanceof AnyNodeTest)) {
            by = 0;
            pattern = slashExpression.getSelectExpression().toPattern(configuration);
        }
        if (pattern == null) {
            by = PatternMaker.getAxisForPathStep(expression3);
            pattern = expression2.toPattern(configuration);
        }
        return new AncestorQualifiedPattern((Pattern)expression, pattern, by);
    }

    public boolean isContextFree() {
        return this.a;
    }

    public void setContextFree(boolean bl2) {
        this.a = bl2;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SlashExpression)) {
            return false;
        }
        object = (SlashExpression)object;
        return this.getStart().isEqual(((SlashExpression)object).getStart()) && this.getStep().isEqual(((SlashExpression)object).getStep());
    }

    @Override
    public int computeHashCode() {
        return "SlashExpression".hashCode() + this.getStart().hashCode() + this.getStep().hashCode();
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext2) {
        if (this.a) {
            return new MappingIterator(this.getStart().iterate(xPathContext2), item -> ((AxisExpression)this.getRhsExpression()).iterate((NodeInfo)item));
        }
        XPathContextMinor xPathContextMinor = xPathContext2.newMinorContext();
        xPathContextMinor.trackFocus(this.getStart().iterate(xPathContext2));
        return new ContextMappingIterator(xPathContext -> this.getStep().iterate(xPathContext), xPathContextMinor);
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("slash", this);
        if (this instanceof SimpleStepExpression) {
            expressionPresenter.emitAttribute("simple", "1");
        } else if (this.isContextFree()) {
            expressionPresenter.emitAttribute("simple", "2");
        }
        this.getStart().export(expressionPresenter);
        this.getStep().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public String toString() {
        return ExpressionTool.parenthesize(this.getStart()) + "/" + ExpressionTool.parenthesize(this.getStep());
    }

    @Override
    public String toShortString() {
        return ExpressionTool.parenthesizeShort(this.getStart()) + "/" + ExpressionTool.parenthesizeShort(this.getStep());
    }

    public Expression getFirstStep() {
        if (this.getStart() instanceof SlashExpression) {
            return ((SlashExpression)this.getStart()).getFirstStep();
        }
        return this.getStart();
    }

    public Expression getRemainingSteps() {
        if (this.getStart() instanceof SlashExpression) {
            Object object = new ArrayList<Expression>(8);
            this.a((List<Expression>)object);
            object = this.b(object.subList(1, object.size()));
            ExpressionTool.copyLocationInfo(this, (Expression)object);
            return object;
        }
        return this.getStep();
    }

    private void a(List<Expression> list) {
        if (this.getStart() instanceof SlashExpression) {
            ((SlashExpression)this.getStart()).a(list);
        } else {
            list.add(this.getStart());
        }
        if (this.getStep() instanceof SlashExpression) {
            ((SlashExpression)this.getStep()).a(list);
            return;
        }
        list.add(this.getStep());
    }

    private Expression b(List<Expression> list) {
        if (list.size() == 1) {
            return list.get(0).copy(new RebindingMap());
        }
        return new SlashExpression(list.get(0).copy(new RebindingMap()), this.b(list.subList(1, list.size())));
    }

    public Expression getLastStep() {
        if (this.getStep() instanceof SlashExpression) {
            return ((SlashExpression)this.getStep()).getLastStep();
        }
        return this.getStep();
    }

    public Expression getLeadingSteps() {
        if (this.getStep() instanceof SlashExpression) {
            Object object = new ArrayList<Expression>(8);
            this.a((List<Expression>)object);
            object = this.b(object.subList(0, object.size() - 1));
            ExpressionTool.copyLocationInfo(this, (Expression)object);
            return object;
        }
        return this.getStart();
    }

    public boolean isAbsolute() {
        return this.getFirstStep().getItemType().getPrimitiveType() == 9;
    }

    @Override
    public String getStreamerName() {
        return "ForEach";
    }
}

