/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Arrays;
import java.util.Stack;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.om.Sequence;

public class StackFrame {
    protected SlotManager map;
    protected Sequence<?>[] slots;
    protected Stack<Sequence<?>> dynamicStack;
    public static final StackFrame EMPTY = new StackFrame(SlotManager.EMPTY, new Sequence[0]);

    public StackFrame(SlotManager slotManager, Sequence[] sequenceArray) {
        this.map = slotManager;
        this.slots = sequenceArray;
    }

    public SlotManager getStackFrameMap() {
        return this.map;
    }

    public Sequence<?>[] getStackFrameValues() {
        return this.slots;
    }

    public void setStackFrameValues(Sequence[] sequenceArray) {
        this.slots = sequenceArray;
    }

    public StackFrame copy() {
        Object object = Arrays.copyOf(this.slots, this.slots.length);
        object = new StackFrame(this.map, (Sequence[])object);
        if (this.dynamicStack != null) {
            object.dynamicStack = new Stack();
            object.dynamicStack.addAll(this.dynamicStack);
        }
        return object;
    }

    public void pushDynamicValue(Sequence<?> sequence) {
        if (this == EMPTY) {
            throw new IllegalStateException("Immutable stack frame");
        }
        if (this.dynamicStack == null) {
            this.dynamicStack = new Stack();
        }
        this.dynamicStack.push(sequence);
    }

    public Sequence<?> popDynamicValue() {
        return this.dynamicStack.pop();
    }

    public boolean holdsDynamicValue() {
        return this.dynamicStack != null && !this.dynamicStack.empty();
    }
}

