/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.ListCastableFunction;
import net.sf.saxon.expr.ListConstructorFunction;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.UnionCastableFunction;
import net.sf.saxon.expr.UnionConstructorFunction;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.OriginalFunction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;

public class StaticFunctionCall
extends FunctionCall
implements Callable {
    private Function a;

    public StaticFunctionCall(Function function, Expression[] expressionArray) {
        if (function.getArity() != expressionArray.length) {
            throw new IllegalArgumentException("Function call to " + function.getFunctionName() + " with wrong number of arguments (" + expressionArray.length + ")");
        }
        this.a = function;
        this.setOperanda(expressionArray, function.getOperandRoles());
    }

    public Function getTargetFunction() {
        return this.a;
    }

    @Override
    public Function getTargetFunction(XPathContext xPathContext) {
        return this.getTargetFunction();
    }

    @Override
    public StructuredQName getFunctionName() {
        return this.a.getFunctionName();
    }

    @Override
    public boolean isCallOn(Class<? extends SystemFunction> clazz) {
        return clazz.isAssignableFrom(this.a.getClass());
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        StaticFunctionCall staticFunctionCall = this;
        staticFunctionCall.checkFunctionCall(staticFunctionCall.a, expressionVisitor);
        return super.typeCheck(expressionVisitor, contextItemStaticInfo);
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        Expression[] expressionArray = new Expression[this.getArity()];
        for (int i2 = 0; i2 < expressionArray.length; ++i2) {
            expressionArray[i2] = this.getArg(i2).copy(rebindingMap);
        }
        return new StaticFunctionCall(this.a, expressionArray);
    }

    @Override
    protected int computeCardinality() {
        return this.a.getFunctionItemType().getResultType().getCardinality();
    }

    @Override
    public ItemType getItemType() {
        return this.a.getFunctionItemType().getResultType().getPrimaryType();
    }

    @Override
    public UType getStaticUType(UType uType) {
        UType uType2 = ((Expression)this).getItemType().getUType();
        for (Operand operand : ((Expression)this).operands()) {
            if (operand.getUsage() != OperandUsage.TRANSMISSION) continue;
            uType2 = uType2.intersection(operand.getChildExpression().getStaticUType(uType));
        }
        return uType2;
    }

    @Override
    public Sequence<?> call(XPathContext xPathContext, Sequence<?>[] sequenceArray) {
        return this.a.call(xPathContext, (Sequence[])sequenceArray);
    }

    @Override
    public String getExpressionName() {
        return "staticFunctionCall";
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        if (this.a instanceof OriginalFunction) {
            ExpressionPresenter.ExportOptions exportOptions = (ExpressionPresenter.ExportOptions)expressionPresenter.getOptions();
            OriginalFunction iterable2 = (OriginalFunction)this.a;
            expressionPresenter.startElement("origFC", this);
            expressionPresenter.emitAttribute("name", iterable2.getFunctionName());
            expressionPresenter.emitAttribute("pack", "" + exportOptions.packageMap.get(iterable2.getComponent().getContainingPackage()));
            for (Operand operand : ((Expression)this).operands()) {
                operand.getChildExpression().export(expressionPresenter);
            }
            expressionPresenter.endElement();
            return;
        }
        if (this.a instanceof UnionCastableFunction) {
            expressionPresenter.startElement("castable", this);
            expressionPresenter.emitAttribute("emptiable", ((UnionCastableFunction)this.a).isAllowEmpty() ? "1" : "0");
            expressionPresenter.emitAttribute("as", ((UnionCastableFunction)this.a).getTargetType().toExportString());
            for (Operand operand : ((Expression)this).operands()) {
                operand.getChildExpression().export(expressionPresenter);
            }
            expressionPresenter.endElement();
            return;
        }
        if (this.a instanceof ListCastableFunction) {
            expressionPresenter.startElement("castable", this);
            expressionPresenter.emitAttribute("emptiable", ((ListCastableFunction)this.a).isAllowEmpty() ? "1" : "0");
            expressionPresenter.emitAttribute("as", ((ListCastableFunction)this.a).getTargetType().getStructuredQName());
            for (Operand operand : ((Expression)this).operands()) {
                operand.getChildExpression().export(expressionPresenter);
            }
            expressionPresenter.endElement();
            return;
        }
        if (this.a instanceof UnionConstructorFunction) {
            expressionPresenter.startElement("cast", this);
            expressionPresenter.emitAttribute("emptiable", ((UnionConstructorFunction)this.a).isAllowEmpty() ? "1" : "0");
            expressionPresenter.emitAttribute("as", ((UnionConstructorFunction)this.a).getTargetType().toExportString());
            for (Operand operand : ((Expression)this).operands()) {
                operand.getChildExpression().export(expressionPresenter);
            }
            expressionPresenter.endElement();
            return;
        }
        if (this.a instanceof ListConstructorFunction) {
            expressionPresenter.startElement("cast", this);
            expressionPresenter.emitAttribute("emptiable", ((ListConstructorFunction)this.a).isAllowEmpty() ? "1" : "0");
            expressionPresenter.emitAttribute("as", ((ListConstructorFunction)this.a).getTargetType().getStructuredQName());
            for (Operand operand : ((Expression)this).operands()) {
                operand.getChildExpression().export(expressionPresenter);
            }
            expressionPresenter.endElement();
            return;
        }
        super.export(expressionPresenter);
    }
}

