/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.Cardinality;

public abstract class StaticProperty {
    public static final int DEPENDS_ON_CURRENT_ITEM = 1;
    public static final int DEPENDS_ON_CONTEXT_ITEM = 2;
    public static final int DEPENDS_ON_POSITION = 4;
    public static final int DEPENDS_ON_LAST = 8;
    public static final int DEPENDS_ON_CONTEXT_DOCUMENT = 16;
    public static final int DEPENDS_ON_CURRENT_GROUP = 32;
    public static final int DEPENDS_ON_REGEX_GROUP = 64;
    public static final int DEPENDS_ON_LOCAL_VARIABLES = 128;
    public static final int DEPENDS_ON_USER_FUNCTIONS = 256;
    public static final int DEPENDS_ON_ASSIGNABLE_GLOBALS = 512;
    public static final int DEPENDS_ON_RUNTIME_ENVIRONMENT = 1024;
    public static final int DEPENDS_ON_STATIC_CONTEXT = 2048;
    public static final int DEPENDS_ON_XSLT_CONTEXT = 609;
    public static final int DEPENDS_ON_FOCUS = 30;
    public static final int DEPENDS_ON_NON_DOCUMENT_FOCUS = 14;
    public static final int ALLOWS_ZERO = 8192;
    public static final int ALLOWS_ONE = 16384;
    public static final int ALLOWS_MANY = 32768;
    public static final int CARDINALITY_MASK = 57344;
    public static final int ALLOWS_ONE_OR_MORE = 49152;
    public static final int ALLOWS_ZERO_OR_MORE = 57344;
    public static final int ALLOWS_ZERO_OR_ONE = 24576;
    public static final int EXACTLY_ONE = 16384;
    public static final int EMPTY = 8192;
    public static final int CONTEXT_DOCUMENT_NODESET = 65536;
    public static final int ORDERED_NODESET = 131072;
    public static final int REVERSE_DOCUMENT_ORDER = 262144;
    public static final int PEER_NODESET = 524288;
    public static final int SUBTREE_NODESET = 0x100000;
    public static final int ATTRIBUTE_NS_NODESET = 0x200000;
    public static final int ALL_NODES_NEWLY_CREATED = 0x400000;
    public static final int NO_NODES_NEWLY_CREATED = 0x800000;
    public static final int SINGLE_DOCUMENT_NODESET = 0x1000000;
    public static final int HAS_SIDE_EFFECTS = 0x2000000;
    public static final int NOT_UNTYPED_ATOMIC = 0x4000000;
    public static final int ALL_NODES_UNTYPED = 0x8000000;
    public static final int DEPENDENCY_MASK = 0x2000FFF;
    public static final int SPECIAL_PROPERTY_MASK = 0xFFF0000;
    public static final int NODESET_PROPERTIES = 155123712;

    public static int getCardinalityCode(int n2) {
        return (n2 & 0xE000) >> 13;
    }

    private StaticProperty() {
    }

    public static String display(int n2) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(128);
        fastStringBuffer.append("D(");
        if ((n2 & 1) != 0) {
            fastStringBuffer.append("U");
        }
        if ((n2 & 2) != 0) {
            fastStringBuffer.append("C");
        }
        if ((n2 & 4) != 0) {
            fastStringBuffer.append("P");
        }
        if ((n2 & 8) != 0) {
            fastStringBuffer.append("L");
        }
        if ((n2 & 0x10) != 0) {
            fastStringBuffer.append("D");
        }
        if ((n2 & 0x80) != 0) {
            fastStringBuffer.append("V");
        }
        if ((n2 & 0x200) != 0) {
            fastStringBuffer.append("A");
        }
        if ((n2 & 0x40) != 0) {
            fastStringBuffer.append("R");
        }
        if ((n2 & 0x400) != 0) {
            fastStringBuffer.append("E");
        }
        if ((n2 & 0x800) != 0) {
            fastStringBuffer.append("S");
        }
        fastStringBuffer.append(") C(");
        boolean bl2 = Cardinality.allowsMany(n2);
        boolean bl3 = Cardinality.allowsZero(n2);
        if (bl2 && bl3) {
            fastStringBuffer.append("*");
        } else if (bl2) {
            fastStringBuffer.append("+");
        } else if (bl3) {
            fastStringBuffer.append("?");
        } else {
            fastStringBuffer.append("1");
        }
        fastStringBuffer.append(") S(");
        if ((n2 & 0x2000000) != 0) {
            fastStringBuffer.append("E");
        }
        if ((n2 & 0x800000) != 0) {
            fastStringBuffer.append("N");
        }
        if ((n2 & 0x4000000) != 0) {
            fastStringBuffer.append("T");
        }
        if ((n2 & 0x20000) != 0) {
            fastStringBuffer.append("O");
        }
        if ((n2 & 0x80000) != 0) {
            fastStringBuffer.append("P");
        }
        if ((n2 & 0x40000) != 0) {
            fastStringBuffer.append("R");
        }
        if ((n2 & 0x1000000) != 0) {
            fastStringBuffer.append("S");
        }
        if ((n2 & 0x100000) != 0) {
            fastStringBuffer.append("D");
        }
        fastStringBuffer.append(")");
        return fastStringBuffer.toString();
    }
}

