/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.SingleItemFilter;
import net.sf.saxon.expr.TailIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.MemoSequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.value.NumericValue;

public class SubscriptExpression
extends SingleItemFilter {
    private Operand a;

    public SubscriptExpression(Expression expression, Expression expression2) {
        super(expression);
        this.a = new Operand(this, expression2, OperandRole.SINGLE_ATOMIC);
    }

    public Expression getSubscript() {
        return this.a.getChildExpression();
    }

    public void setSubscript(Expression expression) {
        this.a.setChildExpression(expression);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.getOperand().typeCheck(expressionVisitor, contextItemStaticInfo);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.getOperand().optimize(expressionVisitor, contextItemStaticInfo);
        if (Literal.isConstantOne(this.getSubscript())) {
            return FirstItemExpression.makeFirstItemExpression(this.getBaseExpression());
        }
        return this;
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new SubscriptExpression(this.getBaseExpression().copy((RebindingMap)object), this.getSubscript().copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.getOperand(), this.a);
    }

    public Expression getSubscriptExpression() {
        return this.getSubscript();
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof SubscriptExpression && this.getBaseExpression().isEqual(((SubscriptExpression)object).getBaseExpression()) && this.getSubscript().isEqual(((SubscriptExpression)object).getSubscript());
    }

    @Override
    public int computeHashCode() {
        return this.getBaseExpression().hashCode() ^ this.getSubscript().hashCode();
    }

    @Override
    public int computeCardinality() {
        return 24576;
    }

    @Override
    public String getStreamerName() {
        return "SubscriptExpression";
    }

    public Item evaluateItem(XPathContext object) {
        NumericValue numericValue = (NumericValue)this.getSubscript().evaluateItem((XPathContext)object);
        if (numericValue == null) {
            return null;
        }
        int n2 = numericValue.asSubscript();
        if (n2 != -1) {
            object = this.getBaseExpression().iterate((XPathContext)object);
            if (n2 == 1) {
                object = object.next();
            } else if (object instanceof MemoSequence.ProgressiveIterator) {
                MemoSequence memoSequence = ((MemoSequence.ProgressiveIterator)object).getMemoSequence();
                object = memoSequence.itemAt(n2 - 1);
            } else if ((object.getProperties() & 1) != 0) {
                GroundedValue groundedValue = object.materialize();
                object = groundedValue.itemAt(n2 - 1);
            } else {
                SequenceIterator sequenceIterator = TailIterator.make(object, n2);
                object = sequenceIterator.next();
                sequenceIterator.close();
            }
            return object;
        }
        return null;
    }

    @Override
    public String getExpressionName() {
        return "subscript";
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("subscript", this);
        this.getBaseExpression().export(expressionPresenter);
        this.getSubscript().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public String toString() {
        return ExpressionTool.parenthesize(this.getBaseExpression()) + "[" + this.getSubscript() + "]";
    }

    @Override
    public String toShortString() {
        return ExpressionTool.parenthesize(this.getBaseExpression()) + "[" + this.getSubscript().toShortString() + "]";
    }
}

