/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Arrays;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Negatable;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.StaticFunctionCall;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.AnalyzeString;
import net.sf.saxon.expr.oper.OperandArray;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.Evaluator;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.CollectionFn;
import net.sf.saxon.functions.Concat;
import net.sf.saxon.functions.CurrentMergeGroup;
import net.sf.saxon.functions.CurrentMergeKey;
import net.sf.saxon.functions.Doc;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.Empty;
import net.sf.saxon.functions.Error;
import net.sf.saxon.functions.Exists;
import net.sf.saxon.functions.KeyFn;
import net.sf.saxon.functions.NotFn;
import net.sf.saxon.functions.RegexGroup;
import net.sf.saxon.functions.Reverse;
import net.sf.saxon.functions.Root_1;
import net.sf.saxon.functions.StatefulSystemFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.TreatFn;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.ma.map.MapFunctionSet;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.pattern.NodeSetPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.IntegerValue;

public class SystemFunctionCall
extends StaticFunctionCall
implements Negatable {
    public Evaluator[] argumentEvaluators;

    public SystemFunctionCall(SystemFunction systemFunction, Expression[] expressionArray) {
        super(systemFunction, expressionArray);
        this.argumentEvaluators = new Evaluator[expressionArray.length];
        Arrays.fill(this.argumentEvaluators, Evaluator.LAZY_SEQUENCE);
    }

    @Override
    public void setRetainedStaticContext(RetainedStaticContext retainedStaticContext) {
        super.setRetainedStaticContext(retainedStaticContext);
        this.getTargetFunction().setRetainedStaticContext(retainedStaticContext);
    }

    @Override
    public Expression preEvaluate(ExpressionVisitor expressionVisitor) {
        SystemFunction systemFunction = this.getTargetFunction();
        if ((systemFunction.getDetails().properties & 0x200) == 0) {
            return super.preEvaluate(expressionVisitor);
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.typeCheckChildren(expressionVisitor, contextItemStaticInfo);
        SystemFunctionCall systemFunctionCall = this;
        systemFunctionCall.checkFunctionCall(systemFunctionCall.getTargetFunction(), expressionVisitor);
        this.getTargetFunction().supplyTypeInformation(expressionVisitor, contextItemStaticInfo, this.getArguments());
        if ((this.getTargetFunction().getDetails().properties & 0x200) == 0) {
            return this.preEvaluateIfConstant(expressionVisitor);
        }
        SystemFunctionCall systemFunctionCall2 = this;
        systemFunctionCall2.a(systemFunctionCall2.getArguments());
        return this;
    }

    private void a(Expression[] expressionArray) {
        for (int i2 = 0; i2 < expressionArray.length; ++i2) {
            int n2;
            Expression expression = expressionArray[i2];
            int n3 = n2 = ((Expression)this).isCallOn(Concat.class) ? 24576 : this.getTargetFunction().getDetails().argumentTypes[i2].getCardinality();
            this.argumentEvaluators[i2] = expression instanceof Literal ? Evaluator.LITERAL : (expression instanceof VariableReference ? Evaluator.VARIABLE : (n2 == 16384 ? Evaluator.SINGLE_ITEM : (n2 == 24576 ? Evaluator.OPTIONAL_ITEM : Evaluator.LAZY_SEQUENCE)));
        }
    }

    @Override
    public SystemFunction getTargetFunction() {
        return (SystemFunction)super.getTargetFunction();
    }

    @Override
    public int getIntrinsicDependencies() {
        int n2 = this.getTargetFunction().getDetails().properties;
        int n3 = 0;
        if ((n2 & 0x200) != 0) {
            n3 = 1024;
        }
        if ((n2 & 0x5804) != 0) {
            if ((n2 & 0x4000) != 0) {
                n3 |= 0x10;
            }
            if ((n2 & 4) != 0) {
                n3 |= 2;
            }
            if ((n2 & 0x800) != 0) {
                n3 |= 4;
            }
            if ((n2 & 0x1000) != 0) {
                n3 |= 8;
            }
        }
        if ((n2 & 8) != 0) {
            n3 |= 0x800;
        }
        if ((n2 & 0x20) != 0) {
            n3 |= 0x800;
        }
        if (((Expression)this).isCallOn(RegexGroup.class) || ((Expression)this).isCallOn(CurrentMergeGroup.class) || ((Expression)this).isCallOn(CurrentMergeKey.class)) {
            n3 |= 0x20;
        }
        return n3;
    }

    @Override
    protected int computeCardinality() {
        return this.getTargetFunction().getCardinality(this.getArguments());
    }

    @Override
    protected int computeSpecialProperties() {
        return this.getTargetFunction().getSpecialProperties(this.getArguments());
    }

    @Override
    public int getNetCost() {
        return this.getTargetFunction().getNetCost();
    }

    @Override
    public Expression getScopingExpression() {
        if (((Expression)this).isCallOn(RegexGroup.class)) {
            for (Expression expression = this.getParentExpression(); expression != null; expression = expression.getParentExpression()) {
                if (!(expression instanceof AnalyzeString)) continue;
                return expression;
            }
            return null;
        }
        return super.getScopingExpression();
    }

    @Override
    public boolean isLiftable(boolean bl2) {
        return super.isLiftable(bl2) && !((Expression)this).isCallOn(CurrentMergeGroup.class) && !((Expression)this).isCallOn(CurrentMergeKey.class) && (!bl2 || !((Expression)this).isCallOn(MapFunctionSet.MapEntry.class));
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo object) {
        Expression expression = super.optimize(expressionVisitor, (ContextItemStaticInfo)object);
        if (expression == this && (object = this.getTargetFunction().makeOptimizedFunctionCall(expressionVisitor, (ContextItemStaticInfo)object, this.getArguments())) != null) {
            ((Expression)object).setParentExpression(this.getParentExpression());
            ExpressionTool.copyLocationInfo(this, (Expression)object);
            if (object instanceof SystemFunctionCall) {
                ((SystemFunctionCall)object).a(((SystemFunctionCall)object).getArguments());
            }
            return object;
        }
        if (expression instanceof SystemFunctionCall) {
            object = ((SystemFunctionCall)expression).getTargetFunction().getDetails();
            if ((((BuiltInFunctionSet.Entry)object).properties & 0x400) != 0) {
                this.setArg(0, this.getArg(0).unordered(true, expressionVisitor.isOptimizeForStreaming()));
            }
            if (this.getArity() <= ((BuiltInFunctionSet.Entry)object).resultIfEmpty.length) {
                for (int i2 = 0; i2 < this.getArity(); ++i2) {
                    if (!Literal.isEmptySequence(this.getArg(i2)) || ((BuiltInFunctionSet.Entry)object).resultIfEmpty[i2] == null) continue;
                    return Literal.makeLiteral(((BuiltInFunctionSet.Entry)object).resultIfEmpty[i2].materialize(), this);
                }
            }
            ((SystemFunctionCall)expression).a(((SystemFunctionCall)expression).getArguments());
        }
        return expression;
    }

    @Override
    public boolean isVacuousExpression() {
        return ((Expression)this).isCallOn(Error.class);
    }

    @Override
    public ItemType getItemType() {
        return this.getTargetFunction().getResultItemType(this.getArguments());
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        Expression[] expressionArray = new Expression[this.getArity()];
        for (int i2 = 0; i2 < expressionArray.length; ++i2) {
            expressionArray[i2] = this.getArg(i2).copy(rebindingMap);
        }
        SystemFunction systemFunction = this.getTargetFunction();
        if (systemFunction instanceof StatefulSystemFunction) {
            systemFunction = ((StatefulSystemFunction)((Object)systemFunction)).copy();
        }
        return systemFunction.makeFunctionCall(expressionArray);
    }

    @Override
    public IntegerValue[] getIntegerBounds() {
        SystemFunction systemFunction = this.getTargetFunction();
        if ((systemFunction.getDetails().properties & 0x100) != 0) {
            return this.getArg(0).getIntegerBounds();
        }
        return systemFunction.getIntegerBounds();
    }

    @Override
    public boolean isNegatable(TypeHierarchy typeHierarchy) {
        return ((Expression)this).isCallOn(NotFn.class) || ((Expression)this).isCallOn(BooleanFn.class) || ((Expression)this).isCallOn(Empty.class) || ((Expression)this).isCallOn(Exists.class);
    }

    @Override
    public Expression negate() {
        Object object = this.getTargetFunction();
        if (object instanceof NotFn) {
            object = this.getArg(0);
            if (((Expression)object).getItemType() == BuiltInAtomicType.BOOLEAN && ((Expression)object).getCardinality() == 16384) {
                return object;
            }
            return SystemFunction.makeCall("boolean", this.getRetainedStaticContext(), new Expression[]{object});
        }
        if (object instanceof BooleanFn) {
            return SystemFunction.makeCall("not", this.getRetainedStaticContext(), this.getArg(0));
        }
        if (object instanceof Exists) {
            return SystemFunction.makeCall("empty", this.getRetainedStaticContext(), this.getArg(0));
        }
        if (object instanceof Empty) {
            return SystemFunction.makeCall("exists", this.getRetainedStaticContext(), this.getArg(0));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression unordered(boolean bl2, boolean bl3) {
        SystemFunction systemFunction = this.getTargetFunction();
        if (systemFunction instanceof Reverse) {
            return this.getArg(0);
        }
        if (systemFunction instanceof TreatFn) {
            this.setArg(0, this.getArg(0).unordered(bl2, bl3));
        }
        return this;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        if (((Expression)this).isCallOn(Doc.class) || ((Expression)this).isCallOn(DocumentFn.class) || ((Expression)this).isCallOn(CollectionFn.class)) {
            this.getArg(0).addToPathMap(pathMap, pathMapNodeSet);
            return new PathMap.PathMapNodeSet(pathMap.makeNewRoot(this));
        }
        if (((Expression)this).isCallOn(KeyFn.class)) {
            return ((KeyFn)this.getTargetFunction()).addToPathMap(pathMap, pathMapNodeSet);
        }
        return super.addToPathMap(pathMap, pathMapNodeSet);
    }

    @Override
    public Pattern toPattern(Configuration configuration) {
        SystemFunction systemFunction = this.getTargetFunction();
        if (systemFunction instanceof Root_1 && (this.getArg(0) instanceof ContextItemExpression || this.getArg(0) instanceof ItemChecker && ((ItemChecker)this.getArg(0)).getBaseExpression() instanceof ContextItemExpression)) {
            return new NodeSetPattern(this);
        }
        return super.toPattern(configuration);
    }

    @Override
    public Sequence[] evaluateArguments(XPathContext xPathContext) {
        OperandArray operandArray = this.getOperanda();
        int n2 = operandArray.getNumberOfOperands();
        Sequence[] sequenceArray = new Sequence[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Expression expression = operandArray.getOperandExpression(i2);
            sequenceArray[i2] = this.argumentEvaluators[i2].evaluate(expression, xPathContext);
        }
        return sequenceArray;
    }

    @Override
    public void resetLocalStaticProperties() {
        super.resetLocalStaticProperties();
        if (this.argumentEvaluators != null) {
            SystemFunctionCall systemFunctionCall = this;
            systemFunctionCall.a(systemFunctionCall.getArguments());
        }
    }

    @Override
    public String getExpressionName() {
        return "sysFuncCall";
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        if (((FunctionCall)this).getFunctionName().hasURI("http://www.w3.org/2005/xpath-functions")) {
            expressionPresenter.startElement("fn", this);
            expressionPresenter.emitAttribute("name", ((FunctionCall)this).getFunctionName().getLocalPart());
            this.getTargetFunction().exportAttributes(expressionPresenter);
            for (Operand operand : ((Expression)this).operands()) {
                operand.getChildExpression().export(expressionPresenter);
            }
            this.getTargetFunction().exportAdditionalArguments(this, expressionPresenter);
            expressionPresenter.endElement();
            return;
        }
        expressionPresenter.startElement("ifCall", this);
        expressionPresenter.emitAttribute("name", ((FunctionCall)this).getFunctionName());
        expressionPresenter.emitAttribute("type", this.getTargetFunction().getFunctionItemType().getResultType().toExportString());
        ExpressionPresenter.ExportOptions object2 = (ExpressionPresenter.ExportOptions)expressionPresenter.getOptions();
        if (object2.target != null && object2.target.equals("JS") && object2.targetVersion == 2) {
            expressionPresenter.emitAttribute("typeJ", this.getTargetFunction().getFunctionItemType().getResultType().toExportString2());
        }
        this.getTargetFunction().exportAttributes(expressionPresenter);
        for (Operand operand : ((Expression)this).operands()) {
            operand.getChildExpression().export(expressionPresenter);
        }
        this.getTargetFunction().exportAdditionalArguments(this, expressionPresenter);
        expressionPresenter.endElement();
    }

    public static abstract class Optimized
    extends SystemFunctionCall {
        public Optimized(SystemFunction systemFunction, Expression[] expressionArray) {
            super(systemFunction, expressionArray);
        }

        @Override
        public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
            return this;
        }
    }
}

