/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public final class TailCallLoop
extends UnaryExpression {
    private UserFunction a;

    public TailCallLoop(UserFunction userFunction, Expression expression) {
        super(expression);
        this.a = userFunction;
    }

    public final UserFunction getContainingFunction() {
        return this.a;
    }

    @Override
    public final Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.getOperand().typeCheck(expressionVisitor, contextItemStaticInfo);
        return this;
    }

    @Override
    public final int getImplementationMethod() {
        return this.getBaseExpression().getImplementationMethod();
    }

    @Override
    protected final OperandRole getOperandRole() {
        return OperandRole.SAME_FOCUS_ACTION;
    }

    @Override
    public final Expression copy(RebindingMap rebindingMap) {
        throw new UnsupportedOperationException("TailCallLoop.copy()");
    }

    @Override
    public final SequenceIterator<?> iterate(XPathContext xPathContext) {
        TailCallInfo tailCallInfo;
        Object object;
        xPathContext = (XPathContextMajor)xPathContext;
        do {
            object = this.getBaseExpression().iterate(xPathContext);
            object = object.materialize();
            tailCallInfo = ((XPathContextMajor)xPathContext).getTailCallInfo();
            if (tailCallInfo != null) continue;
            return object.iterate();
        } while ((object = TailCallLoop.a(tailCallInfo, (XPathContextMajor)xPathContext)) == this.a);
        return this.a((UserFunction)object, (XPathContextMajor)xPathContext).iterate();
    }

    public final Item evaluateItem(XPathContext xPathContext) {
        TailCallInfo tailCallInfo;
        UserFunction userFunction;
        XPathContextMajor xPathContextMajor = (XPathContextMajor)xPathContext;
        do {
            userFunction = this.getBaseExpression().evaluateItem(xPathContext);
            tailCallInfo = xPathContextMajor.getTailCallInfo();
            if (tailCallInfo != null) continue;
            return userFunction;
        } while ((userFunction = TailCallLoop.a(tailCallInfo, xPathContextMajor)) == this.a);
        return this.a(userFunction, xPathContextMajor).head();
    }

    private static UserFunction a(TailCallInfo object, XPathContextMajor xPathContextMajor) {
        if (object instanceof TailCallFunction) {
            return ((TailCallFunction)object).function;
        }
        if (object instanceof TailCallComponent) {
            object = ((TailCallComponent)object).component;
            xPathContextMajor.setCurrentComponent((Component)object);
            return (UserFunction)((Component)object).getActor();
        }
        throw new AssertionError();
    }

    @Override
    public final void process(XPathContext xPathContext) {
        Object object;
        XPathContextMajor xPathContextMajor = (XPathContextMajor)xPathContext;
        Expression expression = this.getBaseExpression();
        do {
            expression.process(xPathContext);
            object = xPathContextMajor.getTailCallInfo();
            if (object != null) continue;
            return;
        } while ((object = TailCallLoop.a((TailCallInfo)object, xPathContextMajor)) == this.a);
        SequenceTool.process(this.a((UserFunction)object, xPathContextMajor), xPathContextMajor, expression.getLocation());
    }

    private Sequence<?> a(UserFunction object, XPathContextMajor xPathContextMajor) {
        xPathContextMajor.resetStackFrameMap(((Actor)object).getStackFrameMap(), ((UserFunction)object).getArity());
        try {
            return ((UserFunction)object).getEvaluator().evaluate(((Actor)object).getBody(), xPathContextMajor);
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.maybeSetLocation(this.getLocation());
            ((XPathException)object).maybeSetContext(xPathContextMajor);
            throw object;
        }
    }

    @Override
    public final ItemType getItemType() {
        return this.getBaseExpression().getItemType();
    }

    @Override
    public final String getExpressionName() {
        return "tailCallLoop";
    }

    protected static class TailCallFunction
    implements TailCallInfo {
        public UserFunction function;

        protected TailCallFunction() {
        }
    }

    protected static class TailCallComponent
    implements TailCallInfo {
        public Component component;
        public UserFunction function;

        protected TailCallComponent() {
        }
    }

    public static interface TailCallInfo {
    }
}

