/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.ValueTailIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;

public class TailIterator<T extends Item<?>>
implements LastPositionFinder,
SequenceIterator<T>,
LookaheadIterator<T> {
    private SequenceIterator<T> a;
    private int b;

    private TailIterator(SequenceIterator<T> sequenceIterator, int n2) {
        this.a = sequenceIterator;
        this.b = n2;
    }

    public static <T extends Item<?>> SequenceIterator<T> make(SequenceIterator<T> sequenceIterator, int n2) {
        if (n2 <= 1) {
            return sequenceIterator;
        }
        if (sequenceIterator instanceof ArrayIterator) {
            return ((ArrayIterator)sequenceIterator).makeSliceIterator(n2, Integer.MAX_VALUE);
        }
        if ((sequenceIterator.getProperties() & 1) != 0) {
            GroundedValue<T> groundedValue = sequenceIterator.materialize();
            if (n2 > groundedValue.getLength()) {
                return EmptyIterator.emptyIterator();
            }
            return new ValueTailIterator<T>(groundedValue, n2 - 1);
        }
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            T t2 = sequenceIterator.next();
            if (t2 != null) continue;
            return EmptyIterator.emptyIterator();
        }
        return new TailIterator<T>(sequenceIterator, n2);
    }

    @Override
    public T next() {
        return this.a.next();
    }

    @Override
    public boolean hasNext() {
        return ((LookaheadIterator)this.a).hasNext();
    }

    @Override
    public int getLength() {
        int n2 = ((LastPositionFinder)((Object)this.a)).getLength() - this.b + 1;
        if (n2 > 0) {
            return n2;
        }
        return 0;
    }

    @Override
    public void close() {
        this.a.close();
    }

    @Override
    public int getProperties() {
        return this.a.getProperties() & 6;
    }
}

