/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import net.sf.saxon.event.EventBuffer;
import net.sf.saxon.event.EventMonitor;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.BreakInstr;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.IdentityComparable;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Cardinality;

public class TryCatch
extends Expression {
    private Operand a;
    private List<CatchClause> b = new ArrayList<CatchClause>();
    private boolean c;

    public TryCatch(Expression expression) {
        this.a = new Operand(this, expression, OperandRole.SAME_FOCUS_ACTION);
    }

    public void addCatchExpression(QNameTest qNameTest, Expression expression) {
        CatchClause catchClause = new CatchClause();
        new CatchClause().catchOp = new Operand(this, expression, OperandRole.SAME_FOCUS_ACTION);
        catchClause.nameTest = qNameTest;
        this.b.add(catchClause);
    }

    public void setRollbackOutput(boolean bl2) {
        this.c = bl2;
    }

    public boolean isRollbackOutput() {
        return this.c;
    }

    public Operand getTryOperand() {
        return this.a;
    }

    public Expression getTryExpr() {
        return this.a.getChildExpression();
    }

    public List<CatchClause> getCatchClauses() {
        return this.b;
    }

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean allowExtractingCommonSubexpressions() {
        return false;
    }

    @Override
    public int computeCardinality() {
        int n2 = this.getTryExpr().getCardinality();
        for (CatchClause catchClause : this.b) {
            n2 = Cardinality.union(n2, catchClause.catchOp.getChildExpression().getCardinality());
        }
        return n2;
    }

    @Override
    public ItemType getItemType() {
        ItemType itemType = this.getTryExpr().getItemType();
        for (CatchClause catchClause : this.b) {
            itemType = Type.getCommonSuperType(itemType, catchClause.catchOp.getChildExpression().getItemType());
        }
        return itemType;
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> arrayList = new ArrayList<Operand>();
        arrayList.add(this.a);
        for (CatchClause catchClause : this.b) {
            arrayList.add(catchClause.catchOp);
        }
        return arrayList;
    }

    @Override
    public Expression optimize(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        this.optimizeChildren((ExpressionVisitor)object, contextItemStaticInfo);
        for (object = this.getParentExpression(); object != null; object = ((Expression)object).getParentExpression()) {
            if (!(object instanceof LetExpression) || !ExpressionTool.dependsOnVariable(this.getTryExpr(), new Binding[]{(LetExpression)object})) continue;
            ((LetExpression)object).setNeedsEagerEvaluation(true);
        }
        return this;
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof TryCatch && ((TryCatch)object).a.getChildExpression().isEqual(this.a.getChildExpression()) && ((TryCatch)object).b.equals(this.b);
    }

    @Override
    public int computeHashCode() {
        int n2 = -2090134880;
        for (int i2 = 0; i2 < this.b.size(); ++i2) {
            n2 ^= this.b.get(i2).hashCode() << i2;
        }
        return n2 + this.a.getChildExpression().hashCode();
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        TryCatch tryCatch = new TryCatch(this.a.getChildExpression().copy(rebindingMap));
        for (CatchClause catchClause : this.b) {
            tryCatch.addCatchExpression(catchClause.nameTest, catchClause.catchOp.getChildExpression().copy(rebindingMap));
        }
        tryCatch.setRollbackOutput(this.c);
        ExpressionTool.copyLocationInfo(this, tryCatch);
        return tryCatch;
    }

    public Item evaluateItem(XPathContext xPathContext) {
        Object object = xPathContext.newMinorContext();
        try {
            return ExpressionTool.eagerEvaluate(this.a.getChildExpression(), (XPathContext)object).head();
        }
        catch (XPathException xPathException) {
            object = xPathException;
            if (xPathException.isGlobalError()) {
                ((XPathException)object).setIsGlobalError(false);
            } else {
                IdentityComparable identityComparable = ((XPathException)object).getErrorCodeQName();
                if (identityComparable == null) {
                    identityComparable = new StructuredQName("saxon", "http://saxon.sf.net/", "SXWN9000");
                }
                for (CatchClause catchClause : this.b) {
                    if (!catchClause.nameTest.matches((StructuredQName)identityComparable)) continue;
                    identityComparable = catchClause.catchOp.getChildExpression();
                    xPathContext = xPathContext.newContext();
                    ((XPathContextMajor)xPathContext).setCurrentException((XPathException)object);
                    return ((Expression)identityComparable).evaluateItem(xPathContext);
                }
            }
            ((XPathException)object).setHasBeenReported(false);
            throw object;
        }
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        GroundedValue<?> groundedValue = xPathContext.newContext();
        ((XPathContextMajor)((Object)groundedValue)).createThreadManager();
        ((XPathContextMajor)((Object)groundedValue)).setErrorListener(new a(this, xPathContext.getErrorListener()));
        try {
            GroundedValue<?> groundedValue2 = ExpressionTool.eagerEvaluate(this.a.getChildExpression(), (XPathContext)((Object)groundedValue));
            ((XPathContextMinor)((Object)groundedValue)).waitForChildThreads();
            groundedValue = ((XPathContextMajor)((Object)groundedValue)).getTailCallInfo();
            if (groundedValue instanceof BreakInstr) {
                ((BreakInstr)((Object)groundedValue)).markContext(xPathContext);
            }
            return groundedValue2.iterate();
        }
        catch (XPathException xPathException) {
            Object object = xPathException;
            if (xPathException.isGlobalError()) {
                ((XPathException)object).setIsGlobalError(false);
            } else {
                groundedValue = ((XPathException)object).getErrorCodeQName();
                Object object2 = this.b.iterator();
                while (object2.hasNext()) {
                    CatchClause catchClause = object2.next();
                    if (groundedValue == null) {
                        groundedValue = new StructuredQName("saxon", "http://saxon.sf.net/", "SXWN9000");
                    }
                    if (!catchClause.nameTest.matches((StructuredQName)((Object)groundedValue))) continue;
                    groundedValue = catchClause.catchOp.getChildExpression();
                    object2 = xPathContext.newContext();
                    ((XPathContextMajor)object2).setCurrentException((XPathException)object);
                    groundedValue = ExpressionTool.eagerEvaluate((Expression)((Object)groundedValue), (XPathContext)object2);
                    object = ((XPathContextMajor)object2).getTailCallInfo();
                    if (object instanceof BreakInstr) {
                        ((BreakInstr)object).markContext(xPathContext);
                    }
                    return groundedValue.iterate();
                }
            }
            ((XPathException)object).setHasBeenReported(false);
            throw object;
        }
    }

    @Override
    public void process(XPathContext xPathContext) {
        GroundedValue<?> groundedValue = xPathContext.newContext();
        ((XPathContextMajor)((Object)groundedValue)).createThreadManager();
        ((XPathContextMajor)((Object)groundedValue)).setErrorListener(new a(this, xPathContext.getErrorListener()));
        Object object = null;
        Object object2 = null;
        if (this.c) {
            object = new EventBuffer(xPathContext.getReceiver().getPipelineConfiguration());
            ((XPathContextMinor)((Object)groundedValue)).setReceiver((Receiver)object);
        } else {
            object2 = new EventMonitor(xPathContext.getReceiver());
            ((XPathContextMinor)((Object)groundedValue)).setReceiver((Receiver)object2);
        }
        try {
            this.a.getChildExpression().process((XPathContext)((Object)groundedValue));
            ((XPathContextMinor)((Object)groundedValue)).waitForChildThreads();
            groundedValue = ((XPathContextMajor)((Object)groundedValue)).getTailCallInfo();
            if (groundedValue instanceof BreakInstr) {
                ((BreakInstr)((Object)groundedValue)).markContext(xPathContext);
            }
            if (this.c) {
                ((EventBuffer)object).replay(xPathContext.getReceiver());
            }
            return;
        }
        catch (XPathException xPathException) {
            groundedValue = xPathException;
            if (xPathException.isGlobalError()) {
                ((XPathException)((Object)groundedValue)).setIsGlobalError(false);
            } else {
                object = ((XPathException)((Object)groundedValue)).getErrorCodeQName();
                if (object == null) {
                    object = new StructuredQName("saxon", "http://saxon.sf.net/", "SXWN9000");
                }
                for (CatchClause catchClause : this.b) {
                    if (!catchClause.nameTest.matches((StructuredQName)object)) continue;
                    if (object2 != null && ((EventMonitor)object2).hasBeenWrittenTo()) {
                        object = ((Throwable)((Object)groundedValue)).getMessage() + ". The error could not be caught, because rollback-output=no was specified, and output was already written to the result tree";
                        object2 = new XPathException((String)object, "XTDE3530");
                        ((XPathException)object2).setLocation(((XPathException)((Object)groundedValue)).getLocator());
                        ((XPathException)object2).setXPathContext(xPathContext);
                        throw object2;
                    }
                    object = catchClause.catchOp.getChildExpression();
                    object2 = xPathContext.newContext();
                    ((XPathContextMajor)object2).setCurrentException((XPathException)((Object)groundedValue));
                    groundedValue = ExpressionTool.eagerEvaluate((Expression)object, (XPathContext)object2);
                    object = ((XPathContextMajor)object2).getTailCallInfo();
                    if (object instanceof BreakInstr) {
                        ((BreakInstr)object).markContext(xPathContext);
                    }
                    groundedValue.iterate().forEachOrFail(arg_0 -> TryCatch.a((XPathContextMajor)object2, arg_0));
                    return;
                }
            }
            ((XPathException)((Object)groundedValue)).setHasBeenReported(false);
            throw groundedValue;
        }
    }

    @Override
    public String getExpressionName() {
        return "tryCatch";
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("try", this);
        if (this.c) {
            expressionPresenter.emitAttribute("flags", "r");
        }
        this.a.getChildExpression().export(expressionPresenter);
        for (CatchClause catchClause : this.b) {
            expressionPresenter.startElement("catch");
            expressionPresenter.emitAttribute("err", catchClause.nameTest.toString());
            if ("JS".equals(((ExpressionPresenter.ExportOptions)expressionPresenter.getOptions()).target)) {
                int n2 = ((ExpressionPresenter.ExportOptions)expressionPresenter.getOptions()).targetVersion;
                expressionPresenter.emitAttribute("test", catchClause.nameTest.generateJavaScriptNameTest(n2));
            }
            catchClause.catchOp.getChildExpression().export(expressionPresenter);
            expressionPresenter.endElement();
        }
        expressionPresenter.endElement();
    }

    @Override
    public String getStreamerName() {
        return "TryCatch";
    }

    private static /* synthetic */ void a(XPathContextMajor xPathContextMajor, Item item) {
        xPathContextMajor.getReceiver().append(item);
    }

    private final class a
    implements ErrorListener {
        private ErrorListener a;
        private /* synthetic */ TryCatch b;

        a(TryCatch tryCatch, UnfailingErrorListener unfailingErrorListener) {
            this.b = tryCatch;
            this.a = unfailingErrorListener;
        }

        private boolean a(TransformerException object) {
            if (object instanceof XPathException) {
                object = ((XPathException)object).getErrorCodeQName();
                for (CatchClause catchClause : this.b.b) {
                    if (!catchClause.nameTest.matches((StructuredQName)object)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public final void warning(TransformerException transformerException) {
            this.a.warning(transformerException);
        }

        @Override
        public final void error(TransformerException transformerException) {
            if (!this.a(transformerException)) {
                this.a.error(transformerException);
            }
        }

        @Override
        public final void fatalError(TransformerException transformerException) {
            if (!this.a(transformerException)) {
                this.a.fatalError(transformerException);
            }
        }
    }

    public static class CatchClause {
        public int slotNumber = -1;
        public Operand catchOp;
        public QNameTest nameTest;
    }
}

