/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.jiter.MonoIterator;
import net.sf.saxon.type.ItemType;

public abstract class UnaryExpression
extends Expression {
    private Operand a;

    public UnaryExpression(Expression expression) {
        this.a = new Operand(this, expression, this.getOperandRole());
        ExpressionTool.copyLocationInfo(expression, this);
    }

    public Expression getBaseExpression() {
        return this.a.getChildExpression();
    }

    public void setBaseExpression(Expression expression) {
        this.a.setChildExpression(expression);
    }

    public Operand getOperand() {
        return this.a;
    }

    @Override
    public Iterable<Operand> operands() {
        return () -> new MonoIterator<Operand>(this.a);
    }

    protected abstract OperandRole getOperandRole();

    @Override
    public Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        this.a.typeCheck((ExpressionVisitor)object, contextItemStaticInfo);
        try {
            if (this.getBaseExpression() instanceof Literal) {
                object = Literal.makeLiteral(this.iterate(((ExpressionVisitor)object).getStaticContext().makeEarlyEvaluationContext()).materialize(), this);
                ExpressionTool.copyLocationInfo(this, (Expression)object);
                return object;
            }
        }
        catch (Exception exception) {}
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo object) {
        this.a.optimize(expressionVisitor, (ContextItemStaticInfo)object);
        object = this.getBaseExpression();
        try {
            if (object instanceof Literal) {
                return Literal.makeLiteral(this.iterate(expressionVisitor.getStaticContext().makeEarlyEvaluationContext()).materialize(), this);
            }
        }
        catch (XPathException xPathException) {}
        return this;
    }

    @Override
    public int computeSpecialProperties() {
        return this.getBaseExpression().getSpecialProperties();
    }

    @Override
    public int computeCardinality() {
        return this.getBaseExpression().getCardinality();
    }

    @Override
    public ItemType getItemType() {
        return this.getBaseExpression().getItemType();
    }

    @Override
    public boolean equals(Object object) {
        return object != null && this.getClass().equals(object.getClass()) && this.getBaseExpression().isEqual(((UnaryExpression)object).getBaseExpression());
    }

    @Override
    public int computeHashCode() {
        return ("UnaryExpression " + this.getClass()).hashCode() ^ this.getBaseExpression().hashCode();
    }

    @Override
    public String toString() {
        return this.getExpressionName() + "(" + this.getBaseExpression() + ")";
    }

    @Override
    public String toShortString() {
        return this.getExpressionName() + "(" + this.getBaseExpression().toShortString() + ")";
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        String string = this.getExpressionName();
        if (string == null) {
            expressionPresenter.startElement("unaryOperator", this);
            string = this.displayOperator(expressionPresenter.getConfiguration());
            if (string != null) {
                expressionPresenter.emitAttribute("op", string);
            }
        } else {
            expressionPresenter.startElement(string, this);
        }
        this.getBaseExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    protected String displayOperator(Configuration configuration) {
        return null;
    }
}

