/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.AbstractFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.EmptyAtomicSequence;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.UnionType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class UnionConstructorFunction
extends AbstractFunction {
    protected UnionType targetType;
    protected NamespaceResolver resolver;
    protected boolean allowEmpty;

    public UnionConstructorFunction(UnionType unionType, NamespaceResolver namespaceResolver, boolean bl2) {
        this.targetType = unionType;
        this.resolver = namespaceResolver;
        this.allowEmpty = bl2;
    }

    protected OperandRole getOperandRole() {
        return OperandRole.SINGLE_ATOMIC;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public UnionType getTargetType() {
        return this.targetType;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.resolver;
    }

    @Override
    public FunctionItemType getFunctionItemType() {
        SequenceType sequenceType = this.targetType.getResultTypeOfCast();
        SequenceType sequenceType2 = this.allowEmpty ? SequenceType.OPTIONAL_ATOMIC : SequenceType.SINGLE_ATOMIC;
        return new SpecificFunctionType(new SequenceType[]{sequenceType2}, sequenceType);
    }

    @Override
    public StructuredQName getFunctionName() {
        return this.targetType.getStructuredQName();
    }

    @Override
    public String getDescription() {
        return this.getFunctionName().getDisplayName();
    }

    @Override
    public int getArity() {
        return 1;
    }

    public AtomicSequence cast(AtomicValue atomicValue, XPathContext object) {
        Object object2;
        PlainType plainType;
        Iterator<PlainType> iterator;
        object = object.getConfiguration().getConversionRules();
        if (atomicValue == null) {
            throw new NullPointerException();
        }
        if (atomicValue instanceof StringValue && !(atomicValue instanceof AnyURIValue)) {
            try {
                return this.targetType.getTypedValue(atomicValue.getStringValueCS(), this.resolver, (ConversionRules)object);
            }
            catch (ValidationException validationException) {
                ValidationException validationException2 = validationException;
                validationException.setErrorCode("FORG0001");
                throw validationException2;
            }
        }
        Object object3 = atomicValue.getItemType();
        Object object4 = this.targetType.getPlainMemberTypes();
        if (this.targetType.isPlainType()) {
            iterator = object4.iterator();
            while (iterator.hasNext()) {
                plainType = iterator.next();
                if (!object3.equals(plainType)) continue;
                return atomicValue;
            }
            iterator = object4.iterator();
            while (iterator.hasNext()) {
                plainType = iterator.next();
                object2 = object3;
                while (object2 != null) {
                    if (object2.equals(plainType)) {
                        return atomicValue;
                    }
                    object2 = object2.getBaseType() instanceof AtomicType ? (AtomicType)object2.getBaseType() : null;
                }
            }
        }
        iterator = object4.iterator();
        while (iterator.hasNext()) {
            plainType = iterator.next();
            if (!(plainType instanceof AtomicType) || (object2 = ((ConversionRules)object).getConverter(atomicValue.getItemType(), (AtomicType)plainType)) == null || !((object3 = ((Converter)object2).convert(atomicValue)) instanceof AtomicValue)) continue;
            if (!this.targetType.isPlainType()) {
                object4 = this.targetType.checkAgainstFacets((AtomicValue)object3, (ConversionRules)object);
                if (object4 != null) continue;
                return (AtomicValue)object3;
            }
            return (AtomicValue)object3;
        }
        throw new XPathException("Cannot convert the supplied value to " + this.targetType.getDescription(), "FORG0001");
    }

    public AtomicSequence call(XPathContext object, Sequence[] object2) {
        if ((object2 = (AtomicValue)object2[0].head()) == null) {
            if (this.allowEmpty) {
                return EmptyAtomicSequence.getInstance();
            }
            object = new XPathException("Cast expression does not allow an empty sequence to be supplied", "XPTY0004");
            ((XPathException)object).setIsTypeError(true);
            throw object;
        }
        return this.cast((AtomicValue)object2, (XPathContext)object);
    }

    public static AtomicSequence cast(AtomicValue atomicValue, UnionType unionType, NamespaceResolver object, ConversionRules conversionRules) {
        Object object2;
        if (atomicValue == null) {
            throw new NullPointerException();
        }
        if (atomicValue instanceof StringValue && !(atomicValue instanceof AnyURIValue)) {
            try {
                return unionType.getTypedValue(atomicValue.getStringValueCS(), (NamespaceResolver)object, conversionRules);
            }
            catch (ValidationException validationException) {
                object = validationException;
                validationException.setErrorCode("FORG0001");
                throw object;
            }
        }
        object = atomicValue.getItemType();
        Iterable<PlainType> iterable = unionType.getPlainMemberTypes();
        for (PlainType plainType : iterable) {
            if (!object.equals(plainType)) continue;
            return atomicValue;
        }
        for (PlainType plainType : iterable) {
            object2 = object;
            while (object2 != null) {
                if (object2.equals(plainType)) {
                    return atomicValue;
                }
                object2 = object2.getBaseType() instanceof AtomicType ? (AtomicType)object2.getBaseType() : null;
            }
        }
        for (PlainType plainType : iterable) {
            if (!(plainType instanceof AtomicType) || (object2 = conversionRules.getConverter(atomicValue.getItemType(), (AtomicType)plainType)) == null || !((object = ((Converter)object2).convert(atomicValue)) instanceof AtomicValue)) continue;
            return (AtomicValue)object;
        }
        throw new XPathException("Cannot convert the supplied value to " + unionType.getDescription(), "FORG0001");
    }
}

