/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.UntypedAtomicValue;

public final class UntypedSequenceConverter
extends AtomicSequenceConverter {
    public UntypedSequenceConverter(Expression expression, PlainType plainType) {
        super(expression, plainType);
    }

    public static UntypedSequenceConverter makeUntypedSequenceConverter(Configuration object, Expression expression, PlainType object2) {
        ((Configuration)object).getTypeHierarchy();
        expression = new UntypedSequenceConverter(expression, (PlainType)object2);
        object = ((Configuration)object).getConversionRules();
        if (((SimpleType)object2).isNamespaceSensitive()) {
            throw new XPathException("Cannot convert untyped atomic values to a namespace-sensitive type", "XPTY0117");
        }
        object2 = object2.isAtomicType() ? ((ConversionRules)object).getConverter(BuiltInAtomicType.UNTYPED_ATOMIC, (AtomicType)object2) : new StringConverter.StringToUnionConverter((PlainType)object2, (ConversionRules)object);
        object = new UntypedConverter((ConversionRules)object, (Converter)object2);
        ((AtomicSequenceConverter)expression).setConverter((Converter)object);
        return expression;
    }

    public static UntypedSequenceConverter makeUntypedSequenceRejector(Configuration object, Expression object2, PlainType plainType) {
        UntypedSequenceConverter untypedSequenceConverter = new UntypedSequenceConverter((Expression)object2, plainType);
        object = ((Configuration)object).getConversionRules();
        object2 = new Converter(plainType, (Expression)object2){
            private /* synthetic */ PlainType a;
            private /* synthetic */ Expression b;
            {
                this.a = plainType;
                this.b = expression;
            }

            @Override
            public final ConversionResult convert(AtomicValue conversionResult) {
                conversionResult = new ValidationFailure("Implicit conversion of untypedAtomic value to " + this.a.toString() + " is not allowed");
                ((ValidationFailure)conversionResult).setErrorCode("XPTY0117");
                ((ValidationFailure)conversionResult).setLocator(this.b.getLocation());
                return conversionResult;
            }
        };
        object = new UntypedConverter((ConversionRules)object, (Converter)object2);
        untypedSequenceConverter.setConverter((Converter)object);
        return untypedSequenceConverter;
    }

    @Override
    public final Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo object2) {
        if ((object2 = super.typeCheck((ExpressionVisitor)object, (ContextItemStaticInfo)object2)) != this) {
            return object2;
        }
        if (((TypeHierarchy)(object = ((ExpressionVisitor)object).getConfiguration().getTypeHierarchy())).relationship(((Expression)(object2 = this.getBaseExpression())).getItemType(), BuiltInAtomicType.UNTYPED_ATOMIC) == 4 || ((Expression)object2).hasSpecialProperty(0x4000000)) {
            return this.getBaseExpression();
        }
        return this;
    }

    @Override
    public final int computeSpecialProperties() {
        int n2 = super.computeSpecialProperties();
        return n2 | 0x800000 | 0x4000000;
    }

    @Override
    public final Expression copy(RebindingMap object) {
        object = new UntypedSequenceConverter(this.getBaseExpression().copy((RebindingMap)object), this.getRequiredItemType());
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        ((AtomicSequenceConverter)object).setConverter(this.converter);
        ((AtomicSequenceConverter)object).setRoleDiagnostic(this.getRoleDiagnostic());
        return object;
    }

    @Override
    public final ItemType getItemType() {
        if (this.getBaseExpression().getItemType() == BuiltInAtomicType.UNTYPED_ATOMIC) {
            return this.getRequiredItemType();
        }
        TypeHierarchy typeHierarchy = this.getConfiguration().getTypeHierarchy();
        return Type.getCommonSuperType(this.getRequiredItemType(), this.getBaseExpression().getItemType(), typeHierarchy);
    }

    @Override
    public final int computeCardinality() {
        return this.getBaseExpression().getCardinality();
    }

    @Override
    public final boolean equals(Object object) {
        return object instanceof UntypedSequenceConverter && this.getBaseExpression().isEqual(((UntypedSequenceConverter)object).getBaseExpression());
    }

    @Override
    public final int computeHashCode() {
        return super.computeHashCode();
    }

    @Override
    protected final String displayOperator(Configuration configuration) {
        return "convertUntyped";
    }

    @Override
    public final String getExpressionName() {
        return "convertUntyped";
    }

    @Override
    public final String toShortString() {
        return this.getBaseExpression().toShortString();
    }

    @Override
    public final void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("cvUntyped", this);
        expressionPresenter.emitAttribute("to", this.getRequiredItemType().toExportString());
        if (this.getRoleDiagnostic() != null) {
            expressionPresenter.emitAttribute("diag", this.getRoleDiagnostic().save());
        }
        this.getBaseExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    public static class UntypedConverter
    extends Converter {
        private Converter a = null;

        public UntypedConverter(ConversionRules conversionRules, Converter converter) {
            super(conversionRules);
            this.a = converter;
        }

        @Override
        public ConversionResult convert(AtomicValue atomicValue) {
            if (atomicValue instanceof UntypedAtomicValue) {
                return this.a.convert(atomicValue);
            }
            return atomicValue;
        }
    }
}

