/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ComponentInvocation;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.TailCallLoop;
import net.sf.saxon.expr.UserFunctionResolvable;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.Evaluator;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class UserFunctionCall
extends FunctionCall
implements ComponentInvocation,
ContextOriginator,
UserFunctionResolvable {
    private SequenceType a;
    private UserFunction b;
    private int c = -1;
    private int d = 0;
    private StructuredQName e;
    private boolean f = false;
    private Evaluator[] g = null;
    public static final int NOT_TAIL_CALL = 0;
    public static final int FOREIGN_TAIL_CALL = 1;
    public static final int SELF_TAIL_CALL = 2;

    public boolean isBeingInlined() {
        return this.f;
    }

    public void setBeingInlined(boolean bl2) {
        this.f = bl2;
    }

    public final void setFunctionName(StructuredQName structuredQName) {
        this.e = structuredQName;
    }

    public void setStaticType(SequenceType sequenceType) {
        this.a = sequenceType;
    }

    @Override
    public void setFunction(UserFunction userFunction) {
        this.b = userFunction;
    }

    @Override
    public void setBindingSlot(int n2) {
        this.c = n2;
    }

    @Override
    public int getBindingSlot() {
        return this.c;
    }

    public UserFunction getFunction() {
        return this.b;
    }

    @Override
    public Component getFixedTarget() {
        Visibility visibility = this.b.getDeclaringComponent().getVisibility();
        if (visibility == Visibility.PRIVATE || visibility == Visibility.FINAL) {
            return this.b.getDeclaringComponent();
        }
        return null;
    }

    public boolean isTailCall() {
        return this.d != 0;
    }

    public boolean isRecursiveTailCall() {
        return this.d == 2;
    }

    @Override
    public final StructuredQName getFunctionName() {
        if (this.e == null) {
            return this.b.getFunctionName();
        }
        return this.e;
    }

    @Override
    public SymbolicName getSymbolicName() {
        return new SymbolicName.F(((FunctionCall)this).getFunctionName(), this.getArity());
    }

    public Component getTarget() {
        return this.b.getDeclaringComponent();
    }

    public void setArgumentEvaluationModes(int[] nArray) {
        this.g = new Evaluator[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.g[i2] = Evaluator.evaluatorForCode(nArray[i2]);
        }
    }

    public void allocateArgumentEvaluators() {
        this.g = new Evaluator[this.getArity()];
        int n2 = 0;
        for (Operand operand : ((Expression)this).operands()) {
            Expression object = operand.getChildExpression();
            SequenceType sequenceType = this.b.getArgumentType(n2);
            int sequenceType2 = sequenceType.getCardinality();
            this.g[n2] = n2 == 0 && this.b.getDeclaredStreamability().isConsuming() ? Evaluator.STREAMING_ARGUMENT : (this.b.getParameterDefinitions()[n2].isIndexedVariable() ? Evaluator.MAKE_INDEXED_VARIABLE : (object instanceof Literal ? Evaluator.LITERAL : (object instanceof VariableReference ? Evaluator.VARIABLE : (sequenceType2 == 16384 ? Evaluator.SINGLE_ITEM : ((object.getDependencies() & 0x36D) != 0 ? Evaluator.EAGER_SEQUENCE : (!Cardinality.allowsMany(object.getCardinality()) && object.getCost() < 20.0 ? Evaluator.EAGER_SEQUENCE : (sequenceType2 == 24576 ? Evaluator.OPTIONAL_ITEM : (object instanceof Block && ((Block)object).isCandidateForSharedAppend() ? Evaluator.SHARED_APPEND : Evaluator.MEMO_CLOSURE))))))));
            ++n2;
        }
    }

    public Evaluator[] getArgumentEvaluators() {
        return this.g;
    }

    @Override
    public Expression preEvaluate(ExpressionVisitor expressionVisitor) {
        return this;
    }

    @Override
    public ItemType getItemType() {
        if (this.a == null) {
            return AnyItemType.getInstance();
        }
        return this.a.getPrimaryType();
    }

    @Override
    public UType getStaticUType(UType object) {
        object = this.getFunction();
        if (object == null) {
            return UType.ANY;
        }
        return ((UserFunction)object).getResultType().getPrimaryType().getUType();
    }

    @Override
    public int getIntrinsicDependencies() {
        return 256;
    }

    @Override
    public boolean isUpdatingExpression() {
        return this.b.isUpdating();
    }

    @Override
    protected int computeSpecialProperties() {
        if (this.b == null) {
            return super.computeSpecialProperties();
        }
        if (this.b.getBody() != null && (this.b.getDeclaredVisibility() == Visibility.PRIVATE || this.b.getDeclaredVisibility() == Visibility.FINAL)) {
            ArrayList<UserFunction> arrayList = new ArrayList<UserFunction>();
            ExpressionTool.gatherCalledFunctions(this.b.getBody(), arrayList);
            int n2 = arrayList.isEmpty() ? this.b.getBody().getSpecialProperties() : super.computeSpecialProperties();
            if (this.b.getDeterminism() != UserFunction.Determinism.PROACTIVE) {
                n2 |= 0x800000;
            }
            return n2;
        }
        return super.computeSpecialProperties();
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        if (this.b == null) {
            throw new UnsupportedOperationException("UserFunctionCall.copy()");
        }
        UserFunctionCall userFunctionCall = new UserFunctionCall();
        userFunctionCall.setFunction(this.b);
        userFunctionCall.setStaticType(this.a);
        int n2 = this.getArity();
        Expression[] expressionArray = new Expression[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            expressionArray[i2] = this.getArg(i2).copy(rebindingMap);
        }
        userFunctionCall.setArguments(expressionArray);
        ExpressionTool.copyLocationInfo(this, userFunctionCall);
        return userFunctionCall;
    }

    @Override
    public int computeCardinality() {
        if (this.a == null) {
            return 57344;
        }
        return this.a.getCardinality();
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo object) {
        if ((object = super.typeCheck(expressionVisitor, (ContextItemStaticInfo)object)) != this) {
            return object;
        }
        if (this.b != null) {
            UserFunctionCall userFunctionCall = this;
            userFunctionCall.checkFunctionCall(userFunctionCall.b, expressionVisitor);
            if (this.a == null || this.a == SequenceType.ANY_SEQUENCE) {
                this.a = this.b.getResultType();
            }
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        Expression expression = super.optimize((ExpressionVisitor)object, contextItemStaticInfo);
        if (expression == this && this.b != null) {
            object = ((ExpressionVisitor)object).obtainOptimizer().tryInlineFunctionCall(this, (ExpressionVisitor)object, contextItemStaticInfo);
            return object;
        }
        return expression;
    }

    @Override
    public void resetLocalStaticProperties() {
        super.resetLocalStaticProperties();
        this.g = null;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return this.addExternalFunctionCallToPathMap(pathMap, pathMapNodeSet);
    }

    @Override
    public int markTailFunctionCalls(StructuredQName structuredQName, int n2) {
        this.d = ((FunctionCall)this).getFunctionName().equals(structuredQName) && n2 == this.getArity() ? 2 : 1;
        return this.d;
    }

    @Override
    public int getImplementationMethod() {
        if (Cardinality.allowsMany(this.getCardinality())) {
            return 6;
        }
        return 1;
    }

    public Item evaluateItem(XPathContext xPathContext) {
        return this.a(xPathContext).head();
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        return this.a(xPathContext).iterate();
    }

    @Override
    public void evaluatePendingUpdates(XPathContext xPathContext, PendingUpdateList pendingUpdateList) {
        Sequence[] sequenceArray = ((FunctionCall)this).evaluateArguments(xPathContext);
        xPathContext = xPathContext.newCleanContext();
        ((XPathContextMajor)xPathContext).setOrigin(this);
        this.b.callUpdating(sequenceArray, (XPathContextMajor)xPathContext, pendingUpdateList);
    }

    private Sequence<?> a(XPathContext object) {
        UserFunction userFunction;
        Object object2;
        Sequence[] sequenceArray = ((FunctionCall)this).evaluateArguments((XPathContext)object);
        if (this.isTailCall()) {
            this.a((XPathContext)object, sequenceArray);
            return EmptySequence.getInstance();
        }
        if (this.c >= 0) {
            object2 = this.getTargetComponent((XPathContext)object);
            if (((Component)object2).isHiddenAbstractComponent()) {
                throw new XPathException("Cannot call an abstract function (" + this.e.getDisplayName() + ") with no implementation", "XTDE3052");
            }
            userFunction = (UserFunction)((Component)object2).getActor();
            object = userFunction.makeNewContext((XPathContext)object, this);
            ((XPathContextMajor)object).setCurrentComponent((Component)object2);
            ((XPathContextMajor)object).setOrigin(this);
        } else {
            userFunction = this.b;
            object = userFunction.makeNewContext((XPathContext)object, this);
            ((XPathContextMajor)object).setOrigin(this);
        }
        try {
            return userFunction.call((XPathContext)object, sequenceArray);
        }
        catch (UncheckedXPathException uncheckedXPathException) {
            object2 = uncheckedXPathException;
            object = uncheckedXPathException.getXPathException();
            ((XPathException)object).maybeSetLocation(this.getLocation());
            throw object;
        }
        catch (StackOverflowError stackOverflowError) {
            object2 = stackOverflowError;
            stackOverflowError.printStackTrace();
            throw new XPathException.StackOverflow("Too many nested function calls. May be due to infinite recursion", "SXLM0001", this.getLocation());
        }
    }

    private void a(XPathContext xPathContext, Sequence<?>[] sequenceArray) {
        if (this.c >= 0) {
            Component component;
            TailCallLoop.TailCallComponent tailCallComponent = new TailCallLoop.TailCallComponent();
            tailCallComponent.component = component = this.getTargetComponent(xPathContext);
            tailCallComponent.function = (UserFunction)component.getActor();
            if (component.isHiddenAbstractComponent()) {
                throw new XPathException("Cannot call an abstract function (" + this.e.getDisplayName() + ") with no implementation", "XTDE3052");
            }
            ((XPathContextMajor)xPathContext).requestTailCall(tailCallComponent, sequenceArray);
            return;
        }
        TailCallLoop.TailCallFunction tailCallFunction = new TailCallLoop.TailCallFunction();
        new TailCallLoop.TailCallFunction().function = this.b;
        ((XPathContextMajor)xPathContext).requestTailCall(tailCallFunction, sequenceArray);
    }

    @Override
    public void process(XPathContext xPathContext) {
        Sequence[] sequenceArray = ((FunctionCall)this).evaluateArguments(xPathContext);
        if (this.isTailCall()) {
            this.a(xPathContext, sequenceArray);
            return;
        }
        if (this.c >= 0) {
            Component component = this.getTargetComponent(xPathContext);
            UserFunction userFunction = (UserFunction)component.getActor();
            if (component.getVisibility() == Visibility.ABSTRACT) {
                throw new XPathException("Cannot call a function defined with visibility=abstract", "XTDE3052");
            }
            xPathContext = userFunction.makeNewContext(xPathContext, this);
            ((XPathContextMajor)xPathContext).setCurrentComponent(component);
            ((XPathContextMajor)xPathContext).setOrigin(this);
            userFunction.process(sequenceArray, (XPathContextMajor)xPathContext);
            return;
        }
        XPathContextMajor xPathContextMajor = this.b.makeNewContext(xPathContext, this);
        xPathContextMajor.setOrigin(this);
        this.b.process(sequenceArray, xPathContextMajor);
    }

    public Component getTargetComponent(XPathContext xPathContext) {
        if (this.c == -1) {
            return this.b.getDeclaringComponent();
        }
        return xPathContext.getTargetComponent(this.c);
    }

    @Override
    public UserFunction getTargetFunction(XPathContext xPathContext) {
        return (UserFunction)this.getTargetComponent(xPathContext).getActor();
    }

    public Sequence<?>[] evaluateArguments(XPathContext xPathContext) {
        return this.evaluateArguments(xPathContext, false);
    }

    public Sequence<?>[] evaluateArguments(XPathContext xPathContext, boolean bl2) {
        int n2 = this.getArity();
        Sequence<?>[] sequenceArray = SequenceTool.makeSequenceArray(n2);
        UserFunctionCall userFunctionCall = this;
        synchronized (userFunctionCall) {
            if (this.g == null) {
                this.allocateArgumentEvaluators();
            }
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Evaluator evaluator = this.g[i2];
            if (evaluator == Evaluator.STREAMING_ARGUMENT && !bl2) {
                evaluator = Evaluator.EAGER_SEQUENCE;
            }
            sequenceArray[i2] = evaluator.evaluate(this.getArg(i2), xPathContext);
            if (sequenceArray[i2] != null) continue;
            sequenceArray[i2] = EmptySequence.getInstance();
        }
        return sequenceArray;
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("ufCall", this);
        if (((FunctionCall)this).getFunctionName() != null) {
            expressionPresenter.emitAttribute("name", ((FunctionCall)this).getFunctionName());
            expressionPresenter.emitAttribute("tailCall", this.d == 0 ? "false" : (this.d == 2 ? "self" : "foreign"));
        }
        expressionPresenter.emitAttribute("bSlot", "" + this.getBindingSlot());
        if (this.g != null && this.getArity() > 0) {
            FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
            Evaluator[] object = this.g;
            int n2 = this.g.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Evaluator evaluator = object[i2];
                fastStringBuffer.append(evaluator.getCode() + " ");
            }
            expressionPresenter.emitAttribute("eval", Whitespace.trim(fastStringBuffer));
        }
        for (Operand operand : ((Expression)this).operands()) {
            operand.getChildExpression().export(expressionPresenter);
        }
        if (((FunctionCall)this).getFunctionName() == null) {
            expressionPresenter.setChildRole("inline");
            this.b.getBody().export(expressionPresenter);
            expressionPresenter.endElement();
        }
        expressionPresenter.endElement();
    }

    @Override
    public int getConstructType() {
        return 2009;
    }

    @Override
    public String getExpressionName() {
        return "userFunctionCall";
    }

    @Override
    public Object getProperty(String string) {
        if (string.equals("target")) {
            return this.b;
        }
        return super.getProperty(string);
    }

    @Override
    public StructuredQName getObjectName() {
        return ((FunctionCall)this).getFunctionName();
    }
}

