/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.CompareToIntegerConstant;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.IdentityComparison;
import net.sf.saxon.expr.IsLastExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Negatable;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CodepointCollatingComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.ComparisonException;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.expr.sort.UntypedNumericComparer;
import net.sf.saxon.functions.Count;
import net.sf.saxon.functions.GenerateId_1;
import net.sf.saxon.functions.PositionAndLast;
import net.sf.saxon.functions.StringLength_1;
import net.sf.saxon.functions.Subsequence_2;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public final class ValueComparison
extends BinaryExpression
implements ComparisonExpression,
Negatable {
    private AtomicComparer a;
    private BooleanValue b = null;
    private boolean c;

    public ValueComparison(Expression expression, int n2, Expression expression2) {
        super(expression, n2, expression2);
    }

    @Override
    public final String getExpressionName() {
        return "ValueComparison";
    }

    public final void setAtomicComparer(AtomicComparer atomicComparer) {
        this.a = atomicComparer;
    }

    @Override
    public final AtomicComparer getAtomicComparer() {
        return this.a;
    }

    @Override
    public final int getSingletonOperator() {
        return this.operator;
    }

    @Override
    public final boolean convertsUntypedToOther() {
        return this.a instanceof UntypedNumericComparer;
    }

    public final void setResultWhenEmpty(BooleanValue booleanValue) {
        this.b = booleanValue;
    }

    public final BooleanValue getResultWhenEmpty() {
        return this.b;
    }

    public final boolean needsRuntimeComparabilityCheck() {
        return this.c;
    }

    @Override
    public final Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo object2) {
        BuiltInAtomicType builtInAtomicType;
        this.resetLocalStaticProperties();
        this.getLhs().typeCheck((ExpressionVisitor)object, (ContextItemStaticInfo)object2);
        this.getRhs().typeCheck((ExpressionVisitor)object, (ContextItemStaticInfo)object2);
        object2 = ((ExpressionVisitor)object).getConfiguration();
        StaticContext staticContext = ((ExpressionVisitor)object).getStaticContext();
        if (Literal.isEmptySequence(this.getLhsExpression())) {
            if (this.b == null) {
                return this.getLhsExpression();
            }
            return Literal.makeLiteral(this.b, this);
        }
        if (Literal.isEmptySequence(this.getRhsExpression())) {
            if (this.b == null) {
                return this.getRhsExpression();
            }
            return Literal.makeLiteral(this.b, this);
        }
        if (this.a instanceof UntypedNumericComparer) {
            return this;
        }
        Object object3 = SequenceType.OPTIONAL_ATOMIC;
        Object object4 = ((Configuration)object2).getTypeChecker(false);
        Object object5 = new RoleDiagnostic(1, Token.tokens[this.operator], 0);
        this.setLhsExpression(((TypeChecker)object4).staticTypeCheck(this.getLhsExpression(), (SequenceType)object3, (RoleDiagnostic)object5, (ExpressionVisitor)object));
        object5 = new RoleDiagnostic(1, Token.tokens[this.operator], 1);
        this.setRhsExpression(((TypeChecker)object4).staticTypeCheck(this.getRhsExpression(), (SequenceType)object3, (RoleDiagnostic)object5, (ExpressionVisitor)object));
        object3 = this.getLhsExpression().getItemType().getAtomizedItemType();
        object4 = this.getRhsExpression().getItemType().getAtomizedItemType();
        if (object3.isExternalType() || object4.isExternalType()) {
            object5 = new XPathException("Cannot perform comparisons involving external objects");
            ((XPathException)object5).setIsTypeError(true);
            ((XPathException)object5).setErrorCode("XPTY0004");
            ((XPathException)object5).setLocation(this.getLocation());
            throw object5;
        }
        object5 = (BuiltInAtomicType)object3.getPrimitiveItemType();
        if (((BuiltInAtomicType)object5).equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            object5 = BuiltInAtomicType.STRING;
        }
        if ((builtInAtomicType = (BuiltInAtomicType)object4.getPrimitiveItemType()).equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
            builtInAtomicType = BuiltInAtomicType.STRING;
        }
        boolean bl2 = this.c = ((BuiltInAtomicType)object5).equals(BuiltInAtomicType.ANY_ATOMIC) || builtInAtomicType.equals(BuiltInAtomicType.ANY_ATOMIC);
        if (!this.c && !Type.isPossiblyComparable((BuiltInAtomicType)object5, builtInAtomicType, Token.isOrderedOperator(this.operator))) {
            boolean bl3 = Cardinality.allowsZero(this.getLhsExpression().getCardinality());
            boolean bl4 = Cardinality.allowsZero(this.getRhsExpression().getCardinality());
            if (bl3 || bl4) {
                String string = null;
                if (bl3) {
                    string = "the first operand is";
                }
                if (bl4) {
                    string = "the second operand is";
                }
                if (bl3 && bl4) {
                    string = "one or both operands are";
                }
                ((ExpressionVisitor)object).getStaticContext().issueWarning("Comparison of " + object3.toString() + (bl3 ? "?" : "") + " to " + object4.toString() + (bl4 ? "?" : "") + " will fail unless " + string + " empty", this.getLocation());
                this.c = true;
            } else {
                String string = "In {" + ((Expression)this).toShortString() + "}: cannot compare " + object3.toString() + " to " + object4.toString();
                object = new XPathException(string);
                ((XPathException)object).setIsTypeError(true);
                ((XPathException)object).setErrorCode("XPTY0004");
                ((XPathException)object).setLocation(this.getLocation());
                throw object;
            }
        }
        if (this.operator != 50 && this.operator != 51) {
            this.a((PlainType)object3, (BuiltInAtomicType)object5);
            this.a((PlainType)object4, builtInAtomicType);
        }
        if (this.a == null) {
            String string = staticContext.getDefaultCollationName();
            StringCollator stringCollator = ((Configuration)object2).getCollation(string);
            if (stringCollator == null) {
                stringCollator = CodepointCollator.getInstance();
            }
            this.a = GenericAtomicComparer.makeAtomicComparer((BuiltInAtomicType)object5, builtInAtomicType, stringCollator, staticContext.getConfiguration().getConversionContext());
        }
        return this;
    }

    private void a(PlainType object, BuiltInAtomicType builtInAtomicType) {
        if (!builtInAtomicType.isOrdered(true)) {
            object = new XPathException("Type " + object.toString() + " is not an ordered type");
            ((XPathException)object).setErrorCode("XPTY0004");
            ((XPathException)object).setIsTypeError(true);
            ((XPathException)object).setLocation(this.getLocation());
            throw object;
        }
    }

    @Override
    public final Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        int n2;
        int n3;
        Expression expression;
        Object object = expressionVisitor.getConfiguration().getTypeHierarchy();
        this.getLhs().optimize(expressionVisitor, contextItemStaticInfo);
        this.getRhs().optimize(expressionVisitor, contextItemStaticInfo);
        Object object2 = null;
        GroundedValue<?> groundedValue = null;
        if (this.getLhsExpression() instanceof Literal) {
            object2 = ((Literal)this.getLhsExpression()).getValue();
        }
        if (this.getRhsExpression() instanceof Literal) {
            groundedValue = ((Literal)this.getRhsExpression()).getValue();
        }
        if (object2 != null && groundedValue != null) {
            try {
                BooleanValue booleanValue = this.evaluateItem(expressionVisitor.getStaticContext().makeEarlyEvaluationContext());
                return Literal.makeLiteral(booleanValue == null ? EmptySequence.getInstance() : booleanValue, this);
            }
            catch (NoDynamicContextException noDynamicContextException) {
                return this;
            }
        }
        if (this.getLhsExpression().isCallOn(Count.class) && Literal.isAtomic(this.getRhsExpression()) ? (expression = this.a(expressionVisitor, false)) != null : this.getRhsExpression().isCallOn(Count.class) && Literal.isAtomic(this.getLhsExpression()) && (expression = this.a(expressionVisitor, true)) != null) {
            return expression.optimize(expressionVisitor, contextItemStaticInfo);
        }
        if (this.getLhsExpression().isCallOn(StringLength_1.class) && ValueComparison.a(groundedValue)) {
            expression = ((SystemFunctionCall)this.getLhsExpression()).getArg(0);
            switch (this.operator) {
                case 50: 
                case 55: {
                    return SystemFunction.makeCall("not", this.getRetainedStaticContext(), expression);
                }
                case 51: 
                case 52: {
                    return SystemFunction.makeCall("boolean", this.getRetainedStaticContext(), expression);
                }
                case 54: {
                    return Literal.makeLiteral(BooleanValue.TRUE, this);
                }
                case 53: {
                    return Literal.makeLiteral(BooleanValue.FALSE, this);
                }
            }
        }
        if (this.getRhsExpression().isCallOn(StringLength_1.class) && ValueComparison.a(object2)) {
            expression = ((SystemFunctionCall)this.getRhsExpression()).getArg(0);
            switch (this.operator) {
                case 50: 
                case 54: {
                    return SystemFunction.makeCall("not", this.getRetainedStaticContext(), expression);
                }
                case 51: 
                case 53: {
                    return SystemFunction.makeCall("boolean", this.getRetainedStaticContext(), expression);
                }
                case 55: {
                    return Literal.makeLiteral(BooleanValue.TRUE, this);
                }
                case 52: {
                    return Literal.makeLiteral(BooleanValue.FALSE, this);
                }
            }
        }
        if (((n3 = this.getLhsExpression().getItemType().getPrimitiveType()) == 513 || n3 == 529 || n3 == 631) && this.b != BooleanValue.TRUE && this.getRhsExpression() instanceof Literal && ((Literal)this.getRhsExpression()).getValue() instanceof StringValue && ((StringValue)((Literal)this.getRhsExpression()).getValue()).isZeroLength() && this.a instanceof CodepointCollatingComparer) {
            switch (this.operator) {
                case 51: 
                case 52: {
                    return SystemFunction.makeCall("boolean", this.getRetainedStaticContext(), this.getLhsExpression());
                }
                case 50: 
                case 55: {
                    if (this.getLhsExpression().getCardinality() != 16384) break;
                    return SystemFunction.makeCall("not", this.getRetainedStaticContext(), this.getLhsExpression());
                }
            }
        }
        if (((n2 = this.getRhsExpression().getItemType().getPrimitiveType()) == 513 || n2 == 529 || n2 == 631) && this.b != BooleanValue.TRUE && this.getLhsExpression() instanceof Literal && ((Literal)this.getLhsExpression()).getValue() instanceof StringValue && ((StringValue)((Literal)this.getLhsExpression()).getValue()).isZeroLength() && this.a instanceof CodepointCollatingComparer) {
            switch (this.operator) {
                case 51: 
                case 53: {
                    return SystemFunction.makeCall("boolean", this.getRetainedStaticContext(), this.getRhsExpression());
                }
                case 50: 
                case 54: {
                    if (this.getRhsExpression().getCardinality() != 16384) break;
                    return SystemFunction.makeCall("not", this.getRetainedStaticContext(), this.getRhsExpression());
                }
            }
        }
        if (this.getLhsExpression().isCallOn(PositionAndLast.Position.class) && this.getRhsExpression().isCallOn(PositionAndLast.Last.class)) {
            switch (this.operator) {
                case 50: 
                case 54: {
                    object = new IsLastExpression(true);
                    ExpressionTool.copyLocationInfo(this, (Expression)object);
                    return object;
                }
                case 51: 
                case 53: {
                    object2 = new IsLastExpression(false);
                    ExpressionTool.copyLocationInfo(this, (Expression)object2);
                    return object2;
                }
                case 52: {
                    return Literal.makeLiteral(BooleanValue.FALSE, this);
                }
                case 55: {
                    return Literal.makeLiteral(BooleanValue.TRUE, this);
                }
            }
        }
        if (this.getLhsExpression().isCallOn(PositionAndLast.Last.class) && this.getRhsExpression().isCallOn(PositionAndLast.Position.class)) {
            switch (this.operator) {
                case 50: 
                case 55: {
                    object = new IsLastExpression(true);
                    ExpressionTool.copyLocationInfo(this, (Expression)object);
                    return object;
                }
                case 51: 
                case 52: {
                    object2 = new IsLastExpression(false);
                    ExpressionTool.copyLocationInfo(this, (Expression)object2);
                    return object2;
                }
                case 53: {
                    return Literal.makeLiteral(BooleanValue.FALSE, this);
                }
                case 54: {
                    return Literal.makeLiteral(BooleanValue.TRUE, this);
                }
            }
        }
        if (groundedValue instanceof Int64Value && this.getLhsExpression().getCardinality() == 16384 && ((TypeHierarchy)object).isSubType(this.getLhsExpression().getItemType(), NumericType.getInstance())) {
            return new CompareToIntegerConstant(this.getLhsExpression(), this.operator, ((NumericValue)((Int64Value)groundedValue)).longValue());
        }
        if (object2 instanceof Int64Value && this.getRhsExpression().getCardinality() == 16384 && ((TypeHierarchy)object).isSubType(this.getRhsExpression().getItemType(), NumericType.getInstance())) {
            return new CompareToIntegerConstant(this.getRhsExpression(), Token.inverse(this.operator), ((NumericValue)((Int64Value)object2)).longValue());
        }
        if (n3 == 514 && n2 == 514 && (this.operator == 50 || this.operator == 51) && this.getLhsExpression().getCardinality() == 16384 && this.getRhsExpression().getCardinality() == 16384 && (this.getLhsExpression() instanceof Literal || this.getRhsExpression() instanceof Literal)) {
            object = (Literal)(this.getLhsExpression() instanceof Literal ? this.getLhsExpression() : this.getRhsExpression());
            object2 = this.getLhsExpression() instanceof Literal ? this.getRhsExpression() : this.getLhsExpression();
            boolean bl2 = this.operator == 50 != ((BooleanValue)((Literal)object).getValue()).getBooleanValue();
            if (bl2) {
                Expression expression2 = SystemFunction.makeCall("not", this.getRetainedStaticContext(), new Expression[]{object2});
                assert (expression2 != null);
                ExpressionTool.copyLocationInfo(this, expression2);
                return expression2.optimize(expressionVisitor, contextItemStaticInfo);
            }
            return object2;
        }
        if (this.getLhsExpression().isCallOn(GenerateId_1.class) && this.getRhsExpression().isCallOn(GenerateId_1.class)) {
            object = (SystemFunctionCall)this.getLhsExpression();
            object2 = (SystemFunctionCall)this.getRhsExpression();
            if (!Cardinality.allowsMany(((FunctionCall)object).getArg(0).getCardinality()) && !Cardinality.allowsMany(((FunctionCall)object2).getArg(0).getCardinality()) && this.operator == 50) {
                object = new IdentityComparison(((FunctionCall)object).getArg(0), 20, ((FunctionCall)object2).getArg(0));
                ((IdentityComparison)object).setGenerateIdEmulation(true);
                ExpressionTool.copyLocationInfo(this, (Expression)object);
                return ((Expression)object).typeCheck(expressionVisitor, contextItemStaticInfo).optimize(expressionVisitor, contextItemStaticInfo);
            }
        }
        return this;
    }

    private Expression a(ExpressionVisitor object, boolean n2) {
        Expression expression = (SystemFunctionCall)(n2 != 0 ? this.getRhsExpression() : this.getLhsExpression());
        expression = ((FunctionCall)expression).getArg(0);
        expression = expression.unordered(true, false);
        object = ((ExpressionVisitor)object).obtainOptimizer();
        AtomicValue atomicValue = (AtomicValue)((Literal)(n2 != 0 ? this.getLhsExpression() : this.getRhsExpression())).getValue();
        int n3 = n2 = n2 != 0 ? Token.inverse(this.operator) : this.operator;
        if (ValueComparison.a(atomicValue)) {
            if (n2 == 50 || n2 == 55) {
                Expression expression2 = SystemFunction.makeCall("empty", this.getRetainedStaticContext(), expression);
                ((Optimizer)object).trace("Rewrite count()=0 as:", expression2);
                return expression2;
            }
            if (n2 == 51 || n2 == 52) {
                Expression expression3 = SystemFunction.makeCall("exists", this.getRetainedStaticContext(), expression);
                ((Optimizer)object).trace("Rewrite count()>0 as:", expression3);
                return expression3;
            }
            if (n2 == 54) {
                return Literal.makeLiteral(BooleanValue.TRUE, this);
            }
            return Literal.makeLiteral(BooleanValue.FALSE, this);
        }
        if (atomicValue instanceof NumericValue) {
            long l2;
            if (atomicValue instanceof IntegerValue) {
                l2 = ((IntegerValue)atomicValue).longValue();
            } else {
                if (atomicValue.isNaN()) {
                    return Literal.makeLiteral(BooleanValue.get(n2 == 51), this);
                }
                if (((NumericValue)atomicValue).isWholeNumber()) {
                    l2 = ((NumericValue)atomicValue).longValue();
                } else {
                    if (n2 == 50) {
                        return Literal.makeLiteral(BooleanValue.FALSE, this);
                    }
                    if (n2 == 51) {
                        return Literal.makeLiteral(BooleanValue.TRUE, this);
                    }
                    if (n2 == 52 || n2 == 54) {
                        l2 = ((NumericValue)atomicValue).ceiling().longValue();
                        n2 = 54;
                    } else {
                        l2 = ((NumericValue)atomicValue).floor().longValue();
                        n2 = 55;
                    }
                }
            }
            if (l2 < 0L) {
                switch (n2) {
                    case 50: 
                    case 53: 
                    case 55: {
                        return Literal.makeLiteral(BooleanValue.FALSE, this);
                    }
                }
                return Literal.makeLiteral(BooleanValue.TRUE, this);
            }
            if (l2 > Integer.MAX_VALUE) {
                switch (n2) {
                    case 50: 
                    case 52: 
                    case 54: {
                        return Literal.makeLiteral(BooleanValue.FALSE, this);
                    }
                }
                return Literal.makeLiteral(BooleanValue.TRUE, this);
            }
            if (expression instanceof TailExpression || expression.isCallOn(Subsequence_2.class)) {
                return null;
            }
            switch (n2) {
                case 50: 
                case 51: 
                case 53: 
                case 55: {
                    expression = SystemFunction.makeCall("subsequence", this.getRetainedStaticContext(), expression, Literal.makeLiteral(Int64Value.PLUS_ONE, this), Literal.makeLiteral(Int64Value.makeIntegerValue(l2 + 1L), this));
                    expression = SystemFunction.makeCall("count", this.getRetainedStaticContext(), expression);
                    CompareToIntegerConstant compareToIntegerConstant = new CompareToIntegerConstant(expression, n2, l2);
                    ((Optimizer)object).trace("Rewrite count()~N as:", compareToIntegerConstant);
                    ExpressionTool.copyLocationInfo(this, compareToIntegerConstant);
                    return compareToIntegerConstant;
                }
                case 52: 
                case 54: {
                    Expression expression4 = new TailExpression(expression, (int)(n2 == 54 ? l2 : l2 + 1L));
                    ExpressionTool.copyLocationInfo(this, expression4);
                    expression4 = SystemFunction.makeCall("exists", this.getRetainedStaticContext(), expression4);
                    ExpressionTool.copyLocationInfo(this, expression4);
                    ((Optimizer)object).trace("Rewrite count()>=N as:", expression4);
                    return expression4;
                }
            }
        }
        return null;
    }

    @Override
    public final boolean isNegatable(TypeHierarchy typeHierarchy) {
        return ValueComparison.a(this.getLhsExpression(), typeHierarchy) && ValueComparison.a(this.getRhsExpression(), typeHierarchy);
    }

    private static boolean a(Expression expression, TypeHierarchy typeHierarchy) {
        return typeHierarchy.relationship(expression.getItemType(), BuiltInAtomicType.DOUBLE) == 4 && typeHierarchy.relationship(expression.getItemType(), BuiltInAtomicType.FLOAT) == 4;
    }

    @Override
    public final Expression negate() {
        ValueComparison valueComparison = new ValueComparison(this.getLhsExpression(), Token.negate(this.operator), this.getRhsExpression());
        new ValueComparison(this.getLhsExpression(), Token.negate(this.operator), this.getRhsExpression()).a = this.a;
        valueComparison.b = this.b == null || this.b == BooleanValue.FALSE ? BooleanValue.TRUE : BooleanValue.FALSE;
        ExpressionTool.copyLocationInfo(this, valueComparison);
        return valueComparison;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    private static boolean a(GroundedValue groundedValue) {
        return groundedValue instanceof NumericValue && ((NumericValue)groundedValue).compareTo(0L) == 0;
    }

    @Override
    public final boolean equals(Object object) {
        return object instanceof ValueComparison && super.equals(object) && this.a.equals(((ValueComparison)object).a);
    }

    @Override
    public final Expression copy(RebindingMap object) {
        object = new ValueComparison(this.getLhsExpression().copy((RebindingMap)object), this.operator, this.getRhsExpression().copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        ((ValueComparison)object).a = this.a;
        ((ValueComparison)object).b = this.b;
        ((ValueComparison)object).c = this.c;
        return object;
    }

    @Override
    public final boolean effectiveBooleanValue(XPathContext xPathContext) {
        try {
            AtomicValue atomicValue = (AtomicValue)this.getLhsExpression().evaluateItem(xPathContext);
            if (atomicValue == null) {
                return this.b == BooleanValue.TRUE;
            }
            AtomicValue atomicValue2 = (AtomicValue)this.getRhsExpression().evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return this.b == BooleanValue.TRUE;
            }
            return ValueComparison.compare(atomicValue, this.operator, atomicValue2, this.a.provideContext(xPathContext), this.c);
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            xPathException.maybeSetLocation(this.getLocation());
            xPathException2.maybeSetContext(xPathContext);
            throw xPathException2;
        }
    }

    public static boolean compare(AtomicValue object, int n2, AtomicValue atomicValue, AtomicComparer atomicComparer, boolean bl2) {
        if (bl2 && !Type.isGuaranteedComparable(((AtomicValue)object).getPrimitiveType(), atomicValue.getPrimitiveType(), Token.isOrderedOperator(n2))) {
            object = new XPathException("Cannot compare " + Type.displayTypeName((Item)object) + " to " + Type.displayTypeName(atomicValue));
            ((XPathException)object).setErrorCode("XPTY0004");
            ((XPathException)object).setIsTypeError(true);
            throw object;
        }
        if (((AtomicValue)object).isNaN() || atomicValue.isNaN()) {
            return n2 == 51;
        }
        try {
            switch (n2) {
                case 50: {
                    return atomicComparer.comparesEqual((AtomicValue)object, atomicValue);
                }
                case 51: {
                    return !atomicComparer.comparesEqual((AtomicValue)object, atomicValue);
                }
                case 52: {
                    return atomicComparer.compareAtomicValues((AtomicValue)object, atomicValue) > 0;
                }
                case 53: {
                    return atomicComparer.compareAtomicValues((AtomicValue)object, atomicValue) < 0;
                }
                case 54: {
                    return atomicComparer.compareAtomicValues((AtomicValue)object, atomicValue) >= 0;
                }
                case 55: {
                    return atomicComparer.compareAtomicValues((AtomicValue)object, atomicValue) <= 0;
                }
            }
            throw new UnsupportedOperationException("Unknown operator " + n2);
        }
        catch (ComparisonException comparisonException) {
            object = comparisonException;
            throw comparisonException.getCause();
        }
        catch (ClassCastException classCastException) {
            object = new XPathException("Cannot compare " + Type.displayTypeName((Item)object) + " to " + Type.displayTypeName(atomicValue));
            ((XPathException)object).setErrorCode("XPTY0004");
            ((XPathException)object).setIsTypeError(true);
            throw object;
        }
    }

    public final BooleanValue evaluateItem(XPathContext xPathContext) {
        try {
            AtomicValue atomicValue = (AtomicValue)this.getLhsExpression().evaluateItem(xPathContext);
            if (atomicValue == null) {
                return this.b;
            }
            AtomicValue atomicValue2 = (AtomicValue)this.getRhsExpression().evaluateItem(xPathContext);
            if (atomicValue2 == null) {
                return this.b;
            }
            return BooleanValue.get(ValueComparison.compare(atomicValue, this.operator, atomicValue2, this.a.provideContext(xPathContext), this.c));
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            xPathException.maybeSetLocation(this.getLocation());
            xPathException2.maybeSetContext(xPathContext);
            throw xPathException2;
        }
    }

    @Override
    public final ItemType getItemType() {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    public final UType getStaticUType(UType uType) {
        return UType.BOOLEAN;
    }

    @Override
    public final int computeCardinality() {
        if (this.b != null) {
            return 16384;
        }
        return super.computeCardinality();
    }

    @Override
    public final String tag() {
        return "vc";
    }

    @Override
    protected final void explainExtraAttributes(ExpressionPresenter expressionPresenter) {
        if (this.b != null) {
            expressionPresenter.emitAttribute("onEmpty", this.b.getBooleanValue() ? "1" : "0");
        }
        expressionPresenter.emitAttribute("comp", this.a.save());
    }
}

