/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.LocalVariableBinding;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.LocalParamBlock;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public abstract class VariableReference
extends Expression
implements BindingReference {
    protected Binding binding = null;
    protected SequenceType staticType = null;
    protected GroundedValue<?> constantValue = null;
    private StructuredQName a = null;
    private boolean b = false;
    private boolean c = false;
    private boolean d = false;

    public VariableReference(StructuredQName structuredQName) {
        this.a = structuredQName;
    }

    public VariableReference(Binding binding) {
        this.a = binding.getVariableQName();
        this.fixup(binding);
    }

    public void setVariableName(StructuredQName structuredQName) {
        this.a = structuredQName;
    }

    public StructuredQName getVariableName() {
        return this.a;
    }

    @Override
    public abstract Expression copy(RebindingMap var1);

    @Override
    public int getNetCost() {
        return 0;
    }

    protected void copyFrom(VariableReference variableReference) {
        this.binding = variableReference.binding;
        this.staticType = variableReference.staticType;
        this.constantValue = variableReference.constantValue;
        this.a = variableReference.a;
        this.b = variableReference.b;
        this.c = variableReference.c;
        this.d = variableReference.d;
        ExpressionTool.copyLocationInfo(variableReference, this);
    }

    @Override
    public void setStaticType(SequenceType sequenceType, GroundedValue<?> groundedValue, int n2) {
        if (sequenceType == null) {
            sequenceType = SequenceType.ANY_SEQUENCE;
        }
        this.staticType = sequenceType;
        this.constantValue = groundedValue;
        int n3 = this.getDependencies();
        this.staticProperties = n2 & 0xFFFEFFFF & 0xFFBFFFFF | 0x800000 | sequenceType.getCardinality() | n3;
    }

    @Override
    public void setFlattened(boolean bl2) {
        this.b = bl2;
    }

    public boolean isFlattened() {
        return this.b;
    }

    @Override
    public void setFiltered(boolean bl2) {
        this.d = bl2;
    }

    public boolean isFiltered() {
        return this.d;
    }

    public boolean isInLoop() {
        return this.c;
    }

    public void setInLoop(boolean bl2) {
        this.c = bl2;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        if (this.constantValue != null) {
            this.binding = null;
            return Literal.makeLiteral(this.constantValue, this);
        }
        if (this.binding != null) {
            this.recomputeInLoop();
            VariableReference variableReference = this;
            this.binding.addReference(variableReference, variableReference.c);
        }
        return this;
    }

    public void recomputeInLoop() {
        this.c = ExpressionTool.isLoopingReference(this, this.binding);
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo object) {
        if (this.binding instanceof LetExpression && ((LetExpression)this.binding).getSequence() instanceof Literal && !((LetExpression)this.binding).isIndexedVariable) {
            object = ((LetExpression)this.binding).getSequence();
            Optimizer.trace(expressionVisitor.getConfiguration(), "Replaced variable " + this.getDisplayName() + " by its value", (Expression)object);
            this.binding = null;
            return ((Expression)object).copy(new RebindingMap());
        }
        if (this.constantValue != null) {
            this.binding = null;
            object = Literal.makeLiteral(this.constantValue, this);
            ExpressionTool.copyLocationInfo(this, (Expression)object);
            Optimizer.trace(expressionVisitor.getConfiguration(), "Replaced variable " + this.getDisplayName() + " by its value", (Expression)object);
            return object;
        }
        if (this.binding instanceof GlobalParam && ((GlobalParam)this.binding).isStatic() && (object = ((GlobalParam)this.binding).getSelectExpression()) instanceof Literal) {
            this.binding = null;
            Optimizer.trace(expressionVisitor.getConfiguration(), "Replaced static parameter " + this.getDisplayName() + " by its value", (Expression)object);
            return object;
        }
        return this;
    }

    @Override
    public void fixup(Binding binding) {
        boolean bl2 = this.binding instanceof LocalBinding && ((LocalBinding)this.binding).isIndexedVariable();
        this.binding = binding;
        if (bl2 && binding instanceof LocalBinding) {
            ((LocalBinding)binding).setIndexedVariable();
        }
        this.resetLocalStaticProperties();
    }

    public void refineVariableType(ItemType itemType, int n2, GroundedValue<?> groundedValue, int n3) {
        int n4;
        ItemType itemType2;
        TypeHierarchy typeHierarchy = this.getConfiguration().getTypeHierarchy();
        ItemType itemType3 = itemType2 = ((Expression)this).getItemType();
        if (typeHierarchy.isSubType(itemType, itemType2)) {
            itemType3 = itemType;
        }
        if (itemType2 instanceof NodeTest && itemType instanceof AtomicType) {
            itemType3 = itemType;
        }
        if ((n4 = n2 & this.getCardinality()) == 0) {
            n4 = this.getCardinality();
        }
        SequenceType sequenceType = SequenceType.makeSequenceType(itemType3, n4);
        this.setStaticType(sequenceType, groundedValue, n3);
    }

    @Override
    public ItemType getItemType() {
        if (this.staticType == null || this.staticType.getPrimaryType() == AnyItemType.getInstance()) {
            SequenceType sequenceType;
            if (this.binding != null && (sequenceType = this.binding.getRequiredType()) != null) {
                return sequenceType.getPrimaryType();
            }
            return AnyItemType.getInstance();
        }
        return this.staticType.getPrimaryType();
    }

    @Override
    public UType getStaticUType(UType object) {
        if (this.binding != null) {
            if (this.binding.isGlobal() || this.binding instanceof LocalParam || this.binding instanceof LetExpression && ((Expression)((LetExpression)this.binding)).isInstruction() || this.binding instanceof LocalVariableBinding) {
                object = this.binding.getRequiredType();
                if (object != null) {
                    return ((SequenceType)object).getPrimaryType().getUType();
                }
                return UType.ANY;
            }
            if (this.binding instanceof Assignation) {
                return ((Assignation)this.binding).getSequence().getStaticUType((UType)object);
            }
        }
        return UType.ANY;
    }

    @Override
    public IntegerValue[] getIntegerBounds() {
        if (this.binding != null) {
            return this.binding.getIntegerBoundsForVariable();
        }
        return null;
    }

    @Override
    public int computeCardinality() {
        if (this.staticType == null) {
            if (this.binding == null) {
                return 57344;
            }
            if (this.binding instanceof LetExpression) {
                return this.binding.getRequiredType().getCardinality();
            }
            if (this.binding instanceof Assignation) {
                return 16384;
            }
            if (this.binding.getRequiredType() == null) {
                return 57344;
            }
            return this.binding.getRequiredType().getCardinality();
        }
        return this.staticType.getCardinality();
    }

    @Override
    public int computeSpecialProperties() {
        Expression expression;
        int n2 = super.computeSpecialProperties();
        if (this.binding == null || !this.binding.isAssignable()) {
            n2 |= 0x800000;
        }
        if (this.binding instanceof Assignation && (expression = ((Assignation)this.binding).getSequence()) != null) {
            n2 |= expression.getSpecialProperties() & 0x4000000;
        }
        if (this.staticType != null && !Cardinality.allowsMany(this.staticType.getCardinality()) && this.staticType.getPrimaryType() instanceof NodeTest) {
            n2 |= 0x1000000;
        }
        return n2 & 0xFFBFFFFF;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof VariableReference && this.binding == ((VariableReference)object).binding && this.binding != null;
    }

    @Override
    public int computeHashCode() {
        if (this.binding == null) {
            return 73619830;
        }
        return this.binding.hashCode();
    }

    @Override
    public int getIntrinsicDependencies() {
        int n2 = 0;
        if (this.binding == null) {
            n2 = 1664;
        } else if (this.binding.isGlobal()) {
            if (this.binding.isAssignable()) {
                n2 = 512;
            }
            if (this.binding instanceof GlobalParam) {
                n2 |= 0x400;
            }
        } else {
            n2 = 128;
        }
        return n2;
    }

    @Override
    public int getImplementationMethod() {
        return (Cardinality.allowsMany(this.getCardinality()) ? 0 : 1) | 2 | 4;
    }

    @Override
    public Expression getScopingExpression() {
        if (this.binding instanceof Expression) {
            if (this.binding instanceof LocalParam && ((LocalParam)this.binding).getParentExpression() instanceof LocalParamBlock) {
                LocalParamBlock localParamBlock = (LocalParamBlock)((LocalParam)this.binding).getParentExpression();
                return localParamBlock.getParentExpression();
            }
            return (Expression)((Object)this.binding);
        }
        for (Expression expression = this.getParentExpression(); expression != null; expression = expression.getParentExpression()) {
            if (!expression.hasVariableBinding(this.binding)) continue;
            return expression;
        }
        return null;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return pathMap.getPathForVariable(this.getBinding());
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        try {
            Sequence<?> sequence = this.evaluateVariable(xPathContext);
            assert (sequence != null);
            return sequence.iterate();
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            xPathException.maybeSetLocation(this.getLocation());
            throw xPathException2;
        }
        catch (NullPointerException nullPointerException) {
            Object object = nullPointerException;
            nullPointerException.printStackTrace();
            object = "Internal error: no value for variable $" + this.getDisplayName() + " at line " + this.getLocation().getLineNumber() + (this.getLocation().getSystemId() == null ? "" : " of " + this.getLocation().getSystemId());
            XPathContext xPathContext2 = xPathContext;
            StandardErrorListener.printStackTrace(xPathContext2, xPathContext2.getConfiguration().getLogger(), 2);
            throw new AssertionError(object);
        }
        catch (AssertionError assertionError) {
            Object object = assertionError;
            ((Throwable)((Object)assertionError)).printStackTrace();
            object = ((Throwable)object).getMessage() + ". Variable reference $" + this.getDisplayName() + " at line " + this.getLocation().getLineNumber() + (this.getLocation().getSystemId() == null ? "" : " of " + this.getLocation().getSystemId());
            XPathContext xPathContext3 = xPathContext;
            StandardErrorListener.printStackTrace(xPathContext3, xPathContext3.getConfiguration().getLogger(), 2);
            throw new AssertionError(object);
        }
    }

    public Item evaluateItem(XPathContext sequence) {
        try {
            sequence = this.evaluateVariable((XPathContext)((Object)sequence));
            assert (sequence != null);
            return sequence.head();
        }
        catch (XPathException xPathException) {
            sequence = xPathException;
            xPathException.maybeSetLocation(this.getLocation());
            throw sequence;
        }
    }

    @Override
    public void process(XPathContext object) {
        try {
            SequenceIterator<?> sequenceIterator = this.evaluateVariable((XPathContext)object).iterate();
            object = object.getReceiver();
            Location location = this.getLocation();
            sequenceIterator.forEachOrFail(arg_0 -> VariableReference.a((Receiver)object, location, arg_0));
            return;
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            xPathException.maybeSetLocation(this.getLocation());
            throw xPathException2;
        }
    }

    public Sequence<?> evaluateVariable(XPathContext xPathContext) {
        try {
            return this.binding.evaluateVariable(xPathContext);
        }
        catch (NullPointerException nullPointerException) {
            if (this.binding == null) {
                throw new IllegalStateException("Variable $" + this.a.getDisplayName() + " has not been fixed up");
            }
            throw nullPointerException;
        }
    }

    public Binding getBinding() {
        return this.binding;
    }

    public String getDisplayName() {
        if (this.binding != null) {
            return this.binding.getVariableQName().getDisplayName();
        }
        return this.a.getDisplayName();
    }

    public String getEQName() {
        if (this.binding != null) {
            StructuredQName structuredQName = this.binding.getVariableQName();
            if (structuredQName.hasURI("")) {
                return structuredQName.getLocalPart();
            }
            return structuredQName.getEQName();
        }
        return this.a.getEQName();
    }

    @Override
    public String toString() {
        String string = this.getEQName();
        return "$" + (string == null ? "$" : string);
    }

    @Override
    public String toShortString() {
        return "$" + this.getDisplayName();
    }

    @Override
    public String getExpressionName() {
        return "varRef";
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("varRef", this);
        expressionPresenter.emitAttribute("name", this.a);
        if (this.binding instanceof LocalBinding) {
            expressionPresenter.emitAttribute("slot", "" + ((LocalBinding)this.binding).getLocalSlotNumber());
        }
        expressionPresenter.endElement();
    }

    @Override
    public String getStreamerName() {
        return "VariableReference";
    }

    private static /* synthetic */ void a(Receiver receiver, Location location, Item item) {
        receiver.append(item, location, 524288);
    }
}

