/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.HashSet;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AndExpression;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.DifferenceEnumeration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.IntersectionEnumeration;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OrExpression;
import net.sf.saxon.expr.SingletonIntersectExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.UnionEnumeration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.expr.sort.GlobalOrderComparer;
import net.sf.saxon.functions.CurrentGroupCall;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ExceptPattern;
import net.sf.saxon.pattern.IntersectPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.UnionPattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class VennExpression
extends BinaryExpression {
    public VennExpression(Expression expression, int n2, Expression expression2) {
        super(expression, n2, expression2);
    }

    @Override
    public Expression simplify() {
        if (!(this.getLhsExpression() instanceof DocumentSorter)) {
            this.setLhsExpression(new DocumentSorter(this.getLhsExpression()));
        }
        if (!(this.getRhsExpression() instanceof DocumentSorter)) {
            this.setRhsExpression(new DocumentSorter(this.getRhsExpression()));
        }
        super.simplify();
        return this;
    }

    @Override
    public String getExpressionName() {
        switch (this.operator) {
            case 1: {
                return "union";
            }
            case 23: {
                return "intersect";
            }
            case 24: {
                return "except";
            }
        }
        return "unknown";
    }

    @Override
    public final ItemType getItemType() {
        ItemType itemType = this.getLhsExpression().getItemType();
        if (this.operator == 1) {
            ItemType itemType2 = this.getRhsExpression().getItemType();
            TypeHierarchy typeHierarchy = this.getConfiguration().getTypeHierarchy();
            return Type.getCommonSuperType(itemType, itemType2, typeHierarchy);
        }
        return itemType;
    }

    @Override
    public UType getStaticUType(UType uType) {
        switch (this.operator) {
            case 1: {
                return this.getLhsExpression().getStaticUType(uType).union(this.getRhsExpression().getStaticUType(uType));
            }
            case 23: {
                return this.getLhsExpression().getStaticUType(uType).intersection(this.getRhsExpression().getStaticUType(uType));
            }
        }
        return this.getLhsExpression().getStaticUType(uType);
    }

    @Override
    public final int computeCardinality() {
        int n2 = this.getLhsExpression().getCardinality();
        int n3 = this.getRhsExpression().getCardinality();
        switch (this.operator) {
            case 1: {
                if (Literal.isEmptySequence(this.getLhsExpression())) {
                    return n3;
                }
                if (Literal.isEmptySequence(this.getRhsExpression())) {
                    return n2;
                }
                return n2 | n3 | 0x4000 | 0x8000;
            }
            case 23: {
                if (Literal.isEmptySequence(this.getLhsExpression())) {
                    return 8192;
                }
                if (Literal.isEmptySequence(this.getRhsExpression())) {
                    return 8192;
                }
                return n2 & n3 | 0x2000 | 0x4000;
            }
            case 24: {
                if (Literal.isEmptySequence(this.getLhsExpression())) {
                    return 8192;
                }
                if (Literal.isEmptySequence(this.getRhsExpression())) {
                    return n2;
                }
                return n2 | 0x2000 | 0x4000;
            }
        }
        return 57344;
    }

    @Override
    public int computeSpecialProperties() {
        boolean bl2;
        boolean bl3;
        int n2 = this.getLhsExpression().getSpecialProperties();
        int n3 = this.getRhsExpression().getSpecialProperties();
        int n4 = 131072;
        int n5 = n3;
        int n6 = n2;
        VennExpression vennExpression = this;
        switch (vennExpression.operator) {
            case 1: {
                if ((n6 & n5 & 0x10000) != 0) {
                    bl3 = true;
                    break;
                }
                bl3 = false;
                break;
            }
            case 23: {
                if (((n6 | n5) & 0x10000) != 0) {
                    bl3 = true;
                    break;
                }
                bl3 = false;
                break;
            }
            case 24: {
                if ((n6 & 0x10000) != 0) {
                    bl3 = true;
                    break;
                }
                bl3 = false;
                break;
            }
            default: {
                bl3 = false;
            }
        }
        if (bl3) {
            n4 = 196608;
        }
        n5 = n3;
        n6 = n2;
        vennExpression = this;
        switch (vennExpression.operator) {
            case 1: {
                if ((n6 & n5 & 0x100000) != 0) {
                    bl2 = true;
                    break;
                }
                bl2 = false;
                break;
            }
            case 23: {
                if (((n6 | n5) & 0x100000) != 0) {
                    bl2 = true;
                    break;
                }
                bl2 = false;
                break;
            }
            case 24: {
                if ((n6 & 0x100000) != 0) {
                    bl2 = true;
                    break;
                }
                bl2 = false;
                break;
            }
            default: {
                bl2 = false;
            }
        }
        if (bl2) {
            n4 |= 0x100000;
        }
        n6 = n3;
        int n7 = n2;
        if ((n7 & 0x800000) != 0 && (n6 & 0x800000) != 0) {
            n4 |= 0x800000;
        }
        return n4;
    }

    public void gatherComponents(int n2, Set<Expression> set) {
        if (this.getLhsExpression() instanceof VennExpression && ((VennExpression)this.getLhsExpression()).operator == n2) {
            ((VennExpression)this.getLhsExpression()).gatherComponents(n2, set);
        } else {
            set.add(this.getLhsExpression());
        }
        if (this.getRhsExpression() instanceof VennExpression && ((VennExpression)this.getRhsExpression()).operator == n2) {
            ((VennExpression)this.getRhsExpression()).gatherComponents(n2, set);
            return;
        }
        set.add(this.getRhsExpression());
    }

    @Override
    public Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo object2) {
        Object object3 = ((ExpressionVisitor)object).getConfiguration();
        TypeChecker typeChecker = ((Configuration)object3).getTypeChecker(false);
        this.getLhs().typeCheck((ExpressionVisitor)object, (ContextItemStaticInfo)object2);
        this.getRhs().typeCheck((ExpressionVisitor)object, (ContextItemStaticInfo)object2);
        if (!(this.getLhsExpression() instanceof Pattern)) {
            object2 = new RoleDiagnostic(1, Token.tokens[this.operator], 0);
            this.setLhsExpression(typeChecker.staticTypeCheck(this.getLhsExpression(), SequenceType.NODE_SEQUENCE, (RoleDiagnostic)object2, (ExpressionVisitor)object));
        }
        if (!(this.getRhsExpression() instanceof Pattern)) {
            object2 = new RoleDiagnostic(1, Token.tokens[this.operator], 1);
            this.setRhsExpression(typeChecker.staticTypeCheck(this.getRhsExpression(), SequenceType.NODE_SEQUENCE, (RoleDiagnostic)object2, (ExpressionVisitor)object));
        }
        if (this.operator != 1 && ((TypeHierarchy)(object2 = ((Configuration)object3).getTypeHierarchy())).relationship((ItemType)(object = this.getLhsExpression().getItemType()), (ItemType)(object3 = this.getRhsExpression().getItemType())) == 4) {
            if (this.operator == 23) {
                return Literal.makeEmptySequence();
            }
            if (this.getLhsExpression().hasSpecialProperty(131072)) {
                return this.getLhsExpression();
            }
            return new DocumentSorter(this.getLhsExpression());
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        Expression expression;
        Expression expression2;
        Object object = super.optimize(expressionVisitor, contextItemStaticInfo);
        if (object != this) {
            return object;
        }
        object = expressionVisitor.getConfiguration();
        object = ((Configuration)object).getTypeHierarchy();
        Expression expression3 = this.getLhsExpression();
        Expression expression4 = this.getRhsExpression();
        switch (this.operator) {
            case 1: {
                if (Literal.isEmptySequence(expression3) && (expression4.getSpecialProperties() & 0x20000) != 0) {
                    return expression4;
                }
                if (Literal.isEmptySequence(expression4) && (expression3.getSpecialProperties() & 0x20000) != 0) {
                    return expression3;
                }
                if (!(expression3 instanceof CurrentGroupCall) || !(expression4 instanceof ContextItemExpression)) break;
                return expression3;
            }
            case 23: {
                if (Literal.isEmptySequence(expression3)) {
                    return expression3;
                }
                if (Literal.isEmptySequence(expression4)) {
                    return expression4;
                }
                if (!(expression3 instanceof CurrentGroupCall) || !(expression4 instanceof ContextItemExpression)) break;
                return expression4;
            }
            case 24: {
                if (Literal.isEmptySequence(expression3)) {
                    return expression3;
                }
                if (Literal.isEmptySequence(expression4) && (expression3.getSpecialProperties() & 0x20000) != 0) {
                    return expression3;
                }
                if (!(expression3 instanceof CurrentGroupCall) || !(expression4 instanceof ContextItemExpression)) break;
                return new TailExpression(expression3, 2);
            }
        }
        if (expression3 instanceof AxisExpression && expression4 instanceof AxisExpression) {
            expression2 = (AxisExpression)expression3;
            expression = (AxisExpression)expression4;
            if (((AxisExpression)expression2).getAxis() == ((AxisExpression)expression).getAxis()) {
                if (((AxisExpression)expression2).getNodeTest().equals(((AxisExpression)expression).getNodeTest())) {
                    if (this.operator == 24) {
                        return Literal.makeEmptySequence();
                    }
                    return expression2;
                }
                object = new AxisExpression(((AxisExpression)expression2).getAxis(), new CombinedNodeTest(((AxisExpression)expression2).getNodeTest(), this.operator, ((AxisExpression)expression).getNodeTest()));
                ExpressionTool.copyLocationInfo(this, (Expression)object);
                return object;
            }
        }
        if (expression3 instanceof SlashExpression && expression4 instanceof SlashExpression && this.operator == 1) {
            expression2 = (SlashExpression)expression3;
            expression = (SlashExpression)expression4;
            if (((SlashExpression)expression2).getFirstStep().isEqual(((SlashExpression)expression).getFirstStep())) {
                object = new VennExpression(((SlashExpression)expression2).getRemainingSteps(), this.operator, ((SlashExpression)expression).getRemainingSteps());
                ExpressionTool.copyLocationInfo(this, (Expression)object);
                object = ExpressionTool.makePathExpression(((SlashExpression)expression2).getFirstStep(), (Expression)object);
                ExpressionTool.copyLocationInfo(this, (Expression)object);
                return ((Expression)object).optimize(expressionVisitor, contextItemStaticInfo);
            }
        }
        if (expression3 instanceof FilterExpression && expression4 instanceof FilterExpression) {
            expression2 = (FilterExpression)expression3;
            expression = (FilterExpression)expression4;
            if (!((FilterExpression)expression2).isPositional((TypeHierarchy)object) && !((FilterExpression)expression).isPositional((TypeHierarchy)object) && ((FilterExpression)expression2).getSelectExpression().isEqual(((FilterExpression)expression).getSelectExpression())) {
                switch (this.operator) {
                    case 1: {
                        object = new OrExpression(((FilterExpression)expression2).getFilter(), ((FilterExpression)expression).getFilter());
                        break;
                    }
                    case 23: {
                        object = new AndExpression(((FilterExpression)expression2).getFilter(), ((FilterExpression)expression).getFilter());
                        break;
                    }
                    case 24: {
                        object = SystemFunction.makeCall("not", this.getRetainedStaticContext(), ((FilterExpression)expression).getFilter());
                        object = new AndExpression(((FilterExpression)expression2).getFilter(), (Expression)object);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown operator " + this.operator));
                    }
                }
                ExpressionTool.copyLocationInfo(this, (Expression)object);
                object = new FilterExpression(((FilterExpression)expression2).getSelectExpression(), (Expression)object);
                ExpressionTool.copyLocationInfo(this, (Expression)object);
                return ((Expression)object).simplify().typeCheck(expressionVisitor, contextItemStaticInfo).optimize(expressionVisitor, contextItemStaticInfo);
            }
        }
        if (!expressionVisitor.isOptimizeForStreaming() && this.operator == 1 && expression3 instanceof AxisExpression && expression4 instanceof AxisExpression) {
            expression2 = (AxisExpression)expression3;
            expression = (AxisExpression)expression4;
            if (((AxisExpression)expression2).getAxis() == 2 && ((AxisExpression)expression).getAxis() == 3) {
                return new Block(new Expression[]{expression3, expression4});
            }
            if (((AxisExpression)expression).getAxis() == 2 && ((AxisExpression)expression2).getAxis() == 3) {
                return new Block(new Expression[]{expression4, expression3});
            }
        }
        if (this.operator == 23 && !Cardinality.allowsMany(expression3.getCardinality())) {
            return new SingletonIntersectExpression(expression3, this.operator, expression4.unordered(false, false));
        }
        if (this.operator == 23 && !Cardinality.allowsMany(expression4.getCardinality())) {
            return new SingletonIntersectExpression(expression4, this.operator, expression3.unordered(false, false));
        }
        if (this.a((TypeHierarchy)object)) {
            if (this.operator == 23) {
                return Literal.makeEmptySequence();
            }
            if (this.operator == 24) {
                if ((expression3.getSpecialProperties() & 0x20000) != 0) {
                    return expression3;
                }
                return new DocumentSorter(expression3);
            }
        }
        return this;
    }

    private boolean a(TypeHierarchy typeHierarchy) {
        return typeHierarchy.relationship(this.getLhsExpression().getItemType(), this.getRhsExpression().getItemType()) == 4;
    }

    @Override
    public Expression unordered(boolean bl2, boolean bl3) {
        if (this.operator == 1 && !bl3) {
            VennExpression vennExpression = this;
            if (vennExpression.a(vennExpression.getConfiguration().getTypeHierarchy())) {
                Block block = new Block(new Expression[]{this.getLhsExpression(), this.getRhsExpression()});
                ExpressionTool.copyLocationInfo(this, block);
                return block;
            }
        }
        return this;
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new VennExpression(this.getLhsExpression().copy((RebindingMap)object), this.operator, this.getRhsExpression().copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    protected OperandRole getOperandRole(int n2) {
        return OperandRole.SAME_FOCUS_ACTION;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof VennExpression) {
            Object object2 = (VennExpression)object;
            if (this.operator != ((BinaryExpression)object2).operator) {
                return false;
            }
            if (this.getLhsExpression().isEqual(((BinaryExpression)object2).getLhsExpression()) && this.getRhsExpression().isEqual(((BinaryExpression)object2).getRhsExpression())) {
                return true;
            }
            if (this.operator == 1 || this.operator == 23) {
                object2 = new HashSet(10);
                VennExpression vennExpression = this;
                vennExpression.gatherComponents(vennExpression.operator, (Set<Expression>)object2);
                HashSet<Expression> hashSet = new HashSet<Expression>(10);
                ((VennExpression)object).gatherComponents(this.operator, hashSet);
                return object2.equals(hashSet);
            }
        }
        return false;
    }

    @Override
    public int computeHashCode() {
        return this.getLhsExpression().hashCode() ^ this.getRhsExpression().hashCode();
    }

    @Override
    public Pattern toPattern(Configuration configuration) {
        if (VennExpression.a(this.getLhsExpression()) || VennExpression.a(this.getRhsExpression())) {
            throw new XPathException("Cannot use a predicate pattern as an operand of a union, intersect, or except operator", "XTSE0340");
        }
        if (this.operator == 1) {
            return new UnionPattern(this.getLhsExpression().toPattern(configuration), this.getRhsExpression().toPattern(configuration));
        }
        if (this.operator == 24) {
            return new ExceptPattern(this.getLhsExpression().toPattern(configuration), this.getRhsExpression().toPattern(configuration));
        }
        return new IntersectPattern(this.getLhsExpression().toPattern(configuration), this.getRhsExpression().toPattern(configuration));
    }

    private static boolean a(Expression expression) {
        if (expression instanceof ItemChecker) {
            expression = ((ItemChecker)expression).getBaseExpression();
        }
        return expression instanceof FilterExpression && ((FilterExpression)expression).getSelectExpression() instanceof ContextItemExpression;
    }

    @Override
    protected String tag() {
        if (this.operator == 1) {
            return "union";
        }
        return Token.tokens[this.operator];
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext object) {
        SequenceIterator<?> sequenceIterator = this.getLhsExpression().iterate((XPathContext)object);
        object = this.getRhsExpression().iterate((XPathContext)object);
        switch (this.operator) {
            case 1: {
                return new UnionEnumeration(sequenceIterator, (SequenceIterator<? extends NodeInfo>)object, GlobalOrderComparer.getInstance());
            }
            case 23: {
                return new IntersectionEnumeration(sequenceIterator, (SequenceIterator<? extends NodeInfo>)object, GlobalOrderComparer.getInstance());
            }
            case 24: {
                return new DifferenceEnumeration(sequenceIterator, (SequenceIterator<? extends NodeInfo>)object, GlobalOrderComparer.getInstance());
            }
        }
        throw new UnsupportedOperationException("Unknown operator in Venn Expression");
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        if (this.operator == 1) {
            return this.getLhsExpression().effectiveBooleanValue(xPathContext) || this.getRhsExpression().effectiveBooleanValue(xPathContext);
        }
        return super.effectiveBooleanValue(xPathContext);
    }

    @Override
    public String getStreamerName() {
        return "VennExpression";
    }
}

