/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Arrays;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Controller;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ComponentBinding;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.TailCallLoop;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.lib.DelegatingErrorListener;
import net.sf.saxon.lib.StandardURIResolver;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.trans.rules.Rule;
import net.sf.saxon.trans.rules.RuleManager;
import net.sf.saxon.tree.iter.SingletonIterator;

public class XPathContextMajor
extends XPathContextMinor {
    private ParameterSet f;
    private ParameterSet g;
    private TailCallLoop.TailCallInfo h;
    private Component.M i;
    private Rule j;
    private GroupIterator k;
    private GroupIterator l;
    private RegexIterator m;
    private ContextOriginator n;
    private ThreadManager o = null;
    private URIResolver p;
    private UnfailingErrorListener q;
    private Component r;
    private XPathException s;

    public XPathContextMajor(Controller controller) {
        this.a = controller;
        this.stackFrame = StackFrame.EMPTY;
        this.n = controller;
    }

    private XPathContextMajor() {
    }

    public XPathContextMajor(Item<?> object, Executable executable) {
        Controller controller = this.a = executable instanceof PreparedStylesheet ? new XsltController(executable.getConfiguration(), (PreparedStylesheet)executable) : new Controller(executable.getConfiguration(), executable);
        if (object != null) {
            object = SingletonIterator.makeIterator(object);
            this.b = new FocusTrackingIterator((SequenceIterator<?>)object);
            try {
                this.b.next();
            }
            catch (XPathException xPathException) {}
            this.c = new XPathContextMinor.LastValue(1);
        }
        this.n = this.a;
    }

    @Override
    public XPathContextMajor newContext() {
        XPathContextMajor xPathContextMajor = new XPathContextMajor();
        new XPathContextMajor().a = this.a;
        xPathContextMajor.b = this.b;
        xPathContextMajor.stackFrame = this.stackFrame;
        xPathContextMajor.f = this.f;
        xPathContextMajor.g = this.g;
        xPathContextMajor.c = this.c;
        xPathContextMajor.d = this.d;
        xPathContextMajor.currentDestination = this.currentDestination;
        xPathContextMajor.i = this.i;
        xPathContextMajor.j = this.j;
        xPathContextMajor.m = this.m;
        xPathContextMajor.k = this.k;
        xPathContextMajor.l = this.l;
        xPathContextMajor.s = this.s;
        xPathContextMajor.e = this;
        xPathContextMajor.h = null;
        xPathContextMajor.temporaryOutputState = this.temporaryOutputState;
        xPathContextMajor.o = this.o;
        xPathContextMajor.r = this.r;
        xPathContextMajor.q = this.q;
        xPathContextMajor.p = this.p;
        return xPathContextMajor;
    }

    public static XPathContextMajor newContext(XPathContextMinor xPathContextMinor) {
        XPathContextMajor xPathContextMajor = new XPathContextMajor();
        XPathContext xPathContext = xPathContextMinor;
        while (!(xPathContext instanceof XPathContextMajor)) {
            xPathContext = xPathContext.getCaller();
        }
        xPathContextMajor.a = xPathContext.getController();
        xPathContextMajor.b = xPathContextMinor.getCurrentIterator();
        xPathContextMajor.stackFrame = xPathContextMinor.getStackFrame();
        xPathContextMajor.f = xPathContext.getLocalParameters();
        xPathContextMajor.g = xPathContext.getTunnelParameters();
        xPathContextMajor.c = xPathContextMinor.c;
        xPathContextMajor.d = xPathContextMinor.d;
        xPathContextMajor.currentDestination = xPathContextMinor.currentDestination;
        xPathContextMajor.i = xPathContext.getCurrentMode();
        xPathContextMajor.j = xPathContext.getCurrentTemplateRule();
        xPathContextMajor.m = xPathContext.getCurrentRegexIterator();
        xPathContextMajor.k = xPathContext.getCurrentGroupIterator();
        xPathContextMajor.l = xPathContext.getCurrentMergeGroupIterator();
        xPathContextMajor.e = xPathContextMinor;
        xPathContextMajor.h = null;
        xPathContextMajor.o = ((XPathContextMajor)xPathContext).o;
        xPathContextMajor.r = ((XPathContextMajor)xPathContext).r;
        xPathContextMajor.q = ((XPathContextMajor)xPathContext).q;
        xPathContextMajor.p = ((XPathContextMajor)xPathContext).p;
        xPathContextMajor.temporaryOutputState = xPathContextMinor.temporaryOutputState;
        return xPathContextMajor;
    }

    public static XPathContextMajor newThreadContext(XPathContextMinor xPathContextMinor) {
        XPathContextMajor xPathContextMajor = XPathContextMajor.newContext(xPathContextMinor);
        XPathContextMajor.newContext(xPathContextMinor).stackFrame = xPathContextMinor.stackFrame.copy();
        return xPathContextMajor;
    }

    @Override
    public ThreadManager getThreadManager() {
        return this.o;
    }

    public void createThreadManager() {
        this.o = this.getConfiguration().makeThreadManager();
    }

    @Override
    public void waitForChildThreads() {
        if (this.o != null) {
            this.o.waitForChildThreads();
        }
    }

    @Override
    public ParameterSet getLocalParameters() {
        if (this.f == null) {
            this.f = new ParameterSet();
        }
        return this.f;
    }

    public void setLocalParameters(ParameterSet parameterSet) {
        this.f = parameterSet;
    }

    @Override
    public ParameterSet getTunnelParameters() {
        return this.g;
    }

    public void setTunnelParameters(ParameterSet parameterSet) {
        this.g = parameterSet;
    }

    public void setOrigin(ContextOriginator contextOriginator) {
        this.n = contextOriginator;
    }

    public ContextOriginator getOrigin() {
        return this.n;
    }

    public void setStackFrame(SlotManager slotManager, Sequence[] sequenceArray) {
        this.stackFrame = new StackFrame(slotManager, sequenceArray);
        if (slotManager != null && sequenceArray.length != slotManager.getNumberOfVariables()) {
            if (sequenceArray.length > slotManager.getNumberOfVariables()) {
                throw new IllegalStateException("Attempting to set more local variables (" + sequenceArray.length + ") than the stackframe can accommodate (" + slotManager.getNumberOfVariables() + ")");
            }
            this.stackFrame.slots = new Sequence[slotManager.getNumberOfVariables()];
            System.arraycopy(sequenceArray, 0, this.stackFrame.slots, 0, sequenceArray.length);
        }
    }

    public void resetStackFrameMap(SlotManager sequenceArray, int n2) {
        this.stackFrame.map = sequenceArray;
        if (this.stackFrame.slots.length != sequenceArray.getNumberOfVariables()) {
            sequenceArray = new Sequence[sequenceArray.getNumberOfVariables()];
            System.arraycopy(this.stackFrame.slots, 0, sequenceArray, 0, n2);
            this.stackFrame.slots = sequenceArray;
            return;
        }
        Arrays.fill(this.stackFrame.slots, n2, this.stackFrame.slots.length, null);
    }

    public Sequence[] getAllVariableValues() {
        return this.stackFrame.getStackFrameValues();
    }

    public void resetAllVariableValues(Sequence[] sequenceArray) {
        this.stackFrame.setStackFrameValues(sequenceArray);
    }

    public void resetParameterValues(Sequence[] sequenceArray) {
        System.arraycopy(sequenceArray, 0, this.stackFrame.slots, 0, sequenceArray.length);
    }

    public void requestTailCall(TailCallLoop.TailCallInfo tailCallInfo, Sequence<?>[] sequenceArray) {
        if (sequenceArray != null) {
            if (sequenceArray.length > this.stackFrame.slots.length) {
                this.stackFrame.slots = Arrays.copyOf(sequenceArray, sequenceArray.length);
            } else {
                System.arraycopy(sequenceArray, 0, this.stackFrame.slots, 0, sequenceArray.length);
            }
        }
        this.h = tailCallInfo;
    }

    public TailCallLoop.TailCallInfo getTailCallInfo() {
        TailCallLoop.TailCallInfo tailCallInfo = this.h;
        this.h = null;
        return tailCallInfo;
    }

    public void openStackFrame(SlotManager slotManager) {
        int n2 = slotManager.getNumberOfVariables();
        if (n2 == 0) {
            this.stackFrame = StackFrame.EMPTY;
            return;
        }
        this.stackFrame = new StackFrame(slotManager, new Sequence[n2]);
    }

    public void openStackFrame(int n2) {
        this.stackFrame = new StackFrame(new SlotManager(n2), SequenceTool.makeSequenceArray(n2));
    }

    public void setCurrentMode(Component.M m2) {
        this.i = m2;
    }

    @Override
    public Component.M getCurrentMode() {
        Object object = this.i;
        if (object == null) {
            object = this.getController().getRuleManager();
            if (object != null) {
                return ((RuleManager)object).getUnnamedMode().getDeclaringComponent();
            }
            return null;
        }
        return object;
    }

    public void setCurrentTemplateRule(Rule rule) {
        this.j = rule;
    }

    @Override
    public Rule getCurrentTemplateRule() {
        return this.j;
    }

    public void setCurrentGroupIterator(GroupIterator groupIterator) {
        this.k = groupIterator;
    }

    @Override
    public GroupIterator getCurrentGroupIterator() {
        return this.k;
    }

    public void setCurrentMergeGroupIterator(GroupIterator groupIterator) {
        this.l = groupIterator;
    }

    @Override
    public GroupIterator getCurrentMergeGroupIterator() {
        return this.l;
    }

    public void setCurrentRegexIterator(RegexIterator regexIterator) {
        this.m = regexIterator;
    }

    @Override
    public RegexIterator getCurrentRegexIterator() {
        return this.m;
    }

    @Override
    public int useLocalParameter(StructuredQName structuredQName, int n2, boolean bl2) {
        ParameterSet parameterSet = bl2 ? ((XPathContextMinor)this).getTunnelParameters() : this.f;
        if (parameterSet == null) {
            return 0;
        }
        int n3 = parameterSet.getIndex(structuredQName);
        if (n3 < 0) {
            return 0;
        }
        Sequence<?> sequence = parameterSet.getValue(n3);
        this.stackFrame.slots[n2] = sequence;
        boolean bl3 = parameterSet.isTypeChecked(n3);
        n3 = bl3 ? 1 : 0;
        if (bl3) {
            return 2;
        }
        return 1;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.p = uRIResolver;
        if (uRIResolver instanceof StandardURIResolver) {
            ((StandardURIResolver)uRIResolver).setConfiguration(this.getConfiguration());
        }
    }

    @Override
    public URIResolver getURIResolver() {
        if (this.p == null) {
            return this.a.getURIResolver();
        }
        return this.p;
    }

    public void setErrorListener(ErrorListener errorListener) {
        if (errorListener instanceof UnfailingErrorListener) {
            this.q = (UnfailingErrorListener)errorListener;
            return;
        }
        this.q = new DelegatingErrorListener(errorListener);
    }

    @Override
    public UnfailingErrorListener getErrorListener() {
        if (this.q == null) {
            return this.a.getErrorListener();
        }
        return this.q;
    }

    public void setCurrentException(XPathException xPathException) {
        this.s = xPathException;
    }

    @Override
    public XPathException getCurrentException() {
        return this.s;
    }

    @Override
    public Component getCurrentComponent() {
        return this.r;
    }

    public void setCurrentComponent(Component component) {
        this.r = component;
    }

    @Override
    public Component getTargetComponent(int n2) {
        try {
            ComponentBinding componentBinding = this.r.getComponentBindings().get(n2);
            return componentBinding.getTarget();
        }
        catch (NullPointerException nullPointerException) {
            NullPointerException nullPointerException2 = nullPointerException;
            nullPointerException.printStackTrace();
            throw nullPointerException2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            IndexOutOfBoundsException indexOutOfBoundsException2 = indexOutOfBoundsException;
            indexOutOfBoundsException.printStackTrace();
            throw indexOutOfBoundsException2;
        }
    }

    public static abstract class ThreadManager {
        public abstract void waitForChildThreads();
    }
}

