/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import java.util.function.Function;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.trace.ContextStackIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.Rule;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.value.DateTimeValue;

public class XPathContextMinor
implements XPathContext {
    Controller a;
    FocusIterator<?> b;
    LastValue c = null;
    Receiver d;
    XPathContext e = null;
    protected StackFrame stackFrame;
    protected String currentDestination = "";
    protected int temporaryOutputState = 0;

    protected XPathContextMinor() {
    }

    @Override
    public XPathContextMajor newContext() {
        return XPathContextMajor.newContext(this);
    }

    @Override
    public XPathContextMinor newMinorContext() {
        XPathContextMinor xPathContextMinor = new XPathContextMinor();
        new XPathContextMinor().a = this.a;
        xPathContextMinor.e = this;
        xPathContextMinor.b = this.b;
        xPathContextMinor.d = this.d;
        xPathContextMinor.c = this.c;
        xPathContextMinor.stackFrame = this.stackFrame;
        xPathContextMinor.currentDestination = this.currentDestination;
        xPathContextMinor.temporaryOutputState = this.temporaryOutputState;
        return xPathContextMinor;
    }

    @Override
    public void setCaller(XPathContext xPathContext) {
        this.e = xPathContext;
    }

    @Override
    public XPathContextMajor newCleanContext() {
        XPathContextMajor xPathContextMajor = new XPathContextMajor(this.getController());
        xPathContextMajor.setCaller(this);
        return xPathContextMajor;
    }

    @Override
    public ParameterSet getLocalParameters() {
        return this.getCaller().getLocalParameters();
    }

    @Override
    public ParameterSet getTunnelParameters() {
        return this.getCaller().getTunnelParameters();
    }

    @Override
    public final Controller getController() {
        return this.a;
    }

    @Override
    public final Configuration getConfiguration() {
        return this.a.getConfiguration();
    }

    @Override
    public final NamePool getNamePool() {
        return this.a.getConfiguration().getNamePool();
    }

    @Override
    public final XPathContext getCaller() {
        return this.e;
    }

    @Override
    public void setCurrentIterator(FocusIterator<?> focusIterator) {
        this.b = focusIterator;
        this.c = new LastValue(-1);
    }

    @Override
    public <T extends Item<?>> FocusIterator<T> trackFocus(SequenceIterator<T> focusIterator) {
        Function<SequenceIterator<?>, FocusTrackingIterator<?>> function = this.a.getFocusTrackerFactory(false);
        focusIterator = function.apply(focusIterator);
        this.setCurrentIterator(focusIterator);
        return focusIterator;
    }

    public <T extends Item<?>> FocusIterator<T> trackFocusMultithreaded(SequenceIterator<T> focusIterator) {
        Function<SequenceIterator<?>, FocusTrackingIterator<?>> function = this.a.getFocusTrackerFactory(true);
        focusIterator = function.apply(focusIterator);
        this.setCurrentIterator(focusIterator);
        return focusIterator;
    }

    @Override
    public final FocusIterator<?> getCurrentIterator() {
        return this.b;
    }

    public final Item getContextItem() {
        if (this.b == null) {
            return null;
        }
        return this.b.current();
    }

    @Override
    public final int getLast() {
        if (this.b == null) {
            XPathException xPathException = new XPathException("The context item is absent, so last() is undefined");
            xPathException.setXPathContext(this);
            xPathException.setErrorCode("XPDY0002");
            throw xPathException;
        }
        if (this.c.value >= 0) {
            return this.c.value;
        }
        return this.b.getLength();
    }

    @Override
    public final boolean isAtLast() {
        if ((this.b.getProperties() & 4) != 0) {
            return !((LookaheadIterator)((Object)this.b)).hasNext();
        }
        return this.b.position() == this.getLast();
    }

    @Override
    public URIResolver getURIResolver() {
        return this.e.getURIResolver();
    }

    @Override
    public UnfailingErrorListener getErrorListener() {
        return this.e.getErrorListener();
    }

    @Override
    public XPathException getCurrentException() {
        return this.e.getCurrentException();
    }

    @Override
    public XPathContextMajor.ThreadManager getThreadManager() {
        return this.e.getThreadManager();
    }

    @Override
    public Component getCurrentComponent() {
        return this.e.getCurrentComponent();
    }

    @Override
    public StackFrame getStackFrame() {
        return this.stackFrame;
    }

    public void makeStackFrameMutable() {
        if (this.stackFrame == StackFrame.EMPTY) {
            this.stackFrame = new StackFrame(null, SequenceTool.makeSequenceArray(0));
        }
    }

    @Override
    public final Sequence<?> evaluateLocalVariable(int n2) {
        return this.stackFrame.slots[n2];
    }

    @Override
    public final void setLocalVariable(int n2, Sequence<?> sequence) {
        sequence = sequence.makeRepeatable();
        try {
            this.stackFrame.slots[n2] = sequence;
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (n2 == -999) {
                throw new AssertionError((Object)"Internal error: Cannot set local variable: no slot allocated");
            }
            throw new AssertionError((Object)("Internal error: Cannot set local variable (slot " + n2 + " of " + this.getStackFrame().getStackFrameValues().length + ")"));
        }
    }

    @Override
    public synchronized void waitForChildThreads() {
        this.getCaller().waitForChildThreads();
    }

    @Override
    public void setReceiver(Receiver receiver) {
        this.d = receiver;
    }

    @Override
    public final Receiver getReceiver() {
        return this.d;
    }

    @Override
    public void setTemporaryOutputState(int n2) {
        this.temporaryOutputState = n2;
    }

    @Override
    public int getTemporaryOutputState() {
        return this.temporaryOutputState;
    }

    @Override
    public void setCurrentOutputUri(String string) {
        this.currentDestination = string;
    }

    @Override
    public String getCurrentOutputUri() {
        return this.currentDestination;
    }

    @Override
    public int useLocalParameter(StructuredQName structuredQName, int n2, boolean bl2) {
        return this.getCaller().useLocalParameter(structuredQName, n2, bl2);
    }

    @Override
    public Component.M getCurrentMode() {
        return this.getCaller().getCurrentMode();
    }

    @Override
    public Rule getCurrentTemplateRule() {
        return null;
    }

    @Override
    public GroupIterator getCurrentGroupIterator() {
        return this.getCaller().getCurrentGroupIterator();
    }

    @Override
    public GroupIterator getCurrentMergeGroupIterator() {
        return this.getCaller().getCurrentMergeGroupIterator();
    }

    @Override
    public RegexIterator getCurrentRegexIterator() {
        return this.getCaller().getCurrentRegexIterator();
    }

    @Override
    public DateTimeValue getCurrentDateTime() {
        return this.a.getCurrentDateTime();
    }

    @Override
    public final int getImplicitTimezone() {
        return this.a.getImplicitTimezone();
    }

    @Override
    public Iterator iterateStackFrames() {
        return new ContextStackIterator(this);
    }

    @Override
    public Component getTargetComponent(int n2) {
        return this.getCaller().getTargetComponent(n2);
    }

    protected static class LastValue {
        public int value = 0;

        public LastValue(int n2) {
            this.value = n2;
        }
    }
}

