/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.accum;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.accum.AccumulatorData;
import net.sf.saxon.expr.accum.FailedAccumulatorData;
import net.sf.saxon.expr.accum.IAccumulatorData;
import net.sf.saxon.expr.accum.PathMappedAccumulatorData;
import net.sf.saxon.expr.accum.VirtualAccumulatorData;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.wrapper.VirtualCopy;
import net.sf.saxon.tree.wrapper.VirtualTreeInfo;

public class AccumulatorManager {
    private transient WeakHashMap<TreeInfo, Map<Accumulator, IAccumulatorData>> a = new WeakHashMap();
    private transient WeakHashMap<TreeInfo, Set<? extends Accumulator>> b = new WeakHashMap();
    private static AccumulatorData c = new AccumulatorData(null);

    public void setApplicableAccumulators(TreeInfo treeInfo, Set<? extends Accumulator> set) {
        this.b.put(treeInfo, set);
    }

    public boolean isApplicable(TreeInfo object, Accumulator accumulator) {
        return (object = this.b.get(object)) == null || object.contains(accumulator);
    }

    public synchronized IAccumulatorData getAccumulatorData(TreeInfo object, Accumulator accumulator, XPathContext object2) {
        Object object3;
        Map<Accumulator, IAccumulatorData> map = this.a.get(object);
        if (map != null) {
            object3 = map.get(accumulator);
            if (object3 != null) {
                if (object3 == c) {
                    throw new XPathException("Accumulator " + accumulator.getAccumulatorName().getDisplayName() + " requires access to its own value", "XTDE3400");
                }
                return object3;
            }
        } else {
            map = new HashMap<Accumulator, IAccumulatorData>();
            map.put(accumulator, c);
            this.a.put((TreeInfo)object, map);
        }
        if (object instanceof VirtualTreeInfo && ((VirtualTreeInfo)object).isCopyAccumulators()) {
            object3 = ((VirtualCopy)object.getRootNode()).getOriginalNode();
            object2 = this.getAccumulatorData(object3.getTreeInfo(), accumulator, (XPathContext)object2);
            object = new VirtualAccumulatorData((IAccumulatorData)object2);
            map.put(accumulator, (IAccumulatorData)object);
            return object;
        }
        if (object instanceof TinyTree && ((TinyTree)object).getCopiedFrom() != null) {
            object3 = this.getAccumulatorData(((TinyTree)object).getCopiedFrom().getTreeInfo(), accumulator, (XPathContext)object2);
            return new PathMappedAccumulatorData((IAccumulatorData)object3, ((TinyTree)object).getCopiedFrom());
        }
        object3 = new AccumulatorData(accumulator);
        object2 = object2.newCleanContext();
        ((XPathContextMajor)object2).setCurrentComponent(accumulator.getDeclaringComponent());
        try {
            ((AccumulatorData)object3).buildIndex(object.getRootNode(), (XPathContext)object2);
            map.put(accumulator, (IAccumulatorData)object3);
            return object3;
        }
        catch (XPathException xPathException) {
            FailedAccumulatorData failedAccumulatorData = new FailedAccumulatorData(accumulator, xPathException);
            map.put(accumulator, failedAccumulatorData);
            return failedAccumulatorData;
        }
    }

    public synchronized void addAccumulatorData(TreeInfo object, Accumulator accumulator, IAccumulatorData iAccumulatorData) {
        Map<Accumulator, IAccumulatorData> map = this.a.get(object);
        if (map != null) {
            object = map.get(accumulator);
            if (object != null) {
                return;
            }
        } else {
            map = new HashMap<Accumulator, IAccumulatorData>();
            this.a.put((TreeInfo)object, map);
        }
        map.put(accumulator, iAccumulatorData);
    }
}

