/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.accum;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.functions.AccumulatorFn;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class AccumulatorRegistry {
    protected Map<StructuredQName, Accumulator> accumulatorsByName = new HashMap<StructuredQName, Accumulator>();

    /*
     * WARNING - void declaration
     */
    public Set<Accumulator> getUsedAccumulators(String object2, StyleElement styleElement) {
        HashSet<Accumulator> hashSet;
        block6: {
            String[] stringArray;
            block5: {
                hashSet = new HashSet<Accumulator>();
                String string = Whitespace.trim((CharSequence)object2);
                stringArray = string.split("[ \t\r\n]+");
                if (stringArray.length != 1 || !stringArray[0].equals("#all")) break block5;
                for (Accumulator accumulator : this.getAllAccumulators()) {
                    hashSet.add(accumulator);
                }
                break block6;
            }
            if (stringArray.length == 1 && stringArray[0].isEmpty()) break block6;
            ArrayList<StructuredQName> arrayList = new ArrayList<StructuredQName>(stringArray.length);
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                void var2_7;
                String string = stringArray2[i2];
                if (string.equals("#all")) {
                    throw new XPathException("If use-accumulators contains the token '#all', it must be the only token", "XTSE3300");
                }
                StructuredQName structuredQName = var2_7.makeQName(string);
                if (arrayList.contains(structuredQName)) {
                    throw new XPathException("Duplicate QName in use-accumulators attribute: " + string, "XTSE3300");
                }
                Accumulator accumulator = this.getAccumulator(structuredQName);
                if (accumulator == null) {
                    throw new XPathException("Unknown accumulator name: " + string, "XTSE3300");
                }
                arrayList.add(structuredQName);
                hashSet.add(accumulator);
            }
        }
        return hashSet;
    }

    public void addAccumulator(Accumulator accumulator) {
        if (accumulator.getAccumulatorName() != null) {
            this.accumulatorsByName.put(accumulator.getAccumulatorName(), accumulator);
        }
    }

    public Accumulator getAccumulator(StructuredQName structuredQName) {
        return this.accumulatorsByName.get(structuredQName);
    }

    public Iterable<Accumulator> getAllAccumulators() {
        return this.accumulatorsByName.values();
    }

    public Sequence<?> getStreamingAccumulatorValue(NodeInfo nodeInfo, Accumulator accumulator, AccumulatorFn.Phase phase) {
        return null;
    }
}

