/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.compat;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Calculator;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.NegateExpression;
import net.sf.saxon.expr.OrExpression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.Number_1;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;

public class ArithmeticExpression10
extends ArithmeticExpression
implements Callable {
    public ArithmeticExpression10(Expression expression, int n2, Expression expression2) {
        super(expression, n2, expression2);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.getLhs().typeCheck(expressionVisitor, contextItemStaticInfo);
        this.getRhs().typeCheck(expressionVisitor, contextItemStaticInfo);
        Object object = expressionVisitor.getConfiguration();
        TypeHierarchy typeHierarchy = ((Configuration)object).getTypeHierarchy();
        if (Literal.isEmptySequence(this.getLhsExpression())) {
            return Literal.makeLiteral(DoubleValue.NaN, this);
        }
        if (Literal.isEmptySequence(this.getRhsExpression())) {
            return Literal.makeLiteral(DoubleValue.NaN, this);
        }
        Expression expression = this.getLhsExpression();
        Expression expression2 = this.getRhsExpression();
        Object object2 = SequenceType.OPTIONAL_ATOMIC;
        Object object3 = expressionVisitor.getConfiguration().getTypeChecker(true);
        RoleDiagnostic roleDiagnostic = new RoleDiagnostic(1, Token.tokens[this.operator], 0);
        this.setLhsExpression(((TypeChecker)object3).staticTypeCheck(this.getLhsExpression(), (SequenceType)object2, roleDiagnostic, expressionVisitor));
        roleDiagnostic = new RoleDiagnostic(1, Token.tokens[this.operator], 1);
        this.setRhsExpression(((TypeChecker)object3).staticTypeCheck(this.getRhsExpression(), (SequenceType)object2, roleDiagnostic, expressionVisitor));
        object2 = this.getLhsExpression().getItemType();
        if (object2 instanceof ErrorType) {
            return Literal.makeLiteral(DoubleValue.NaN, this);
        }
        object2 = (AtomicType)object2.getPrimitiveItemType();
        object3 = this.getRhsExpression().getItemType();
        if (object3 instanceof ErrorType) {
            return Literal.makeLiteral(DoubleValue.NaN, this);
        }
        object3 = (AtomicType)object3.getPrimitiveItemType();
        if (typeHierarchy.isSubType((ItemType)object2, BuiltInAtomicType.INTEGER) && typeHierarchy.isSubType((ItemType)object3, BuiltInAtomicType.INTEGER) && (this.operator == 15 || this.operator == 16 || this.operator == 17)) {
            object = new ArithmeticExpression(this.getLhsExpression(), this.operator, this.getRhsExpression());
            object = SystemFunction.makeCall("number", this.getRetainedStaticContext(), new Expression[]{object});
            return ((Expression)object).typeCheck(expressionVisitor, contextItemStaticInfo);
        }
        if (this.calculator == null) {
            ArithmeticExpression10 arithmeticExpression10 = this;
            arithmeticExpression10.setLhsExpression(arithmeticExpression10.a(this.getLhsExpression(), (Configuration)object, (AtomicType)object2));
        }
        object2 = (AtomicType)this.getLhsExpression().getItemType().getPrimitiveItemType();
        if (this.calculator == null) {
            ArithmeticExpression10 arithmeticExpression10 = this;
            arithmeticExpression10.setRhsExpression(arithmeticExpression10.a(this.getRhsExpression(), (Configuration)object, (AtomicType)object3));
        }
        object3 = (AtomicType)this.getRhsExpression().getItemType().getPrimitiveItemType();
        if (this.getLhsExpression() != expression) {
            ArithmeticExpression10 arithmeticExpression10 = this;
            arithmeticExpression10.adoptChildExpression(arithmeticExpression10.getLhsExpression());
        }
        if (this.getRhsExpression() != expression2) {
            ArithmeticExpression10 arithmeticExpression10 = this;
            arithmeticExpression10.adoptChildExpression(arithmeticExpression10.getRhsExpression());
        }
        if (this.operator == 299) {
            if (this.getRhsExpression() instanceof Literal && (object = ((Literal)this.getRhsExpression()).getValue()) instanceof NumericValue) {
                return Literal.makeLiteral(((NumericValue)object).negate(), this);
            }
            object = new NegateExpression(this.getRhsExpression());
            ((NegateExpression)object).setBackwardsCompatible(true);
            return ((Expression)object).typeCheck(expressionVisitor, contextItemStaticInfo);
        }
        boolean bl2 = !object2.equals(BuiltInAtomicType.ANY_ATOMIC) && !object3.equals(BuiltInAtomicType.ANY_ATOMIC) && !object2.equals(NumericType.getInstance()) && !object3.equals(NumericType.getInstance());
        this.calculator = this.a((AtomicType)object2, (AtomicType)object3, bl2);
        try {
            if (this.getLhsExpression() instanceof Literal && this.getRhsExpression() instanceof Literal) {
                return Literal.makeLiteral(((ArithmeticExpression)this).evaluateItem(expressionVisitor.getStaticContext().makeEarlyEvaluationContext()).materialize(), this);
            }
        }
        catch (XPathException xPathException) {}
        return this;
    }

    @Override
    public void setCalculator(Calculator calculator) {
        this.calculator = calculator;
    }

    private Calculator a(AtomicType object, AtomicType atomicType, boolean bl2) {
        Calculator calculator = Calculator.getCalculator(object.getFingerprint(), atomicType.getFingerprint(), ArithmeticExpression.mapOpCode(this.operator), bl2);
        if (calculator == null) {
            object = new XPathException("Arithmetic operator is not defined for arguments of types (" + object.getDescription() + ", " + atomicType.getDescription() + ")");
            ((XPathException)object).setLocation(this.getLocation());
            ((XPathException)object).setErrorCode("XPTY0004");
            throw object;
        }
        return calculator;
    }

    private Expression a(Expression expression, Configuration object, AtomicType object2) {
        Object object3;
        Object object4 = ((Configuration)object).getTypeHierarchy();
        if (Cardinality.allowsMany(expression.getCardinality())) {
            object3 = FirstItemExpression.makeFirstItemExpression(expression);
            ExpressionTool.copyLocationInfo(this, (Expression)object3);
            expression = object3;
        }
        if (((TypeHierarchy)object4).isSubType((ItemType)object2, BuiltInAtomicType.DOUBLE) || ((TypeHierarchy)object4).isSubType((ItemType)object2, BuiltInAtomicType.DATE) || ((TypeHierarchy)object4).isSubType((ItemType)object2, BuiltInAtomicType.TIME) || ((TypeHierarchy)object4).isSubType((ItemType)object2, BuiltInAtomicType.DATE_TIME) || ((TypeHierarchy)object4).isSubType((ItemType)object2, BuiltInAtomicType.DURATION)) {
            return expression;
        }
        if (((TypeHierarchy)object4).isSubType((ItemType)object2, BuiltInAtomicType.BOOLEAN) || ((TypeHierarchy)object4).isSubType((ItemType)object2, BuiltInAtomicType.STRING) || ((TypeHierarchy)object4).isSubType((ItemType)object2, BuiltInAtomicType.UNTYPED_ATOMIC) || ((TypeHierarchy)object4).isSubType((ItemType)object2, BuiltInAtomicType.FLOAT) || ((TypeHierarchy)object4).isSubType((ItemType)object2, BuiltInAtomicType.DECIMAL)) {
            if (expression instanceof Literal) {
                object3 = ((Literal)expression).getValue();
                return Literal.makeLiteral(Number_1.convert((AtomicValue)object3, (Configuration)object), this);
            }
            return SystemFunction.makeCall("number", this.getRetainedStaticContext(), expression);
        }
        object3 = new LetExpression();
        ((Assignation)object3).setRequiredType(SequenceType.OPTIONAL_ATOMIC);
        ((Assignation)object3).setVariableQName(new StructuredQName("nn", "http://saxon.sf.net/", "nn" + ((Expression)object3).hashCode()));
        ((Assignation)object3).setSequence(expression);
        expression = new LocalVariableReference((LocalBinding)object3);
        object = new InstanceOfExpression(expression, BuiltInAtomicType.DOUBLE.zeroOrOne());
        expression = new LocalVariableReference((LocalBinding)object3);
        object2 = new InstanceOfExpression(expression, BuiltInAtomicType.DECIMAL.zeroOrOne());
        expression = new LocalVariableReference((LocalBinding)object3);
        object4 = new InstanceOfExpression(expression, BuiltInAtomicType.FLOAT.zeroOrOne());
        expression = new LocalVariableReference((LocalBinding)object3);
        InstanceOfExpression instanceOfExpression = new InstanceOfExpression(expression, BuiltInAtomicType.STRING.zeroOrOne());
        expression = new LocalVariableReference((LocalBinding)object3);
        InstanceOfExpression instanceOfExpression2 = new InstanceOfExpression(expression, BuiltInAtomicType.UNTYPED_ATOMIC.zeroOrOne());
        expression = new LocalVariableReference((LocalBinding)object3);
        expression = new InstanceOfExpression(expression, BuiltInAtomicType.BOOLEAN.zeroOrOne());
        object = new OrExpression((Expression)object, (Expression)object2);
        object = new OrExpression((Expression)object, (Expression)object4);
        object = new OrExpression((Expression)object, instanceOfExpression);
        object = new OrExpression((Expression)object, instanceOfExpression2);
        object = new OrExpression((Expression)object, expression);
        expression = new LocalVariableReference((LocalBinding)object3);
        object2 = SystemFunction.makeCall("number", this.getRetainedStaticContext(), expression);
        expression = new LocalVariableReference((LocalBinding)object3);
        ((VariableReference)expression).setStaticType(SequenceType.SINGLE_ATOMIC, null, 0);
        expression = Choose.makeConditional((Expression)object, (Expression)object2, expression);
        ((Assignation)object3).setAction(expression);
        return object3;
    }

    @Override
    public PlainType getItemType() {
        ItemType itemType;
        if (this.calculator == null) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        ItemType itemType2 = this.getLhsExpression().getItemType();
        if (!(itemType2 instanceof AtomicType)) {
            itemType2 = itemType2.getAtomizedItemType();
        }
        if (!((itemType = this.getRhsExpression().getItemType()) instanceof AtomicType)) {
            itemType = itemType.getAtomizedItemType();
        }
        return this.calculator.getResultType((AtomicType)itemType2.getPrimitiveItemType(), (AtomicType)itemType.getPrimitiveItemType());
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new ArithmeticExpression10(this.getLhsExpression().copy((RebindingMap)object), this.operator, this.getRhsExpression().copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        ((ArithmeticExpression)object).calculator = this.calculator;
        return object;
    }

    @Override
    protected String tag() {
        return "arith10";
    }

    @Override
    protected void explainExtraAttributes(ExpressionPresenter expressionPresenter) {
        expressionPresenter.emitAttribute("calc", this.calculator.code());
    }

    @Override
    public AtomicValue evaluateItem(XPathContext xPathContext) {
        Calculator calculator = this.calculator;
        AtomicValue atomicValue = (AtomicValue)this.getLhsExpression().evaluateItem(xPathContext);
        if (atomicValue == null) {
            return DoubleValue.NaN;
        }
        AtomicValue atomicValue2 = (AtomicValue)this.getRhsExpression().evaluateItem(xPathContext);
        if (atomicValue2 == null) {
            return DoubleValue.NaN;
        }
        if (calculator == null) {
            calculator = this.a(atomicValue.getPrimitiveType(), atomicValue2.getPrimitiveType(), true);
        }
        return calculator.compute(atomicValue, atomicValue2, xPathContext);
    }

    public AtomicValue call(XPathContext xPathContext, Sequence[] object) {
        Calculator calculator = this.calculator;
        AtomicValue atomicValue = (AtomicValue)object[0].head();
        if (atomicValue == null) {
            return DoubleValue.NaN;
        }
        if ((object = (AtomicValue)object[1].head()) == null) {
            return DoubleValue.NaN;
        }
        if (calculator == null) {
            calculator = this.a(atomicValue.getPrimitiveType(), ((AtomicValue)object).getPrimitiveType(), true);
        }
        return calculator.compute(atomicValue, (AtomicValue)object, xPathContext);
    }
}

