/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.compat;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.compat.ArithmeticExpression10;
import net.sf.saxon.expr.compat.GeneralComparison10;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class TypeChecker10
extends TypeChecker {
    @Override
    public Expression staticTypeCheck(Expression object, SequenceType object2, RoleDiagnostic roleDiagnostic, ExpressionVisitor expressionVisitor) {
        Object object3;
        if (((Expression)object).implementsStaticTypeCheck()) {
            return ((Expression)object).staticTypeCheck((SequenceType)object2, true, roleDiagnostic, expressionVisitor);
        }
        Configuration configuration = expressionVisitor.getConfiguration();
        TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
        if (!Cardinality.allowsMany(((SequenceType)object2).getCardinality()) && Cardinality.allowsMany(((Expression)object).getCardinality())) {
            object3 = FirstItemExpression.makeFirstItemExpression((Expression)object);
            ((Expression)object3).adoptChildExpression((Expression)object);
            object = object3;
        }
        object3 = ((SequenceType)object2).getPrimaryType();
        if (((SequenceType)object2).getPrimaryType().equals(BuiltInAtomicType.STRING) && !Cardinality.allowsMany(((SequenceType)object2).getCardinality()) && !typeHierarchy.isSubType(((Expression)object).getItemType(), BuiltInAtomicType.STRING)) {
            object2 = new RetainedStaticContext(configuration);
            object2 = SystemFunction.makeCall("string", (RetainedStaticContext)object2, new Expression[]{object});
            try {
                return ((Expression)object2).typeCheck(expressionVisitor, configuration.getDefaultContextItemStaticInfo());
            }
            catch (XPathException xPathException) {
                object2 = xPathException;
                xPathException.maybeSetLocation(((Expression)object).getLocation());
                ((XPathException)object2).setIsStaticError(true);
                throw object2;
            }
        }
        if (object3.equals(NumericType.getInstance()) || object3.equals(BuiltInAtomicType.DOUBLE) && !Cardinality.allowsMany(((SequenceType)object2).getCardinality()) && !typeHierarchy.isSubType(((Expression)object).getItemType(), BuiltInAtomicType.DOUBLE)) {
            object2 = new RetainedStaticContext(configuration);
            object2 = SystemFunction.makeCall("number", (RetainedStaticContext)object2, new Expression[]{object});
            try {
                return ((Expression)object2).typeCheck(expressionVisitor, configuration.getDefaultContextItemStaticInfo());
            }
            catch (XPathException xPathException) {
                object2 = xPathException;
                xPathException.maybeSetLocation(((Expression)object).getLocation());
                ((XPathException)object2).setIsStaticError(true);
                throw object2;
            }
        }
        return super.staticTypeCheck((Expression)object, (SequenceType)object2, roleDiagnostic, expressionVisitor);
    }

    @Override
    public Expression makeArithmeticExpression(Expression expression, int n2, Expression expression2) {
        return new ArithmeticExpression10(expression, n2, expression2);
    }

    @Override
    public Expression makeGeneralComparison(Expression expression, int n2, Expression expression2) {
        return new GeneralComparison10(expression, n2, expression2);
    }

    @Override
    public Expression processValueOf(Expression expression, Configuration configuration) {
        TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
        if (!expression.getItemType().isPlainType()) {
            expression = Atomizer.makeAtomizer(expression, null);
        }
        if (Cardinality.allowsMany(expression.getCardinality())) {
            expression = FirstItemExpression.makeFirstItemExpression(expression);
        }
        if (!typeHierarchy.isSubType(expression.getItemType(), BuiltInAtomicType.STRING)) {
            expression = new AtomicSequenceConverter(expression, BuiltInAtomicType.STRING);
            ((AtomicSequenceConverter)expression).allocateConverterStatically(configuration, false);
        }
        return expression;
    }
}

