/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.AndExpression;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.ForClause;
import net.sf.saxon.expr.flwor.LetClause;
import net.sf.saxon.expr.flwor.LocalVariableBinding;
import net.sf.saxon.expr.flwor.OperandProcessor;
import net.sf.saxon.expr.flwor.OuterForExpression;
import net.sf.saxon.expr.flwor.ReturnClauseIterator;
import net.sf.saxon.expr.flwor.ReturnClausePush;
import net.sf.saxon.expr.flwor.SingularityPull;
import net.sf.saxon.expr.flwor.TuplePull;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.expr.flwor.WhereClause;
import net.sf.saxon.expr.parser.CodeInjector;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;

public class FLWORExpression
extends Expression {
    public List<Clause> clauses;
    public Operand returnClauseOp;
    private static final OperandRole a = new OperandRole(0, OperandUsage.TRANSMISSION, SequenceType.ANY_SEQUENCE);
    private static final OperandRole b = new OperandRole(4, OperandUsage.TRANSMISSION, SequenceType.ANY_SEQUENCE);

    public void init(List<Clause> object, Expression expression) {
        this.clauses = object;
        boolean bl2 = false;
        object = object.iterator();
        while (object.hasNext()) {
            Clause clause = (Clause)object.next();
            if (!FLWORExpression.isLoopingClause(clause)) continue;
            bl2 = true;
            break;
        }
        this.returnClauseOp = new Operand(this, expression, bl2 ? b : a);
    }

    public List<Clause> getClauseList() {
        return this.clauses;
    }

    public static boolean isLoopingClause(Clause clause) {
        return clause.getClauseKey() == 0 || clause.getClauseKey() == 3 || clause.getClauseKey() == 2;
    }

    public Expression getReturnClause() {
        return this.returnClauseOp.getChildExpression();
    }

    @Override
    public boolean hasVariableBinding(Binding binding) {
        for (Clause clause : this.clauses) {
            if (!FLWORExpression.a(clause, binding)) continue;
            return true;
        }
        return false;
    }

    private static boolean a(Clause localVariableBindingArray, Binding binding) {
        for (LocalVariableBinding localVariableBinding : localVariableBindingArray.getRangeVariables()) {
            if (localVariableBinding != binding) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allowExtractingCommonSubexpressions() {
        return false;
    }

    @Override
    public Expression simplify() {
        OperandProcessor operandProcessor = operand -> {
            Operand operand2 = operand;
            operand2.setChildExpression(operand2.getChildExpression().simplify());
        };
        for (Clause clause : this.clauses) {
            clause.processOperands(operandProcessor);
        }
        this.returnClauseOp.setChildExpression(this.getReturnClause().simplify());
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        OperandProcessor operandProcessor = operand -> operand.typeCheck(expressionVisitor, contextItemStaticInfo);
        for (int i2 = 0; i2 < this.clauses.size(); ++i2) {
            this.clauses.get(i2).processOperands(operandProcessor);
            this.clauses.get(i2).typeCheck(expressionVisitor, contextItemStaticInfo);
            LocalVariableBinding[] localVariableBindingArray = this.clauses.get(i2).getRangeVariables();
            LocalVariableBinding[] localVariableBindingArray2 = localVariableBindingArray;
            localVariableBindingArray2 = localVariableBindingArray;
            int n2 = localVariableBindingArray.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                LocalVariableBinding localVariableBinding = localVariableBindingArray2[i3];
                ArrayList<VariableReference> arrayList = new ArrayList<VariableReference>();
                for (int i4 = i2; i4 < this.clauses.size(); ++i4) {
                    this.clauses.get(i4).gatherVariableReferences(expressionVisitor, localVariableBinding, arrayList);
                }
                ExpressionTool.gatherVariableReferences(this.getReturnClause(), localVariableBinding, arrayList);
                this.clauses.get(i2).refineVariableType(expressionVisitor, arrayList, this.getReturnClause());
            }
        }
        this.returnClauseOp.typeCheck(expressionVisitor, contextItemStaticInfo);
        return this;
    }

    @Override
    public boolean implementsStaticTypeCheck() {
        block3: for (Clause clause : this.clauses) {
            switch (clause.getClauseKey()) {
                case 1: 
                case 6: {
                    continue block3;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public Expression staticTypeCheck(SequenceType sequenceType, boolean bl2, RoleDiagnostic roleDiagnostic, ExpressionVisitor expressionVisitor) {
        TypeChecker typeChecker = expressionVisitor.getConfiguration().getTypeChecker(bl2);
        this.returnClauseOp.setChildExpression(typeChecker.staticTypeCheck(this.getReturnClause(), sequenceType, roleDiagnostic, expressionVisitor));
        return this;
    }

    @Override
    public ItemType getItemType() {
        return this.getReturnClause().getItemType();
    }

    @Override
    protected int computeCardinality() {
        return 57344;
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> arrayList = new ArrayList<Operand>(5);
        try {
            for (Clause clause : this.clauses) {
                clause.processOperands(arrayList::add);
            }
        }
        catch (XPathException xPathException) {
            throw new IllegalStateException(xPathException);
        }
        arrayList.add(this.returnClauseOp);
        return arrayList;
    }

    @Override
    public void checkForUpdatingSubexpressions() {
        OperandProcessor operandProcessor = operand -> {
            operand.getChildExpression().checkForUpdatingSubexpressions();
            if (operand.getChildExpression().isUpdatingExpression()) {
                throw new XPathException("An updating expression cannot be used in a clause of a FLWOR expression", "XUST0001");
            }
        };
        for (Clause clause : this.clauses) {
            clause.processOperands(operandProcessor);
        }
        this.getReturnClause().checkForUpdatingSubexpressions();
    }

    @Override
    public boolean isUpdatingExpression() {
        return this.getReturnClause().isUpdatingExpression();
    }

    @Override
    public int getImplementationMethod() {
        return 6;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        for (Clause clause : this.clauses) {
            clause.addToPathMap(pathMap, pathMapNodeSet);
        }
        return this.getReturnClause().addToPathMap(pathMap, pathMapNodeSet);
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("FLWOR", this);
        for (Clause clause : this.clauses) {
            clause.explain(expressionPresenter);
        }
        expressionPresenter.startSubsidiaryElement("return");
        this.getReturnClause().export(expressionPresenter);
        expressionPresenter.endSubsidiaryElement();
        expressionPresenter.endElement();
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        ArrayList<Clause> arrayList = new ArrayList<Clause>();
        FLWORExpression fLWORExpression = new FLWORExpression();
        for (Clause clause : this.clauses) {
            Clause clause2 = clause.copy(fLWORExpression, rebindingMap);
            clause2.setLocation(clause.getLocation());
            clause2.setRepeated(clause.isRepeated());
            LocalVariableBinding[] localVariableBindingArray = clause.getRangeVariables();
            LocalVariableBinding[] localVariableBindingArray2 = clause2.getRangeVariables();
            assert (localVariableBindingArray.length == localVariableBindingArray2.length);
            for (int i2 = 0; i2 < localVariableBindingArray.length; ++i2) {
                rebindingMap.put(localVariableBindingArray[i2], localVariableBindingArray2[i2]);
            }
            arrayList.add(clause2);
        }
        fLWORExpression.init(arrayList, this.getReturnClause().copy(rebindingMap));
        ExpressionTool.copyLocationInfo(this, fLWORExpression);
        return fLWORExpression;
    }

    @Override
    public Expression unordered(boolean bl2, boolean bl3) {
        for (Clause clause : this.clauses) {
            if (!(clause instanceof ForClause) || ((ForClause)clause).getPositionVariable() != null) continue;
            ((ForClause)clause).setSequence(((ForClause)clause).getSequence().unordered(bl2, bl3));
        }
        this.returnClauseOp.setChildExpression(this.getReturnClause().unordered(bl2, bl3));
        return this;
    }

    @Override
    public int getEvaluationMethod() {
        return 4;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        final class A {
            int a = 0;
            WhereClause b;
            private /* synthetic */ FLWORExpression c;

            A(FLWORExpression fLWORExpression) {
                this.c = fLWORExpression;
            }
        }
        FLWORExpression fLWORExpression;
        FLWORExpression fLWORExpression2;
        boolean bl2;
        Object object3 = this.clauses.iterator();
        while (object3.hasNext()) {
            Clause clause2 = object3.next();
            clause2.processOperands(operand -> operand.optimize(expressionVisitor, contextItemStaticInfo));
            clause2.optimize(expressionVisitor, contextItemStaticInfo);
        }
        this.returnClauseOp.setChildExpression(this.getReturnClause().optimize(expressionVisitor, contextItemStaticInfo));
        if (this.clauses.size() == 1 && ((object3 = this.clauses.get(0)) instanceof LetClause || object3 instanceof ForClause && ((ForClause)object3).getPositionVariable() == null)) {
            return this.a(expressionVisitor, contextItemStaticInfo);
        }
        boolean bl3 = false;
        do {
            bl2 = false;
            for (Clause object22 : this.clauses) {
                boolean bl4;
                if (object22.getClauseKey() != 1) continue;
                Clause clause = (LetClause)object22;
                if (!ExpressionTool.dependsOnVariable(this, new Binding[]{((LetClause)clause).getRangeVariable()})) {
                    this.clauses.remove(object22);
                    bl2 = true;
                    break;
                }
                boolean bl5 = false;
                for (Clause clause2 : this.clauses) {
                    if (!clause2.containsNonInlineableVariableReference(((LetClause)clause).getRangeVariable())) continue;
                    bl5 = true;
                    break;
                }
                if (bl5) continue;
                boolean bl6 = ((LetClause)clause).getRangeVariable().getNominalReferenceCount() == 1;
                boolean bl7 = bl4 = ((LetClause)clause).getSequence() instanceof VariableReference || ((LetClause)clause).getSequence() instanceof Literal;
                if (!bl6 && !bl4) continue;
                ExpressionTool.replaceVariableReferences(this, ((LetClause)clause).getRangeVariable(), ((LetClause)clause).getSequence(), true);
                this.clauses.remove(object22);
                if (this.clauses.isEmpty()) {
                    return this.getReturnClause();
                }
                bl2 = true;
                break;
            }
            bl3 |= bl2;
        } while (bl2);
        if (bl3) {
            for (int i2 = this.clauses.size() - 1; i2 > 0; --i2) {
                if (this.clauses.get(i2).getClauseKey() != 7 || this.clauses.get(i2 - 1).getClauseKey() != 7) continue;
                this.clauses.remove(i2);
            }
        }
        boolean bl8 = false;
        for (Clause clause : this.clauses) {
            if (!(clause instanceof WhereClause) || !ExpressionTool.dependsOnFocus(((WhereClause)clause).getPredicate())) continue;
            bl8 = true;
            break;
        }
        if (bl8 && contextItemStaticInfo != null) {
            Expression expression = ExpressionTool.tryToFactorOutDot(this, contextItemStaticInfo.getItemType());
            if (expression == null || expression == this) {
                return this;
            }
            this.resetLocalStaticProperties();
            return expression.optimize(expressionVisitor, contextItemStaticInfo);
        }
        ContextItemStaticInfo contextItemStaticInfo2 = contextItemStaticInfo;
        ExpressionVisitor expressionVisitor2 = expressionVisitor;
        FLWORExpression fLWORExpression3 = this;
        int n2 = 0;
        ArrayList arrayList = new ArrayList();
        for (Clause clause : fLWORExpression3.clauses) {
            if (clause instanceof WhereClause) {
                A a2 = new A(fLWORExpression3);
                new A(fLWORExpression3).b = (WhereClause)clause;
                a2.a = fLWORExpression3.clauses.size() - n2;
                arrayList.add(a2);
            }
            ++n2;
        }
        if (arrayList.size() == 0) {
            fLWORExpression2 = null;
        } else {
            while (!arrayList.isEmpty()) {
                WhereClause whereClause = ((A)arrayList.get((int)0)).b;
                n2 = ((A)arrayList.get((int)0)).a;
                Expression expression = whereClause.getPredicate();
                ArrayList<Expression> arrayList2 = new ArrayList<Expression>(5);
                BooleanExpression.listAndComponents(expression, arrayList2);
                for (int i2 = arrayList2.size() - 1; i2 >= 0; --i2) {
                    Expression expression2 = (Expression)arrayList2.get(i2);
                    for (int i3 = fLWORExpression3.clauses.size() - n2 - 1; i3 >= 0; --i3) {
                        Clause clause = fLWORExpression3.clauses.get(i3);
                        Object object = clause.getRangeVariables();
                        if (!ExpressionTool.dependsOnVariable(expression2, object) && clause.getClauseKey() != 4) continue;
                        object = (Expression)arrayList2.remove(i2);
                        if (arrayList2.isEmpty()) {
                            fLWORExpression3.clauses.remove(fLWORExpression3.clauses.size() - n2);
                        } else {
                            whereClause.setPredicate(fLWORExpression3.a(arrayList2));
                        }
                        if (clause instanceof ForClause && !((ForClause)clause).isAllowingEmpty()) {
                            boolean bl9 = ((ForClause)clause).addPredicate(fLWORExpression3, expressionVisitor2, contextItemStaticInfo2, expression2);
                            if (bl9) break;
                            fLWORExpression3.clauses.add(i3 + 1, new WhereClause(fLWORExpression3, (Expression)object));
                            break;
                        }
                        clause = new WhereClause(fLWORExpression3, expression2);
                        fLWORExpression3.clauses.add(i3 + 1, clause);
                        break;
                    }
                    if (arrayList2.size() - 1 != i2) continue;
                    arrayList2.remove(i2);
                    if (arrayList2.isEmpty()) {
                        fLWORExpression3.clauses.remove(fLWORExpression3.clauses.size() - n2);
                    } else {
                        whereClause.setPredicate(fLWORExpression3.a(arrayList2));
                    }
                    WhereClause whereClause2 = new WhereClause(fLWORExpression3, expression2);
                    fLWORExpression3.clauses.add(0, whereClause2);
                }
                arrayList.remove(0);
            }
            fLWORExpression2 = fLWORExpression = fLWORExpression3;
        }
        if (fLWORExpression2 != null && fLWORExpression != this) {
            return ((Expression)fLWORExpression).optimize(expressionVisitor, contextItemStaticInfo);
        }
        n2 = 1;
        for (Clause clause : this.clauses) {
            if (clause instanceof ForClause) {
                if (((ForClause)clause).getPositionVariable() == null) continue;
                n2 = 0;
                break;
            }
            if (clause instanceof LetClause) continue;
            n2 = 0;
            break;
        }
        if (n2 != 0) {
            return this.a(expressionVisitor, contextItemStaticInfo);
        }
        return this;
    }

    private Expression a(List<Expression> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        return new AndExpression(list.get(0), this.a(list.subList(1, list.size())));
    }

    private Expression a(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        Expression expression = this.getReturnClause();
        CodeInjector codeInjector = null;
        if (expressionVisitor.getStaticContext() instanceof QueryModule) {
            codeInjector = ((QueryModule)expressionVisitor.getStaticContext()).getCodeInjector();
        }
        for (int i2 = this.clauses.size() - 1; i2 >= 0; --i2) {
            Assignation assignation;
            Clause clause;
            if (this.clauses.get(i2) instanceof ForClause) {
                clause = (ForClause)this.clauses.get(i2);
                assignation = ((ForClause)clause).isAllowingEmpty() ? new OuterForExpression() : new ForExpression();
                assignation.setLocation(clause.getLocation());
                assignation.setRetainedStaticContext(this.getRetainedStaticContext());
                assignation.setAction(expression);
                assignation.setSequence(((ForClause)clause).getSequence());
                assignation.setVariableQName(((ForClause)clause).getRangeVariable().getVariableQName());
                assignation.setRequiredType(((ForClause)clause).getRangeVariable().getRequiredType());
                ExpressionTool.rebindVariableReferences(expression, ((ForClause)clause).getRangeVariable(), assignation);
                expression = assignation;
                if (codeInjector == null) continue;
                expression = codeInjector.inject(expression, expressionVisitor.getStaticContext(), 2012, assignation.getVariableQName());
                continue;
            }
            clause = (LetClause)this.clauses.get(i2);
            assignation = new LetExpression();
            assignation.setLocation(clause.getLocation());
            assignation.setRetainedStaticContext(this.getRetainedStaticContext());
            assignation.setAction(expression);
            assignation.setSequence(((LetClause)clause).getSequence());
            assignation.setVariableQName(((LetClause)clause).getRangeVariable().getVariableQName());
            assignation.setRequiredType(((LetClause)clause).getRangeVariable().getRequiredType());
            if (((LetClause)clause).getRangeVariable().isIndexedVariable()) {
                assignation.setIndexedVariable();
            }
            ExpressionTool.rebindVariableReferences(expression, ((LetClause)clause).getRangeVariable(), assignation);
            expression = assignation;
            if (codeInjector == null) continue;
            expression = codeInjector.inject(expression, expressionVisitor.getStaticContext(), 2013, assignation.getVariableQName());
        }
        expression = expression.typeCheck(expressionVisitor, contextItemStaticInfo);
        expression = expression.optimize(expressionVisitor, contextItemStaticInfo);
        return expression;
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        TuplePull tuplePull = new SingularityPull();
        for (Clause clause : this.clauses) {
            tuplePull = clause.getPullStream(tuplePull, xPathContext);
        }
        return new ReturnClauseIterator(tuplePull, this, xPathContext);
    }

    @Override
    public void process(XPathContext xPathContext) {
        TuplePush tuplePush = new ReturnClausePush(this.getReturnClause());
        for (int i2 = this.clauses.size() - 1; i2 >= 0; --i2) {
            Clause clause = this.clauses.get(i2);
            tuplePush = clause.getPushStream(tuplePush, xPathContext);
        }
        ((TuplePush)tuplePush).processTuple(xPathContext);
        ((TuplePush)tuplePush).close();
    }

    @Override
    public void evaluatePendingUpdates(XPathContext xPathContext, PendingUpdateList pendingUpdateList) {
        TuplePull tuplePull = new SingularityPull();
        for (Clause clause : this.clauses) {
            tuplePull = clause.getPullStream(tuplePull, xPathContext);
        }
        while (((TuplePull)tuplePull).nextTuple(xPathContext)) {
            this.getReturnClause().evaluatePendingUpdates(xPathContext, pendingUpdateList);
        }
    }

    @Override
    public String getExpressionName() {
        return "FLWOR";
    }

    @Override
    public String toShortString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        fastStringBuffer.append(this.clauses.get(0).toShortString());
        fastStringBuffer.append(" ... return ");
        fastStringBuffer.append(this.getReturnClause().toShortString());
        return fastStringBuffer.toString();
    }

    @Override
    public String toString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        for (Clause clause : this.clauses) {
            fastStringBuffer.append(clause.toString());
            fastStringBuffer.append(' ');
        }
        fastStringBuffer.append(" return ");
        fastStringBuffer.append(this.getReturnClause().toString());
        return fastStringBuffer.toString();
    }

    public boolean hasLoopingVariableReference(Binding object) {
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < this.clauses.size(); ++n2) {
            if (!FLWORExpression.a(this.clauses.get(n2), (Binding)object)) continue;
            n3 = n2;
            break;
        }
        if ((n2 = n3 < 0 ? 1 : 0) != 0) {
            n3 = 0;
        }
        n2 = this.clauses.size();
        if (!ExpressionTool.dependsOnVariable(this.getReturnClause(), new Binding[]{object})) {
            ArrayList arrayList = new ArrayList();
            object = arg_0 -> FLWORExpression.a(arrayList, (Binding)object, arg_0);
            for (int i2 = this.clauses.size() - 1; i2 >= 0; --i2) {
                try {
                    this.clauses.get(i2).processOperands((OperandProcessor)object);
                    if (arrayList.isEmpty()) continue;
                    n2 = i2;
                    break;
                }
                catch (XPathException xPathException) {
                    assert (false);
                    continue;
                }
            }
        }
        for (int i3 = n2 - 1; i3 >= n3; --i3) {
            if (!FLWORExpression.isLoopingClause(this.clauses.get(i3))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void a(List list, Binding binding, Operand operand) {
        if (list.isEmpty() && ExpressionTool.dependsOnVariable(operand.getChildExpression(), new Binding[]{binding})) {
            list.add(Boolean.TRUE);
        }
    }
}

