/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.CompareToIntegerConstant;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.FLWORExpression;
import net.sf.saxon.expr.flwor.ForClauseOuterPull;
import net.sf.saxon.expr.flwor.ForClauseOuterPush;
import net.sf.saxon.expr.flwor.ForClausePull;
import net.sf.saxon.expr.flwor.ForClausePush;
import net.sf.saxon.expr.flwor.LocalVariableBinding;
import net.sf.saxon.expr.flwor.OperandProcessor;
import net.sf.saxon.expr.flwor.TuplePull;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.KeyFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class ForClause
extends Clause {
    private LocalVariableBinding a;
    private LocalVariableBinding b;
    private Operand c;
    private boolean d;

    @Override
    public int getClauseKey() {
        return 0;
    }

    @Override
    public ForClause copy(FLWORExpression fLWORExpression, RebindingMap rebindingMap) {
        ForClause forClause = new ForClause();
        forClause.setLocation(this.getLocation());
        forClause.setPackageData(this.getPackageData());
        forClause.a = this.a.copy();
        if (this.b != null) {
            forClause.b = this.b.copy();
        }
        forClause.initSequence(fLWORExpression, this.getSequence().copy(rebindingMap));
        forClause.d = this.d;
        return forClause;
    }

    public void initSequence(FLWORExpression fLWORExpression, Expression expression) {
        this.c = new Operand(fLWORExpression, expression, this.isRepeated() ? OperandRole.REPEAT_NAVIGATE : OperandRole.NAVIGATE);
    }

    public void setSequence(Expression expression) {
        this.c.setChildExpression(expression);
    }

    public Expression getSequence() {
        return this.c.getChildExpression();
    }

    public void setRangeVariable(LocalVariableBinding localVariableBinding) {
        this.a = localVariableBinding;
    }

    public LocalVariableBinding getRangeVariable() {
        return this.a;
    }

    public void setPositionVariable(LocalVariableBinding localVariableBinding) {
        this.b = localVariableBinding;
    }

    public LocalVariableBinding getPositionVariable() {
        return this.b;
    }

    @Override
    public LocalVariableBinding[] getRangeVariables() {
        if (this.b == null) {
            return new LocalVariableBinding[]{this.a};
        }
        return new LocalVariableBinding[]{this.a, this.b};
    }

    public void setAllowingEmpty(boolean bl2) {
        this.d = bl2;
    }

    public boolean isAllowingEmpty() {
        return this.d;
    }

    @Override
    public void typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo object) {
        Object object2;
        Object object3;
        object = this.a.getRequiredType();
        if (this.d && !Cardinality.allowsZero(((SequenceType)object).getCardinality())) {
            object3 = new RoleDiagnostic(3, this.a.getVariableQName().getDisplayName(), 0);
            object2 = CardinalityChecker.makeCardinalityChecker(this.getSequence(), 49152, (RoleDiagnostic)object3);
            this.setSequence((Expression)object2);
        }
        object3 = SequenceType.makeSequenceType(((SequenceType)object).getPrimaryType(), 57344);
        object2 = new RoleDiagnostic(3, this.a.getVariableQName().getDisplayName(), 0);
        ForClause forClause = this;
        forClause.setSequence(TypeChecker.strictTypeCheck(forClause.getSequence(), (SequenceType)object3, (RoleDiagnostic)object2, expressionVisitor.getStaticContext()));
    }

    @Override
    public TuplePull getPullStream(TuplePull tuplePull, XPathContext xPathContext) {
        if (this.d) {
            return new ForClauseOuterPull(tuplePull, this);
        }
        return new ForClausePull(tuplePull, this);
    }

    @Override
    public TuplePush getPushStream(TuplePush tuplePush, XPathContext xPathContext) {
        if (this.d) {
            return new ForClauseOuterPush(tuplePush, this);
        }
        return new ForClausePush(tuplePush, this);
    }

    public boolean addPredicate(FLWORExpression fLWORExpression, ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo, Expression expression) {
        Binding[] bindingArray;
        Object object;
        Binding[] bindingArray2;
        Object object2;
        ItemType itemType;
        Configuration configuration = this.getConfiguration();
        Optimizer optimizer = expressionVisitor.obtainOptimizer();
        boolean bl2 = configuration.getBooleanProperty(Feature.TRACE_OPTIMIZER_DECISIONS);
        TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
        Expression expression2 = null;
        Expression expression3 = this.getSequence();
        ItemType itemType2 = itemType = contextItemStaticInfo == null ? null : contextItemStaticInfo.getItemType();
        if (this.getSequence() instanceof SlashExpression) {
            if (((SlashExpression)this.getSequence()).isAbsolute()) {
                expression2 = ((SlashExpression)this.getSequence()).getFirstStep();
                expression3 = ((SlashExpression)this.getSequence()).getRemainingSteps();
                itemType = expression2.getItemType();
            } else {
                SlashExpression slashExpression = ((SlashExpression)this.getSequence()).tryToMakeAbsolute();
                if (slashExpression != null) {
                    this.setSequence(slashExpression);
                    expression2 = slashExpression.getFirstStep();
                    expression3 = slashExpression.getRemainingSteps();
                    itemType = expression2.getItemType();
                }
            }
        }
        int n2 = 0;
        if (this.b != null && (expression instanceof ValueComparison || expression instanceof GeneralComparison || expression instanceof CompareToIntegerConstant) && ExpressionTool.dependsOnVariable(expression, new Binding[]{this.b})) {
            ComparisonExpression comparisonExpression = (ComparisonExpression)((Object)expression);
            object2 = new Expression[]{comparisonExpression.getLhsExpression(), comparisonExpression.getRhsExpression()};
            if (ExpressionTool.dependsOnVariable(fLWORExpression, new Binding[]{this.b})) {
                return false;
            }
            for (int i2 = 0; i2 < 2; ++i2) {
                bindingArray2 = new Binding[]{this.getRangeVariable()};
                if (this.b == null || !(object2[i2] instanceof VariableReference)) continue;
                object = new ArrayList();
                ExpressionTool.gatherVariableReferences(expression, this.b, (List<VariableReference>)object);
                if (object.size() != 1 || object.get(0) != object2[i2] || ExpressionTool.dependsOnFocus(object2[1 - i2]) || ExpressionTool.dependsOnVariable(object2[1 - i2], bindingArray2)) continue;
                Object object3 = new RetainedStaticContext(expressionVisitor.getStaticContext());
                object3 = SystemFunction.makeCall("position", (RetainedStaticContext)object3, new Expression[0]);
                object2 = expression.copy(new RebindingMap());
                Operand operand = i2 == 0 ? ((ComparisonExpression)object2).getLhs() : ((ComparisonExpression)object2).getRhs();
                operand.setChildExpression((Expression)object3);
                if (bl2) {
                    optimizer.trace("Replaced positional variable in predicate by position()", (Expression)object2);
                }
                expression3 = new FilterExpression(expression3, (Expression)object2);
                ExpressionTool.copyLocationInfo((Expression)object2, expression3);
                ContextItemStaticInfo contextItemStaticInfo2 = configuration.makeContextItemStaticInfo(itemType, true);
                expression3 = expression3.typeCheck(expressionVisitor, contextItemStaticInfo2);
                if (!ExpressionTool.dependsOnVariable(fLWORExpression, new Binding[]{this.b})) {
                    this.b = null;
                }
                n2 = 1;
                break;
            }
        }
        if (this.b == null && optimizer.isVariableReplaceableByDot(expression, bindingArray = new Binding[]{this.getRangeVariable()})) {
            object2 = new ContextItemExpression();
            boolean bl3 = ExpressionTool.inlineVariableReferences(expression, this.getRangeVariable(), (Expression)object2);
            if (bl3) {
                bindingArray2 = configuration.makeContextItemStaticInfo(this.getSequence().getItemType(), true);
                object = expression.typeCheck(expressionVisitor, (ContextItemStaticInfo)bindingArray2);
                n2 = typeHierarchy.relationship(((Expression)object).getItemType(), BuiltInAtomicType.INTEGER);
                if (n2 != 4) {
                    RetainedStaticContext retainedStaticContext = new RetainedStaticContext(expressionVisitor.getStaticContext());
                    object = SystemFunction.makeCall("boolean", retainedStaticContext, new Expression[]{object});
                    assert (object != null);
                }
                expression3 = new FilterExpression(expression3, (Expression)object);
                ExpressionTool.copyLocationInfo((Expression)object, expression3);
                bindingArray2 = configuration.makeContextItemStaticInfo(itemType, true);
                expression3 = expression3.typeCheck(expressionVisitor, (ContextItemStaticInfo)bindingArray2);
                n2 = 1;
            }
        }
        if (n2 != 0) {
            if (expression2 == null) {
                this.setSequence(expression3);
            } else if (expression2 instanceof RootExpression && expression3.isCallOn(KeyFn.class)) {
                this.setSequence(expression3);
            } else {
                Expression expression4 = ExpressionTool.makePathExpression(expression2, expression3);
                if (expression4 instanceof SlashExpression) {
                    ExpressionTool.copyLocationInfo(expression, expression4);
                    object2 = expressionVisitor.obtainOptimizer().convertPathExpressionToKey((SlashExpression)expression4, expressionVisitor);
                    if (object2 == null) {
                        this.setSequence(expression4);
                    } else {
                        this.setSequence((Expression)object2);
                    }
                    this.c.typeCheck(expressionVisitor, contextItemStaticInfo);
                    this.c.optimize(expressionVisitor, contextItemStaticInfo);
                }
            }
        }
        return n2 != 0;
    }

    @Override
    public void processOperands(OperandProcessor operandProcessor) {
        operandProcessor.processOperand(this.c);
    }

    @Override
    public void gatherVariableReferences(ExpressionVisitor expressionVisitor, Binding binding, List<VariableReference> list) {
        ExpressionTool.gatherVariableReferences(this.getSequence(), binding, list);
    }

    @Override
    public void refineVariableType(ExpressionVisitor object, List<VariableReference> object2, Expression expression) {
        object = this.getSequence().getItemType();
        if (object instanceof ErrorType) {
            object = AnyItemType.getInstance();
        }
        object2 = object2.iterator();
        while (object2.hasNext()) {
            expression = (VariableReference)object2.next();
            ((VariableReference)expression).refineVariableType((ItemType)object, this.d ? 24576 : 16384, null, this.getSequence().getSpecialProperties());
        }
    }

    @Override
    public void addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        pathMapNodeSet = this.getSequence().addToPathMap(pathMap, pathMapNodeSet);
        pathMap.registerPathForVariable(this.a, pathMapNodeSet);
    }

    @Override
    public void explain(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("for");
        expressionPresenter.emitAttribute("var", this.getRangeVariable().getVariableQName());
        expressionPresenter.emitAttribute("slot", "" + this.getRangeVariable().getLocalSlotNumber());
        LocalVariableBinding localVariableBinding = this.getPositionVariable();
        if (localVariableBinding != null) {
            expressionPresenter.emitAttribute("at", localVariableBinding.getVariableQName());
            expressionPresenter.emitAttribute("at-slot", "" + localVariableBinding.getLocalSlotNumber());
        }
        this.getSequence().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public String toShortString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        fastStringBuffer.append("for $");
        fastStringBuffer.append(this.a.getVariableQName().getDisplayName());
        fastStringBuffer.append(' ');
        LocalVariableBinding localVariableBinding = this.getPositionVariable();
        if (localVariableBinding != null) {
            fastStringBuffer.append("at $");
            fastStringBuffer.append(localVariableBinding.getVariableQName().getDisplayName());
            fastStringBuffer.append(' ');
        }
        fastStringBuffer.append("in ");
        fastStringBuffer.append(this.getSequence().toShortString());
        return fastStringBuffer.toString();
    }

    public String toString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        fastStringBuffer.append("for $");
        fastStringBuffer.append(this.a.getVariableQName().getDisplayName());
        fastStringBuffer.append(' ');
        LocalVariableBinding localVariableBinding = this.getPositionVariable();
        if (localVariableBinding != null) {
            fastStringBuffer.append("at $");
            fastStringBuffer.append(localVariableBinding.getVariableQName().getDisplayName());
            fastStringBuffer.append(' ');
        }
        fastStringBuffer.append("in ");
        fastStringBuffer.append(this.getSequence().toString());
        return fastStringBuffer.toString();
    }
}

