/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.ForClause;
import net.sf.saxon.expr.flwor.TuplePull;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.value.Int64Value;

public class ForClausePull
extends TuplePull {
    protected TuplePull base;
    protected ForClause forClause;
    protected FocusIterator currentIteration;

    public ForClausePull(TuplePull tuplePull, ForClause forClause) {
        this.base = tuplePull;
        this.forClause = forClause;
    }

    @Override
    public boolean nextTuple(XPathContext xPathContext) {
        while (true) {
            Object t2;
            if (this.currentIteration == null) {
                if (!this.base.nextTuple(xPathContext)) {
                    return false;
                }
                this.currentIteration = new FocusTrackingIterator(this.forClause.getSequence().iterate(xPathContext));
            }
            if ((t2 = this.currentIteration.next()) != null) {
                xPathContext.setLocalVariable(this.forClause.getRangeVariable().getLocalSlotNumber(), (Sequence<?>)t2);
                if (this.forClause.getPositionVariable() != null) {
                    xPathContext.setLocalVariable(this.forClause.getPositionVariable().getLocalSlotNumber(), new Int64Value(this.currentIteration.position()));
                }
                return true;
            }
            this.currentIteration = null;
        }
    }

    @Override
    public void close() {
        this.base.close();
        if (this.currentIteration != null) {
            this.currentIteration.close();
        }
    }
}

