/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.FLWORExpression;
import net.sf.saxon.expr.flwor.GroupByClausePull;
import net.sf.saxon.expr.flwor.GroupByClausePush;
import net.sf.saxon.expr.flwor.LocalVariableBinding;
import net.sf.saxon.expr.flwor.OperandProcessor;
import net.sf.saxon.expr.flwor.Tuple;
import net.sf.saxon.expr.flwor.TupleExpression;
import net.sf.saxon.expr.flwor.TuplePull;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceExtent;

public class GroupByClause
extends Clause {
    private Configuration b;
    private LocalVariableBinding[] c;
    GenericAtomicComparer[] a;
    private Operand d;
    private Operand e;

    public GroupByClause(Configuration configuration) {
        this.b = configuration;
    }

    @Override
    public int getClauseKey() {
        return 3;
    }

    @Override
    public boolean containsNonInlineableVariableReference(Binding binding) {
        return this.getRetainedTupleExpression().includesBinding(binding) || this.getGroupingTupleExpression().includesBinding(binding);
    }

    @Override
    public GroupByClause copy(FLWORExpression fLWORExpression, RebindingMap rebindingMap) {
        GroupByClause groupByClause = new GroupByClause(this.b);
        groupByClause.setLocation(this.getLocation());
        groupByClause.setPackageData(this.getPackageData());
        groupByClause.c = new LocalVariableBinding[this.c.length];
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            groupByClause.c[i2] = this.c[i2].copy();
        }
        groupByClause.a = this.a;
        groupByClause.initRetainedTupleExpression(fLWORExpression, (TupleExpression)((Expression)this.getRetainedTupleExpression()).copy(rebindingMap));
        groupByClause.initGroupingTupleExpression(fLWORExpression, (TupleExpression)((Expression)this.getGroupingTupleExpression()).copy(rebindingMap));
        return groupByClause;
    }

    public void initRetainedTupleExpression(FLWORExpression fLWORExpression, TupleExpression tupleExpression) {
        this.d = new Operand(fLWORExpression, tupleExpression, OperandRole.REPEAT_NAVIGATE_CONSTRAINED);
    }

    public void setRetainedTupleExpression(TupleExpression tupleExpression) {
        this.d.setChildExpression(tupleExpression);
    }

    public TupleExpression getRetainedTupleExpression() {
        return (TupleExpression)this.d.getChildExpression();
    }

    @Override
    public void optimize(ExpressionVisitor object, ContextItemStaticInfo object2) {
        int n2;
        object = new LinkedList<LocalVariableBinding>(Arrays.asList(this.c));
        object2 = new LinkedList();
        for (Operand operand : ((Expression)this.getRetainedTupleExpression()).operands()) {
            ((LinkedList)object2).add((LocalVariableReference)operand.getChildExpression());
        }
        for (int i2 = n2 = this.getGroupingTupleExpression().getSize(); i2 < ((LinkedList)object).size(); ++i2) {
            if (((LocalVariableBinding)((LinkedList)object).get(i2)).getNominalReferenceCount() != 0) continue;
            ((LinkedList)object).remove(i2);
            ((LinkedList)object2).remove(i2 - n2);
        }
        this.c = ((LinkedList)object).toArray(new LocalVariableBinding[0]);
        this.getRetainedTupleExpression().setVariables((List<LocalVariableReference>)object2);
    }

    public void initGroupingTupleExpression(FLWORExpression fLWORExpression, TupleExpression tupleExpression) {
        this.e = new Operand(fLWORExpression, tupleExpression, OperandRole.REPEAT_NAVIGATE_CONSTRAINED);
    }

    public void setGroupingTupleExpression(TupleExpression tupleExpression) {
        this.e.setChildExpression(tupleExpression);
    }

    public TupleExpression getGroupingTupleExpression() {
        return (TupleExpression)this.e.getChildExpression();
    }

    public void setVariableBindings(LocalVariableBinding[] localVariableBindingArray) {
        this.c = localVariableBindingArray;
    }

    @Override
    public LocalVariableBinding[] getRangeVariables() {
        return this.c;
    }

    public void setComparers(GenericAtomicComparer[] genericAtomicComparerArray) {
        this.a = genericAtomicComparerArray;
    }

    @Override
    public TuplePull getPullStream(TuplePull tuplePull, XPathContext xPathContext) {
        return new GroupByClausePull(tuplePull, this, xPathContext);
    }

    @Override
    public TuplePush getPushStream(TuplePush tuplePush, XPathContext xPathContext) {
        return new GroupByClausePush(tuplePush, this, xPathContext);
    }

    @Override
    public void processOperands(OperandProcessor operandProcessor) {
        operandProcessor.processOperand(this.e);
        operandProcessor.processOperand(this.d);
    }

    @Override
    public void explain(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("group-by");
        for (Operand operand : ((Expression)this.getRetainedTupleExpression()).operands()) {
            LocalVariableReference object = (LocalVariableReference)operand.getChildExpression();
            expressionPresenter.startSubsidiaryElement("by");
            expressionPresenter.emitAttribute("var", object.getDisplayName());
            expressionPresenter.emitAttribute("slot", "" + object.getBinding().getLocalSlotNumber());
            expressionPresenter.endSubsidiaryElement();
        }
        expressionPresenter.endElement();
    }

    public String toString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        fastStringBuffer.append("group by ... ");
        return fastStringBuffer.toString();
    }

    public void processGroup(List<ObjectToBeGrouped> list, XPathContext xPathContext) {
        Object object;
        int n2;
        LocalVariableBinding[] localVariableBindingArray = ((Clause)this).getRangeVariables();
        Sequence<?>[] sequenceArray = list.get((int)0).groupingValues.getMembers();
        for (n2 = 0; n2 < sequenceArray.length; ++n2) {
            object = sequenceArray[n2];
            xPathContext.setLocalVariable(localVariableBindingArray[n2].getLocalSlotNumber(), (Sequence<?>)object);
        }
        for (n2 = sequenceArray.length; n2 < localVariableBindingArray.length; ++n2) {
            object = new ArrayList();
            for (ObjectToBeGrouped objectToBeGrouped : list) {
                Object obj;
                Sequence<?> sequence = objectToBeGrouped.retainedValues.getMembers()[n2 - sequenceArray.length];
                SequenceIterator<?> sequenceIterator = sequence.iterate();
                while ((obj = sequenceIterator.next()) != null) {
                    object.add(obj);
                }
            }
            SequenceExtent sequenceExtent = new SequenceExtent(object);
            xPathContext.setLocalVariable(localVariableBindingArray[n2].getLocalSlotNumber(), sequenceExtent);
        }
    }

    public TupleComparisonKey getComparisonKey(Tuple tuple, GenericAtomicComparer[] genericAtomicComparerArray) {
        return new TupleComparisonKey(this, tuple.getMembers(), genericAtomicComparerArray);
    }

    @Override
    public void addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        throw new UnsupportedOperationException("Cannot use document projection with group-by");
    }

    public class TupleComparisonKey {
        private Sequence[] a;
        private GenericAtomicComparer[] b;
        private /* synthetic */ GroupByClause c;

        public TupleComparisonKey(GroupByClause groupByClause, Sequence[] sequenceArray, GenericAtomicComparer[] genericAtomicComparerArray) {
            this.c = groupByClause;
            this.a = sequenceArray;
            this.b = genericAtomicComparerArray;
        }

        public int hashCode() {
            int n2 = 0x77557755 ^ this.a.length;
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                GenericAtomicComparer genericAtomicComparer = this.b[i2];
                int n3 = genericAtomicComparer.getContext().getImplicitTimezone();
                try {
                    AtomicValue atomicValue;
                    SequenceIterator sequenceIterator = this.a[i2].iterate();
                    while ((atomicValue = (AtomicValue)sequenceIterator.next()) != null) {
                        n2 ^= i2 + atomicValue.getXPathComparable(false, genericAtomicComparer.getCollator(), n3).hashCode();
                    }
                    continue;
                }
                catch (XPathException xPathException) {}
            }
            return n2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof TupleComparisonKey)) {
                return false;
            }
            if (this.a.length != ((TupleComparisonKey)object).a.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                try {
                    if (DeepEqual.deepEqual(this.a[i2].iterate(), ((TupleComparisonKey)object).a[i2].iterate(), this.b[i2], this.b[i2].getContext(), 0)) continue;
                    return false;
                }
                catch (XPathException xPathException) {
                    return false;
                }
            }
            return true;
        }
    }

    public static class ObjectToBeGrouped {
        public Tuple groupingValues;
        public Tuple retainedValues;
    }
}

