/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.GroupByClause;
import net.sf.saxon.expr.flwor.Tuple;
import net.sf.saxon.expr.flwor.TupleExpression;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;

public class GroupByClausePush
extends TuplePush {
    private TuplePush a;
    private GroupByClause b;
    private HashMap<Object, List<GroupByClause.ObjectToBeGrouped>> c = new HashMap();
    private XPathContext d;
    private GenericAtomicComparer[] e;

    public GroupByClausePush(TuplePush tuplePush, GroupByClause groupByClause, XPathContext xPathContext) {
        this.a = tuplePush;
        this.b = groupByClause;
        this.d = xPathContext;
        this.e = new GenericAtomicComparer[groupByClause.a.length];
        for (int i2 = 0; i2 < this.e.length; ++i2) {
            this.e[i2] = groupByClause.a[i2].provideContext(xPathContext);
        }
    }

    @Override
    public void processTuple(XPathContext object) {
        Object object2 = this.b.getGroupingTupleExpression();
        TupleExpression tupleExpression = this.b.getRetainedTupleExpression();
        GroupByClause.ObjectToBeGrouped objectToBeGrouped = new GroupByClause.ObjectToBeGrouped();
        object2 = object2.evaluateItem((XPathContext)object).getMembers();
        GroupByClausePush.checkGroupingValues(object2);
        objectToBeGrouped.groupingValues = new Tuple((Sequence<?>[])object2);
        objectToBeGrouped.retainedValues = tupleExpression.evaluateItem((XPathContext)object);
        object = this.b.getComparisonKey(objectToBeGrouped.groupingValues, this.e);
        object2 = this.c.get(object);
        GroupByClausePush.addToGroup(object, objectToBeGrouped, (List<GroupByClause.ObjectToBeGrouped>)object2, this.c);
    }

    protected static void addToGroup(Object object, GroupByClause.ObjectToBeGrouped objectToBeGrouped, List<GroupByClause.ObjectToBeGrouped> list, HashMap<Object, List<GroupByClause.ObjectToBeGrouped>> hashMap) {
        if (list != null) {
            list.add(objectToBeGrouped);
            hashMap.put(object, list);
            return;
        }
        list = new ArrayList<GroupByClause.ObjectToBeGrouped>();
        list.add(objectToBeGrouped);
        hashMap.put(object, list);
    }

    protected static void checkGroupingValues(Sequence[] sequenceArray) {
        for (int i2 = 0; i2 < sequenceArray.length; ++i2) {
            GroundedValue<? extends AtomicValue> groundedValue = sequenceArray[i2];
            if (groundedValue instanceof EmptySequence || groundedValue instanceof AtomicValue) continue;
            if (SequenceTool.getLength(groundedValue = Atomizer.getAtomizingIterator(groundedValue.iterate(), false).materialize()) > 1) {
                throw new XPathException("Grouping key value cannot be a sequence of more than one item", "XPTY0004");
            }
            sequenceArray[i2] = groundedValue;
        }
    }

    @Override
    public void close() {
        for (List<GroupByClause.ObjectToBeGrouped> list : this.c.values()) {
            this.b.processGroup(list, this.d);
            this.a.processTuple(this.d);
        }
        this.a.close();
    }
}

