/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.List;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.FLWORExpression;
import net.sf.saxon.expr.flwor.LetClausePull;
import net.sf.saxon.expr.flwor.LetClausePush;
import net.sf.saxon.expr.flwor.LocalVariableBinding;
import net.sf.saxon.expr.flwor.OperandProcessor;
import net.sf.saxon.expr.flwor.TuplePull;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.Evaluator;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ItemType;

public class LetClause
extends Clause {
    private LocalVariableBinding a;
    private Operand b;
    private Evaluator c;

    @Override
    public int getClauseKey() {
        return 1;
    }

    public Evaluator getEvaluator() {
        if (this.c == null) {
            this.c = ExpressionTool.lazyEvaluator(this.getSequence(), true);
        }
        return this.c;
    }

    @Override
    public LetClause copy(FLWORExpression fLWORExpression, RebindingMap rebindingMap) {
        LetClause letClause = new LetClause();
        letClause.setLocation(this.getLocation());
        letClause.setPackageData(this.getPackageData());
        letClause.a = this.a.copy();
        letClause.initSequence(fLWORExpression, this.getSequence().copy(rebindingMap));
        return letClause;
    }

    public void initSequence(FLWORExpression fLWORExpression, Expression expression) {
        this.b = new Operand(fLWORExpression, expression, this.isRepeated() ? OperandRole.REPEAT_NAVIGATE : OperandRole.NAVIGATE);
    }

    public void setSequence(Expression expression) {
        this.b.setChildExpression(expression);
    }

    public Expression getSequence() {
        return this.b.getChildExpression();
    }

    public void setRangeVariable(LocalVariableBinding localVariableBinding) {
        this.a = localVariableBinding;
    }

    public LocalVariableBinding getRangeVariable() {
        return this.a;
    }

    @Override
    public LocalVariableBinding[] getRangeVariables() {
        return new LocalVariableBinding[]{this.a};
    }

    @Override
    public TuplePull getPullStream(TuplePull tuplePull, XPathContext xPathContext) {
        return new LetClausePull(tuplePull, this);
    }

    @Override
    public TuplePush getPushStream(TuplePush tuplePush, XPathContext xPathContext) {
        return new LetClausePush(tuplePush, this);
    }

    @Override
    public void processOperands(OperandProcessor operandProcessor) {
        operandProcessor.processOperand(this.b);
    }

    @Override
    public void typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo object) {
        object = new RoleDiagnostic(3, this.a.getVariableQName().getDisplayName(), 0);
        LetClause letClause = this;
        letClause.setSequence(TypeChecker.strictTypeCheck(letClause.getSequence(), this.a.getRequiredType(), (RoleDiagnostic)object, expressionVisitor.getStaticContext()));
        this.c = ExpressionTool.lazyEvaluator(this.getSequence(), true);
    }

    @Override
    public void gatherVariableReferences(ExpressionVisitor expressionVisitor, Binding binding, List<VariableReference> list) {
        ExpressionTool.gatherVariableReferences(this.getSequence(), binding, list);
    }

    @Override
    public void refineVariableType(ExpressionVisitor object, List<VariableReference> object2, Expression expression) {
        object = this.getSequence();
        ItemType itemType = ((Expression)object).getItemType();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            VariableReference variableReference = (VariableReference)object2.next();
            variableReference.refineVariableType(itemType, this.getSequence().getCardinality(), object instanceof Literal ? ((Literal)object).getValue() : null, ((Expression)object).getSpecialProperties());
            ExpressionTool.resetStaticProperties(expression);
        }
    }

    @Override
    public void addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        pathMapNodeSet = this.getSequence().addToPathMap(pathMap, pathMapNodeSet);
        pathMap.registerPathForVariable(this.a, pathMapNodeSet);
    }

    @Override
    public void explain(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("let");
        expressionPresenter.emitAttribute("var", this.getRangeVariable().getVariableQName());
        expressionPresenter.emitAttribute("slot", "" + this.getRangeVariable().getLocalSlotNumber());
        this.getSequence().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public String toShortString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        fastStringBuffer.append("let $");
        fastStringBuffer.append(this.a.getVariableQName().getDisplayName());
        fastStringBuffer.append(" := ");
        fastStringBuffer.append(this.getSequence().toShortString());
        return fastStringBuffer.toString();
    }

    public String toString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        fastStringBuffer.append("let $");
        fastStringBuffer.append(this.a.getVariableQName().getDisplayName());
        fastStringBuffer.append(" := ");
        fastStringBuffer.append(this.getSequence().toString());
        return fastStringBuffer.toString();
    }
}

