/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.Iterator;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.FLWORExpression;
import net.sf.saxon.expr.flwor.OperandProcessor;
import net.sf.saxon.expr.flwor.OrderByClausePull;
import net.sf.saxon.expr.flwor.OrderByClausePush;
import net.sf.saxon.expr.flwor.TupleExpression;
import net.sf.saxon.expr.flwor.TuplePull;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.expr.sort.SortKeyDefinitionList;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;

public class OrderByClause
extends Clause {
    public static final OperandRole SORT_KEYS_ROLE = new OperandRole(20, OperandUsage.NAVIGATION, SequenceType.ANY_SEQUENCE, expression -> expression instanceof SortKeyDefinitionList);
    private Operand a;
    private AtomicComparer[] b;
    private Operand c;

    public OrderByClause(FLWORExpression fLWORExpression, SortKeyDefinition[] sortKeyDefinitionArray, TupleExpression tupleExpression) {
        this.a = new Operand(fLWORExpression, new SortKeyDefinitionList(sortKeyDefinitionArray), SORT_KEYS_ROLE);
        this.c = new Operand(fLWORExpression, tupleExpression, OperandRole.REPEAT_NAVIGATE_CONSTRAINED);
    }

    @Override
    public int getClauseKey() {
        return 5;
    }

    @Override
    public boolean containsNonInlineableVariableReference(Binding binding) {
        return this.getTupleExpression().includesBinding(binding);
    }

    @Override
    public OrderByClause copy(FLWORExpression fLWORExpression, RebindingMap rebindingMap) {
        SortKeyDefinitionList sortKeyDefinitionList = this.getSortKeyDefinitions();
        SortKeyDefinition[] sortKeyDefinitionArray = new SortKeyDefinition[sortKeyDefinitionList.size()];
        for (int i2 = 0; i2 < sortKeyDefinitionList.size(); ++i2) {
            sortKeyDefinitionArray[i2] = sortKeyDefinitionList.getSortKeyDefinition(i2).copy(rebindingMap);
        }
        OrderByClause orderByClause = new OrderByClause(fLWORExpression, sortKeyDefinitionArray, (TupleExpression)((Expression)this.getTupleExpression()).copy(rebindingMap));
        orderByClause.setLocation(this.getLocation());
        orderByClause.setPackageData(this.getPackageData());
        orderByClause.b = this.b;
        return orderByClause;
    }

    public SortKeyDefinitionList getSortKeyDefinitions() {
        return (SortKeyDefinitionList)this.a.getChildExpression();
    }

    public AtomicComparer[] getAtomicComparers() {
        return this.b;
    }

    public TupleExpression getTupleExpression() {
        return (TupleExpression)this.c.getChildExpression();
    }

    @Override
    public TuplePull getPullStream(TuplePull tuplePull, XPathContext xPathContext) {
        return new OrderByClausePull(tuplePull, this.getTupleExpression(), this, xPathContext);
    }

    @Override
    public TuplePush getPushStream(TuplePush tuplePush, XPathContext xPathContext) {
        return new OrderByClausePush(tuplePush, this.getTupleExpression(), this, xPathContext);
    }

    @Override
    public void processOperands(OperandProcessor operandProcessor) {
        operandProcessor.processOperand(this.c);
        operandProcessor.processOperand(this.a);
    }

    @Override
    public void typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        Object object;
        boolean bl2 = true;
        Object object2 = this.getSortKeyDefinitions();
        Iterator<SortKeyDefinition> iterator = ((SortKeyDefinitionList)object2).iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (((SortKeyDefinition)object).isFixed()) continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            this.b = new AtomicComparer[((SortKeyDefinitionList)object2).size()];
        }
        int n2 = 0;
        object = expressionVisitor.getConfiguration().getTypeChecker(false);
        object2 = ((SortKeyDefinitionList)object2).iterator();
        while (object2.hasNext()) {
            SortKeyDefinition sortKeyDefinition = (SortKeyDefinition)object2.next();
            Object object3 = sortKeyDefinition.getSortKey();
            RoleDiagnostic roleDiagnostic = new RoleDiagnostic(6, "", n2);
            roleDiagnostic.setErrorCode("XPTY0004");
            object3 = ((TypeChecker)object).staticTypeCheck((Expression)object3, SequenceType.OPTIONAL_ATOMIC, roleDiagnostic, expressionVisitor);
            sortKeyDefinition.setSortKey((Expression)object3, false);
            sortKeyDefinition.typeCheck(expressionVisitor, contextItemStaticInfo);
            if (sortKeyDefinition.isFixed()) {
                object3 = sortKeyDefinition.makeComparator(expressionVisitor.getStaticContext().makeEarlyEvaluationContext());
                sortKeyDefinition.setFinalComparator((AtomicComparer)object3);
                if (bl2) {
                    this.b[n2] = object3;
                }
            }
            ++n2;
        }
    }

    @Override
    public void addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        Object object = this.getSortKeyDefinitions();
        object = ((SortKeyDefinitionList)object).iterator();
        while (object.hasNext()) {
            Expression expression = (SortKeyDefinition)object.next();
            expression = expression.getSortKey();
            expression.addToPathMap(pathMap, pathMapNodeSet);
        }
    }

    @Override
    public void explain(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("order-by");
        for (SortKeyDefinition sortKeyDefinition : this.getSortKeyDefinitions()) {
            expressionPresenter.startSubsidiaryElement("key");
            sortKeyDefinition.getSortKey().export(expressionPresenter);
            expressionPresenter.endSubsidiaryElement();
        }
        expressionPresenter.endElement();
    }

    public String toString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        fastStringBuffer.append("order by ... ");
        return fastStringBuffer.toString();
    }

    public AtomicValue evaluateSortKey(int n2, XPathContext xPathContext) {
        SortKeyDefinitionList sortKeyDefinitionList = this.getSortKeyDefinitions();
        return (AtomicValue)sortKeyDefinitionList.getSortKeyDefinition(n2).getSortKey().evaluateItem(xPathContext);
    }
}

