/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.ArrayList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.OrderByClause;
import net.sf.saxon.expr.flwor.Tuple;
import net.sf.saxon.expr.flwor.TupleExpression;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.GenericSorter;
import net.sf.saxon.expr.sort.ItemToBeSorted;
import net.sf.saxon.expr.sort.SortKeyDefinitionList;
import net.sf.saxon.expr.sort.Sortable;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;

public class OrderByClausePush
extends TuplePush
implements Sortable {
    private TuplePush a;
    private OrderByClause b;
    private TupleExpression c;
    protected AtomicComparer[] comparers;
    private XPathContext d;
    private int e = 0;
    private ArrayList<ItemToBeSorted> f = new ArrayList(100);

    public OrderByClausePush(TuplePush atomicComparerArray, TupleExpression tupleExpression, OrderByClause orderByClause, XPathContext xPathContext) {
        this.a = atomicComparerArray;
        this.c = tupleExpression;
        this.b = orderByClause;
        this.d = xPathContext;
        atomicComparerArray = orderByClause.getAtomicComparers();
        this.comparers = new AtomicComparer[atomicComparerArray.length];
        for (int i2 = 0; i2 < this.comparers.length; ++i2) {
            this.comparers[i2] = atomicComparerArray[i2].provideContext(xPathContext);
        }
    }

    @Override
    public void processTuple(XPathContext xPathContext) {
        Tuple tuple = this.c.evaluateItem(xPathContext);
        SortKeyDefinitionList sortKeyDefinitionList = this.b.getSortKeyDefinitions();
        ItemToBeSorted itemToBeSorted = new ItemToBeSorted(sortKeyDefinitionList.size());
        new ItemToBeSorted(sortKeyDefinitionList.size()).value = tuple;
        for (int i2 = 0; i2 < sortKeyDefinitionList.size(); ++i2) {
            itemToBeSorted.sortKeyValues[i2] = this.b.evaluateSortKey(i2, xPathContext);
        }
        itemToBeSorted.originalPosition = ++this.e;
        this.f.add(itemToBeSorted);
    }

    @Override
    public int compare(int n2, int n3) {
        try {
            for (int i2 = 0; i2 < this.comparers.length; ++i2) {
                int n4 = this.comparers[i2].compareAtomicValues(this.f.get((int)n2).sortKeyValues[i2], this.f.get((int)n3).sortKeyValues[i2]);
                if (n4 == 0) continue;
                return n4;
            }
        }
        catch (NoDynamicContextException noDynamicContextException) {
            throw new AssertionError((Object)("Sorting without dynamic context: " + noDynamicContextException.getMessage()));
        }
        return this.f.get((int)n2).originalPosition - this.f.get((int)n3).originalPosition;
    }

    @Override
    public void swap(int n2, int n3) {
        ItemToBeSorted itemToBeSorted = this.f.get(n2);
        ArrayList<ItemToBeSorted> arrayList = this.f;
        arrayList.set(n2, arrayList.get(n3));
        this.f.set(n3, itemToBeSorted);
    }

    @Override
    public void close() {
        try {
            GenericSorter.quickSort(0, this.e, this);
        }
        catch (ClassCastException classCastException) {
            XPathException xPathException = new XPathException("Non-comparable types found while sorting: " + classCastException.getMessage());
            xPathException.setErrorCode("XPTY0004");
            throw xPathException;
        }
        for (ItemToBeSorted itemToBeSorted : this.f) {
            this.c.setCurrentTuple(this.d, (Tuple)itemToBeSorted.value);
            this.a.processTuple(this.d);
        }
        this.a.close();
    }
}

