/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Tuple;
import net.sf.saxon.expr.oper.OperandArray;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.type.ItemType;

public class TupleExpression
extends Expression {
    private OperandArray a;

    protected void setOperanda(OperandArray operandArray) {
        this.a = operandArray;
    }

    protected OperandArray getOperanda() {
        return this.a;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.a.operands();
    }

    public void setVariables(List<LocalVariableReference> list) {
        Expression[] expressionArray = new Expression[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            expressionArray[i2] = list.get(i2);
        }
        this.setOperanda(new OperandArray((Expression)this, expressionArray, OperandRole.SAME_FOCUS_ACTION));
    }

    public int getSize() {
        return this.getOperanda().getNumberOfOperands();
    }

    public LocalVariableReference getSlot(int n2) {
        return (LocalVariableReference)this.getOperanda().getOperandExpression(n2);
    }

    public void setSlot(int n2, LocalVariableReference localVariableReference) {
        this.getOperanda().setOperand(n2, localVariableReference);
    }

    public boolean includesBinding(Binding binding) {
        for (Operand operand : ((Expression)this).operands()) {
            if (((LocalVariableReference)operand.getChildExpression()).getBinding() != binding) continue;
            return true;
        }
        return false;
    }

    @Override
    public ItemType getItemType() {
        return this.getConfiguration().getJavaExternalObjectType(Object.class);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            this.a.getOperand(i2).typeCheck(expressionVisitor, contextItemStaticInfo);
        }
        return this;
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof TupleExpression)) {
            return false;
        }
        object = (TupleExpression)object;
        if (this.getOperanda().getNumberOfOperands() != ((TupleExpression)object).getOperanda().getNumberOfOperands()) {
            return false;
        }
        for (int i2 = 0; i2 < this.getSize(); ++i2) {
            if (this.getSlot(i2).isEqual(((TupleExpression)object).getSlot(i2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int computeHashCode() {
        int n2 = 77;
        for (Operand operand : ((Expression)this).operands()) {
            n2 ^= operand.getChildExpression().hashCode();
        }
        return n2;
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        int n2 = this.getOperanda().getNumberOfOperands();
        ArrayList<LocalVariableReference> arrayList = new ArrayList<LocalVariableReference>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add((LocalVariableReference)((Expression)this.getSlot(i2)).copy(rebindingMap));
        }
        TupleExpression tupleExpression = new TupleExpression();
        ExpressionTool.copyLocationInfo(this, tupleExpression);
        tupleExpression.setVariables(arrayList);
        return tupleExpression;
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("tuple", this);
        for (Operand operand : ((Expression)this).operands()) {
            operand.getChildExpression().export(expressionPresenter);
        }
        expressionPresenter.endElement();
    }

    public Tuple evaluateItem(XPathContext xPathContext) {
        int n2 = this.getSize();
        Sequence[] sequenceArray = new Sequence[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            sequenceArray[i2] = ((VariableReference)this.getSlot(i2)).evaluateVariable(xPathContext);
        }
        return new Tuple(sequenceArray);
    }

    @Override
    public String getExpressionName() {
        return "tuple";
    }

    public void setCurrentTuple(XPathContext xPathContext, Tuple sequenceArray) {
        sequenceArray = sequenceArray.getMembers();
        int n2 = this.getSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            xPathContext.setLocalVariable(this.getSlot(i2).getBinding().getLocalSlotNumber(), sequenceArray[i2]);
        }
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 0;
    }
}

