/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.List;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.FLWORExpression;
import net.sf.saxon.expr.flwor.OperandProcessor;
import net.sf.saxon.expr.flwor.TuplePull;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.expr.flwor.WhereClausePull;
import net.sf.saxon.expr.flwor.WhereClausePush;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ItemType;

public class WhereClause
extends Clause {
    private Operand a;

    public WhereClause(FLWORExpression fLWORExpression, Expression expression) {
        this.a = new Operand(fLWORExpression, expression, OperandRole.INSPECT);
    }

    @Override
    public void setRepeated(boolean bl2) {
        super.setRepeated(bl2);
        if (bl2) {
            this.a.setOperandRole(OperandRole.REPEAT_INSPECT);
        }
    }

    @Override
    public int getClauseKey() {
        return 6;
    }

    public Expression getPredicate() {
        return this.a.getChildExpression();
    }

    public void setPredicate(Expression expression) {
        this.a.setChildExpression(expression);
    }

    @Override
    public WhereClause copy(FLWORExpression object, RebindingMap rebindingMap) {
        object = new WhereClause((FLWORExpression)object, this.getPredicate().copy(rebindingMap));
        ((Clause)object).setLocation(this.getLocation());
        ((Clause)object).setPackageData(this.getPackageData());
        return object;
    }

    @Override
    public void typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        super.typeCheck(expressionVisitor, contextItemStaticInfo);
    }

    @Override
    public TuplePull getPullStream(TuplePull tuplePull, XPathContext xPathContext) {
        return new WhereClausePull(tuplePull, this.getPredicate());
    }

    @Override
    public void gatherVariableReferences(ExpressionVisitor expressionVisitor, Binding binding, List<VariableReference> list) {
        ExpressionTool.gatherVariableReferences(this.getPredicate(), binding, list);
    }

    @Override
    public void refineVariableType(ExpressionVisitor object, List<VariableReference> object2, Expression expression) {
        object = this.getPredicate().getItemType();
        object2 = object2.iterator();
        while (object2.hasNext()) {
            VariableReference variableReference = (VariableReference)object2.next();
            variableReference.refineVariableType((ItemType)object, this.getPredicate().getCardinality(), this.getPredicate() instanceof Literal ? ((Literal)this.getPredicate()).getValue() : null, this.getPredicate().getSpecialProperties());
            ExpressionTool.resetStaticProperties(expression);
        }
    }

    @Override
    public TuplePush getPushStream(TuplePush tuplePush, XPathContext xPathContext) {
        return new WhereClausePush(tuplePush, this.getPredicate());
    }

    @Override
    public void processOperands(OperandProcessor operandProcessor) {
        operandProcessor.processOperand(this.a);
    }

    @Override
    public void addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        this.getPredicate().addToPathMap(pathMap, pathMapNodeSet);
    }

    @Override
    public void explain(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("where");
        this.getPredicate().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public String toShortString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        fastStringBuffer.append("where ");
        fastStringBuffer.append(this.getPredicate().toShortString());
        return fastStringBuffer.toString();
    }

    public String toString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        fastStringBuffer.append("where ");
        fastStringBuffer.append(this.getPredicate().toString());
        return fastStringBuffer.toString();
    }
}

