/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.ItemTypeCheckingFunction;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.FLWORExpression;
import net.sf.saxon.expr.flwor.LocalVariableBinding;
import net.sf.saxon.expr.flwor.OperandProcessor;
import net.sf.saxon.expr.flwor.TuplePull;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.expr.flwor.WindowClausePull;
import net.sf.saxon.expr.flwor.WindowClausePush;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.functions.Count;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.z.IntHashMap;

public class WindowClause
extends Clause {
    private boolean a;
    private boolean b = true;
    private Operand c;
    private Operand d;
    private Operand e;
    private IntHashMap<LocalVariableBinding> f = new IntHashMap(10);
    private ItemTypeCheckingFunction<Item<?>> g;
    private boolean h;
    public static final int WINDOW_VAR = 0;
    public static final int START_ITEM = 1;
    public static final int START_ITEM_POSITION = 2;
    public static final int START_PREVIOUS_ITEM = 3;
    public static final int START_NEXT_ITEM = 4;
    public static final int END_ITEM = 5;
    public static final int END_ITEM_POSITION = 6;
    public static final int END_PREVIOUS_ITEM = 7;
    public static final int END_NEXT_ITEM = 8;

    @Override
    public int getClauseKey() {
        return 2;
    }

    public void setIsSlidingWindow(boolean bl2) {
        this.a = bl2;
    }

    public boolean isSlidingWindow() {
        return this.a;
    }

    public boolean isTumblingWindow() {
        return !this.a;
    }

    public void setIncludeUnclosedWindows(boolean bl2) {
        this.b = bl2;
    }

    public boolean isIncludeUnclosedWindows() {
        return this.b;
    }

    public void initSequence(FLWORExpression fLWORExpression, Expression expression) {
        this.c = new Operand(fLWORExpression, expression, OperandRole.INSPECT);
    }

    public void setSequence(Expression expression) {
        this.c.setChildExpression(expression);
    }

    public Expression getSequence() {
        return this.c.getChildExpression();
    }

    public void initStartCondition(FLWORExpression fLWORExpression, Expression expression) {
        this.d = new Operand(fLWORExpression, expression, OperandRole.INSPECT);
    }

    public void setStartCondition(Expression expression) {
        this.d.setChildExpression(expression);
    }

    public Expression getStartCondition() {
        return this.d.getChildExpression();
    }

    public void initEndCondition(FLWORExpression fLWORExpression, Expression expression) {
        this.e = new Operand(fLWORExpression, expression, OperandRole.INSPECT);
    }

    public void setEndCondition(Expression expression) {
        this.e.setChildExpression(expression);
    }

    public Expression getEndCondition() {
        if (this.e == null) {
            return null;
        }
        return this.e.getChildExpression();
    }

    public void setVariableBinding(int n2, LocalVariableBinding localVariableBinding) {
        Iterator<LocalVariableBinding> iterator = this.f.valueIterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getVariableQName().equals(localVariableBinding.getVariableQName())) continue;
            throw new XPathException("Two variables in a window clause cannot have the same name (" + localVariableBinding.getVariableQName().getDisplayName() + ")", "XQST0103");
        }
        this.f.put(n2, localVariableBinding);
    }

    public LocalVariableBinding getVariableBinding(int n2) {
        return this.f.get(n2);
    }

    public ItemTypeCheckingFunction<Item<?>> getItemTypeChecker() {
        return this.g;
    }

    public boolean isWindowMustBeSingleton() {
        return this.h;
    }

    @Override
    public void typeCheck(ExpressionVisitor object, ContextItemStaticInfo object2) {
        object2 = this.getVariableBinding(0).getRequiredType();
        ItemType itemType = ((SequenceType)object2).getPrimaryType();
        Object object3 = this.getSequence().getItemType();
        object = ((ExpressionVisitor)object).getConfiguration();
        TypeHierarchy typeHierarchy = ((Configuration)object).getTypeHierarchy();
        int n2 = typeHierarchy.relationship(itemType, (ItemType)object3);
        switch (n2) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                object3 = new RoleDiagnostic(3, this.getVariableBinding(0).getVariableQName().getDisplayName(), 0);
                this.g = new ItemTypeCheckingFunction(itemType, (RoleDiagnostic)object3, this.getLocation(), (Configuration)object);
                break;
            }
            case 4: {
                object = "The items in the window will always be instances of " + object3 + ", never of the required type " + itemType;
                throw new XPathException((String)object, "XPTY0004", this.getLocation());
            }
        }
        boolean bl2 = this.h = !Cardinality.allowsMany(((SequenceType)object2).getCardinality());
        if (((SequenceType)object2).getCardinality() == 8192) {
            object3 = "The value of the window variable can never be an empty sequence";
            throw new XPathException((String)object3, "XPTY0004", this.getLocation());
        }
    }

    public void checkWindowContents(Window object) {
        if (this.h && ((Window)object).contents.size() > 1) {
            throw new XPathException("Required type of window allows only a single item; window has length " + ((Window)object).contents.size(), "XPTY0004", this.getLocation());
        }
        ItemTypeCheckingFunction<Item<?>> itemTypeCheckingFunction = this.getItemTypeChecker();
        if (itemTypeCheckingFunction != null) {
            object = new ItemMappingIterator(new ListIterator(((Window)object).contents), itemTypeCheckingFunction);
            Count.count(object);
        }
    }

    @Override
    public Clause copy(FLWORExpression fLWORExpression, RebindingMap rebindingMap) {
        WindowClause windowClause = new WindowClause();
        windowClause.setLocation(this.getLocation());
        windowClause.setPackageData(this.getPackageData());
        windowClause.a = this.a;
        windowClause.b = this.b;
        windowClause.initSequence(fLWORExpression, this.getSequence().copy(rebindingMap));
        windowClause.initStartCondition(fLWORExpression, this.getStartCondition().copy(rebindingMap));
        if (this.getEndCondition() != null) {
            windowClause.initEndCondition(fLWORExpression, this.getEndCondition().copy(rebindingMap));
        }
        windowClause.f = this.f;
        return windowClause;
    }

    @Override
    public TuplePull getPullStream(TuplePull tuplePull, XPathContext xPathContext) {
        return new WindowClausePull(tuplePull, this, xPathContext);
    }

    @Override
    public TuplePush getPushStream(TuplePush tuplePush, XPathContext xPathContext) {
        return new WindowClausePush(tuplePush, this);
    }

    @Override
    public void processOperands(OperandProcessor operandProcessor) {
        operandProcessor.processOperand(this.c);
        operandProcessor.processOperand(this.d);
        if (this.e != null) {
            operandProcessor.processOperand(this.e);
        }
    }

    @Override
    public void addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        throw new UnsupportedOperationException("Cannot use document projection with windowing");
    }

    @Override
    public LocalVariableBinding[] getRangeVariables() {
        LocalVariableBinding[] localVariableBindingArray = new LocalVariableBinding[this.f.size()];
        int n2 = 0;
        Iterator<LocalVariableBinding> iterator = this.f.valueIterator();
        while (iterator.hasNext()) {
            localVariableBindingArray[n2++] = iterator.next();
        }
        return localVariableBindingArray;
    }

    @Override
    public void explain(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement(this.isSlidingWindow() ? "slidingWindow" : "tumblingWindow");
        expressionPresenter.startSubsidiaryElement("select");
        this.getSequence().export(expressionPresenter);
        expressionPresenter.endSubsidiaryElement();
        expressionPresenter.startSubsidiaryElement("start");
        this.getStartCondition().export(expressionPresenter);
        expressionPresenter.endSubsidiaryElement();
        if (this.e != null) {
            expressionPresenter.startSubsidiaryElement("end");
            this.getEndCondition().export(expressionPresenter);
            expressionPresenter.endSubsidiaryElement();
        }
        expressionPresenter.endElement();
    }

    protected boolean matchesStart(Item item, Item item2, Item item3, int n2, XPathContext xPathContext) {
        WindowClause windowClause = this;
        LocalVariableBinding localVariableBinding = windowClause.getVariableBinding(1);
        if (localVariableBinding != null) {
            xPathContext.setLocalVariable(localVariableBinding.getLocalSlotNumber(), item2);
        }
        if ((localVariableBinding = windowClause.getVariableBinding(2)) != null) {
            xPathContext.setLocalVariable(localVariableBinding.getLocalSlotNumber(), new Int64Value(n2));
        }
        if ((localVariableBinding = windowClause.getVariableBinding(4)) != null) {
            xPathContext.setLocalVariable(localVariableBinding.getLocalSlotNumber(), WindowClause.makeValue(item3));
        }
        if ((localVariableBinding = windowClause.getVariableBinding(3)) != null) {
            xPathContext.setLocalVariable(localVariableBinding.getLocalSlotNumber(), WindowClause.makeValue(item));
        }
        return windowClause.getStartCondition().effectiveBooleanValue(xPathContext);
    }

    protected boolean matchesEnd(Window window, Item item, Item item2, Item item3, int n2, XPathContext xPathContext) {
        WindowClause windowClause = this;
        LocalVariableBinding localVariableBinding = windowClause.getVariableBinding(1);
        if (localVariableBinding != null) {
            xPathContext.setLocalVariable(localVariableBinding.getLocalSlotNumber(), window.startItem);
        }
        if ((localVariableBinding = windowClause.getVariableBinding(2)) != null) {
            xPathContext.setLocalVariable(localVariableBinding.getLocalSlotNumber(), new Int64Value(window.startPosition));
        }
        if ((localVariableBinding = windowClause.getVariableBinding(4)) != null) {
            xPathContext.setLocalVariable(localVariableBinding.getLocalSlotNumber(), WindowClause.makeValue(window.startNextItem));
        }
        if ((localVariableBinding = windowClause.getVariableBinding(3)) != null) {
            xPathContext.setLocalVariable(localVariableBinding.getLocalSlotNumber(), WindowClause.makeValue(window.startPreviousItem));
        }
        if ((localVariableBinding = windowClause.getVariableBinding(5)) != null) {
            xPathContext.setLocalVariable(localVariableBinding.getLocalSlotNumber(), item2);
        }
        if ((localVariableBinding = windowClause.getVariableBinding(6)) != null) {
            xPathContext.setLocalVariable(localVariableBinding.getLocalSlotNumber(), new Int64Value(n2));
        }
        if ((localVariableBinding = windowClause.getVariableBinding(8)) != null) {
            xPathContext.setLocalVariable(localVariableBinding.getLocalSlotNumber(), WindowClause.makeValue(item3));
        }
        if ((localVariableBinding = windowClause.getVariableBinding(7)) != null) {
            xPathContext.setLocalVariable(localVariableBinding.getLocalSlotNumber(), WindowClause.makeValue(item));
        }
        return windowClause.getEndCondition().effectiveBooleanValue(xPathContext);
    }

    protected static Sequence<?> makeValue(Item item) {
        if (item == null) {
            return EmptySequence.getInstance();
        }
        return item;
    }

    protected static class Window {
        public Item startItem;
        public int startPosition;
        public Item startPreviousItem;
        public Item startNextItem;
        public Item endItem;
        public int endPosition = 0;
        public Item endPreviousItem;
        public Item endNextItem;
        public List<Item<?>> contents;
        public boolean isDespatched = false;

        protected Window() {
        }

        public boolean isFinished() {
            return this.endPosition > 0;
        }

        public boolean isDespatched() {
            return this.isDespatched;
        }
    }
}

