/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.AnalyzeMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class AnalyzeString
extends Instruction
implements ContextOriginator {
    private Operand a;
    private Operand b;
    private Operand c;
    private Operand d;
    private Operand e;
    private static final OperandRole f = new OperandRole(6, OperandUsage.NAVIGATION);
    private static final OperandRole g = new OperandRole(1, OperandUsage.ABSORPTION, SequenceType.SINGLE_STRING);
    private RegularExpression h;

    public AnalyzeString(Expression expression, Expression expression2, Expression expression3, Expression expression4, Expression expression5, RegularExpression regularExpression) {
        this.a = new Operand(this, expression, g);
        this.b = new Operand(this, expression2, OperandRole.SINGLE_ATOMIC);
        this.c = new Operand(this, expression3, OperandRole.SINGLE_ATOMIC);
        if (expression4 != null) {
            this.d = new Operand(this, expression4, f);
        }
        if (expression5 != null) {
            this.e = new Operand(this, expression5, f);
        }
        this.h = regularExpression;
    }

    public Expression getSelect() {
        return this.a.getChildExpression();
    }

    public void setSelect(Expression expression) {
        this.a.setChildExpression(expression);
    }

    public Expression getRegex() {
        return this.b.getChildExpression();
    }

    public void setRegex(Expression expression) {
        this.b.setChildExpression(expression);
    }

    public Expression getFlags() {
        return this.c.getChildExpression();
    }

    public void setFlags(Expression expression) {
        this.c.setChildExpression(expression);
    }

    public Expression getMatching() {
        if (this.d == null) {
            return null;
        }
        return this.d.getChildExpression();
    }

    public void setMatching(Expression expression) {
        if (this.d != null) {
            this.d.setChildExpression(expression);
            return;
        }
        this.d = new Operand(this, expression, f);
    }

    public Expression getNonMatching() {
        if (this.e == null) {
            return null;
        }
        return this.e.getChildExpression();
    }

    public void setNonMatching(Expression expression) {
        if (this.e != null) {
            this.e.setChildExpression(expression);
            return;
        }
        this.e = new Operand(this, expression, f);
    }

    @Override
    public int getInstructionNameCode() {
        return 131;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandSparseList(this.a, this.b, this.c, this.d, this.e);
    }

    @Override
    public int getImplementationMethod() {
        return 6;
    }

    public RegularExpression getPatternExpression() {
        return this.h;
    }

    @Override
    public boolean allowExtractingCommonSubexpressions() {
        return false;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo object) {
        Object object2 = expressionVisitor.getConfiguration();
        this.a.typeCheck(expressionVisitor, (ContextItemStaticInfo)object);
        this.b.typeCheck(expressionVisitor, (ContextItemStaticInfo)object);
        this.c.typeCheck(expressionVisitor, (ContextItemStaticInfo)object);
        if (this.d != null) {
            this.d.typeCheck(expressionVisitor, ((Configuration)object2).makeContextItemStaticInfo(BuiltInAtomicType.STRING, false));
        }
        if (this.e != null) {
            this.e.typeCheck(expressionVisitor, ((Configuration)object2).makeContextItemStaticInfo(BuiltInAtomicType.STRING, false));
        }
        object = expressionVisitor.getConfiguration().getTypeChecker(false);
        object2 = new RoleDiagnostic(4, "analyze-string/select", 0);
        SequenceType sequenceType = SequenceType.OPTIONAL_STRING;
        this.setSelect(((TypeChecker)object).staticTypeCheck(this.getSelect(), sequenceType, (RoleDiagnostic)object2, expressionVisitor));
        object2 = new RoleDiagnostic(4, "analyze-string/regex", 0);
        this.setRegex(((TypeChecker)object).staticTypeCheck(this.getRegex(), SequenceType.SINGLE_STRING, (RoleDiagnostic)object2, expressionVisitor));
        object2 = new RoleDiagnostic(4, "analyze-string/flags", 0);
        this.setFlags(((TypeChecker)object).staticTypeCheck(this.getFlags(), SequenceType.SINGLE_STRING, (RoleDiagnostic)object2, expressionVisitor));
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo iterator) {
        Object object = expressionVisitor.getConfiguration();
        this.a.optimize(expressionVisitor, (ContextItemStaticInfo)((Object)iterator));
        this.b.optimize(expressionVisitor, (ContextItemStaticInfo)((Object)iterator));
        this.c.optimize(expressionVisitor, (ContextItemStaticInfo)((Object)iterator));
        if (this.d != null) {
            this.d.optimize(expressionVisitor, ((Configuration)object).makeContextItemStaticInfo(BuiltInAtomicType.STRING, false));
        }
        if (this.e != null) {
            this.e.optimize(expressionVisitor, ((Configuration)object).makeContextItemStaticInfo(BuiltInAtomicType.STRING, false));
        }
        iterator = new ArrayList();
        this.precomputeRegex((Configuration)object, (List<String>)((Object)iterator));
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            expressionVisitor.getStaticContext().issueWarning((String)object, this.getLocation());
        }
        return this;
    }

    public void precomputeRegex(Configuration configuration, List<String> list) {
        if (this.h == null && this.getRegex() instanceof StringLiteral && this.getFlags() instanceof StringLiteral) {
            try {
                String string = ((StringLiteral)this.getRegex()).getStringValue();
                String string2 = ((StringLiteral)this.getFlags()).getStringValue();
                String string3 = "XP30";
                this.h = configuration.compileRegularExpression(string, string2.toString(), string3, list);
                return;
            }
            catch (XPathException xPathException) {
                if ("XTDE1150".equals(xPathException.getErrorCodeLocalPart())) {
                    throw xPathException;
                }
                if ("FORX0001".equals(xPathException.getErrorCodeLocalPart())) {
                    this.a("Error in regular expression flags: " + xPathException, "FORX0001");
                    return;
                }
                this.a("Error in regular expression: " + xPathException, xPathException.getErrorCodeLocalPart());
            }
        }
    }

    private void a(String object, String string) {
        this.h = null;
        object = new XPathException((String)object, string);
        ((XPathException)object).setLocation(this.getLocation());
        throw object;
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new AnalyzeString(AnalyzeString.a(this.getSelect(), (RebindingMap)object), AnalyzeString.a(this.getRegex(), (RebindingMap)object), AnalyzeString.a(this.getFlags(), (RebindingMap)object), AnalyzeString.a(this.getMatching(), (RebindingMap)object), AnalyzeString.a(this.getNonMatching(), (RebindingMap)object), this.h);
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    private static Expression a(Expression expression, RebindingMap rebindingMap) {
        if (expression == null) {
            return null;
        }
        return expression.copy(rebindingMap);
    }

    @Override
    public void checkPermittedContents(SchemaType schemaType, boolean bl2) {
        if (this.getMatching() != null) {
            this.getMatching().checkPermittedContents(schemaType, false);
        }
        if (this.getNonMatching() != null) {
            this.getNonMatching().checkPermittedContents(schemaType, false);
        }
    }

    @Override
    public ItemType getItemType() {
        if (this.getMatching() != null) {
            if (this.getNonMatching() != null) {
                TypeHierarchy typeHierarchy = this.getConfiguration().getTypeHierarchy();
                return Type.getCommonSuperType(this.getMatching().getItemType(), this.getNonMatching().getItemType(), typeHierarchy);
            }
            return this.getMatching().getItemType();
        }
        if (this.getNonMatching() != null) {
            return this.getNonMatching().getItemType();
        }
        return ErrorType.getInstance();
    }

    @Override
    public int computeDependencies() {
        int n2 = 0 | this.getSelect().getDependencies();
        n2 |= this.getRegex().getDependencies();
        n2 |= this.getFlags().getDependencies();
        if (this.getMatching() != null) {
            n2 |= this.getMatching().getDependencies() & 0xFFFFFFA1;
        }
        if (this.getNonMatching() != null) {
            n2 |= this.getNonMatching().getDependencies() & 0xFFFFFFA1;
        }
        return n2;
    }

    @Override
    public TailCall processLeavingTail(XPathContext xPathContext) {
        RegexIterator regexIterator = this.a(xPathContext);
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setOrigin(this);
        FocusIterator<StringValue> focusIterator = xPathContextMajor.trackFocus(regexIterator);
        xPathContextMajor.setCurrentRegexIterator(regexIterator);
        PipelineConfiguration pipelineConfiguration = xPathContextMajor.getReceiver().getPipelineConfiguration();
        pipelineConfiguration.setXPathContext(xPathContextMajor);
        while (focusIterator.next() != null) {
            if (regexIterator.isMatching()) {
                if (this.getMatching() == null) continue;
                this.getMatching().process(xPathContextMajor);
                continue;
            }
            if (this.getNonMatching() == null) continue;
            this.getNonMatching().process(xPathContextMajor);
        }
        pipelineConfiguration.setXPathContext(xPathContext);
        return null;
    }

    private RegexIterator a(XPathContext xPathContext) {
        CharSequence charSequence = this.getSelect().evaluateAsString(xPathContext);
        Object object = this.h;
        if (object == null) {
            object = this.getFlags().evaluateAsString(xPathContext).toString();
            StringValue cfr_ignored_0 = (StringValue)this.getRegex().evaluateItem(xPathContext);
            object = xPathContext.getConfiguration().compileRegularExpression(this.getRegex().evaluateAsString(xPathContext), (String)object, "XP30", null);
        }
        return object.analyze(charSequence);
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        Object object = this.a(xPathContext);
        xPathContext = xPathContext.newContext();
        ((XPathContextMajor)xPathContext).setOrigin(this);
        ((XPathContextMinor)xPathContext).trackFocus(object);
        ((XPathContextMajor)xPathContext).setCurrentRegexIterator((RegexIterator)object);
        object = new AnalyzeMappingFunction((RegexIterator)object, xPathContext, this.getNonMatching(), this.getMatching());
        return new ContextMappingIterator(object, xPathContext);
    }

    @Override
    public String getExpressionName() {
        return "analyzeString";
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("analyzeString", this);
        expressionPresenter.setChildRole("select");
        this.getSelect().export(expressionPresenter);
        expressionPresenter.setChildRole("regex");
        this.getRegex().export(expressionPresenter);
        expressionPresenter.setChildRole("flags");
        this.getFlags().export(expressionPresenter);
        if (this.getMatching() != null) {
            expressionPresenter.setChildRole("matching");
            this.getMatching().export(expressionPresenter);
        }
        if (this.getNonMatching() != null) {
            expressionPresenter.setChildRole("nonMatching");
            this.getNonMatching().export(expressionPresenter);
        }
        expressionPresenter.endElement();
    }
}

