/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ComponentInvocation;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.ITemplateCall;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.RuleManager;
import net.sf.saxon.tree.iter.EmptyIterator;

public class ApplyTemplates
extends Instruction
implements ComponentInvocation,
ITemplateCall {
    private Operand a;
    private WithParam[] b;
    private WithParam[] c;
    protected boolean useCurrentMode = false;
    protected boolean useTailRecursion = false;
    protected Mode mode;
    protected boolean implicitSelect;
    protected boolean inStreamableConstruct = false;
    protected RuleManager ruleManager;
    private int d = -1;

    protected ApplyTemplates() {
    }

    public ApplyTemplates(Expression expression, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Mode mode, RuleManager ruleManager) {
        this.a = new Operand(this, expression, OperandRole.SINGLE_ATOMIC);
        this.init(expression, bl2, bl3, mode);
        this.implicitSelect = bl4;
        this.inStreamableConstruct = bl5;
        this.ruleManager = ruleManager;
    }

    protected void init(Expression expression, boolean bl2, boolean bl3, Mode mode) {
        this.setSelect(expression);
        this.useCurrentMode = bl2;
        this.useTailRecursion = bl3;
        this.mode = mode;
        this.adoptChildExpression(expression);
    }

    public void setMode(SimpleMode simpleMode) {
        this.mode = simpleMode;
    }

    @Override
    public WithParam[] getActualParams() {
        return this.b;
    }

    @Override
    public WithParam[] getTunnelParams() {
        return this.c;
    }

    public void setActualParams(WithParam[] withParamArray) {
        this.b = withParamArray;
    }

    public void setTunnelParams(WithParam[] withParamArray) {
        this.c = withParamArray;
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> arrayList = new ArrayList<Operand>();
        arrayList.add(this.a);
        ApplyTemplates applyTemplates = this;
        WithParam.gatherOperands(applyTemplates, applyTemplates.getActualParams(), arrayList);
        ApplyTemplates applyTemplates2 = this;
        WithParam.gatherOperands(applyTemplates2, applyTemplates2.getTunnelParams(), arrayList);
        return arrayList;
    }

    @Override
    public int getInstructionNameCode() {
        return 133;
    }

    @Override
    public int getImplementationMethod() {
        return super.getImplementationMethod() | 8;
    }

    @Override
    public Expression simplify() {
        WithParam.simplify(this.getActualParams());
        WithParam.simplify(this.getTunnelParams());
        ApplyTemplates applyTemplates = this;
        applyTemplates.setSelect(applyTemplates.getSelect().simplify());
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo object) {
        WithParam.typeCheck(this.b, expressionVisitor, (ContextItemStaticInfo)object);
        WithParam.typeCheck(this.c, expressionVisitor, (ContextItemStaticInfo)object);
        try {
            this.a.typeCheck(expressionVisitor, (ContextItemStaticInfo)object);
        }
        catch (XPathException xPathException) {
            if (this.implicitSelect) {
                object = xPathException.getErrorCodeLocalPart();
                if ("XPTY0020".equals(object) || "XPTY0019".equals(object)) {
                    XPathException xPathException2 = new XPathException("Cannot apply-templates to child nodes when the context item is an atomic value");
                    xPathException2.setErrorCode("XTTE0510");
                    xPathException2.setIsTypeError(true);
                    throw xPathException2;
                }
                if ("XPDY0002".equals(object)) {
                    XPathException xPathException3 = new XPathException("Cannot apply-templates to child nodes when the context item is absent");
                    xPathException3.setErrorCode("XTTE0510");
                    xPathException3.setIsTypeError(true);
                    throw xPathException3;
                }
            }
            throw xPathException;
        }
        ApplyTemplates applyTemplates = this;
        applyTemplates.adoptChildExpression(applyTemplates.getSelect());
        if (Literal.isEmptySequence(this.getSelect())) {
            return this.getSelect();
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        WithParam.optimize(expressionVisitor, this.b, contextItemStaticInfo);
        WithParam.optimize(expressionVisitor, this.c, contextItemStaticInfo);
        this.a.typeCheck(expressionVisitor, contextItemStaticInfo);
        this.a.optimize(expressionVisitor, contextItemStaticInfo);
        if (Literal.isEmptySequence(this.getSelect())) {
            return this.getSelect();
        }
        return this;
    }

    @Override
    public int getIntrinsicDependencies() {
        return super.getIntrinsicDependencies() | (this.useCurrentMode ? 1 : 0);
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        ApplyTemplates applyTemplates = new ApplyTemplates(this.getSelect().copy(rebindingMap), this.useCurrentMode, this.useTailRecursion, this.implicitSelect, this.inStreamableConstruct, this.mode, this.ruleManager);
        applyTemplates.setActualParams(WithParam.copy(applyTemplates, this.getActualParams(), rebindingMap));
        ApplyTemplates applyTemplates2 = applyTemplates;
        applyTemplates2.setTunnelParams(WithParam.copy(applyTemplates2, this.getTunnelParams(), rebindingMap));
        ExpressionTool.copyLocationInfo(this, applyTemplates);
        applyTemplates.ruleManager = this.ruleManager;
        return applyTemplates;
    }

    @Override
    public final boolean mayCreateNewNodes() {
        return true;
    }

    @Override
    public void process(XPathContext xPathContext) {
        this.apply(xPathContext, false);
    }

    @Override
    public TailCall processLeavingTail(XPathContext xPathContext) {
        return this.apply(xPathContext, this.useTailRecursion);
    }

    protected TailCall apply(XPathContext xPathContext, boolean bl2) {
        Object object = this.getTargetMode(xPathContext);
        Mode mode = ((Component.M)object).getActor();
        ParameterSet parameterSet = ApplyTemplates.assembleParams(xPathContext, this.getActualParams());
        ParameterSet parameterSet2 = ApplyTemplates.assembleTunnelParams(xPathContext, this.getTunnelParams());
        if (bl2) {
            XPathContextMajor xPathContextMajor = xPathContext.newContext();
            xPathContextMajor.setOrigin(this);
            return new ApplyTemplatesPackage(ExpressionTool.lazyEvaluate(this.getSelect(), xPathContext, false), (Component.M)object, parameterSet, parameterSet2, xPathContextMajor, this.getLocation());
        }
        SequenceIterator<?> sequenceIterator = this.getSelect().iterate(xPathContext);
        if (sequenceIterator instanceof EmptyIterator) {
            return null;
        }
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.trackFocus(sequenceIterator);
        xPathContextMajor.setCurrentMode((Component.M)object);
        xPathContextMajor.setOrigin(this);
        xPathContextMajor.setCurrentComponent((Component)object);
        if (this.inStreamableConstruct) {
            xPathContextMajor.setCurrentGroupIterator(null);
        }
        sequenceIterator = xPathContextMajor.getReceiver().getPipelineConfiguration();
        ((PipelineConfiguration)((Object)sequenceIterator)).setXPathContext(xPathContextMajor);
        try {
            for (object = mode.applyTemplates(parameterSet, parameterSet2, xPathContextMajor, this.getLocation()); object != null; object = object.processLeavingTail()) {
            }
        }
        catch (StackOverflowError stackOverflowError) {
            sequenceIterator = new XPathException.StackOverflow("Too many nested apply-templates calls. The stylesheet may be looping.", "SXLM0001", this.getLocation());
            ((XPathException)((Object)sequenceIterator)).setXPathContext(xPathContext);
            throw sequenceIterator;
        }
        ((PipelineConfiguration)((Object)sequenceIterator)).setXPathContext(xPathContext);
        return null;
    }

    public Component.M getTargetMode(XPathContext object) {
        if (this.useCurrentMode) {
            object = object.getCurrentMode();
        } else if (this.d >= 0) {
            if (((Component)(object = (Component.M)object.getTargetComponent(this.d))).getVisibility() == Visibility.ABSTRACT) {
                throw new AssertionError((Object)"Modes cannot be abstract");
            }
        } else {
            object = this.mode.getDeclaringComponent();
        }
        return object;
    }

    public Expression getSelectExpression() {
        return this.getSelect();
    }

    public boolean isImplicitSelect() {
        return this.implicitSelect;
    }

    public boolean useTailRecursion() {
        return this.useTailRecursion;
    }

    public boolean usesCurrentMode() {
        return this.useCurrentMode;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public Component getFixedTarget() {
        return this.mode.getDeclaringComponent();
    }

    @Override
    public SymbolicName getSymbolicName() {
        if (this.mode == null) {
            return null;
        }
        return ((Actor)this.mode).getSymbolicName();
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        pathMapNodeSet = super.addToPathMap(pathMap, pathMapNodeSet);
        pathMapNodeSet.setReturnable(false);
        return new PathMap.PathMapNodeSet(pathMap.makeNewRoot(this));
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("applyT", this);
        if (this.mode != null && !this.mode.isUnnamedMode()) {
            expressionPresenter.emitAttribute("mode", this.mode.getModeName());
        }
        String string = "";
        if (this.useCurrentMode) {
            string = "c";
        }
        if (this.useTailRecursion) {
            string = string + "t";
        }
        if (this.implicitSelect) {
            string = string + "i";
        }
        if (!string.isEmpty()) {
            expressionPresenter.emitAttribute("flags", string);
        }
        expressionPresenter.emitAttribute("bSlot", "" + this.getBindingSlot());
        expressionPresenter.setChildRole("select");
        this.getSelect().export(expressionPresenter);
        if (this.getActualParams().length != 0) {
            WithParam.exportParameters(this.getActualParams(), expressionPresenter, false);
        }
        if (this.getTunnelParams().length != 0) {
            WithParam.exportParameters(this.getTunnelParams(), expressionPresenter, true);
        }
        expressionPresenter.endElement();
    }

    public Expression getSelect() {
        return this.a.getChildExpression();
    }

    public void setSelect(Expression expression) {
        this.a.setChildExpression(expression);
    }

    @Override
    public void setBindingSlot(int n2) {
        this.d = n2;
    }

    @Override
    public int getBindingSlot() {
        return this.d;
    }

    @Override
    public String getStreamerName() {
        return "ApplyTemplates";
    }

    protected static class ApplyTemplatesPackage
    implements TailCall {
        private Sequence<?> a;
        private Component.M b;
        private ParameterSet c;
        private ParameterSet d;
        private XPathContextMajor e;
        private Location f;

        ApplyTemplatesPackage(Sequence<?> sequence, Component.M m2, ParameterSet parameterSet, ParameterSet parameterSet2, XPathContextMajor xPathContextMajor, Location location) {
            this.a = sequence;
            this.b = m2;
            this.c = parameterSet;
            this.d = parameterSet2;
            this.e = xPathContextMajor;
            this.f = location;
        }

        @Override
        public TailCall processLeavingTail() {
            this.e.trackFocus(this.a.iterate());
            this.e.setCurrentMode(this.b);
            this.e.setCurrentComponent(this.b);
            return this.b.getActor().applyTemplates(this.c, this.d, this.e, this.f);
        }
    }
}

