/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.DummyNamespaceResolver;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.instruct.ValidatingInstruction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.Whitespace;

public abstract class AttributeCreator
extends SimpleNodeConstructor
implements ValidatingInstruction {
    private SimpleType a = null;
    private int b;
    private int c;
    private boolean d;

    public void setInstruction(boolean bl2) {
        this.d = bl2;
    }

    @Override
    public boolean isInstruction() {
        return this.d;
    }

    public void setSchemaType(SimpleType simpleType) {
        this.a = simpleType;
    }

    @Override
    public SimpleType getSchemaType() {
        return this.a;
    }

    public void setValidationAction(int n2) {
        this.b = n2;
    }

    @Override
    public int getValidationAction() {
        return this.b;
    }

    public void setOptions(int n2) {
        this.c = n2;
    }

    public void setRejectDuplicates() {
        this.c |= 0x20;
    }

    public void setNoSpecialChars() {
        this.c |= 4;
    }

    public int getOptions() {
        return this.c;
    }

    @Override
    public int computeSpecialProperties() {
        int n2 = super.computeSpecialProperties();
        if (this.getValidationAction() == 4) {
            n2 |= 0x8000000;
        }
        return n2;
    }

    @Override
    public ItemType getItemType() {
        return NodeKindTest.ATTRIBUTE;
    }

    @Override
    public void processValue(CharSequence object, XPathContext xPathContext) {
        Object object2;
        SimpleType simpleType;
        NodeName nodeName = this.evaluateNodeName(xPathContext);
        Receiver receiver = xPathContext.getReceiver();
        int n2 = this.getOptions();
        SimpleType simpleType2 = this.getSchemaType();
        int n3 = this.getValidationAction();
        if (simpleType2 != null) {
            simpleType = simpleType2;
            object2 = simpleType2.validateContent((CharSequence)object, DummyNamespaceResolver.getInstance(), xPathContext.getConfiguration().getConversionRules());
            if (object2 != null) {
                object = new ValidationFailure("Attribute value " + Err.wrap((CharSequence)object, 4) + " does not match the required type " + simpleType2.getDescription() + ". " + ((ValidationFailure)object2).getMessage());
                ((ValidationFailure)object).setSchemaType(simpleType2);
                ((ValidationFailure)object).setErrorCode("XTTE1540");
                throw ((ValidationFailure)object).makeException();
            }
        } else if (n3 == 1 || n3 == 2) {
            try {
                object2 = xPathContext.getConfiguration();
                simpleType = ((Configuration)object2).validateAttribute(nodeName.getStructuredQName(), (CharSequence)object, n3);
            }
            catch (ValidationException validationException) {
                ValidationException validationException2 = validationException;
                object = XPathException.makeXPathException(validationException);
                ((XPathException)object).maybeSetErrorCode(n3 == 1 ? "XTTE1510" : "XTTE1515");
                ((XPathException)object).setXPathContext(xPathContext);
                ((XPathException)object).maybeSetLocation(this.getLocation());
                ((XPathException)object).setIsTypeError(true);
                throw object;
            }
        } else {
            simpleType = BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        if (nodeName.equals(StandardNames.XML_ID_NAME)) {
            object = Whitespace.collapseWhitespace((CharSequence)object);
        }
        try {
            receiver.attribute(nodeName, simpleType, (CharSequence)object, this.getLocation(), n2);
            return;
        }
        catch (XPathException xPathException) {
            throw AttributeCreator.dynamicError(this.getLocation(), xPathException, xPathContext);
        }
    }

    protected void validateOrphanAttribute(Orphan orphan, XPathContext xPathContext) {
        Object object = xPathContext.getConfiguration().getConversionRules();
        Object object2 = this.getSchemaType();
        int n2 = this.getValidationAction();
        if (object2 != null) {
            object = object2.validateContent(orphan.getStringValueCS(), DummyNamespaceResolver.getInstance(), (ConversionRules)object);
            if (object != null) {
                ((ValidationFailure)object).setMessage("Attribute value " + Err.wrap(orphan.getStringValueCS(), 4) + " does not the match the required type " + object2.getDescription() + ". " + ((ValidationFailure)object).getMessage());
                ((ValidationFailure)object).setErrorCode("XTTE1555");
                ((ValidationFailure)object).setLocator(this.getLocation());
                throw ((ValidationFailure)object).makeException();
            }
            orphan.setTypeAnnotation((SchemaType)object2);
            if (object2.isNamespaceSensitive()) {
                throw new XPathException("Cannot validate a parentless attribute whose content is namespace-sensitive", "XTTE1545");
            }
            return;
        }
        if (n2 == 1 || n2 == 2) {
            try {
                object = xPathContext.getController();
                assert (object != null);
                object2 = ((Controller)object).getConfiguration().validateAttribute(NameOfNode.makeName(orphan).getStructuredQName(), orphan.getStringValueCS(), n2);
                orphan.setTypeAnnotation((SchemaType)object2);
                return;
            }
            catch (ValidationException validationException) {
                object = validationException;
                object2 = XPathException.makeXPathException(validationException);
                ((XPathException)object2).setErrorCodeQName(((XPathException)object).getErrorCodeQName());
                ((XPathException)object2).setXPathContext(xPathContext);
                ((XPathException)object2).setLocation(this.getLocation());
                ((XPathException)object2).setIsTypeError(true);
                throw object2;
            }
        }
    }
}

