/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.BlockIterator;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.Message;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TailCallReturner;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;

public class Block
extends Instruction {
    private final Operand[] a;
    private boolean b;

    public Block(Expression[] expressionArray) {
        this.a = new Operand[expressionArray.length];
        for (int i2 = 0; i2 < expressionArray.length; ++i2) {
            this.a[i2] = new Operand(this, expressionArray[i2], OperandRole.SAME_FOCUS_ACTION);
        }
        Expression[] expressionArray2 = expressionArray;
        int n2 = expressionArray.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            Expression expression = expressionArray2[i3];
            this.adoptChildExpression(expression);
        }
    }

    @Override
    public boolean isInstruction() {
        return false;
    }

    private Expression a(int n2) {
        return this.a[n2].getChildExpression();
    }

    @Override
    public Iterable<Operand> operands() {
        return Arrays.asList(this.a);
    }

    @Override
    public boolean hasVariableBinding(Binding binding) {
        if (binding instanceof LocalParam) {
            Operand[] operandArray = this.a;
            int n2 = this.a.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Operand operand = operandArray[i2];
                if (operand.getChildExpression() != binding) continue;
                return true;
            }
        }
        return false;
    }

    public static Expression makeBlock(Expression expressionArray, Expression expression) {
        if (expressionArray == null || Literal.isEmptySequence((Expression)expressionArray)) {
            return expression;
        }
        if (expression == null || Literal.isEmptySequence(expression)) {
            return expressionArray;
        }
        if (expressionArray instanceof Block || expression instanceof Block) {
            ArrayList<Expression> arrayList = new ArrayList<Expression>(10);
            if (expressionArray instanceof Block) {
                for (Operand operand : expressionArray.operands()) {
                    arrayList.add(operand.getChildExpression());
                }
            } else {
                arrayList.add((Expression)expressionArray);
            }
            if (expression instanceof Block) {
                for (Operand operand : expression.operands()) {
                    arrayList.add(operand.getChildExpression());
                }
            } else {
                arrayList.add(expression);
            }
            expressionArray = new Expression[arrayList.size()];
            expressionArray = arrayList.toArray(expressionArray);
            return new Block(expressionArray);
        }
        Expression[] expressionArray2 = new Expression[]{expressionArray, expression};
        return new Block(expressionArray2);
    }

    public static Expression makeBlock(List<Expression> list) {
        if (list.isEmpty()) {
            return Literal.makeEmptySequence();
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        Expression[] expressionArray = new Expression[list.size()];
        expressionArray = list.toArray(expressionArray);
        return new Block(expressionArray);
    }

    @Override
    public String getExpressionName() {
        return "sequence";
    }

    public Operand[] getOperanda() {
        return this.a;
    }

    @Override
    public int computeSpecialProperties() {
        Block block = this;
        if (block.a.length == 0) {
            return 0xDFF0000;
        }
        int n2 = super.computeSpecialProperties();
        if (this.b) {
            n2 |= 0x8000000;
        }
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        for (Operand object : ((Expression)this).operands()) {
            Expression expression = object.getChildExpression();
            if (!(expression instanceof AxisExpression)) {
                bl2 = false;
                bl3 = false;
                bl4 = false;
                break;
            }
            byte by = ((AxisExpression)expression).getAxis();
            if (by != 3) {
                bl3 = false;
            }
            if (AxisInfo.isSubtreeAxis[by]) continue;
            bl4 = false;
        }
        if (bl2) {
            n2 |= 0x1810000;
            if (bl3) {
                n2 |= 0x80000;
            }
            if (bl4) {
                n2 |= 0x100000;
            }
            Block block2 = this;
            if (block2.a.length == 2 && ((AxisExpression)this.a(0)).getAxis() == 2 && ((AxisExpression)this.a(1)).getAxis() == 3) {
                n2 |= 0x20000;
            }
        }
        return n2;
    }

    @Override
    public boolean implementsStaticTypeCheck() {
        return true;
    }

    @Override
    public Expression staticTypeCheck(SequenceType object, boolean bl2, RoleDiagnostic roleDiagnostic, ExpressionVisitor expressionVisitor) {
        TypeChecker typeChecker = expressionVisitor.getConfiguration().getTypeChecker(bl2);
        if (bl2 && !Cardinality.allowsMany(((SequenceType)object).getCardinality())) {
            Expression expression = FirstItemExpression.makeFirstItemExpression(this);
            return typeChecker.staticTypeCheck(expression, (SequenceType)object, roleDiagnostic, expressionVisitor);
        }
        Expression[] expressionArray = new Expression[this.a.length];
        SequenceType sequenceType = object;
        if (((SequenceType)object).getCardinality() != 57344) {
            sequenceType = SequenceType.makeSequenceType(((SequenceType)object).getPrimaryType(), 57344);
        }
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            expressionArray[i2] = typeChecker.staticTypeCheck(this.a[i2].getChildExpression(), sequenceType, roleDiagnostic, expressionVisitor);
        }
        Block block = new Block(expressionArray);
        ExpressionTool.copyLocationInfo(this, block);
        block.b = this.b;
        int n2 = ((SequenceType)object).getCardinality();
        int n3 = block.getCardinality();
        if (!Cardinality.subsumes(((SequenceType)object).getCardinality(), n3)) {
            if ((n2 & n3) == 0) {
                object = new XPathException("The required cardinality of the " + roleDiagnostic.getMessage() + " is " + Cardinality.toString(n2) + ", but the supplied cardinality is " + Cardinality.toString(n3), roleDiagnostic.getErrorCode(), this.getLocation());
                ((XPathException)object).setIsTypeError(true);
                ((XPathException)object).setFailingExpression(this);
                throw object;
            }
            return CardinalityChecker.makeCardinalityChecker(block, n2, roleDiagnostic);
        }
        return block;
    }

    public static boolean neverReturnsTypedNodes(Instruction object, TypeHierarchy typeHierarchy) {
        for (Operand operand : ((Expression)((Object)object)).operands()) {
            ItemType itemType;
            Expression expression = operand.getChildExpression();
            if (expression.hasSpecialProperty(0x8000000) || typeHierarchy.relationship(itemType = expression.getItemType(), NodeKindTest.ELEMENT) == 4 && typeHierarchy.relationship(itemType, NodeKindTest.ATTRIBUTE) == 4) continue;
            return false;
        }
        return true;
    }

    public Expression mergeAdjacentTextInstructions() {
        Block block = this;
        boolean[] blArray = new boolean[block.a.length];
        boolean bl2 = false;
        int n2 = 0;
        while (true) {
            block = this;
            if (n2 >= block.a.length) break;
            boolean bl3 = blArray[n2] = this.a(n2) instanceof ValueOf && ((ValueOf)this.a(n2)).getSelect() instanceof StringLiteral && !((ValueOf)this.a(n2)).isDisableOutputEscaping();
            if (n2 > 0 && blArray[n2] && blArray[n2 - 1]) {
                bl2 = true;
            }
            ++n2;
        }
        if (bl2) {
            block = this;
            ArrayList<Expression> arrayList = new ArrayList<Expression>(block.a.length);
            Object object = null;
            int n3 = 0;
            while (true) {
                block = this;
                if (n3 >= block.a.length) break;
                if (blArray[n3]) {
                    object = (String)(object == null ? "" : object) + ((StringLiteral)((ValueOf)this.a(n3)).getSelect()).getStringValue();
                } else {
                    if (object != null) {
                        object = new ValueOf(new StringLiteral((CharSequence)object), false, false);
                        arrayList.add((Expression)object);
                        object = null;
                    }
                    arrayList.add(this.a(n3));
                }
                ++n3;
            }
            if (object != null) {
                ValueOf valueOf = new ValueOf(new StringLiteral((CharSequence)object), false, false);
                arrayList.add(valueOf);
            }
            return Block.makeBlock(arrayList);
        }
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        Block block = this;
        Expression[] expressionArray = new Expression[block.a.length];
        int n2 = 0;
        while (true) {
            block = this;
            if (n2 >= block.a.length) break;
            expressionArray[n2] = this.a(n2).copy(rebindingMap);
            ++n2;
        }
        Block block2 = new Block(expressionArray);
        int n3 = 0;
        while (true) {
            block = this;
            if (n3 >= block.a.length) break;
            block2.adoptChildExpression(expressionArray[n3]);
            ++n3;
        }
        block2.b = this.b;
        ExpressionTool.copyLocationInfo(this, block2);
        return block2;
    }

    @Override
    public final ItemType getItemType() {
        Object object = this;
        if (((Block)object).a.length == 0) {
            return ErrorType.getInstance();
        }
        Object object2 = null;
        TypeHierarchy typeHierarchy = this.getConfiguration().getTypeHierarchy();
        int n2 = 0;
        while (true) {
            object = this;
            if (n2 >= ((Block)object).a.length) break;
            object = this.a(n2);
            if (!(object instanceof Message)) {
                object = ((Expression)object).getItemType();
                if ((object2 = object2 == null ? object : Type.getCommonSuperType((ItemType)object2, (ItemType)object, typeHierarchy)) instanceof AnyItemType) {
                    return object2;
                }
            }
            ++n2;
        }
        if (object2 == null) {
            return ErrorType.getInstance();
        }
        return object2;
    }

    @Override
    public UType getStaticUType(UType uType) {
        if (((Expression)this).isInstruction()) {
            return super.getStaticUType(uType);
        }
        Block block = this;
        if (block.a.length == 0) {
            return UType.VOID;
        }
        UType uType2 = this.a(0).getStaticUType(uType);
        int n2 = 1;
        while (true) {
            block = this;
            if (n2 >= block.a.length) break;
            if ((uType2 = uType2.union(this.a(n2).getStaticUType(uType))) == UType.ANY) {
                return uType2;
            }
            ++n2;
        }
        return uType2;
    }

    @Override
    public int computeCardinality() {
        Block block = this;
        if (block.a.length == 0) {
            return 8192;
        }
        int n2 = this.a(0).getCardinality();
        int n3 = 1;
        while (true) {
            block = this;
            if (n3 >= block.a.length || (n2 = Cardinality.sum(n2, this.a(n3).getCardinality())) == 32768) break;
            ++n3;
        }
        return n2;
    }

    @Override
    public final boolean mayCreateNewNodes() {
        return this.someOperandCreatesNewNodes();
    }

    @Override
    public void checkForUpdatingSubexpressions() {
        Block block = this;
        if (block.a.length < 2) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        for (Operand operand : ((Expression)this).operands()) {
            Expression object = operand.getChildExpression();
            if (ExpressionTool.isNotAllowedInUpdatingContext(object)) {
                if (bl2) {
                    XPathException xPathException = new XPathException("If any subexpression is updating, then all must be updating", "XUST0001");
                    xPathException.setLocation(object.getLocation());
                    throw xPathException;
                }
                bl3 = true;
            }
            if (!object.isUpdatingExpression()) continue;
            if (bl3) {
                XPathException xPathException = new XPathException("If any subexpression is updating, then all must be updating", "XUST0001");
                xPathException.setLocation(object.getLocation());
                throw xPathException;
            }
            bl2 = true;
        }
    }

    @Override
    public boolean isVacuousExpression() {
        for (Operand operand : ((Expression)this).operands()) {
            Expression object = operand.getChildExpression();
            if (object.isVacuousExpression()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Expression simplify() {
        Block block;
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            block = this;
            if (n4 >= block.a.length) break;
            Expression expression = this.a(n4).simplify();
            int n5 = n4;
            block = this;
            block.a[n5].setChildExpression(expression);
            if (!Literal.isAtomic(this.a(n4))) {
                n2 = 0;
            }
            if (this.a(n4) instanceof Block) {
                n3 = 1;
            } else if (Literal.isEmptySequence(this.a(n4))) {
                n3 = 1;
            }
            ++n4;
        }
        block = this;
        if (block.a.length == 1) {
            Expression expression = this.getOperanda()[0].getChildExpression();
            expression.setParentExpression(this.getParentExpression());
            return expression;
        }
        block = this;
        if (block.a.length == 0) {
            Literal literal = Literal.makeEmptySequence();
            ExpressionTool.copyLocationInfo(this, literal);
            literal.setParentExpression(this.getParentExpression());
            return literal;
        }
        if (n3 != 0) {
            block = this;
            ArrayList<Expression> arrayList = new ArrayList<Expression>(block.a.length << 1);
            this.a(arrayList);
            Expression[] expressionArray = new Expression[arrayList.size()];
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                expressionArray[n3] = (Expression)arrayList.get(n3);
            }
            Block block2 = new Block(expressionArray);
            ExpressionTool.copyLocationInfo(this, block2);
            return ((Expression)block2).simplify();
        }
        if (n2 != 0) {
            block = this;
            Item[] itemArray = new AtomicValue[block.a.length];
            n2 = 0;
            while (true) {
                block = this;
                if (n2 >= block.a.length) break;
                itemArray[n2] = (AtomicValue)((Literal)this.a(n2)).getValue();
                ++n2;
            }
            Literal literal = Literal.makeLiteral(new SequenceExtent(itemArray), this);
            literal.setParentExpression(this.getParentExpression());
            return literal;
        }
        return this;
    }

    private void a(List<Expression> list) {
        ArrayList arrayList = null;
        for (Operand operand : ((Expression)this).operands()) {
            Expression expression = operand.getChildExpression();
            if (Literal.isEmptySequence(expression)) continue;
            if (expression instanceof Block) {
                this.a(arrayList, list);
                arrayList = null;
                ((Block)expression).a(list);
                continue;
            }
            if (expression instanceof Literal && !(((Literal)expression).getValue() instanceof IntegerRange)) {
                Object t2;
                SequenceIterator sequenceIterator = ((Literal)expression).getValue().iterate();
                if (arrayList == null) {
                    arrayList = new ArrayList(10);
                }
                while ((t2 = sequenceIterator.next()) != null) {
                    arrayList.add(t2);
                }
                continue;
            }
            this.a(arrayList, list);
            arrayList = null;
            list.add(expression);
        }
        this.a(arrayList, list);
    }

    private void a(List<Item<?>> object, List<Expression> list) {
        if (object != null) {
            object = new ListIterator((List<Item<?>>)object);
            object = Literal.makeLiteral(((ListIterator)object).materialize(), this);
            list.add((Expression)object);
        }
    }

    public boolean isCandidateForSharedAppend() {
        for (Operand operand : ((Expression)this).operands()) {
            Expression object = operand.getChildExpression();
            if (!(object instanceof VariableReference) && !(object instanceof Literal)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.typeCheckChildren(expressionVisitor, contextItemStaticInfo);
        if (Block.neverReturnsTypedNodes(this, expressionVisitor.getConfiguration().getTypeHierarchy())) {
            this.resetLocalStaticProperties();
            this.b = true;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.optimizeChildren(expressionVisitor, contextItemStaticInfo);
        boolean bl2 = false;
        boolean bl3 = false;
        for (Operand operand : ((Expression)this).operands()) {
            Expression object = operand.getChildExpression();
            if (object instanceof Block) {
                bl2 = true;
                break;
            }
            if (object instanceof Literal && !(((Literal)object).getValue() instanceof IntegerRange)) {
                if (bl3 || Literal.isEmptySequence(object)) {
                    bl2 = true;
                    break;
                }
                bl3 = true;
                continue;
            }
            bl3 = false;
        }
        if (bl2) {
            Block block = this;
            ArrayList arrayList = new ArrayList(block.a.length << 1);
            this.a(arrayList);
            Expression expression = Block.makeBlock(arrayList);
            expression.setRetainedStaticContext(this.getRetainedStaticContext());
            return expression;
        }
        Block block = this;
        if (block.a.length == 0) {
            return Literal.makeEmptySequence();
        }
        block = this;
        if (block.a.length == 1) {
            return this.a(0);
        }
        return this;
    }

    @Override
    public void checkPermittedContents(SchemaType schemaType, boolean bl2) {
        for (Operand operand : ((Expression)this).operands()) {
            Expression object = operand.getChildExpression();
            object.checkPermittedContents(schemaType, false);
        }
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("sequence", this);
        for (Operand operand : ((Expression)this).operands()) {
            Expression object = operand.getChildExpression();
            object.export(expressionPresenter);
        }
        expressionPresenter.endElement();
    }

    @Override
    public String toShortString() {
        return "(" + this.a(0).toShortString() + ", ...)";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TailCall processLeavingTail(XPathContext xPathContext) {
        void var2_3;
        Object object2 = null;
        for (Operand operand : ((Expression)this).operands()) {
            Expression expression = operand.getChildExpression();
            try {
                if (expression instanceof TailCallReturner) {
                    TailCall tailCall = ((TailCallReturner)((Object)expression)).processLeavingTail(xPathContext);
                    continue;
                }
                expression.process(xPathContext);
                Object var2_6 = null;
            }
            catch (XPathException xPathException) {
                XPathException xPathException2 = xPathException;
                xPathException.maybeSetLocation(expression.getLocation());
                xPathException2.maybeSetContext(xPathContext);
                throw xPathException2;
            }
        }
        return var2_3;
    }

    @Override
    public int getImplementationMethod() {
        return 6;
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        Block block = this;
        if (block.a.length == 0) {
            return EmptyIterator.emptyIterator();
        }
        block = this;
        if (block.a.length == 1) {
            return this.a(0).iterate(xPathContext);
        }
        return new BlockIterator(this.a, xPathContext);
    }

    @Override
    public void evaluatePendingUpdates(XPathContext xPathContext, PendingUpdateList pendingUpdateList) {
        for (Operand operand : ((Expression)this).operands()) {
            Expression object = operand.getChildExpression();
            object.evaluatePendingUpdates(xPathContext, pendingUpdateList);
        }
    }

    @Override
    public String getStreamerName() {
        return "Block";
    }
}

