/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ComponentInvocation;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.ITemplateCall;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.NamedTemplate;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;

public class CallTemplate
extends Instruction
implements ComponentInvocation,
ITemplateCall {
    private NamedTemplate a = null;
    private StructuredQName b;
    private WithParam[] c = WithParam.EMPTY_ARRAY;
    private WithParam[] d = WithParam.EMPTY_ARRAY;
    private boolean e = false;
    private int f = -1;
    private boolean g;

    public CallTemplate(NamedTemplate namedTemplate, StructuredQName structuredQName, boolean bl2, boolean bl3) {
        this.a = namedTemplate;
        this.b = structuredQName;
        this.e = bl2;
        this.g = bl3;
    }

    public void setActualParameters(WithParam[] withParamArray, WithParam[] withParamArray2) {
        this.c = withParamArray;
        this.d = withParamArray2;
        for (WithParam withParam : withParamArray) {
            this.adoptChildExpression(withParam.getSelectExpression());
        }
        withParamArray = withParamArray2;
        int n2 = withParamArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            WithParam withParam;
            withParam = withParamArray[i2];
            this.adoptChildExpression(withParam.getSelectExpression());
        }
    }

    public StructuredQName getCalledTemplateName() {
        return this.b;
    }

    @Override
    public SymbolicName getSymbolicName() {
        if (this.b == null) {
            return null;
        }
        return new SymbolicName(200, this.b);
    }

    public Component getTarget() {
        return this.a.getDeclaringComponent();
    }

    @Override
    public Component getFixedTarget() {
        Component component = this.getTarget();
        Visibility visibility = component.getVisibility();
        if (visibility == Visibility.PRIVATE || visibility == Visibility.FINAL) {
            return component;
        }
        return null;
    }

    @Override
    public WithParam[] getActualParams() {
        return this.c;
    }

    @Override
    public WithParam[] getTunnelParams() {
        return this.d;
    }

    public void setTargetTemplate(NamedTemplate namedTemplate) {
        this.a = namedTemplate;
    }

    public NamedTemplate getTargetTemplate() {
        return this.a;
    }

    public boolean usesTailRecursion() {
        return this.e;
    }

    @Override
    public int getInstructionNameCode() {
        return 138;
    }

    @Override
    public void setBindingSlot(int n2) {
        this.f = n2;
    }

    @Override
    public int getBindingSlot() {
        return this.f;
    }

    @Override
    public Expression simplify() {
        WithParam.simplify(this.c);
        WithParam.simplify(this.d);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        WithParam.typeCheck(this.c, expressionVisitor, contextItemStaticInfo);
        WithParam.typeCheck(this.d, expressionVisitor, contextItemStaticInfo);
        boolean bl2 = expressionVisitor.getStaticContext().isInBackwardsCompatibleMode();
        TypeChecker typeChecker = expressionVisitor.getConfiguration().getTypeChecker(bl2);
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            WithParam withParam = this.c[i2];
            Object object = this.a.getLocalParamInfo(withParam.getVariableQName());
            if (object == null) continue;
            object = ((NamedTemplate.LocalParamInfo)object).requiredType;
            RoleDiagnostic roleDiagnostic = new RoleDiagnostic(8, withParam.getVariableQName().getDisplayName(), i2);
            roleDiagnostic.setErrorCode("XTTE0590");
            object = typeChecker.staticTypeCheck(withParam.getSelectExpression(), (SequenceType)object, roleDiagnostic, expressionVisitor);
            withParam.setSelectExpression(this, (Expression)object);
            withParam.setTypeChecked(true);
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        WithParam.optimize(expressionVisitor, this.c, contextItemStaticInfo);
        WithParam.optimize(expressionVisitor, this.d, contextItemStaticInfo);
        return this;
    }

    @Override
    public int computeCardinality() {
        if (this.a == null) {
            return 57344;
        }
        return this.a.getRequiredType().getCardinality();
    }

    @Override
    public ItemType getItemType() {
        if (this.a == null) {
            return AnyItemType.getInstance();
        }
        return this.a.getRequiredType().getPrimaryType();
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        CallTemplate callTemplate = new CallTemplate(this.a, this.b, this.e, this.g);
        ExpressionTool.copyLocationInfo(this, callTemplate);
        callTemplate.c = WithParam.copy(callTemplate, this.c, rebindingMap);
        callTemplate.d = WithParam.copy(callTemplate, this.d, rebindingMap);
        return callTemplate;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 639;
    }

    @Override
    public final boolean mayCreateNewNodes() {
        return true;
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> arrayList = new ArrayList<Operand>(10);
        CallTemplate callTemplate = this;
        WithParam.gatherOperands(callTemplate, callTemplate.c, arrayList);
        CallTemplate callTemplate2 = this;
        WithParam.gatherOperands(callTemplate2, callTemplate2.d, arrayList);
        return arrayList;
    }

    @Override
    public void process(XPathContext xPathContext) {
        Component component = this.getFixedTarget();
        if (this.f >= 0 && (component = xPathContext.getTargetComponent(this.f)).isHiddenAbstractComponent()) {
            XPathException xPathException = new XPathException("Cannot call an abstract template (" + this.b.getDisplayName() + ") with no implementation", "XTDE3052");
            xPathException.setLocation(this.getLocation());
            throw xPathException;
        }
        Object object = (NamedTemplate)component.getActor();
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setCurrentComponent(component);
        xPathContextMajor.setOrigin(this);
        xPathContextMajor.openStackFrame(((Actor)object).getStackFrameMap());
        xPathContextMajor.setLocalParameters(CallTemplate.assembleParams(xPathContext, this.c));
        xPathContextMajor.setTunnelParameters(CallTemplate.assembleTunnelParams(xPathContext, this.d));
        xPathContextMajor.setCurrentMergeGroupIterator(null);
        if (this.g) {
            xPathContextMajor.setCurrentGroupIterator(null);
        }
        try {
            for (object = ((NamedTemplate)object).expand(xPathContextMajor); object != null; object = object.processLeavingTail()) {
            }
            return;
        }
        catch (StackOverflowError stackOverflowError) {
            object = new XPathException("Too many nested template or function calls. The stylesheet may be looping.", "SXLM0001", this.getLocation());
            ((XPathException)object).setXPathContext(xPathContext);
            throw object;
        }
    }

    @Override
    public TailCall processLeavingTail(XPathContext xPathContext) {
        if (this.e) {
            Component component = this.f >= 0 ? xPathContext.getTargetComponent(this.f) : this.getFixedTarget();
            if (component == null) {
                throw new XPathException("Internal Saxon error: No binding available for call-template instruction", "SXPK0001", this.getLocation());
            }
            if (component.isHiddenAbstractComponent()) {
                throw new XPathException("Cannot call an abstract template (" + this.b.getDisplayName() + ") with no implementation", "XTDE3052", this.getLocation());
            }
            ParameterSet parameterSet = CallTemplate.assembleParams(xPathContext, this.c);
            ParameterSet parameterSet2 = CallTemplate.assembleTunnelParams(xPathContext, this.d);
            if (parameterSet == null) {
                parameterSet = ParameterSet.EMPTY_PARAMETER_SET;
            }
            Arrays.fill(xPathContext.getStackFrame().getStackFrameValues(), null);
            return new CallTemplatePackage(component, parameterSet, parameterSet2, this, xPathContext);
        }
        ((Expression)this).process(xPathContext);
        return null;
    }

    @Override
    public StructuredQName getObjectName() {
        if (this.a == null) {
            return null;
        }
        return this.a.getTemplateName();
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("callT", this);
        String string = "";
        if (this.a != null && this.a.getTemplateName() != null) {
            expressionPresenter.emitAttribute("name", this.a.getTemplateName());
        }
        expressionPresenter.emitAttribute("bSlot", "" + this.getBindingSlot());
        if (this.g) {
            string = string + "d";
        }
        if (this.e) {
            string = string + "t";
        }
        if (!string.isEmpty()) {
            expressionPresenter.emitAttribute("flags", string);
        }
        if (this.c.length > 0) {
            WithParam.exportParameters(this.c, expressionPresenter, false);
        }
        if (this.d.length > 0) {
            WithParam.exportParameters(this.d, expressionPresenter, true);
        }
        expressionPresenter.endElement();
    }

    @Override
    public String toString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        fastStringBuffer.append("CallTemplate#");
        if (this.a.getObjectName() != null) {
            fastStringBuffer.append(this.a.getObjectName().getDisplayName());
        }
        boolean bl2 = true;
        for (WithParam withParam : this.getActualParams()) {
            fastStringBuffer.append(bl2 ? "(" : ", ");
            fastStringBuffer.append(withParam.getVariableQName().getDisplayName());
            fastStringBuffer.append("=");
            fastStringBuffer.append(withParam.getSelectExpression().toString());
            bl2 = false;
        }
        if (!bl2) {
            fastStringBuffer.append(")");
        }
        return fastStringBuffer.toString();
    }

    @Override
    public String toShortString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        fastStringBuffer.append("CallTemplate#");
        fastStringBuffer.append(this.a.getObjectName().getDisplayName());
        return fastStringBuffer.toString();
    }

    @Override
    public String getStreamerName() {
        return "CallTemplate";
    }

    public static class CallTemplatePackage
    implements TailCall {
        private Component a;
        private ParameterSet b;
        private ParameterSet c;
        private CallTemplate d;
        private XPathContext e;

        public CallTemplatePackage(Component component, ParameterSet parameterSet, ParameterSet parameterSet2, CallTemplate callTemplate, XPathContext xPathContext) {
            this.a = component;
            if (!(component.getActor() instanceof NamedTemplate)) {
                throw new ClassCastException("Target of call-template must be a named template");
            }
            this.b = parameterSet;
            this.c = parameterSet2;
            this.d = callTemplate;
            this.e = xPathContext;
        }

        @Override
        public TailCall processLeavingTail() {
            NamedTemplate namedTemplate = (NamedTemplate)this.a.getActor();
            XPathContextMajor xPathContextMajor = this.e.newContext();
            xPathContextMajor.setCurrentComponent(this.a);
            xPathContextMajor.setOrigin(this.d);
            xPathContextMajor.setLocalParameters(this.b);
            xPathContextMajor.setTunnelParameters(this.c);
            xPathContextMajor.setCurrentMergeGroupIterator(null);
            xPathContextMajor.openStackFrame(namedTemplate.getStackFrameMap());
            return namedTemplate.expand(xPathContextMajor);
        }
    }
}

