/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.Arrays;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ConditionalInstruction;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TailCallReturner;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class Choose
extends Instruction
implements ConditionalInstruction {
    private Operand[] a;
    private Operand[] b;
    private boolean c;
    public static final OperandRole CHOICE_ACTION = new OperandRole(8, OperandUsage.TRANSMISSION, SequenceType.ANY_SEQUENCE);

    public Choose(Expression[] expressionArray, Expression[] expressionArray2) {
        int n2;
        this.a = new Operand[expressionArray.length];
        for (n2 = 0; n2 < expressionArray.length; ++n2) {
            this.a[n2] = new Operand(this, expressionArray[n2], OperandRole.INSPECT);
        }
        this.b = new Operand[expressionArray2.length];
        for (n2 = 0; n2 < expressionArray2.length; ++n2) {
            this.b[n2] = new Operand(this, expressionArray2[n2], CHOICE_ACTION);
        }
    }

    public static Expression makeConditional(Expression expressionArray, Expression expressionArray2, Expression expression) {
        if (Literal.isEmptySequence(expression)) {
            expressionArray = new Expression[]{expressionArray};
            expressionArray2 = new Expression[]{expressionArray2};
            return new Choose(expressionArray, expressionArray2);
        }
        expressionArray = new Expression[]{expressionArray, Literal.makeLiteral(BooleanValue.TRUE, (Expression)expressionArray)};
        expressionArray2 = new Expression[]{expressionArray2, expression};
        return new Choose(expressionArray, expressionArray2);
    }

    public static Expression makeConditional(Expression expressionArray, Expression expressionArray2) {
        expressionArray = new Expression[]{expressionArray};
        expressionArray2 = new Expression[]{expressionArray2};
        return new Choose(expressionArray, expressionArray2);
    }

    public void setInstruction(boolean bl2) {
        this.c = bl2;
    }

    @Override
    public boolean isInstruction() {
        return this.c;
    }

    public int size() {
        return this.a.length;
    }

    public static boolean isSingleBranchChoice(Expression expression) {
        return expression instanceof Choose && ((Choose)expression).size() == 1;
    }

    public int getNumberOfConditions() {
        return this.size();
    }

    public Expression getCondition(int n2) {
        return this.a[n2].getChildExpression();
    }

    public void setCondition(int n2, Expression expression) {
        this.a[n2].setChildExpression(expression);
    }

    public Iterable<Operand> conditions() {
        return Arrays.asList(this.a);
    }

    public Operand getActionOperand(int n2) {
        return this.b[n2];
    }

    public Expression getAction(int n2) {
        return this.b[n2].getChildExpression();
    }

    public void setAction(int n2, Expression expression) {
        this.b[n2].setChildExpression(expression);
    }

    public Iterable<Operand> actions() {
        return Arrays.asList(this.b);
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> arrayList = new ArrayList<Operand>(this.size() << 1);
        for (int i2 = 0; i2 < this.size(); ++i2) {
            arrayList.add(this.a[i2]);
            arrayList.add(this.b[i2]);
        }
        return arrayList;
    }

    @Override
    public boolean allowExtractingCommonSubexpressions() {
        return false;
    }

    public void atomizeActions() {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.setAction(i2, Atomizer.makeAtomizer(this.getAction(i2), null));
        }
    }

    @Override
    public int getInstructionNameCode() {
        if (this.size() == 1) {
            return 160;
        }
        return 142;
    }

    @Override
    public Expression simplify() {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.setCondition(i2, this.getCondition(i2).simplify());
            try {
                this.setAction(i2, this.getAction(i2).simplify());
                continue;
            }
            catch (XPathException xPathException) {
                XPathException xPathException2 = xPathException;
                if (xPathException.isTypeError()) {
                    throw xPathException2;
                }
                this.setAction(i2, new ErrorExpression(xPathException2));
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Expression a(ExpressionVisitor var1_1) {
        var2_2 = var1_1;
        var1_1 = this;
        var3_4 = false;
        for (var4_10 = 0; var4_10 < var1_1.size(); ++var4_10) {
            var5_11 /* !! */  = var1_1.getCondition(var4_10);
            if (!(var5_11 /* !! */  instanceof Literal)) continue;
            var3_4 = true;
            break;
        }
        var4_10 = var1_1.size();
        if (!var3_4) ** GOTO lbl-1000
        var3_5 = new ArrayList<Expression[]>(var4_10);
        var5_11 /* !! */  = new ArrayList<E>(var4_10);
        for (var6_13 = 0; var6_13 < var4_10; ++var6_13) {
            var7_17 = var1_1.getCondition(var6_13);
            if (!Literal.hasEffectiveBooleanValue((Expression)var7_17, false)) {
                var3_5.add(var7_17);
                var5_11 /* !! */ .add(var1_1.getAction(var6_13));
            }
            if (Literal.hasEffectiveBooleanValue((Expression)var7_17, true)) break;
        }
        if (var3_5.isEmpty()) {
            var6_14 = Literal.makeEmptySequence();
            ExpressionTool.copyLocationInfo((Expression)var1_1, var6_14);
            v0 = var6_14;
        } else if (var3_5.size() == 1 && Literal.hasEffectiveBooleanValue((Expression)var3_5.get(0), true)) {
            v0 = (Expression)var5_11 /* !! */ .get(0);
        } else if (var3_5.size() != var4_10) {
            v1 = var3_5;
            var6_15 = v1.toArray(new Expression[v1.size()]);
            var7_17 = var5_11 /* !! */ .toArray(new Expression[var5_11 /* !! */ .size()]);
            var2_2 = new Choose(var6_15, var7_17);
            var2_2.setRetainedStaticContext(var1_1.getRetainedStaticContext());
            v0 = var2_2;
        } else if (var1_1.size() == 1 && Literal.hasEffectiveBooleanValue(var1_1.getCondition(0), true)) {
            v0 = var1_1.getAction(0);
        } else {
            v2 = var1_1;
            if (Literal.isEmptySequence(v2.getAction(v2.size() - 1))) {
                if (var1_1.size() == 1) {
                    var3_6 = Literal.makeEmptySequence();
                    ExpressionTool.copyLocationInfo((Expression)var1_1, var3_6);
                    v0 = var3_6;
                } else {
                    var3_7 = new Expression[var4_10 - 1];
                    var5_11 /* !! */  = new Expression[var4_10 - 1];
                    for (var6_13 = 0; var6_13 < var4_10 - 1; ++var6_13) {
                        var3_7[var6_13] = var1_1.getCondition(var6_13);
                        var5_11 /* !! */ [var6_13] = var1_1.getAction(var6_13);
                    }
                    v0 = new Choose(var3_7, var5_11 /* !! */ );
                }
            } else if (Literal.hasEffectiveBooleanValue(var1_1.getCondition(var4_10 - 1), true) && var1_1.getAction(var4_10 - 1) instanceof Choose) {
                var3_8 = (Choose)var1_1.getAction(var4_10 - 1);
                var5_12 = var4_10 + var3_8.size() - 1;
                var6_16 = new Expression[var5_12];
                var7_17 = new Expression[var5_12];
                for (var2_3 = 0; var2_3 < var4_10 - 1; ++var2_3) {
                    var6_16[var2_3] = var1_1.getCondition(var2_3);
                    var7_17[var2_3] = var1_1.getAction(var2_3);
                }
                for (var2_3 = 0; var2_3 < var3_8.size(); ++var2_3) {
                    var6_16[var2_3 + var4_10 - 1] = var3_8.getCondition(var2_3);
                    var7_17[var2_3 + var4_10 - 1] = var3_8.getAction(var2_3);
                }
                v0 = new Choose(var6_16, var7_17);
            } else {
                v0 = var4_10 == 2 && Literal.isConstantBoolean(var1_1.getAction(0), true) && Literal.isConstantBoolean(var1_1.getAction(1), false) && Literal.hasEffectiveBooleanValue(var1_1.getCondition(1), true) ? ((var3_9 = var2_2.getConfiguration().getTypeHierarchy()).isSubType(var1_1.getCondition(0).getItemType(), BuiltInAtomicType.BOOLEAN) && var1_1.getCondition(0).getCardinality() == 16384 ? var1_1.getCondition(0) : SystemFunction.makeCall("boolean", var1_1.getRetainedStaticContext(), new Expression[]{var1_1.getCondition(0)})) : (var1_1 = var1_1);
            }
        }
        if (v0 != this) {
            ExpressionTool.copyLocationInfo(this, (Expression)var1_1);
        }
        return var1_1;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        XPathException xPathException;
        int n2;
        TypeHierarchy typeHierarchy = expressionVisitor.getConfiguration().getTypeHierarchy();
        for (n2 = 0; n2 < this.size(); ++n2) {
            this.a[n2].typeCheck(expressionVisitor, contextItemStaticInfo);
            xPathException = TypeChecker.ebvError(this.getCondition(n2), typeHierarchy);
            if (xPathException == null) continue;
            xPathException.setLocator(this.getCondition(n2).getLocation());
            xPathException.maybeSetFailingExpression(this.getCondition(n2));
            throw xPathException;
        }
        for (n2 = 0; n2 < this.size(); ++n2) {
            try {
                this.b[n2].typeCheck(expressionVisitor, contextItemStaticInfo);
                continue;
            }
            catch (XPathException xPathException2) {
                xPathException = xPathException2;
                xPathException2.maybeSetLocation(this.getLocation());
                xPathException.maybeSetFailingExpression(this.getAction(n2));
                if (xPathException.isStaticError()) {
                    throw xPathException;
                }
                if (xPathException.isTypeError()) {
                    if (Literal.isEmptySequence(this.getAction(n2)) || Literal.hasEffectiveBooleanValue(this.getCondition(n2), false)) {
                        this.setAction(n2, new ErrorExpression(xPathException));
                        continue;
                    }
                    throw xPathException;
                }
                this.setAction(n2, new ErrorExpression(xPathException));
            }
        }
        Expression expression = this.a(expressionVisitor);
        if (expression != this) {
            return expression.typeCheck(expressionVisitor, contextItemStaticInfo);
        }
        return expression;
    }

    @Override
    public boolean implementsStaticTypeCheck() {
        return true;
    }

    @Override
    public Expression staticTypeCheck(SequenceType object, boolean bl2, RoleDiagnostic roleDiagnostic, ExpressionVisitor expressionVisitor) {
        Expression[] expressionArray;
        int n2 = this.size();
        TypeChecker typeChecker = this.getConfiguration().getTypeChecker(bl2);
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                this.setAction(i2, typeChecker.staticTypeCheck(this.getAction(i2), (SequenceType)object, roleDiagnostic, expressionVisitor));
                continue;
            }
            catch (XPathException expressionArray2) {
                expressionArray = expressionArray2;
                if (expressionArray2.isStaticError()) {
                    throw expressionArray;
                }
                ErrorExpression errorExpression = new ErrorExpression((XPathException)expressionArray);
                ExpressionTool.copyLocationInfo(this.getAction(i2), errorExpression);
                this.setAction(i2, errorExpression);
            }
        }
        if (!Literal.hasEffectiveBooleanValue(this.getCondition(n2 - 1), true) && !Cardinality.allowsZero(((SequenceType)object).getCardinality())) {
            Expression[] expressionArray3 = new Expression[n2 + 1];
            expressionArray = new Expression[n2 + 1];
            for (int i3 = 0; i3 < n2; ++i3) {
                expressionArray3[i3] = this.getCondition(i3);
                expressionArray[i3] = this.getAction(i3);
            }
            expressionArray3[n2] = Literal.makeLiteral(BooleanValue.TRUE, this);
            String string = n2 == 1 ? "The condition is not" : "None of the conditions is";
            object = "Conditional expression: " + string + " satisfied, so an empty sequence is returned, but this is not allowed as the " + roleDiagnostic.getMessage();
            object = new ErrorExpression((String)object, roleDiagnostic.getErrorCode(), true);
            ExpressionTool.copyLocationInfo(this, (Expression)object);
            expressionArray[n2] = object;
            return new Choose(expressionArray3, expressionArray);
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        Object object2;
        int n2;
        int n3 = this.size();
        for (n2 = 0; n2 < n3; ++n2) {
            boolean bl2;
            this.a[n2].optimize((ExpressionVisitor)object, contextItemStaticInfo);
            object2 = BooleanFn.rewriteEffectiveBooleanValue(this.getCondition(n2), (ExpressionVisitor)object, contextItemStaticInfo);
            if (object2 != null && object2 != this.getCondition(n2)) {
                this.setCondition(n2, (Expression)object2);
            }
            if (!(this.getCondition(n2) instanceof Literal) || ((Literal)this.getCondition(n2)).getValue() instanceof BooleanValue) continue;
            try {
                bl2 = ((Literal)this.getCondition(n2)).getValue().effectiveBooleanValue();
            }
            catch (XPathException xPathException) {
                object = xPathException;
                xPathException.setLocation(this.getLocation());
                throw object;
            }
            this.setCondition(n2, Literal.makeLiteral(BooleanValue.get(bl2), this));
        }
        for (n2 = 0; n2 < n3; ++n2) {
            try {
                this.b[n2].optimize((ExpressionVisitor)object, contextItemStaticInfo);
            }
            catch (XPathException xPathException) {
                object2 = xPathException;
                if (xPathException.isTypeError()) {
                    throw object2;
                }
                object2 = new ErrorExpression((XPathException)object2);
                ExpressionTool.copyLocationInfo(this.b[n2].getChildExpression(), (Expression)object2);
                this.setAction(n2, (Expression)object2);
            }
            if (!(this.getAction(n2) instanceof ErrorExpression) || !((ErrorExpression)this.getAction(n2)).isTypeError() || Literal.isConstantBoolean(this.getCondition(n2), false) || Literal.isConstantBoolean(this.getCondition(n2), true)) continue;
            ((ExpressionVisitor)object).issueWarning("Branch " + (n2 + 1) + " of conditional will fail with a type error if executed. " + ((ErrorExpression)this.getAction(n2)).getMessage(), this.getAction(n2).getLocation());
        }
        if (n3 == 0) {
            return Literal.makeEmptySequence();
        }
        Expression expression = this.a((ExpressionVisitor)object);
        if (expression instanceof Choose) {
            return ((ExpressionVisitor)object).obtainOptimizer().trySwitch((Choose)expression, (ExpressionVisitor)object);
        }
        return expression;
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        int n2 = this.size();
        Expression[] expressionArray = new Expression[n2];
        Expression[] expressionArray2 = new Expression[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            expressionArray[i2] = this.getCondition(i2).copy(rebindingMap);
            expressionArray2[i2] = this.getAction(i2).copy(rebindingMap);
        }
        Choose choose = new Choose(expressionArray, expressionArray2);
        ExpressionTool.copyLocationInfo(this, choose);
        choose.setInstruction(((Expression)this).isInstruction());
        return choose;
    }

    @Override
    public void checkForUpdatingSubexpressions() {
        for (Operand operand : this.conditions()) {
            Expression expression = operand.getChildExpression();
            expression.checkForUpdatingSubexpressions();
            if (!expression.isUpdatingExpression()) continue;
            XPathException xPathException = new XPathException("Updating expression appears in a context where it is not permitted", "XUST0001");
            xPathException.setLocator(expression.getLocation());
            throw xPathException;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        for (Operand operand : this.actions()) {
            Expression object = operand.getChildExpression();
            object.checkForUpdatingSubexpressions();
            if (ExpressionTool.isNotAllowedInUpdatingContext(object)) {
                if (bl2) {
                    XPathException xPathException = new XPathException("If any branch of a conditional is an updating expression, then all must be updating expressions (or vacuous)", "XUST0001");
                    xPathException.setLocator(object.getLocation());
                    throw xPathException;
                }
                bl3 = true;
            }
            if (!object.isUpdatingExpression()) continue;
            if (bl3) {
                XPathException xPathException = new XPathException("If any branch of a conditional is an updating expression, then all must be updating expressions (or vacuous)", "XUST0001");
                xPathException.setLocator(object.getLocation());
                throw xPathException;
            }
            bl2 = true;
        }
    }

    @Override
    public boolean isUpdatingExpression() {
        for (Operand operand : this.actions()) {
            if (!operand.getChildExpression().isUpdatingExpression()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVacuousExpression() {
        for (Operand operand : this.actions()) {
            if (operand.getChildExpression().isVacuousExpression()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getImplementationMethod() {
        int n2 = 14;
        if (!Cardinality.allowsMany(this.getCardinality())) {
            n2 = 15;
        }
        return n2;
    }

    @Override
    public int markTailFunctionCalls(StructuredQName structuredQName, int n2) {
        int n3 = 0;
        for (Operand operand : this.actions()) {
            n3 = Math.max(n3, operand.getChildExpression().markTailFunctionCalls(structuredQName, n2));
        }
        return n3;
    }

    @Override
    public ItemType getItemType() {
        TypeHierarchy typeHierarchy = this.getConfiguration().getTypeHierarchy();
        ItemType itemType = this.getAction(0).getItemType();
        for (int i2 = 1; i2 < this.size(); ++i2) {
            itemType = Type.getCommonSuperType(itemType, this.getAction(i2).getItemType(), typeHierarchy);
        }
        return itemType;
    }

    @Override
    public UType getStaticUType(UType uType) {
        if (((Expression)this).isInstruction()) {
            return super.getStaticUType(uType);
        }
        UType uType2 = this.getAction(0).getStaticUType(uType);
        for (int i2 = 1; i2 < this.size(); ++i2) {
            uType2 = uType2.union(this.getAction(i2).getStaticUType(uType));
        }
        return uType2;
    }

    @Override
    public int computeCardinality() {
        int n2 = 0;
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            n2 = Cardinality.union(n2, this.getAction(i2).getCardinality());
            if (!Literal.hasEffectiveBooleanValue(this.getCondition(i2), true)) continue;
            bl2 = true;
        }
        if (!bl2) {
            n2 = Cardinality.union(n2, 8192);
        }
        return n2;
    }

    @Override
    public int computeSpecialProperties() {
        int n2 = this.getAction(0).getSpecialProperties();
        for (int i2 = 1; i2 < this.size(); ++i2) {
            n2 &= this.getAction(i2).getSpecialProperties();
        }
        return n2;
    }

    @Override
    public final boolean mayCreateNewNodes() {
        for (Operand operand : this.actions()) {
            int n2 = operand.getChildExpression().getSpecialProperties();
            if ((n2 & 0x800000) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Expression unordered(boolean bl2, boolean bl3) {
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.setAction(i2, this.getAction(i2).unordered(bl2, bl3));
        }
        return this;
    }

    @Override
    public void checkPermittedContents(SchemaType schemaType, boolean bl2) {
        for (Operand operand : this.actions()) {
            operand.getChildExpression().checkPermittedContents(schemaType, bl2);
        }
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        for (Operand object : this.conditions()) {
            object.getChildExpression().addToPathMap(pathMap, pathMapNodeSet);
        }
        PathMap.PathMapNodeSet pathMapNodeSet2 = new PathMap.PathMapNodeSet();
        for (Iterable<Operand> iterable : this.actions()) {
            iterable = iterable.getChildExpression().addToPathMap(pathMap, pathMapNodeSet);
            pathMapNodeSet2.addNodeSet((PathMap.PathMapNodeSet)iterable);
        }
        return pathMapNodeSet2;
    }

    @Override
    public String toString() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
        fastStringBuffer.append("if (");
        for (int i2 = 0; i2 < this.size(); ++i2) {
            fastStringBuffer.append(this.getCondition(i2).toString());
            fastStringBuffer.append(") then (");
            fastStringBuffer.append(this.getAction(i2).toString());
            if (i2 == this.size() - 1) {
                fastStringBuffer.append(")");
                continue;
            }
            fastStringBuffer.append(") else if (");
        }
        return fastStringBuffer.toString();
    }

    @Override
    public String toShortString() {
        return "if(" + this.getCondition(0).toShortString() + ") then ... else ...";
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("choose", this);
        for (int i2 = 0; i2 < this.size(); ++i2) {
            this.getCondition(i2).export(expressionPresenter);
            this.getAction(i2).export(expressionPresenter);
        }
        expressionPresenter.endElement();
    }

    @Override
    public TailCall processLeavingTail(XPathContext xPathContext) {
        int n2 = this.a(xPathContext);
        if (n2 >= 0) {
            Expression expression = this.getAction(n2);
            if (expression instanceof TailCallReturner) {
                return ((TailCallReturner)((Object)expression)).processLeavingTail(xPathContext);
            }
            expression.process(xPathContext);
            return null;
        }
        return null;
    }

    private int a(XPathContext object) {
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl2;
            try {
                bl2 = this.getCondition(i2).effectiveBooleanValue((XPathContext)object);
            }
            catch (XPathException xPathException) {
                object = xPathException;
                xPathException.maybeSetFailingExpression(this.getCondition(i2));
                throw object;
            }
            if (!bl2) continue;
            return i2;
        }
        return -1;
    }

    public Item evaluateItem(XPathContext xPathContext) {
        int n2 = this.a(xPathContext);
        if (n2 < 0) {
            return null;
        }
        return this.getAction(n2).evaluateItem(xPathContext);
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        int n2 = this.a(xPathContext);
        if (n2 < 0) {
            return EmptyIterator.emptyIterator();
        }
        return this.getAction(n2).iterate(xPathContext);
    }

    @Override
    public void evaluatePendingUpdates(XPathContext xPathContext, PendingUpdateList pendingUpdateList) {
        int n2 = this.a(xPathContext);
        if (n2 >= 0) {
            this.getAction(n2).evaluatePendingUpdates(xPathContext, pendingUpdateList);
        }
    }

    @Override
    public String getExpressionName() {
        return "choose";
    }

    @Override
    public String getStreamerName() {
        return "Choose";
    }
}

