/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public final class Comment
extends SimpleNodeConstructor {
    @Override
    public final int getInstructionNameCode() {
        return 143;
    }

    @Override
    public final ItemType getItemType() {
        return NodeKindTest.COMMENT;
    }

    @Override
    public final int getCardinality() {
        return 16384;
    }

    @Override
    public final Expression copy(RebindingMap rebindingMap) {
        Comment comment = new Comment();
        ExpressionTool.copyLocationInfo(this, comment);
        comment.setSelect(this.getSelect().copy(rebindingMap));
        return comment;
    }

    @Override
    public final void localTypeCheck(ExpressionVisitor object, ContextItemStaticInfo object2) {
        if (this.getSelect() instanceof Literal && !((String)(object = this.checkContent((String)(object2 = ((Literal)this.getSelect()).getValue().getStringValue()), ((ExpressionVisitor)object).getStaticContext().makeEarlyEvaluationContext()))).equals(object2)) {
            this.setSelect(new StringLiteral((CharSequence)object));
        }
    }

    @Override
    public final void processValue(CharSequence charSequence, XPathContext object) {
        charSequence = this.checkContent(charSequence.toString(), (XPathContext)object);
        object = object.getReceiver();
        object.comment(charSequence, this.getLocation(), 0);
    }

    @Override
    protected final String checkContent(String object, XPathContext xPathContext) {
        if (this.isXSLT()) {
            return Comment.checkContentXSLT((String)object);
        }
        try {
            return Comment.checkContentXQuery((String)object);
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.setXPathContext(xPathContext);
            ((XPathException)object).setLocation(this.getLocation());
            throw object;
        }
    }

    public static String checkContentXSLT(String string) {
        int n2;
        while ((n2 = string.indexOf("--")) >= 0) {
            string = string.substring(0, n2 + 1) + ' ' + string.substring(n2 + 1);
        }
        if (string.length() > 0) {
            String string2 = string;
            if (string2.charAt(string2.length() - 1) == '-') {
                string = string + ' ';
            }
        }
        return string;
    }

    public static String checkContentXQuery(String string) {
        if (string.contains("--")) {
            throw new XPathException("Invalid characters (--) in comment", "XQDY0072");
        }
        if (string.length() > 0) {
            String string2 = string;
            if (string2.charAt(string2.length() - 1) == '-') {
                throw new XPathException("Comment cannot end in '-'", "XQDY0072");
            }
        }
        return string;
    }

    @Override
    public final void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("comment", this);
        String string = "";
        if (this.isLocal()) {
            string = string + "l";
        }
        if (!string.isEmpty()) {
            expressionPresenter.emitAttribute("flags", string);
        }
        this.getSelect().export(expressionPresenter);
        expressionPresenter.endElement();
    }
}

