/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.AttributeCreator;
import net.sf.saxon.expr.instruct.FixedAttribute;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public final class ComputedAttribute
extends AttributeCreator {
    private Operand a;
    private Operand b;
    private boolean c;

    public ComputedAttribute(Expression expression, Expression expression2, NamespaceResolver namespaceResolver, int n2, SimpleType simpleType, boolean bl2) {
        this.a = new Operand(this, expression, OperandRole.SINGLE_ATOMIC);
        if (expression2 != null) {
            this.b = new Operand(this, expression2, OperandRole.SINGLE_ATOMIC);
        }
        this.setSchemaType(simpleType);
        this.setValidationAction(n2);
        this.setOptions(0);
        this.c = bl2;
    }

    @Override
    public final void setRejectDuplicates() {
        ComputedAttribute computedAttribute = this;
        computedAttribute.setOptions(computedAttribute.getOptions() | 0x20);
    }

    @Override
    public final int getInstructionNameCode() {
        return 135;
    }

    public final Expression getNameExp() {
        return this.a.getChildExpression();
    }

    public final Expression getNamespaceExp() {
        if (this.b == null) {
            return null;
        }
        return this.b.getChildExpression();
    }

    public final void setNameExp(Expression expression) {
        this.a.setChildExpression(expression);
    }

    public final void setNamespace(Expression expression) {
        if (expression != null) {
            if (this.b == null) {
                this.b = new Operand(this, expression, OperandRole.SINGLE_ATOMIC);
                return;
            }
            this.b.setChildExpression(expression);
        }
    }

    @Override
    public final Iterable<Operand> operands() {
        return this.operandSparseList(this.selectOp, this.a, this.b);
    }

    public final NamespaceResolver getNamespaceResolver() {
        return this.getRetainedStaticContext();
    }

    @Override
    public final ItemType getItemType() {
        return NodeKindTest.ATTRIBUTE;
    }

    @Override
    public final int getCardinality() {
        return 24576;
    }

    public final boolean isAllowNameAsQName() {
        return this.c;
    }

    @Override
    public final int computeSpecialProperties() {
        return super.computeSpecialProperties() | 0x1000000;
    }

    @Override
    public final void localTypeCheck(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        this.a.typeCheck((ExpressionVisitor)object, contextItemStaticInfo);
        Object object2 = new RoleDiagnostic(4, "attribute/name", 0);
        Configuration configuration = ((ExpressionVisitor)object).getConfiguration();
        TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
        if (this.c) {
            boolean bl2;
            this.setNameExp(configuration.getTypeChecker(false).staticTypeCheck(this.getNameExp(), SequenceType.SINGLE_ATOMIC, (RoleDiagnostic)object2, (ExpressionVisitor)object));
            object2 = this.getNameExp().getItemType();
            boolean bl3 = typeHierarchy.relationship((ItemType)object2, BuiltInAtomicType.STRING) != 4 || typeHierarchy.relationship((ItemType)object2, BuiltInAtomicType.UNTYPED_ATOMIC) != 4;
            boolean bl4 = bl2 = typeHierarchy.relationship((ItemType)object2, BuiltInAtomicType.QNAME) != 4;
            if (!bl3 && !bl2) {
                object = new XPathException("The attribute name must be either an xs:string, an xs:QName, or untyped atomic");
                ((XPathException)object).setErrorCode("XPTY0004");
                ((XPathException)object).setIsTypeError(true);
                ((XPathException)object).setLocation(this.getLocation());
                throw object;
            }
        } else if (!typeHierarchy.isSubType(this.getNameExp().getItemType(), BuiltInAtomicType.STRING)) {
            this.setNameExp(SystemFunction.makeCall("string", this.getRetainedStaticContext(), this.getNameExp()));
        }
        if (this.getNamespaceExp() != null) {
            this.b.typeCheck((ExpressionVisitor)object, contextItemStaticInfo);
        }
        if (Literal.isAtomic(this.getNameExp())) {
            try {
                Object object3 = (AtomicValue)((Literal)this.getNameExp()).getValue();
                if (object3 instanceof StringValue) {
                    String[] stringArray = NameChecker.checkQNameParts(((AtomicValue)object3).getStringValueCS());
                    if (this.getNamespaceExp() == null) {
                        object3 = this.getNamespaceResolver().getURIForPrefix(stringArray[0], false);
                        if (object3 == null) {
                            object = new XPathException("Prefix " + stringArray[0] + " has not been declared");
                            if (this.isXSLT()) {
                                ((XPathException)object).setErrorCode("XTDE0860");
                                ((XPathException)object).setIsStaticError(true);
                                throw object;
                            }
                            ((XPathException)object).setErrorCode("XQDY0074");
                            ((XPathException)object).setIsStaticError(false);
                            throw object;
                        }
                        this.setNamespace(new StringLiteral((CharSequence)object3));
                    }
                }
                return;
            }
            catch (XPathException xPathException) {
                XPathException xPathException2 = xPathException;
                if (xPathException.getErrorCodeQName() == null || xPathException2.getErrorCodeLocalPart().equals("FORG0001")) {
                    xPathException2.setErrorCode(this.isXSLT() ? "XTDE0850" : "XQDY0074");
                }
                xPathException2.maybeSetLocation(this.getLocation());
                xPathException2.setIsStaticError(true);
                throw xPathException2;
            }
        }
    }

    @Override
    public final Expression optimize(ExpressionVisitor object, ContextItemStaticInfo object2) {
        if ((object2 = super.optimize((ExpressionVisitor)object, (ContextItemStaticInfo)object2)) != this) {
            return object2;
        }
        if (this.getNameExp() instanceof Literal && (this.getNamespaceExp() == null || this.getNamespaceExp() instanceof Literal)) {
            object = ((ExpressionVisitor)object).getStaticContext().makeEarlyEvaluationContext();
            object = ((SimpleNodeConstructor)this).evaluateNodeName((XPathContext)object);
            object = new FixedAttribute((NodeName)object, this.getValidationAction(), this.getSchemaType());
            ((SimpleNodeConstructor)object).setSelect(this.getSelect());
            return object;
        }
        return this;
    }

    @Override
    public final Expression copy(RebindingMap rebindingMap) {
        ComputedAttribute computedAttribute = new ComputedAttribute(this.getNameExp() == null ? null : this.getNameExp().copy(rebindingMap), this.getNamespaceExp() == null ? null : this.getNamespaceExp().copy(rebindingMap), this.getRetainedStaticContext(), this.getValidationAction(), this.getSchemaType(), this.c);
        ExpressionTool.copyLocationInfo(this, computedAttribute);
        computedAttribute.setSelect(this.getSelect().copy(rebindingMap));
        computedAttribute.setInstruction(((Expression)this).isInstruction());
        return computedAttribute;
    }

    @Override
    public final void checkPermittedContents(SchemaType object, boolean bl2) {
        if (object instanceof SimpleType) {
            String string = "Attributes are not permitted here: ";
            string = object.isAnonymousType() ? string + "the containing element is defined to have a simple type" : string + "the containing element is of simple type " + object.getDescription();
            object = new XPathException(string);
            ((XPathException)object).setIsTypeError(true);
            ((XPathException)object).setLocation(this.getLocation());
            throw object;
        }
    }

    @Override
    public final NodeName evaluateNodeName(XPathContext xPathContext) {
        Object object;
        Object object2;
        Object object3 = xPathContext.getNamePool();
        Object object4 = this.getNameExp().evaluateItem(xPathContext);
        String string = null;
        if (object4 instanceof StringValue) {
            object2 = object4.getStringValueCS();
            object2 = Whitespace.trimWhitespace((CharSequence)object2);
            try {
                object = NameChecker.getQNameParts((CharSequence)object2);
                object4 = object[0];
                object = object[1];
            }
            catch (QNameException qNameException) {
                object3 = this.isXSLT() ? "XTDE0850" : "XQDY0074";
                object3 = new XPathException("Invalid attribute name: " + object2, (String)object3, this.getLocation());
                throw ComputedAttribute.dynamicError(this.getLocation(), (XPathException)object3, xPathContext);
            }
            if (object2.toString().equals("xmlns") && this.getNamespaceExp() == null) {
                object = this.isXSLT() ? "XTDE0855" : "XQDY0044";
                object3 = new XPathException("Invalid attribute name: " + object2, (String)object, this.getLocation());
                throw ComputedAttribute.dynamicError(this.getLocation(), (XPathException)object3, xPathContext);
            }
            if (((String)object4).equals("xmlns")) {
                if (this.getNamespaceExp() == null) {
                    object = this.isXSLT() ? "XTDE0860" : "XQDY0044";
                    object3 = new XPathException("Invalid attribute name: " + object2, (String)object, this.getLocation());
                    throw ComputedAttribute.dynamicError(this.getLocation(), (XPathException)object3, xPathContext);
                }
                object4 = "";
            }
        } else if (object4 instanceof QNameValue && this.c) {
            object = ((QNameValue)object4).getLocalName();
            string = ((QNameValue)object4).getNamespaceURI();
            if (object.equals("xmlns") && string.isEmpty()) {
                XPathException xPathException = new XPathException("Invalid attribute name: xmlns", "XQDY0044", this.getLocation());
                throw ComputedAttribute.dynamicError(this.getLocation(), xPathException, xPathContext);
            }
            if (string.isEmpty()) {
                object4 = "";
            } else {
                if (((String)(object4 = ((QNameValue)object4).getPrefix())).isEmpty() && (object4 = ((NamePool)object3).suggestPrefixForURI(string)) == null) {
                    object4 = "ns0";
                }
                if (string.equals("http://www.w3.org/XML/1998/namespace") != "xml".equals(object4)) {
                    String string2 = "xml".equals(object4) ? "When the prefix is 'xml', the namespace URI must be http://www.w3.org/XML/1998/namespace" : "When the namespace URI is http://www.w3.org/XML/1998/namespace, the prefix must be 'xml'";
                    object = this.isXSLT() ? "XTDE0835" : "XQDY0044";
                    object3 = new XPathException(string2, (String)object, this.getLocation());
                    throw ComputedAttribute.dynamicError(this.getLocation(), (XPathException)object3, xPathContext);
                }
            }
            if ("xmlns".equals(object4)) {
                XPathException xPathException = new XPathException("Invalid attribute namespace: http://www.w3.org/2000/xmlns/", "XQDY0044", this.getLocation());
                throw ComputedAttribute.dynamicError(this.getLocation(), xPathException, xPathContext);
            }
        } else {
            XPathException xPathException = new XPathException("Attribute name must be either a string or a QName", "XPTY0004", this.getLocation());
            xPathException.setIsTypeError(true);
            throw ComputedAttribute.dynamicError(this.getLocation(), xPathException, xPathContext);
        }
        if (this.getNamespaceExp() == null && string == null) {
            if (((String)object4).isEmpty()) {
                string = "";
            } else {
                string = this.getRetainedStaticContext().getURIForPrefix((String)object4, false);
                if (string == null) {
                    object2 = this.isXSLT() ? "XTDE0860" : "XQDY0074";
                    object = new XPathException("Undeclared prefix in attribute name: " + (String)object4, (String)object2, this.getLocation());
                    throw ComputedAttribute.dynamicError(this.getLocation(), (XPathException)object, xPathContext);
                }
            }
        } else {
            if (string == null) {
                if (this.getNamespaceExp() instanceof StringLiteral) {
                    string = ((StringLiteral)this.getNamespaceExp()).getStringValue();
                } else {
                    string = this.getNamespaceExp().evaluateAsString(xPathContext).toString();
                    if (!StandardURIChecker.getInstance().isValidURI(string)) {
                        object2 = new XPathException("The value of the namespace attribute must be a valid URI", "XTDE0865", this.getLocation());
                        throw ComputedAttribute.dynamicError(this.getLocation(), (XPathException)object2, xPathContext);
                    }
                }
            }
            if (string.isEmpty()) {
                object4 = "";
            } else if (((String)object4).isEmpty() && (object4 = ((NamePool)object3).suggestPrefixForURI(string)) == null) {
                object4 = "ns0";
            }
        }
        if (string.equals("http://www.w3.org/2000/xmlns/")) {
            object2 = this.isXSLT() ? "XTDE0865" : "XQDY0044";
            object = new XPathException("Cannot create attribute in namespace " + string, (String)object2, this.getLocation());
            throw ComputedAttribute.dynamicError(this.getLocation(), (XPathException)object, xPathContext);
        }
        return new FingerprintedQName((String)object4, string, (String)object);
    }

    public final Item evaluateItem(XPathContext xPathContext) {
        Item<?> item = super.evaluateItem(xPathContext);
        this.validateOrphanAttribute((Orphan)item, xPathContext);
        return item;
    }

    @Override
    public final void export(ExpressionPresenter expressionPresenter) {
        Object object;
        expressionPresenter.startElement("compAtt", this);
        if (this.getValidationAction() != 4) {
            expressionPresenter.emitAttribute("validation", Validation.toString(this.getValidationAction()));
        }
        if ((object = this.getSchemaType()) != null) {
            expressionPresenter.emitAttribute("type", object.getStructuredQName());
        }
        object = "";
        if (this.isLocal()) {
            object = (String)object + "l";
        }
        if (!((String)object).isEmpty()) {
            expressionPresenter.emitAttribute("flags", (String)object);
        }
        expressionPresenter.setChildRole("name");
        this.getNameExp().export(expressionPresenter);
        if (this.getNamespaceExp() != null) {
            expressionPresenter.setChildRole("namespace");
            this.getNamespaceExp().export(expressionPresenter);
        }
        expressionPresenter.setChildRole("select");
        this.getSelect().export(expressionPresenter);
        expressionPresenter.endElement();
    }
}

