/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ElementCreator;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class ComputedElement
extends ElementCreator {
    private Operand a;
    private Operand b;
    private boolean c;
    private NodeTest d;

    public ComputedElement(Expression expression, Expression expression2, SchemaType schemaType, int n2, boolean bl2, boolean bl3) {
        this.a = new Operand(this, expression, OperandRole.SINGLE_ATOMIC);
        if (expression2 != null) {
            this.b = new Operand(this, expression2, OperandRole.SINGLE_ATOMIC);
        }
        this.setValidationAction(n2, schemaType);
        this.preservingTypes = schemaType == null && n2 == 3;
        this.inheritNamespacesToChildren = bl2;
        this.c = bl3;
    }

    public Expression getNameExp() {
        return this.a.getChildExpression();
    }

    public Expression getNamespaceExp() {
        if (this.b == null) {
            return null;
        }
        return this.b.getChildExpression();
    }

    protected void setNameExp(Expression expression) {
        this.a.setChildExpression(expression);
    }

    protected void setNamespaceExp(Expression expression) {
        if (this.b == null) {
            this.b = new Operand(this, expression, OperandRole.SINGLE_ATOMIC);
            return;
        }
        this.b.setChildExpression(expression);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandSparseList(this.contentOp, this.a, this.b);
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.getRetainedStaticContext();
    }

    @Override
    public Expression simplify() {
        ComputedElement computedElement = this;
        computedElement.setNameExp(computedElement.getNameExp().simplify());
        if (this.getNamespaceExp() != null) {
            ComputedElement computedElement2 = this;
            computedElement2.setNamespaceExp(computedElement2.getNamespaceExp().simplify());
        }
        Configuration configuration = this.getConfiguration();
        boolean bl2 = this.getPackageData().isSchemaAware();
        this.preservingTypes |= !bl2;
        SchemaType schemaType = this.getSchemaType();
        if (schemaType != null) {
            this.d = new ContentTypeTest(1, schemaType, configuration, false);
            schemaType.analyzeContentExpression(this.getContentExpression(), 1);
        } else {
            this.d = this.getValidationAction() == 4 || !bl2 ? new ContentTypeTest(1, Untyped.getInstance(), configuration, false) : NodeKindTest.ELEMENT;
        }
        return super.simplify();
    }

    @Override
    public Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        super.typeCheck((ExpressionVisitor)object, contextItemStaticInfo);
        Object object2 = ((ExpressionVisitor)object).getConfiguration();
        Object object3 = ((Configuration)object2).getTypeHierarchy();
        RoleDiagnostic roleDiagnostic = new RoleDiagnostic(4, "element/name", 0);
        if (this.c) {
            this.setNameExp(((Configuration)object2).getTypeChecker(false).staticTypeCheck(this.getNameExp(), SequenceType.SINGLE_ATOMIC, roleDiagnostic, (ExpressionVisitor)object));
            object2 = this.getNameExp().getItemType();
            if (((TypeHierarchy)object3).relationship((ItemType)object2, BuiltInAtomicType.STRING) == 4 && ((TypeHierarchy)object3).relationship((ItemType)object2, BuiltInAtomicType.UNTYPED_ATOMIC) == 4 && ((TypeHierarchy)object3).relationship((ItemType)object2, BuiltInAtomicType.QNAME) == 4) {
                object3 = new XPathException("The name of a constructed element must be a string, QName, or untypedAtomic");
                ((XPathException)object3).setErrorCode("XPTY0004");
                ((XPathException)object3).setIsTypeError(true);
                ((XPathException)object3).setLocation(this.getLocation());
                throw object3;
            }
        } else if (!((TypeHierarchy)object3).isSubType(this.getNameExp().getItemType(), BuiltInAtomicType.STRING)) {
            this.setNameExp(SystemFunction.makeCall("string", this.getRetainedStaticContext(), this.getNameExp()));
        }
        if (Literal.isAtomic(this.getNameExp())) {
            try {
                object2 = (AtomicValue)((Literal)this.getNameExp()).getValue();
                if (object2 instanceof StringValue) {
                    object3 = NameChecker.checkQNameParts(((AtomicValue)object2).getStringValueCS());
                    if (this.getNamespaceExp() == null) {
                        object2 = object3[0];
                        object3 = this.getNamespaceResolver().getURIForPrefix((String)object2, true);
                        if (object3 == null) {
                            object = new XPathException("Prefix " + (String)object2 + " has not been declared");
                            ((XPathException)object).setErrorCode("XPST0081");
                            ((XPathException)object).setIsStaticError(true);
                            throw object;
                        }
                        this.setNamespaceExp(new StringLiteral((CharSequence)object3));
                    }
                }
            }
            catch (XPathException xPathException) {
                object2 = xPathException;
                object3 = xPathException.getErrorCodeLocalPart();
                if (object3 == null || ((String)object3).equals("FORG0001")) {
                    ((XPathException)object2).setErrorCode(this.isXSLT() ? "XTDE0820" : "XQDY0074");
                } else if (((String)object3).equals("XPST0081")) {
                    ((XPathException)object2).setErrorCode(this.isXSLT() ? "XTDE0830" : "XQDY0074");
                }
                ((XPathException)object2).maybeSetLocation(this.getLocation());
                ((XPathException)object2).setIsStaticError(true);
                throw object2;
            }
        }
        return super.typeCheck((ExpressionVisitor)object, contextItemStaticInfo);
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        ComputedElement computedElement = new ComputedElement(this.getNameExp().copy(rebindingMap), this.getNamespaceExp() == null ? null : this.getNamespaceExp().copy(rebindingMap), this.getSchemaType(), this.getValidationAction(), this.inheritNamespacesToChildren, this.c);
        ExpressionTool.copyLocationInfo(this, computedElement);
        computedElement.setContentExpression(this.getContentExpression().copy(rebindingMap));
        return computedElement;
    }

    @Override
    public ItemType getItemType() {
        if (this.d == null) {
            return super.getItemType();
        }
        return this.d;
    }

    @Override
    public void checkPermittedContents(SchemaType object, boolean bl2) {
        if (object instanceof SimpleType || ((ComplexType)object).isSimpleContent()) {
            String string = "Elements are not permitted here: the containing element ";
            string = object instanceof SimpleType ? (object.isAnonymousType() ? string + "is defined to have a simple type" : string + "is of simple type " + object.getDescription()) : string + "has a complex type with simple content";
            object = new XPathException(string);
            ((XPathException)object).setIsTypeError(true);
            ((XPathException)object).setLocation(this.getLocation());
            throw object;
        }
    }

    @Override
    public NodeName getElementName(XPathContext xPathContext, NodeInfo object) {
        Object object2;
        Object object3;
        object = xPathContext.getController();
        assert (object != null);
        String string = null;
        object = (AtomicValue)this.getNameExp().evaluateItem(xPathContext);
        if (object == null) {
            String string2 = this.isXSLT() ? "XTDE0820" : "XPTY0004";
            XPathException xPathException = new XPathException("Invalid element name (empty sequence)", string2, this.getLocation());
            throw ComputedElement.dynamicError(this.getLocation(), xPathException, xPathContext);
        }
        if (object instanceof StringValue) {
            object3 = ((AtomicValue)object).getStringValueCS();
            object3 = Whitespace.trimWhitespace((CharSequence)object3);
            try {
                object2 = NameChecker.getQNameParts((CharSequence)object3);
                object = object2[0];
                object2 = object2[1];
            }
            catch (QNameException qNameException) {
                object = "Invalid element name. " + qNameException.getMessage();
                if (object3.length() == 0) {
                    object = "Supplied element name is a zero-length string";
                }
                String string3 = this.isXSLT() ? "XTDE0820" : "XQDY0074";
                object = new XPathException((String)object, string3, this.getLocation());
                throw ComputedElement.dynamicError(this.getLocation(), (XPathException)object, xPathContext);
            }
        } else if (object instanceof QNameValue && this.c) {
            object2 = ((QNameValue)object).getLocalName();
            string = ((QNameValue)object).getNamespaceURI();
            if (((String)(object = ((QNameValue)object).getPrefix())).equals("xmlns")) {
                XPathException xPathException = new XPathException("Computed element name has prefix xmlns", "XQDY0096", this.getLocation());
                throw ComputedElement.dynamicError(this.getLocation(), xPathException, xPathContext);
            }
        } else {
            String string4 = this.isXSLT() ? "XTDE0820" : "XPTY0004";
            XPathException xPathException = new XPathException("Computed element name has incorrect type", string4, this.getLocation());
            xPathException.setIsTypeError(true);
            throw ComputedElement.dynamicError(this.getLocation(), xPathException, xPathContext);
        }
        if (this.getNamespaceExp() == null && string == null) {
            string = this.getRetainedStaticContext().getURIForPrefix((String)object, true);
            if (string == null) {
                object3 = this.isXSLT() ? "XTDE0830" : (((String)object).equals("xmlns") ? "XQDY0096" : "XQDY0074");
                object2 = new XPathException("Undeclared prefix in element name: " + (String)object, (String)object3, this.getLocation());
                throw ComputedElement.dynamicError(this.getLocation(), (XPathException)object2, xPathContext);
            }
        } else {
            if (string == null) {
                if (this.getNamespaceExp() instanceof StringLiteral) {
                    string = ((StringLiteral)this.getNamespaceExp()).getStringValue();
                } else {
                    string = this.getNamespaceExp().evaluateAsString(xPathContext).toString();
                    if (!StandardURIChecker.getInstance().isValidURI(string)) {
                        object3 = new XPathException("The value of the namespace attribute must be a valid URI", "XTDE0835", this.getLocation());
                        throw ComputedElement.dynamicError(this.getLocation(), (XPathException)object3, xPathContext);
                    }
                }
            }
            if (string.isEmpty()) {
                object = "";
            }
            if (((String)object).equals("xmlns")) {
                object = "x-xmlns";
            }
        }
        if (string.equals("http://www.w3.org/2000/xmlns/")) {
            object3 = this.isXSLT() ? "XTDE0835" : "XQDY0096";
            object2 = new XPathException("Cannot create element in namespace " + string, (String)object3, this.getLocation());
            throw ComputedElement.dynamicError(this.getLocation(), (XPathException)object2, xPathContext);
        }
        if (string.equals("http://www.w3.org/XML/1998/namespace") != ((String)object).equals("xml")) {
            object3 = ((String)object).equals("xml") ? "When the prefix is 'xml', the namespace URI must be http://www.w3.org/XML/1998/namespace" : "When the namespace URI is http://www.w3.org/XML/1998/namespace, the prefix must be 'xml'";
            object2 = this.isXSLT() ? "XTDE0835" : "XQDY0096";
            object = new XPathException((String)object3, (String)object2, this.getLocation());
            throw ComputedElement.dynamicError(this.getLocation(), (XPathException)object, xPathContext);
        }
        return new FingerprintedQName((String)object, string, (String)object2);
    }

    public boolean isAllowNameAsQName() {
        return this.c;
    }

    @Override
    public String getNewBaseURI(XPathContext xPathContext, NodeInfo nodeInfo) {
        return this.getStaticBaseURIString();
    }

    @Override
    public void outputNamespaceNodes(XPathContext xPathContext, Receiver receiver, NodeName nodeName, NodeInfo nodeInfo) {
    }

    @Override
    public int getInstructionNameCode() {
        return 151;
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("compElem", this);
        String string = this.getInheritanceFlags();
        if (this.isLocal()) {
            string = string + "l";
        }
        if (!string.isEmpty()) {
            expressionPresenter.emitAttribute("flags", string);
        }
        this.exportValidationAndType(expressionPresenter);
        expressionPresenter.setChildRole("name");
        this.getNameExp().export(expressionPresenter);
        if (this.getNamespaceExp() != null) {
            expressionPresenter.setChildRole("namespace");
            this.getNamespaceExp().export(expressionPresenter);
        }
        expressionPresenter.setChildRole("content");
        this.getContentExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }
}

