/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SignificantItemDetector;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.OnEmptyExpr;
import net.sf.saxon.expr.instruct.OnNonEmptyExpr;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.Action;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.Cardinality;

public class ConditionalBlock
extends Instruction {
    private Operand[] a;
    private boolean b;

    public ConditionalBlock(Expression[] expressionArray) {
        this.a = new Operand[expressionArray.length];
        for (int i2 = 0; i2 < expressionArray.length; ++i2) {
            this.a[i2] = new Operand(this, expressionArray[i2], OperandRole.SAME_FOCUS_ACTION);
        }
    }

    public ConditionalBlock(List<Expression> list) {
        List<Expression> list2 = list;
        this(list2.toArray(new Expression[list2.size()]));
    }

    public Expression getChildExpression(int n2) {
        return this.a[n2].getChildExpression();
    }

    public int size() {
        return this.a.length;
    }

    @Override
    public Iterable<Operand> operands() {
        return Arrays.asList(this.a);
    }

    @Override
    public String getExpressionName() {
        return "condSeq";
    }

    public Expression[] getChildren() {
        Expression[] expressionArray = new Expression[this.size()];
        int n2 = 0;
        for (Operand operand : ((Expression)this).operands()) {
            expressionArray[n2++] = operand.getChildExpression();
        }
        return expressionArray;
    }

    @Override
    public int computeSpecialProperties() {
        if (this.size() == 0) {
            return 0xDFF0000;
        }
        int n2 = super.computeSpecialProperties();
        if (this.b) {
            n2 |= 0x8000000;
        }
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        for (Operand object : ((Expression)this).operands()) {
            Expression expression = object.getChildExpression();
            if (!(expression instanceof AxisExpression)) {
                bl2 = false;
                bl3 = false;
                bl4 = false;
                break;
            }
            byte by = ((AxisExpression)expression).getAxis();
            if (by != 3) {
                bl3 = false;
            }
            if (AxisInfo.isSubtreeAxis[by]) continue;
            bl4 = false;
        }
        if (bl2) {
            n2 |= 0x1810000;
            if (bl3) {
                n2 |= 0x80000;
            }
            if (bl4) {
                n2 |= 0x100000;
            }
            if (this.size() == 2 && ((AxisExpression)this.getChildExpression(0)).getAxis() == 2 && ((AxisExpression)this.getChildExpression(1)).getAxis() == 3) {
                n2 |= 0x20000;
            }
        }
        return n2;
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        Expression[] expressionArray = new Expression[this.size()];
        for (int i2 = 0; i2 < this.size(); ++i2) {
            expressionArray[i2] = this.getChildExpression(i2).copy(rebindingMap);
        }
        ConditionalBlock conditionalBlock = new ConditionalBlock(expressionArray);
        for (int i3 = 0; i3 < this.size(); ++i3) {
            conditionalBlock.adoptChildExpression(expressionArray[i3]);
        }
        conditionalBlock.b = this.b;
        ExpressionTool.copyLocationInfo(this, conditionalBlock);
        return conditionalBlock;
    }

    @Override
    public final ItemType getItemType() {
        if (this.size() == 0) {
            return ErrorType.getInstance();
        }
        ItemType itemType = this.getChildExpression(0).getItemType();
        TypeHierarchy typeHierarchy = this.getConfiguration().getTypeHierarchy();
        for (int i2 = 1; i2 < this.size(); ++i2) {
            if (!((itemType = Type.getCommonSuperType(itemType, this.getChildExpression(i2).getItemType(), typeHierarchy)) instanceof AnyItemType)) continue;
            return itemType;
        }
        return itemType;
    }

    @Override
    public final int getCardinality() {
        if (this.size() == 0) {
            return 8192;
        }
        int n2 = this.getChildExpression(0).getCardinality();
        for (int i2 = 1; i2 < this.size() && (n2 = Cardinality.sum(n2, this.getChildExpression(i2).getCardinality())) != 57344; ++i2) {
        }
        return n2;
    }

    @Override
    public final boolean mayCreateNewNodes() {
        return this.someOperandCreatesNewNodes();
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.typeCheckChildren(expressionVisitor, contextItemStaticInfo);
        if (Block.neverReturnsTypedNodes(this, expressionVisitor.getConfiguration().getTypeHierarchy())) {
            this.resetLocalStaticProperties();
            this.b = true;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo object) {
        int n2;
        if ((object = super.optimize(expressionVisitor, (ContextItemStaticInfo)object)) != this) {
            return object;
        }
        int n3 = -1;
        boolean bl2 = false;
        boolean bl3 = true;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (this.getChildExpression(i2) instanceof OnEmptyExpr || this.getChildExpression(i2) instanceof OnNonEmptyExpr) continue;
            n3 = i2;
            if (this.getChildExpression(i2).getItemType().getUType().intersection(UType.DOCUMENT.union(UType.TEXT)).equals(UType.VOID)) {
                n2 = this.getChildExpression(i2).getCardinality();
                if (!Cardinality.allowsZero(n2)) {
                    bl2 = true;
                }
                if (n2 == 8192) continue;
                bl3 = false;
                continue;
            }
            bl3 = false;
            bl2 = false;
            break;
        }
        if (bl3) {
            expressionVisitor.getStaticContext().issueWarning("The result of the sequence constructor will always be empty, so xsl:on-empty instructions will always be evaluated, and xsl:on-non-empty instructions will never be evaluated", this.getLocation());
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            for (n2 = 0; n2 < this.size(); ++n2) {
                if (this.getChildExpression(n2) instanceof OnNonEmptyExpr) continue;
                if (this.getChildExpression(n2) instanceof OnEmptyExpr) {
                    arrayList.add(((OnEmptyExpr)this.getChildExpression(n2)).getBaseExpression());
                    continue;
                }
                arrayList.add(this.getChildExpression(n2));
            }
            return Block.makeBlock(arrayList);
        }
        if (bl2) {
            expressionVisitor.getStaticContext().issueWarning("The result of the sequence constructor will never be empty, so xsl:on-empty instructions will never be evaluated, and xsl:on-non-empty instructions will always be evaluated", this.getLocation());
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            for (n2 = 0; n2 < this.size(); ++n2) {
                if (this.getChildExpression(n2) instanceof OnEmptyExpr) continue;
                if (this.getChildExpression(n2) instanceof OnNonEmptyExpr) {
                    arrayList.add(((OnNonEmptyExpr)this.getChildExpression(n2)).getBaseExpression());
                    continue;
                }
                arrayList.add(this.getChildExpression(n2));
            }
            return Block.makeBlock(arrayList);
        }
        if (n3 == -1) {
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            for (n2 = 0; n2 < this.size(); ++n2) {
                if (!(this.getChildExpression(n2) instanceof OnEmptyExpr)) continue;
                arrayList.add(((OnEmptyExpr)this.getChildExpression(n2)).getBaseExpression());
            }
            return Block.makeBlock(arrayList);
        }
        return this;
    }

    @Override
    public void checkPermittedContents(SchemaType schemaType, boolean bl2) {
        for (Operand operand : ((Expression)this).operands()) {
            Expression object = operand.getChildExpression();
            object.checkPermittedContents(schemaType, false);
        }
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("condSeq", this);
        for (Operand operand : ((Expression)this).operands()) {
            Expression object = operand.getChildExpression();
            object.export(expressionPresenter);
        }
        expressionPresenter.endElement();
    }

    @Override
    public String toShortString() {
        return "(" + this.getChildExpression(0).toShortString() + ", ...)";
    }

    @Override
    public TailCall processLeavingTail(XPathContext xPathContext) {
        Object object = xPathContext.newMinorContext();
        ArrayList<OnNonEmptyExpr> arrayList = new ArrayList<OnNonEmptyExpr>();
        Object object2 = () -> {
            arrayList = arrayList.iterator();
            while (arrayList.hasNext()) {
                Expression expression = (Expression)arrayList.next();
                expression.process(xPathContext);
            }
        };
        object2 = new SignificantItemDetector(xPathContext.getReceiver(), (Action)object2);
        ((XPathContextMinor)object).setReceiver((Receiver)object2);
        for (Operand operand : ((Expression)this).operands()) {
            Expression object3 = operand.getChildExpression();
            try {
                if (object3 instanceof OnEmptyExpr) continue;
                if (object3 instanceof OnNonEmptyExpr) {
                    if (((SignificantItemDetector)object2).isEmpty()) {
                        arrayList.add((OnNonEmptyExpr)object3);
                        continue;
                    }
                    object3.process(xPathContext);
                    continue;
                }
                object3.process((XPathContext)object);
            }
            catch (XPathException xPathException) {
                object = xPathException;
                xPathException.maybeSetLocation(object3.getLocation());
                ((XPathException)object).maybeSetContext(xPathContext);
                throw object;
            }
        }
        if (((SignificantItemDetector)object2).isEmpty()) {
            for (Operand operand : ((Expression)this).operands()) {
                Expression expression = operand.getChildExpression();
                if (!(expression instanceof OnEmptyExpr)) continue;
                expression.process(xPathContext);
            }
        }
        return null;
    }

    @Override
    public int getImplementationMethod() {
        return 4;
    }

    @Override
    public String getStreamerName() {
        return "ConditionalBlock";
    }
}

