/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.SequenceWriter;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.CopyOf;
import net.sf.saxon.expr.instruct.ElementCreator;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.MultipleNodeKindTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;

public class Copy
extends ElementCreator {
    private boolean a;
    private ItemType b = AnyItemType.getInstance();
    private ItemType c;

    public Copy(boolean bl2, boolean bl3, SchemaType schemaType, int n2) {
        this.a = bl2;
        this.inheritNamespacesToChildren = bl3;
        this.setValidationAction(n2, schemaType);
        this.preservingTypes = schemaType == null && n2 == 3;
    }

    public void setCopyNamespaces(boolean bl2) {
        this.a = bl2;
    }

    public boolean isCopyNamespaces() {
        return this.a;
    }

    @Override
    public Expression simplify() {
        this.preservingTypes |= !this.getPackageData().isSchemaAware();
        return super.simplify();
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.typeCheckChildren(expressionVisitor, contextItemStaticInfo);
        this.b = contextItemStaticInfo.getItemType();
        Object object = contextItemStaticInfo.getItemType();
        if (object == ErrorType.getInstance()) {
            object = new XPathException("No context item supplied for xsl:copy", "XTTE0945");
            ((XPathException)object).setIsTypeError(true);
            ((XPathException)object).setLocation(this.getLocation());
            throw object;
        }
        if (object instanceof NodeTest) {
            switch (object.getPrimitiveType()) {
                case 1: {
                    this.c = NodeKindTest.ELEMENT;
                    break;
                }
                case 9: {
                    this.c = NodeKindTest.DOCUMENT;
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: 
                case 13: {
                    object = new ContextItemExpression();
                    ExpressionTool.copyLocationInfo(this, (Expression)object);
                    object = new CopyOf((Expression)object, this.a, this.getValidationAction(), this.getSchemaType(), false);
                    ExpressionTool.copyLocationInfo(this, (Expression)object);
                    return ((Expression)object).typeCheck(expressionVisitor, contextItemStaticInfo);
                }
                default: {
                    this.c = object;
                    break;
                }
            }
        } else {
            this.c = object;
        }
        this.checkContentSequence(expressionVisitor.getStaticContext());
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        Copy copy = new Copy(this.a, this.inheritNamespacesToChildren, this.getSchemaType(), this.getValidationAction());
        ExpressionTool.copyLocationInfo(this, copy);
        copy.setContentExpression(this.getContentExpression().copy(rebindingMap));
        copy.c = this.c;
        return copy;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 2;
    }

    @Override
    public int getInstructionNameCode() {
        return 145;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.contentOp;
    }

    @Override
    public ItemType getItemType() {
        if (this.c != null) {
            return this.c;
        }
        TypeHierarchy typeHierarchy = this.getConfiguration().getTypeHierarchy();
        this.c = this.a(typeHierarchy);
        return this.c;
    }

    private ItemType a(TypeHierarchy object) {
        ItemType itemType = this.b;
        if (!this.getPackageData().isSchemaAware()) {
            return itemType;
        }
        if (itemType.getUType().overlaps(UType.ANY_ATOMIC.union(UType.FUNCTION))) {
            return itemType;
        }
        Configuration configuration = ((TypeHierarchy)object).getConfiguration();
        if (this.getSchemaType() != null) {
            int n2 = ((TypeHierarchy)object).relationship(itemType, NodeKindTest.ELEMENT);
            if (n2 == 0 || n2 == 2) {
                return new ContentTypeTest(1, this.getSchemaType(), configuration, false);
            }
            int n3 = ((TypeHierarchy)object).relationship(itemType, NodeKindTest.ATTRIBUTE);
            if (n3 == 0 || n3 == 2) {
                return new ContentTypeTest(2, this.getSchemaType(), configuration, false);
            }
            return AnyNodeTest.getInstance();
        }
        switch (this.getValidationAction()) {
            case 3: {
                return itemType;
            }
            case 4: {
                int n4 = ((TypeHierarchy)object).relationship(itemType, NodeKindTest.ELEMENT);
                if (n4 == 0 || n4 == 2) {
                    return new ContentTypeTest(1, Untyped.getInstance(), configuration, false);
                }
                int n5 = ((TypeHierarchy)object).relationship(itemType, NodeKindTest.ATTRIBUTE);
                if (n5 == 0 || n5 == 2) {
                    return new ContentTypeTest(2, BuiltInAtomicType.UNTYPED_ATOMIC, configuration, false);
                }
                if (n4 != 4 || n5 != 4) {
                    return AnyNodeTest.getInstance();
                }
                return itemType;
            }
            case 1: 
            case 2: {
                if (itemType instanceof NodeTest) {
                    int n6 = ((NodeTest)itemType).getFingerprint();
                    if (n6 != -1) {
                        int n7 = ((TypeHierarchy)object).relationship(itemType, NodeKindTest.ELEMENT);
                        if (n7 == 0 || n7 == 2) {
                            object = configuration.getElementDeclaration(n6);
                            if (object != null) {
                                try {
                                    return new ContentTypeTest(1, object.getType(), configuration, false);
                                }
                                catch (MissingComponentException missingComponentException) {
                                    return new ContentTypeTest(1, AnyType.getInstance(), configuration, false);
                                }
                            }
                            return new ContentTypeTest(1, AnyType.getInstance(), configuration, false);
                        }
                        int n8 = ((TypeHierarchy)object).relationship(itemType, NodeKindTest.ATTRIBUTE);
                        if (n8 == 0 || n8 == 2) {
                            SchemaDeclaration schemaDeclaration = configuration.getElementDeclaration(n6);
                            if (schemaDeclaration != null) {
                                try {
                                    return new ContentTypeTest(2, schemaDeclaration.getType(), configuration, false);
                                }
                                catch (MissingComponentException missingComponentException) {
                                    return new ContentTypeTest(2, AnySimpleType.getInstance(), configuration, false);
                                }
                            }
                            return new ContentTypeTest(2, AnySimpleType.getInstance(), configuration, false);
                        }
                    } else {
                        int n9 = ((TypeHierarchy)object).relationship(itemType, NodeKindTest.ELEMENT);
                        if (n9 == 0 || n9 == 2) {
                            return NodeKindTest.ELEMENT;
                        }
                        int n10 = ((TypeHierarchy)object).relationship(itemType, NodeKindTest.ATTRIBUTE);
                        if (n10 == 0 || n10 == 2) {
                            return NodeKindTest.ATTRIBUTE;
                        }
                    }
                    return AnyNodeTest.getInstance();
                }
                if (itemType instanceof AtomicType) {
                    return itemType;
                }
                return AnyItemType.getInstance();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public Expression optimize(ExpressionVisitor object, ContextItemStaticInfo object2) {
        Expression expression = super.optimize((ExpressionVisitor)object, (ContextItemStaticInfo)object2);
        if (expression == this) {
            if (this.c == null) {
                this.c = this.a(object.getConfiguration().getTypeHierarchy());
            }
            if (object.isOptimizeForStreaming() && !(object = object2.getItemType().getUType()).intersection(MultipleNodeKindTest.LEAF.getUType()).equals(UType.VOID)) {
                object2 = this.getParentExpression();
                if (object2 instanceof Choose && ((Choose)object2).size() == 2 && ((Choose)object2).getAction(1) == this && ((Choose)object2).getAction(0) instanceof CopyOf) {
                    return expression;
                }
                object2 = new CopyOf(new ContextItemExpression(), false, this.getValidationAction(), this.getSchemaType(), false);
                object = new MultipleNodeKindTest(object.intersection(MultipleNodeKindTest.LEAF.getUType()));
                object = new Expression[]{new InstanceOfExpression(new ContextItemExpression(), SequenceType.makeSequenceType((ItemType)object, 16384)), Literal.makeLiteral(BooleanValue.TRUE, this)};
                object2 = new Expression[]{object2, this};
                object = new Choose((Expression[])object, (Expression[])object2);
                ExpressionTool.copyLocationInfo(this, (Expression)object);
                return object;
            }
        }
        return expression;
    }

    @Override
    public NodeName getElementName(XPathContext xPathContext, NodeInfo nodeInfo) {
        return NameOfNode.makeName(nodeInfo);
    }

    @Override
    public String getNewBaseURI(XPathContext xPathContext, NodeInfo nodeInfo) {
        return nodeInfo.getBaseURI();
    }

    @Override
    public void outputNamespaceNodes(XPathContext xPathContext, Receiver receiver, NodeName nodeName, NodeInfo nodeInfo) {
        if (this.a) {
            NamespaceIterator.sendNamespaces(nodeInfo, receiver);
            return;
        }
        receiver.namespace(nodeName.getNamespaceBinding(), 0);
    }

    @Override
    public NamespaceBinding[] getActiveNamespaces() {
        if (this.a) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    @Override
    public TailCall processLeavingTail(XPathContext object) {
        Object object2 = object.getController();
        Object object3 = object.getReceiver();
        Item<?> item = object.getContextItem();
        if (item == null) {
            return null;
        }
        if (!(item instanceof NodeInfo)) {
            object3.append(item, this.getLocation(), 524288);
            return null;
        }
        NodeInfo nodeInfo = (NodeInfo)item;
        switch (nodeInfo.getNodeKind()) {
            case 1: {
                return super.processLeavingTail((XPathContext)object, (NodeInfo)item);
            }
            case 2: {
                if (this.getSchemaType() instanceof ComplexType) {
                    this.dynamicError("Cannot copy an attribute when the type requested for validation is a complex type", "XTTE1535", (XPathContext)object);
                }
                try {
                    CopyOf.a(nodeInfo, (SimpleType)this.getSchemaType(), this.getValidationAction(), this, (XPathContext)object, false);
                    break;
                }
                catch (NoOpenStartTagException noOpenStartTagException) {
                    object2 = noOpenStartTagException;
                    noOpenStartTagException.setXPathContext((XPathContext)object);
                    throw Copy.dynamicError(this.getLocation(), (XPathException)object2, (XPathContext)object);
                }
            }
            case 3: {
                object2 = nodeInfo.getStringValueCS();
                object3.characters((CharSequence)object2, this.getLocation(), 0);
                break;
            }
            case 7: {
                object = nodeInfo.getStringValueCS();
                object3.processingInstruction(nodeInfo.getDisplayName(), (CharSequence)object, this.getLocation(), 0);
                break;
            }
            case 8: {
                object = nodeInfo.getStringValueCS();
                object3.comment((CharSequence)object, this.getLocation(), 0);
                break;
            }
            case 13: {
                try {
                    nodeInfo.copy((Receiver)object3, 0, this.getLocation());
                    break;
                }
                catch (NoOpenStartTagException noOpenStartTagException) {
                    XPathException xPathException = new XPathException(noOpenStartTagException.getMessage());
                    xPathException.setXPathContext((XPathContext)object);
                    xPathException.setErrorCodeQName(noOpenStartTagException.getErrorCodeQName());
                    throw Copy.dynamicError(this.getLocation(), xPathException, (XPathContext)object);
                }
            }
            case 9: {
                item = object3;
                boolean bl2 = false;
                if (!this.preservingTypes) {
                    ParseOptions parseOptions = new ParseOptions(this.getValidationOptions());
                    parseOptions.setSpaceStrippingRule(NoElementsSpaceStrippingRule.getInstance());
                    ((Controller)object2).getConfiguration().prepareValidationReporting((XPathContext)object, parseOptions);
                    object2 = ((Controller)object2).getConfiguration().getDocumentValidator((Receiver)object3, nodeInfo.getBaseURI(), parseOptions, this.getLocation());
                    if (object2 != object3) {
                        object2 = new TreeReceiver((Receiver)object2);
                        ((SequenceReceiver)object2).setPipelineConfiguration(object3.getPipelineConfiguration());
                        object.setReceiver((Receiver)object2);
                        bl2 = true;
                        object3 = object2;
                    }
                }
                if (object3.getSystemId() == null) {
                    object3.setSystemId(nodeInfo.getBaseURI());
                }
                object3.startDocument(0);
                Copy.copyUnparsedEntities(nodeInfo, (Receiver)object3);
                this.getContentExpression().process((XPathContext)object);
                object3.endDocument();
                if (!bl2) break;
                object.setReceiver((Receiver)((Object)item));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown node kind " + nodeInfo.getNodeKind());
            }
        }
        return null;
    }

    public static void copyUnparsedEntities(NodeInfo nodeInfo, Receiver receiver) {
        Iterator<String> iterator = nodeInfo.getTreeInfo().getUnparsedEntityNames();
        while (iterator.hasNext()) {
            String string = iterator.next();
            String[] stringArray = nodeInfo.getTreeInfo().getUnparsedEntity(string);
            receiver.setUnparsedEntity(string, stringArray[0], stringArray[1]);
        }
    }

    @Override
    public Item evaluateItem(XPathContext object) {
        Object object2 = object.getController();
        Receiver receiver = object.getReceiver();
        object2 = ((Controller)object2).allocateSequenceOutputter(1);
        ((SequenceReceiver)object2).getPipelineConfiguration().setHostLanguage(this.getPackageData().getHostLanguage());
        object.setReceiver((Receiver)object2);
        ((Expression)this).process((XPathContext)object);
        ((SequenceWriter)object2).close();
        object.setReceiver(receiver);
        object = ((SequenceOutputter)object2).getFirstItem();
        ((SequenceOutputter)object2).reset();
        return object;
    }

    @Override
    public String getStreamerName() {
        return "Copy";
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("copy", this);
        this.exportValidationAndType(expressionPresenter);
        String string = "";
        if (this.a) {
            string = "c";
        }
        if (this.inheritNamespacesToChildren) {
            string = string + "i";
        }
        if (this.inheritNamespacesFromParent) {
            string = string + "n";
        }
        if (this.isLocal()) {
            string = string + "l";
        }
        expressionPresenter.emitAttribute("flags", string);
        expressionPresenter.setChildRole("content");
        this.getContentExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }
}

