/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.FixedElement;
import net.sf.saxon.expr.instruct.ParentNodeConstructor;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.TextFragmentValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class DocumentInstr
extends ParentNodeConstructor {
    private boolean a;
    private String b;

    public DocumentInstr(boolean bl2, String string) {
        this.a = bl2;
        this.b = string;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.contentOp;
    }

    @Override
    public int getImplementationMethod() {
        return 1;
    }

    public boolean isTextOnly() {
        return this.a;
    }

    public CharSequence getConstantText() {
        return this.b;
    }

    @Override
    protected void checkContentSequence(StaticContext staticContext) {
        DocumentInstr.checkContentSequence(staticContext, this.getContentOperand(), this.getValidationOptions());
    }

    protected static void checkContentSequence(StaticContext staticContext, Operand operand, ParseOptions object) {
        Operand[] operandArray = operand.getChildExpression() instanceof Block ? ((Block)operand.getChildExpression()).getOperanda() : new Operand[]{operand};
        int n2 = object == null ? 3 : ((ParseOptions)object).getSchemaValidationMode();
        object = object == null ? null : ((ParseOptions)object).getTopLevelType();
        int n3 = 0;
        boolean bl2 = operand.getChildExpression().getPackageData().getHostLanguage() == 50;
        for (Operand operand2 : operandArray) {
            Expression object2 = operand2.getChildExpression();
            Object object3 = object2.getItemType();
            if (!(object3 instanceof NodeTest)) continue;
            if (((UType)(object3 = object3.getUType())).equals(UType.ATTRIBUTE)) {
                object3 = new XPathException("Cannot create an attribute node whose parent is a document node");
                ((XPathException)object3).setErrorCode(bl2 ? "XTDE0420" : "XPTY0004");
                ((TransformerException)object3).setLocator(object2.getLocation());
                throw object3;
            }
            if (((UType)object3).equals(UType.NAMESPACE)) {
                object3 = new XPathException("Cannot create a namespace node whose parent is a document node");
                ((XPathException)object3).setErrorCode(bl2 ? "XTDE0420" : "XQTY0024");
                ((TransformerException)object3).setLocator(object2.getLocation());
                throw object3;
            }
            if (!((UType)object3).equals(UType.ELEMENT)) continue;
            if (++n3 > 1 && (n2 == 1 || n2 == 2 || object != null)) {
                object3 = new XPathException("A valid document must have only one child element");
                if (bl2) {
                    ((XPathException)object3).setErrorCode("XTTE1550");
                } else {
                    ((XPathException)object3).setErrorCode("XQDY0061");
                }
                ((TransformerException)object3).setLocator(object2.getLocation());
                throw object3;
            }
            if (n2 != 1 || !(object2 instanceof FixedElement) || (object3 = staticContext.getConfiguration().getElementDeclaration(((FixedElement)object2).getElementName().getFingerprint())) == null) continue;
            ((FixedElement)object2).getContentExpression().checkPermittedContents(object3.getType(), true);
        }
    }

    @Override
    public int computeSpecialProperties() {
        int n2 = super.computeSpecialProperties();
        n2 |= 0x1000000;
        if (this.getValidationAction() == 4) {
            n2 |= 0x8000000;
        }
        return n2;
    }

    public Expression getStringValueExpression() {
        if (this.a) {
            if (this.b != null) {
                return new StringLiteral(new UntypedAtomicValue(this.b));
            }
            if (this.getContentExpression() instanceof ValueOf) {
                return ((ValueOf)this.getContentExpression()).convertToCastAsString();
            }
            Expression expression = SystemFunction.makeCall("string-join", this.getRetainedStaticContext(), this.getContentExpression(), new StringLiteral(StringValue.EMPTY_STRING));
            expression = new CastExpression(expression, BuiltInAtomicType.UNTYPED_ATOMIC, false);
            ExpressionTool.copyLocationInfo(this, expression);
            return expression;
        }
        throw new AssertionError((Object)"getStringValueExpression() called on non-text-only document instruction");
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        DocumentInstr documentInstr = new DocumentInstr(this.a, this.b);
        ExpressionTool.copyLocationInfo(this, documentInstr);
        documentInstr.setContentExpression(this.getContentExpression().copy(rebindingMap));
        documentInstr.setValidationAction(this.getValidationAction(), this.getSchemaType());
        return documentInstr;
    }

    @Override
    public ItemType getItemType() {
        return NodeKindTest.DOCUMENT;
    }

    @Override
    public TailCall processLeavingTail(XPathContext object) {
        if (this.preservingTypes && !this.a) {
            Receiver receiver = object.getReceiver();
            receiver.startDocument(0);
            this.getContentExpression().process((XPathContext)object);
            receiver.endDocument();
            return null;
        }
        NodeInfo nodeInfo = this.evaluateItem((XPathContext)object);
        if (nodeInfo != null) {
            object = object.getReceiver();
            object.append(nodeInfo, this.getLocation(), 524288);
        }
        return null;
    }

    public NodeInfo evaluateItem(XPathContext xPathContext) {
        Object object = xPathContext.getController();
        Configuration configuration = ((Controller)object).getConfiguration();
        assert (object != null);
        if (this.a) {
            CharSequence charSequence;
            if (this.b != null) {
                charSequence = this.b;
            } else {
                Object obj;
                FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
                object = this.getContentExpression().iterate(xPathContext);
                while ((obj = object.next()) != null) {
                    fastStringBuffer.append(obj.getStringValueCS());
                }
                charSequence = fastStringBuffer.condense();
            }
            object = TextFragmentValue.makeTextFragment(configuration, charSequence, this.getStaticBaseURIString());
        } else {
            try {
                Receiver receiver = xPathContext.getReceiver();
                PipelineConfiguration pipelineConfiguration = ((Controller)object).makePipelineConfiguration();
                pipelineConfiguration.setXPathContext(xPathContext);
                object = ((Controller)object).makeBuilder();
                ((Builder)object).setUseEventLocation(false);
                if (object instanceof TinyBuilder) {
                    ((TinyBuilder)object).setStatistics(configuration.getTreeStatistics().SOURCE_DOCUMENT_STATISTICS);
                }
                ((Builder)object).setBaseURI(this.getStaticBaseURIString());
                ((Builder)object).setTiming(false);
                pipelineConfiguration.setHostLanguage(this.getPackageData().getHostLanguage());
                ((Builder)object).setPipelineConfiguration(pipelineConfiguration);
                Receiver receiver2 = ComplexContentOutputter.makeComplexContentReceiver((Receiver)object, this.getValidationOptions());
                xPathContext.setReceiver(receiver2);
                receiver2.open();
                receiver2.startDocument(0);
                this.getContentExpression().process(xPathContext);
                receiver2.endDocument();
                receiver2.close();
                xPathContext.setReceiver(receiver);
                object = ((Builder)object).getCurrentRoot();
            }
            catch (XPathException xPathException) {
                XPathException xPathException2 = xPathException;
                xPathException.maybeSetLocation(this.getLocation());
                xPathException2.maybeSetContext(xPathContext);
                throw xPathException2;
            }
        }
        return object;
    }

    @Override
    public int getInstructionNameCode() {
        return 150;
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("doc", this);
        if (!expressionPresenter.isRelocatable()) {
            expressionPresenter.emitAttribute("base", this.getStaticBaseURIString());
        }
        Object object = "";
        if (this.a) {
            object = (String)object + "t";
        }
        if (this.isLocal()) {
            object = (String)object + "l";
        }
        if (!((String)object).isEmpty()) {
            expressionPresenter.emitAttribute("flags", (String)object);
        }
        if (this.b != null) {
            expressionPresenter.emitAttribute("text", this.b);
        }
        if (this.getValidationAction() != 4 && this.getValidationAction() != 8) {
            expressionPresenter.emitAttribute("validation", Validation.toString(this.getValidationAction()));
        }
        if ((object = this.getSchemaType()) != null) {
            expressionPresenter.emitAttribute("type", object.getStructuredQName());
        }
        this.getContentExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public String getStreamerName() {
        return "DocumentInstr";
    }
}

