/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.ParentNodeConstructor;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.Cardinality;

public abstract class ElementCreator
extends ParentNodeConstructor {
    protected boolean inheritNamespacesToChildren = true;
    protected boolean inheritNamespacesFromParent = true;

    @Override
    public ItemType getItemType() {
        return NodeKindTest.ELEMENT;
    }

    @Override
    public int getCardinality() {
        return 16384;
    }

    public void setInheritNamespacesToChildren(boolean bl2) {
        this.inheritNamespacesToChildren = bl2;
    }

    public boolean isInheritNamespacesToChildren() {
        return this.inheritNamespacesToChildren;
    }

    public void setInheritNamespacesFromParent(boolean bl2) {
        this.inheritNamespacesFromParent = bl2;
    }

    public boolean isInheritNamespacesFromParent() {
        return this.inheritNamespacesFromParent;
    }

    @Override
    public int computeSpecialProperties() {
        int n2 = super.computeSpecialProperties() | 0x1000000;
        if (this.getValidationAction() == 4) {
            n2 |= 0x8000000;
        }
        return n2;
    }

    @Override
    public void suppressValidation(int n2) {
        if (this.getValidationAction() == n2 && this.getSchemaType() == null) {
            this.setValidationAction(3, null);
        }
    }

    @Override
    protected void checkContentSequence(StaticContext staticContext) {
        Operand[] operandArray = this.getContentExpression() instanceof Block ? ((Block)this.getContentExpression()).getOperanda() : new Operand[]{this.contentOp};
        boolean bl2 = false;
        boolean bl3 = false;
        for (Operand operand : operandArray) {
            Expression object = operand.getChildExpression();
            Object object2 = object.getItemType();
            if (object2.isAtomicType()) {
                bl2 = true;
                continue;
            }
            if (object2 instanceof FunctionItemType && !(object2 instanceof ArrayItemType)) {
                String string = object2 instanceof MapType ? "map" : "function";
                object2 = new XPathException("Cannot add a " + string + " as a child of a constructed element");
                ((XPathException)object2).setErrorCode(this.isXSLT() ? "XTDE0450" : "XQTY0105");
                ((TransformerException)object2).setLocator(object.getLocation());
                ((XPathException)object2).setIsTypeError(true);
                throw object2;
            }
            if (!(object2 instanceof NodeTest)) continue;
            boolean string = Cardinality.allowsZero(object.getCardinality());
            if (((UType)(object2 = object2.getUType())).overlaps(UType.TEXT)) {
                if (object instanceof ValueOf && ((ValueOf)object).getSelect() instanceof StringLiteral) {
                    object2 = ((StringLiteral)((ValueOf)object).getSelect()).getStringValue();
                    if (((String)object2).isEmpty()) continue;
                    bl2 = true;
                    continue;
                }
                bl3 = true;
                continue;
            }
            if (!((UType)object2).overlaps(UType.CHILD_NODE_KINDS)) {
                if (string) {
                    bl3 = true;
                    continue;
                }
                bl2 = true;
                continue;
            }
            if (bl2 && object2 == UType.ATTRIBUTE && !string) {
                object2 = new XPathException("Cannot create an attribute node after creating a child of the containing element");
                ((XPathException)object2).setErrorCode(this.isXSLT() ? "XTDE0410" : "XQTY0024");
                ((TransformerException)object2).setLocator(object.getLocation());
                throw object2;
            }
            if (bl2 && object2 == UType.NAMESPACE && !string) {
                object2 = new XPathException("Cannot create a namespace node after creating a child of the containing element");
                ((XPathException)object2).setErrorCode(this.isXSLT() ? "XTDE0410" : "XQTY0024");
                ((TransformerException)object2).setLocator(object.getLocation());
                throw object2;
            }
            if ((bl2 || bl3) && object2 == UType.ATTRIBUTE) {
                staticContext.issueWarning("Creating an attribute here will fail if previous instructions create any children", object.getLocation());
                continue;
            }
            if (!bl2 && !bl3 || object2 != UType.NAMESPACE) continue;
            staticContext.issueWarning("Creating a namespace node here will fail if previous instructions create any children", object.getLocation());
        }
    }

    public abstract NodeName getElementName(XPathContext var1, NodeInfo var2);

    public abstract String getNewBaseURI(XPathContext var1, NodeInfo var2);

    public abstract void outputNamespaceNodes(XPathContext var1, Receiver var2, NodeName var3, NodeInfo var4);

    public NamespaceBinding[] getActiveNamespaces() {
        return null;
    }

    @Override
    public int getImplementationMethod() {
        return 5;
    }

    @Override
    public TailCall processLeavingTail(XPathContext xPathContext) {
        return this.processLeavingTail(xPathContext, null);
    }

    public final TailCall processLeavingTail(XPathContext xPathContext, NodeInfo nodeInfo) {
        try {
            int n2;
            Receiver receiver;
            NodeName nodeName = this.getElementName(xPathContext, nodeInfo);
            Enum enum_ = this.getValidationAction() == 3 ? AnyType.getInstance() : Untyped.getInstance();
            Receiver receiver2 = receiver = xPathContext.getReceiver();
            boolean bl2 = false;
            Receiver receiver3 = receiver;
            if (!this.preservingTypes) {
                ParseOptions parseOptions = new ParseOptions(this.getValidationOptions());
                parseOptions.setTopLevelElement(nodeName.getStructuredQName());
                xPathContext.getConfiguration().prepareValidationReporting(xPathContext, parseOptions);
                receiver3 = xPathContext.getConfiguration().getElementValidator(receiver, parseOptions, this.getLocation());
                if (receiver3 != receiver) {
                    receiver = new TreeReceiver(receiver3);
                    xPathContext.setReceiver(receiver);
                    bl2 = true;
                }
                receiver3 = receiver;
            }
            if (receiver3.getSystemId() == null) {
                receiver3.setSystemId(this.getNewBaseURI(xPathContext, nodeInfo));
            }
            int n3 = n2 = this.inheritNamespacesToChildren ? 0 : 128;
            if (!this.inheritNamespacesFromParent) {
                n2 |= 0x10000;
            }
            receiver3.startElement(nodeName, (SchemaType)((Object)enum_), this.getLocation(), n2);
            this.outputNamespaceNodes(xPathContext, receiver3, nodeName, nodeInfo);
            this.getContentExpression().process(xPathContext);
            receiver3.endElement();
            if (bl2) {
                xPathContext.setReceiver(receiver2);
            }
            return null;
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            xPathException.maybeSetLocation(this.getLocation());
            xPathException2.maybeSetContext(xPathContext);
            throw xPathException2;
        }
    }

    public Item evaluateItem(XPathContext xPathContext) {
        return this.a(xPathContext, null);
    }

    private NodeInfo a(XPathContext xPathContext, NodeInfo object) {
        try {
            int n2;
            object = xPathContext.getController();
            if (object == null) {
                throw new NoDynamicContextException("No controller available");
            }
            Receiver receiver = xPathContext.getReceiver();
            SequenceOutputter sequenceOutputter = ((Controller)object).allocateSequenceOutputter(1);
            sequenceOutputter.getPipelineConfiguration().setHostLanguage(this.getPackageData().getHostLanguage());
            NodeName nodeName = this.getElementName(xPathContext, null);
            Enum enum_ = this.getValidationAction() == 3 ? AnyType.getInstance() : Untyped.getInstance();
            Object object2 = sequenceOutputter;
            if (!this.preservingTypes) {
                ParseOptions parseOptions = new ParseOptions(this.getValidationOptions());
                parseOptions.setTopLevelElement(nodeName.getStructuredQName());
                ((Controller)object).getConfiguration().prepareValidationReporting(xPathContext, parseOptions);
                object = ((Controller)object).getConfiguration().getElementValidator((Receiver)object2, parseOptions, this.getLocation());
                if (((SequenceReceiver)object2).getSystemId() == null) {
                    ((SequenceReceiver)object2).setSystemId(this.getNewBaseURI(xPathContext, null));
                }
                if (object == object2) {
                    xPathContext.setReceiver((Receiver)object2);
                } else {
                    object = new TreeReceiver((Receiver)object);
                    ((SequenceReceiver)object).setPipelineConfiguration(sequenceOutputter.getPipelineConfiguration());
                    xPathContext.setReceiver((Receiver)object);
                    object2 = object;
                }
            } else {
                xPathContext.setReceiver((Receiver)object2);
                if (((SequenceReceiver)object2).getSystemId() == null) {
                    ((SequenceReceiver)object2).setSystemId(this.getNewBaseURI(xPathContext, null));
                }
            }
            ((SequenceReceiver)object2).open();
            int n3 = n2 = this.inheritNamespacesToChildren ? 0 : 128;
            if (!this.inheritNamespacesFromParent) {
                n2 |= 0x10000;
            }
            object2.startElement(nodeName, (SchemaType)((Object)enum_), this.getLocation(), n2);
            this.outputNamespaceNodes(xPathContext, (Receiver)object2, nodeName, null);
            this.getContentExpression().process(xPathContext);
            object2.endElement();
            object2.close();
            xPathContext.setReceiver(receiver);
            object = (NodeInfo)sequenceOutputter.popLastItem();
            sequenceOutputter.reset();
            return object;
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.maybeSetLocation(this.getLocation());
            ((XPathException)object).maybeSetContext(xPathContext);
            throw object;
        }
    }

    protected void exportValidationAndType(ExpressionPresenter expressionPresenter) {
        SchemaType schemaType;
        if (this.getValidationAction() != 4 && this.getValidationAction() != 8) {
            expressionPresenter.emitAttribute("validation", Validation.toString(this.getValidationAction()));
        }
        if (this.getValidationAction() == 8 && (schemaType = this.getSchemaType()) != null) {
            expressionPresenter.emitAttribute("type", schemaType.getStructuredQName());
        }
    }

    protected String getInheritanceFlags() {
        String string = "";
        if (!this.inheritNamespacesFromParent) {
            string = string + "P";
        }
        if (!this.inheritNamespacesToChildren) {
            string = string + "C";
        }
        return string;
    }

    public void setInheritanceFlags(String string) {
        this.inheritNamespacesFromParent = !string.contains("P");
        this.inheritNamespacesToChildren = !string.contains("C");
    }

    @Override
    public String getStreamerName() {
        return "ElementCreator";
    }
}

